/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.plugin.filter.RGBStackSplitter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class ZProjector
implements PlugIn {
    public static final int AVG_METHOD = 0;
    public static final int MAX_METHOD = 1;
    public static final int MIN_METHOD = 2;
    public static final int SUM_METHOD = 3;
    public static final int SD_METHOD = 4;
    public static final int MEDIAN_METHOD = 5;
    public static final String[] METHODS = new String[]{"Average Intensity", "Max Intensity", "Min Intensity", "Sum Slices", "Standard Deviation", "Median"};
    private static int method = 0;
    private static final int BYTE_TYPE = 0;
    private static final int SHORT_TYPE = 1;
    private static final int FLOAT_TYPE = 2;
    public static final String lutMessage = "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).";
    private ImagePlus projImage = null;
    private ImagePlus imp = null;
    private int startSlice = 1;
    private int stopSlice = 1;
    private String color = "";

    public ZProjector() {
    }

    public ZProjector(ImagePlus imp) {
        this.setImage(imp);
    }

    public void setImage(ImagePlus imp) {
        this.imp = imp;
        this.startSlice = 1;
        this.stopSlice = imp.getStackSize();
    }

    public void setStartSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.startSlice = slice;
    }

    public void setStopSlice(int slice) {
        if (this.imp == null || slice < 1 || slice > this.imp.getStackSize()) {
            return;
        }
        this.stopSlice = slice;
    }

    public void setMethod(int projMethod) {
        method = projMethod;
    }

    public ImagePlus getProjection() {
        return this.projImage;
    }

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (this.imp.getStackSize() == 1) {
            IJ.error("ZProjection", "Stack required");
            return;
        }
        if (this.imp.getProcessor().isInvertedLut() && !IJ.showMessageWithCancel("ZProjection", lutMessage)) {
            return;
        }
        this.startSlice = 1;
        this.stopSlice = this.imp.getStackSize();
        GenericDialog gd = this.buildControlDialog(this.startSlice, this.stopSlice);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        long tstart = System.currentTimeMillis();
        this.setStartSlice((int)gd.getNextNumber());
        this.setStopSlice((int)gd.getNextNumber());
        method = gd.getNextChoiceIndex();
        if (this.imp.getType() == 4) {
            if (method == 3 || method == 4 || method == 5) {
                IJ.error("ZProjection", "Sum, StdDev and Median methods \nnot available with RGB stacks.");
                this.imp.unlock();
                return;
            }
            this.doRGBProjection();
        } else {
            this.doProjection();
        }
        if (arg.equals("")) {
            long tstop = System.currentTimeMillis();
            this.projImage.setCalibration(this.imp.getCalibration());
            this.projImage.show("ZProjector: " + IJ.d2s((double)(tstop - tstart) / 1000.0, 2) + " seconds");
        }
        this.imp.unlock();
        IJ.register(ZProjector.class);
    }

    public void doRGBProjection() {
        RGBStackSplitter splitter = new RGBStackSplitter();
        splitter.split(this.imp.getStack(), true);
        ImagePlus red = new ImagePlus("Red", splitter.red);
        ImagePlus green = new ImagePlus("Green", splitter.green);
        ImagePlus blue = new ImagePlus("Blue", splitter.blue);
        this.imp.unlock();
        ImagePlus saveImp = this.imp;
        this.imp = red;
        this.color = "(red)";
        this.doProjection();
        ImagePlus red2 = this.projImage;
        this.imp = green;
        this.color = "(green)";
        this.doProjection();
        ImagePlus green2 = this.projImage;
        this.imp = blue;
        this.color = "(blue)";
        this.doProjection();
        ImagePlus blue2 = this.projImage;
        int w = red2.getWidth();
        int h = red2.getHeight();
        int d = red2.getStackSize();
        RGBStackMerge merge = new RGBStackMerge();
        ImageStack stack = merge.mergeStacks(w, h, d, red2.getStack(), green2.getStack(), blue2.getStack(), true);
        this.imp = saveImp;
        this.projImage = new ImagePlus(this.makeTitle(), stack);
    }

    protected GenericDialog buildControlDialog(int start, int stop) {
        GenericDialog gd = new GenericDialog("ZProjection", IJ.getInstance());
        gd.addNumericField("Start slice:", this.startSlice, 0);
        gd.addNumericField("Stop slice:", this.stopSlice, 0);
        gd.addChoice("Projection Type", METHODS, METHODS[method]);
        return gd;
    }

    /*
     * WARNING - void declaration
     */
    public void doProjection() {
        void var4_4;
        int ptype;
        if (this.imp == null) {
            return;
        }
        if (method == 5) {
            this.projImage = this.doMedianProjection();
            return;
        }
        FloatProcessor fp = new FloatProcessor(this.imp.getWidth(), this.imp.getHeight());
        ImageStack stack = this.imp.getStack();
        RayFunction rayFunc = this.getRayFunction(method, fp);
        if (IJ.debugMode) {
            IJ.log("\nProjecting stack from: " + this.startSlice + " to: " + this.stopSlice);
        }
        if (stack.getProcessor(1) instanceof ByteProcessor) {
            ptype = 0;
        } else if (stack.getProcessor(1) instanceof ShortProcessor) {
            ptype = 1;
        } else if (stack.getProcessor(1) instanceof FloatProcessor) {
            ptype = 2;
        } else {
            IJ.error("ZProjector: Unknown processor type.");
            return;
        }
        for (int n = this.startSlice; n <= this.stopSlice; ++n) {
            IJ.showStatus("ZProjection " + this.color + ": " + n + "/" + this.stopSlice);
            IJ.showProgress(n - this.startSlice, this.stopSlice - this.startSlice);
            this.projectSlice(stack.getPixels(n), rayFunc, (int)var4_4);
        }
        if (method == 3) {
            fp.resetMinAndMax();
            this.projImage = new ImagePlus(this.makeTitle(), fp);
        } else if (method == 4) {
            rayFunc.postProcess();
            fp.resetMinAndMax();
            this.projImage = new ImagePlus(this.makeTitle(), fp);
        } else {
            rayFunc.postProcess();
            this.projImage = this.makeOutputImage(this.imp, fp, (int)var4_4);
        }
        if (this.projImage == null) {
            IJ.error("ZProjection - error computing projection.");
        }
    }

    private RayFunction getRayFunction(int method, FloatProcessor fp) {
        switch (method) {
            case 0: 
            case 3: {
                return new AverageIntensity(fp, this.stopSlice - this.startSlice + 1);
            }
            case 1: {
                return new MaxIntensity(fp);
            }
            case 2: {
                return new MinIntensity(fp);
            }
            case 4: {
                return new StandardDeviation(fp, this.stopSlice - this.startSlice + 1);
            }
        }
        IJ.error("ZProjection - unknown method.");
        return null;
    }

    private ImagePlus makeOutputImage(ImagePlus imp, FloatProcessor fp, int ptype) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        float[] pixels = (float[])fp.getPixels();
        ImageProcessor oip = null;
        int size = pixels.length;
        switch (ptype) {
            case 0: {
                oip = imp.getProcessor().createProcessor(width, height);
                byte[] pixels8 = (byte[])oip.getPixels();
                for (int i = 0; i < size; ++i) {
                    pixels8[i] = (byte)pixels[i];
                }
                break;
            }
            case 1: {
                oip = imp.getProcessor().createProcessor(width, height);
                short[] pixels16 = (short[])oip.getPixels();
                for (int i = 0; i < size; ++i) {
                    pixels16[i] = (short)pixels[i];
                }
                break;
            }
            case 2: {
                oip = new FloatProcessor(width, height, pixels, null);
            }
        }
        oip.resetMinAndMax();
        return new ImagePlus(this.makeTitle(), oip);
    }

    private void projectSlice(Object pixelArray, RayFunction rayFunc, int ptype) {
        switch (ptype) {
            case 0: {
                rayFunc.projectSlice((byte[])pixelArray);
                break;
            }
            case 1: {
                rayFunc.projectSlice((short[])pixelArray);
                break;
            }
            case 2: {
                rayFunc.projectSlice((float[])pixelArray);
            }
        }
    }

    ImagePlus doMedianProjection() {
        IJ.showStatus("Calculating median...");
        ImageStack stack = this.imp.getStack();
        int nSlices = this.stopSlice - this.startSlice + 1;
        ImageProcessor[] slices = new ImageProcessor[nSlices];
        int index = 0;
        for (int slice = this.startSlice; slice <= this.stopSlice; ++slice) {
            slices[index++] = stack.getProcessor(slice);
        }
        ImageProcessor ip2 = slices[0].duplicate();
        ip2 = ip2.convertToFloat();
        float[] values = new float[nSlices];
        int width = ip2.getWidth();
        int height = ip2.getHeight();
        int inc = Math.min(height / 30, 1);
        for (int y = 0; y < height; ++y) {
            if (y % inc == 0) {
                IJ.showProgress(y, height - 1);
            }
            for (int x = 0; x < width; ++x) {
                for (int i = 0; i < nSlices; ++i) {
                    values[i] = slices[i].getPixelValue(x, y);
                }
                ip2.putPixelValue(x, y, this.median(values));
            }
        }
        return new ImagePlus(this.makeTitle(), ip2);
    }

    String makeTitle() {
        String prefix = "AVG_";
        switch (method) {
            case 3: {
                prefix = "SUM_";
                break;
            }
            case 1: {
                prefix = "MAX_";
                break;
            }
            case 2: {
                prefix = "MIN_";
                break;
            }
            case 4: {
                prefix = "STD_";
                break;
            }
            case 5: {
                prefix = "MED_";
            }
        }
        return WindowManager.makeUniqueName(prefix + this.imp.getTitle());
    }

    float median(float[] a2) {
        this.sort(a2);
        int length = a2.length;
        if ((length & 1) == 0) {
            return (a2[length / 2 - 1] + a2[length / 2]) / 2.0f;
        }
        return a2[length / 2];
    }

    void sort(float[] a2) {
        if (!this.alreadySorted(a2)) {
            this.sort(a2, 0, a2.length - 1);
        }
    }

    void sort(float[] a2, int from, int to) {
        int i = from;
        int j = to;
        float center = a2[(from + to) / 2];
        while (true) {
            if (i < to && center > a2[i]) {
                ++i;
                continue;
            }
            while (j > from && center < a2[j]) {
                --j;
            }
            if (i < j) {
                float temp = a2[i];
                a2[i] = a2[j];
                a2[j] = temp;
            }
            if (i <= j) {
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (from < j) {
            this.sort(a2, from, j);
        }
        if (i < to) {
            this.sort(a2, i, to);
        }
    }

    boolean alreadySorted(float[] a2) {
        for (int i = 1; i < a2.length; ++i) {
            if (!(a2[i] < a2[i - 1])) continue;
            return false;
        }
        return true;
    }

    class StandardDeviation
    extends RayFunction {
        private float[] result;
        private double[] sum;
        private double[] sum2;
        private int num;
        private int len;

        public StandardDeviation(FloatProcessor fp, int num) {
            this.result = (float[])fp.getPixels();
            this.len = this.result.length;
            this.num = num;
            this.sum = new double[this.len];
            this.sum2 = new double[this.len];
        }

        public void projectSlice(byte[] pixels) {
            int i = 0;
            while (i < this.len) {
                int v = pixels[i] & 0xFF;
                int n = i;
                this.sum[n] = this.sum[n] + (double)v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + (double)(v * v);
            }
        }

        public void projectSlice(short[] pixels) {
            int i = 0;
            while (i < this.len) {
                double v = pixels[i] & 0xFFFF;
                int n = i;
                this.sum[n] = this.sum[n] + v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + v * v;
            }
        }

        public void projectSlice(float[] pixels) {
            int i = 0;
            while (i < this.len) {
                double v = pixels[i];
                int n = i;
                this.sum[n] = this.sum[n] + v;
                int n2 = i++;
                this.sum2[n2] = this.sum2[n2] + v * v;
            }
        }

        public void postProcess() {
            double n = this.num;
            for (int i = 0; i < this.len; ++i) {
                if (this.num > 1) {
                    double stdDev = (n * this.sum2[i] - this.sum[i] * this.sum[i]) / n;
                    if (stdDev > 0.0) {
                        this.result[i] = (float)Math.sqrt(stdDev / (n - 1.0));
                        continue;
                    }
                    this.result[i] = 0.0f;
                    continue;
                }
                this.result[i] = 0.0f;
            }
        }
    }

    class MinIntensity
    extends RayFunction {
        private float[] fpixels;
        private int len;

        public MinIntensity(FloatProcessor fp) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            for (int i = 0; i < this.len; ++i) {
                this.fpixels[i] = Float.MAX_VALUE;
            }
        }

        public void projectSlice(byte[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(pixels[i] & 0xFF) < this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i] & 0xFF;
            }
        }

        public void projectSlice(short[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(pixels[i] & 0xFFFF) < this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i] & 0xFFFF;
            }
        }

        public void projectSlice(float[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!(pixels[i] < this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i];
            }
        }
    }

    class MaxIntensity
    extends RayFunction {
        private float[] fpixels;
        private int len;

        public MaxIntensity(FloatProcessor fp) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            for (int i = 0; i < this.len; ++i) {
                this.fpixels[i] = -3.4028235E38f;
            }
        }

        public void projectSlice(byte[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(pixels[i] & 0xFF) > this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i] & 0xFF;
            }
        }

        public void projectSlice(short[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!((float)(pixels[i] & 0xFFFF) > this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i] & 0xFFFF;
            }
        }

        public void projectSlice(float[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                if (!(pixels[i] > this.fpixels[i])) continue;
                this.fpixels[i] = pixels[i];
            }
        }
    }

    class AverageIntensity
    extends RayFunction {
        private float[] fpixels;
        private int num;
        private int len;

        public AverageIntensity(FloatProcessor fp, int num) {
            this.fpixels = (float[])fp.getPixels();
            this.len = this.fpixels.length;
            this.num = num;
        }

        public void projectSlice(byte[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(pixels[i] & 0xFF);
            }
        }

        public void projectSlice(short[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + (float)(pixels[i] & 0xFFFF);
            }
        }

        public void projectSlice(float[] pixels) {
            for (int i = 0; i < this.len; ++i) {
                int n = i;
                this.fpixels[n] = this.fpixels[n] + pixels[i];
            }
        }

        public void postProcess() {
            float fnum = this.num;
            int i = 0;
            while (i < this.len) {
                int n = i++;
                this.fpixels[n] = this.fpixels[n] / fnum;
            }
        }
    }

    abstract class RayFunction {
        RayFunction() {
        }

        public abstract void projectSlice(byte[] var1);

        public abstract void projectSlice(short[] var1);

        public abstract void projectSlice(float[] var1);

        public void postProcess() {
        }
    }
}

