/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.ShortImageHelper;

public class ShortSpectrumHelper
extends ANumberSpectrumHelper {
    public ShortSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.imageHelper = new ShortImageHelper(iAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        short[] sArray = new short[dArray.length];
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(dArray[i] / d);
        }
        deviceAttribute.insert(sArray);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Short((short)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Short((short)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Short((short)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Short((short)d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Short((short)d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Short((short)d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Short((short)d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Short((short)d));
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Short((short)d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Short((short)d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Short((short)d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Short((short)d), bl);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Short((short)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Short((short)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Short((short)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Short((short)d), bl);
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        short[] sArray = deviceAttribute.extractShortArray();
        double[] dArray = new double[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            dArray[i] = sArray[i];
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        short[] sArray = deviceAttribute.extractShortArray();
        double d = this.attribute.getDisplayUnitFactor();
        double[] dArray = new double[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            dArray[i] = (double)sArray[i] * d;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: ShortSpectrumHelper.java,v 1.8 2007/10/08 14:17:33 jlpons Exp $";
    }
}

