/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.FloatImageHelper;

public class FloatSpectrumHelper
extends ANumberSpectrumHelper {
    public FloatSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.imageHelper = new FloatImageHelper(iAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        float[] fArray = new float[dArray.length];
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)(dArray[i] / d);
        }
        deviceAttribute.insert(fArray);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Float(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Float(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Float(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Float(d), bl);
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Float(d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Float(d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Float(d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Float(d), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Float(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Float(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Float(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Float(d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Float(d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Float(d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Float(d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Float(d));
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        float[] fArray = deviceAttribute.extractFloatArray();
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            dArray[i] = fArray[i];
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double d = this.attribute.getDisplayUnitFactor();
        float[] fArray = deviceAttribute.extractFloatArray();
        double[] dArray = new double[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            dArray[i] = (double)fArray[i] * d;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: FloatSpectrumHelper.java,v 1.5 2007/10/08 14:17:33 jlpons Exp $";
    }
}

