/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;

abstract class ANumberScalarHelper
extends ANumberSpectrumHelper {
    ANumberSpectrumHelper spectrumHelper;

    ANumberScalarHelper() {
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
    }

    void addNumberScalarListener(INumberScalarListener iNumberScalarListener) {
        this.propChanges.addNumberScalarListener(iNumberScalarListener);
    }

    void removeNumberScalarListener(INumberScalarListener iNumberScalarListener) {
        this.propChanges.removeNumberScalarListener(iNumberScalarListener);
    }

    void fireSpectrumValueChanged(double d, long l) {
        double[] dArray = new double[]{d};
        this.fireSpectrumValueChanged(dArray, l);
    }

    void fireScalarValueChanged(double d, long l) {
        this.propChanges.fireNumberScalarEvent((INumberScalar)this.attribute, d, l);
        this.fireSpectrumValueChanged(d, l);
    }

    abstract double getNumberScalarValue(DeviceAttribute var1);

    abstract double getNumberScalarSetPoint(DeviceAttribute var1);

    protected abstract IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] var1);

    abstract void insert(double var1);

    abstract double getNumberScalarDisplayValue(DeviceAttribute var1);

    abstract double getNumberScalarDisplaySetPoint(DeviceAttribute var1);

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        return this.spectrumHelper.getNumberSpectrumValue(deviceAttribute);
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        return this.spectrumHelper.getNumberSpectrumDisplayValue(deviceAttribute);
    }

    void insert(double[] dArray) {
        this.spectrumHelper.insert(dArray);
    }

    public String getVersion() {
        return "$Id: ANumberScalarHelper.java,v 1.7 2006/06/29 11:19:13 poncet Exp $";
    }
}

