/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.ATKEvent;
import fr.esrf.tangoatk.core.INumberImage;

public class NumberImageEvent
extends ATKEvent {
    double[][] value;
    double[][] devValue;

    public NumberImageEvent(INumberImage iNumberImage, double[][] dArray, long l) {
        super(iNumberImage, l);
        this.setValue(dArray);
        this.devValue = new double[1][1];
    }

    public double[][] getValue() {
        return this.value;
    }

    public double[][] getDeviceValue() {
        double d = 1.0;
        if (this.source != null && this.source instanceof INumberImage) {
            d = ((INumberImage)this.source).getDisplayUnitFactor();
        }
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return this.value;
        }
        int n = this.value.length;
        int n2 = this.value[0].length;
        if (n != this.devValue.length || this.devValue.length == 0 || n2 != this.devValue[0].length) {
            this.devValue = new double[n][n2];
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.devValue[i][j] = this.value[i][j] / d;
            }
        }
        return this.devValue;
    }

    public double[][] getStandardValue() {
        double d = 1.0;
        double[][] dArray = this.getDeviceValue();
        if (this.source != null && this.source instanceof INumberImage) {
            d = ((INumberImage)this.source).getStandardUnitFactor();
        }
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return dArray;
        }
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j] * d;
            }
        }
        return dArray2;
    }

    public void setValue(double[][] dArray) {
        this.value = dArray;
    }

    public void setSource(INumberImage iNumberImage) {
        this.source = iNumberImage;
    }

    public String getVersion() {
        return "$Id: NumberImageEvent.java,v 1.2 2006/06/29 11:19:12 poncet Exp $";
    }
}

