/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class EventDetails {
    private final long mTimeStamp;
    private final String mTimeStampStr;
    private final Level mLevel;
    private final String mCategoryName;
    private final String mNDC;
    private final String mThreadName;
    private final String mMessage;
    private final String[] mThrowableStrRep;
    private final String mLocationDetails;
    private static final DateFormat mDateFormatter = DateFormat.getDateTimeInstance(3, 2);

    public EventDetails(long l, Level level, String string, String string2, String string3, String string4, String[] stringArray, String string5) {
        this.mTimeStamp = l;
        Timestamp timestamp = new Timestamp(this.mTimeStamp);
        this.mTimeStampStr = mDateFormatter.format(new Date(this.mTimeStamp)) + "." + timestamp.getNanos() / 1000000;
        this.mLevel = level;
        this.mCategoryName = string;
        this.mNDC = string2;
        this.mThreadName = string3;
        this.mMessage = string4;
        this.mThrowableStrRep = stringArray;
        this.mLocationDetails = string5;
    }

    EventDetails(LoggingEvent loggingEvent) {
        this(loggingEvent.timeStamp, loggingEvent.getLevel(), loggingEvent.getLoggerName(), loggingEvent.getNDC(), loggingEvent.getThreadName(), loggingEvent.getRenderedMessage(), loggingEvent.getThrowableStrRep(), loggingEvent.getLocationInformation() == null ? null : loggingEvent.getLocationInformation().fullInfo);
    }

    long getTimeStamp() {
        return this.mTimeStamp;
    }

    String getRenderedTimeStamp() {
        return this.mTimeStampStr;
    }

    Level getLevel() {
        return this.mLevel;
    }

    String getCategoryName() {
        return this.mCategoryName;
    }

    String getNDC() {
        return this.mNDC;
    }

    String getThreadName() {
        return this.mThreadName;
    }

    String getMessage() {
        return this.mMessage;
    }

    String getLocationDetails() {
        return this.mLocationDetails;
    }

    String[] getThrowableStrRep() {
        return this.mThrowableStrRep;
    }
}

