/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.EventDetails;
import fr.esrf.logviewer.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class DetailPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getLogger((Class)(class$fr$esrf$logviewer$DetailPanel == null ? (class$fr$esrf$logviewer$DetailPanel = DetailPanel.class$("fr.esrf.logviewer.DetailPanel")) : class$fr$esrf$logviewer$DetailPanel));
    private static final MessageFormat FORMATTER = new MessageFormat("<b>Time:</b> <code>{0}</code>&nbsp;&nbsp;<b>Level:</b> <code>{1}</code>&nbsp;&nbsp;<b>Device:</b> <code>{3}</code>&nbsp;&nbsp;<b>Thread:</b> <code>{2}</code><pre>{4}</pre>");
    private final MyTableModel mModel;
    private final JEditorPane mDetails;
    static /* synthetic */ Class class$fr$esrf$logviewer$DetailPanel;

    public DetailPanel(JTable jTable, MyTableModel myTableModel) {
        this.mModel = myTableModel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Log Details"));
        this.mDetails = new JEditorPane();
        this.mDetails.setEditable(false);
        this.mDetails.setContentType("text/html");
        this.add((Component)new JScrollPane(this.mDetails), "Center");
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.mDetails.setText("Nothing selected");
        } else {
            int n = listSelectionModel.getMinSelectionIndex();
            EventDetails eventDetails = this.mModel.getEventDetails(n);
            Object[] objectArray = new Object[]{eventDetails.getRenderedTimeStamp(), eventDetails.getLevel(), this.escape(eventDetails.getThreadName()), this.escape(eventDetails.getCategoryName()), this.escape(eventDetails.getMessage())};
            this.mDetails.setText(FORMATTER.format(objectArray));
            this.mDetails.setCaretPosition(0);
        }
    }

    private static String getThrowableStrRep(EventDetails eventDetails) {
        String[] stringArray = eventDetails.getThrowableStrRep();
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append("\n");
        }
        return stringBuffer.toString();
    }

    private String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

