/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.ColumnListener;
import explorer.DeviceList;
import explorer.EntityAdapter;
import explorer.MyCellRenderer;
import explorer.Preferences;
import explorer.Status;
import explorer.ui.Clearable;
import explorer.ui.Refresher;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public abstract class EntityTableModel
extends AbstractTableModel
implements Refresher,
Clearable {
    protected List listenerList = new ArrayList();
    protected List columnIdentifiers;
    protected List columnNames;
    protected List adapters;
    protected AEntityList entities;
    protected TableColumnModel columnModel;
    protected Status status;
    protected Preferences preferences;
    protected DeviceList deviceList;
    boolean disregardPreference = false;
    public static String DEVICE = "Device";
    public static String NAME = "Name";
    public static String LEVEL = "Level";
    protected boolean refresherStarted = false;

    public void addColumnListener(ColumnListener l) {
        this.listenerList.add(l);
    }

    public void removeColumnListener(ColumnListener l) {
        this.listenerList.remove(l);
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public String getEntityAlias(IEntity entity) {
        String tmp = entity.getAlias();
        return tmp != null ? tmp : entity.getName();
    }

    public String getDeviceAlias(IDevice device) {
        String tmp = device.getAlias();
        return tmp != null ? tmp : device.getName();
    }

    public void setColumnModel(TableColumnModel model) {
        this.columnModel = model;
        this.initColumns();
    }

    public void storePreferences() {
        int i = 0;
        while (i < this.columnNames.size()) {
            String name = (String)this.columnNames.get(i);
            int index = -1;
            try {
                index = this.columnModel.getColumnIndex(name);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.putIndex(name, index);
            ++i;
        }
    }

    EntityAdapter getAdapterAt(int row) {
        return (EntityAdapter)this.adapters.get(row);
    }

    public int getRowCount() {
        if (this.adapters == null) {
            return 0;
        }
        return this.adapters.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int column) {
        if (column >= this.columnIdentifiers.size()) {
            return "URK";
        }
        return this.columnIdentifiers.get(column).toString();
    }

    public boolean exists(IEntity entity) {
        int i = 0;
        while (i < this.adapters.size()) {
            if (this.getEntityAt(i).getName().equals(entity.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addColumn(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.getColumnCount()) {
            found = name.equalsIgnoreCase(this.columnIdentifiers.get(i).toString());
            if (found) continue;
            ++i;
        }
        if (found) {
            return;
        }
        this.columnIdentifiers.add(name);
        this.putIndex(name, this.columnIdentifiers.size() - 1);
    }

    public void removeColumn(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.getColumnCount()) {
            found = name.equalsIgnoreCase(this.columnIdentifiers.get(i).toString());
            if (found) continue;
            ++i;
        }
        if (found) {
            this.columnIdentifiers.remove(i);
        }
        this.putIndex(name, -1);
    }

    public void reorderColumns() {
        if (this.columnNames == null) {
            return;
        }
        int i = 0;
        while (i < this.columnNames.size()) {
            String name = (String)this.columnNames.get(i);
            int index = this.getIndex(name, -1);
            if (index == -1) {
                this.removeColumn(name);
            } else {
                this.addColumn(name);
            }
            ++i;
        }
        this.publishColumnChange();
    }

    void publishColumnChange() {
        int i = 0;
        while (i < this.listenerList.size()) {
            ((ColumnListener)this.listenerList.get(i)).columnsChanged();
            ++i;
        }
    }

    public boolean isVisible(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.getColumnCount()) {
            found = name.equalsIgnoreCase(this.columnIdentifiers.get(i).toString());
            if (found) continue;
            ++i;
        }
        return found;
    }

    public void setVisible(String[] names, boolean[] visible) {
        int i = 0;
        while (i < names.length) {
            if (visible[i]) {
                this.addColumn(names[i]);
            } else {
                this.removeColumn(names[i]);
            }
            this.disregardPreference = true;
            this.fireTableStructureChanged();
            this.disregardPreference = false;
            ++i;
        }
    }

    public boolean containsEntity(IEntity e) {
        return this.entities.contains((Object)e);
    }

    public void addEntities(AEntityList entityList) {
        int i = 0;
        while (i < entityList.size()) {
            this.addEntity((IEntity)entityList.get(i));
            ++i;
        }
        this.reorderColumns();
        this.fireTableStructureChanged();
    }

    public void removeEntityAt(int row) {
        ((EntityAdapter)this.adapters.get(row)).remove();
        try {
            IEntity entity = this.getEntityAt(row);
            if (this.deviceList != null) {
                this.deviceList.remove(entity.getDevice());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adapters.remove(row);
        this.entities.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public AEntityList getList() {
        return this.entities;
    }

    public void setRefreshInterval(int milliseconds) {
        this.preferences.putInt("refreshInterval", milliseconds);
        this.entities.setRefreshInterval(milliseconds);
        if (this.deviceList != null) {
            this.deviceList.setRefreshInterval(milliseconds);
        }
    }

    public void startRefresher() {
        if (!this.refresherStarted) {
            this.entities.startRefresher();
            this.refresherStarted = true;
        }
        if (this.deviceList != null) {
            this.deviceList.start();
        }
    }

    public void stopRefresher() {
        this.refresherStarted = false;
        this.entities.stopRefresher();
        if (this.deviceList != null) {
            this.deviceList.stop();
        }
    }

    public void refresh() {
        this.entities.refresh();
        if (this.deviceList != null) {
            this.deviceList.refresh();
        }
    }

    public void addErrorListener(IErrorListener listener) {
        this.entities.addErrorListener(listener);
    }

    public int getRefreshInterval() {
        return this.entities.getRefreshInterval();
    }

    public void clear() {
        int size = this.adapters.size();
        int i = 0;
        while (i < size) {
            EntityAdapter adapter = (EntityAdapter)this.adapters.get(i);
            adapter.remove();
            ++i;
        }
        this.adapters.clear();
        this.entities.clear();
        this.fireTableRowsDeleted(0, size);
    }

    public List getAllColumnNames() {
        return this.columnNames;
    }

    public IEntity getEntityAt(int row) {
        return ((EntityAdapter)this.adapters.get(row)).getEntity();
    }

    int getIndex(String name, int def) {
        if (this.disregardPreference) {
            return def;
        }
        String pref = this.getPreferencePrefix().append(name).append("Index").toString();
        return this.preferences.getInt(pref, def);
    }

    void putIndex(String name, int val) {
        String pref = this.getPreferencePrefix().append(name).append("Index").toString();
        this.preferences.putInt(pref, val);
    }

    JComponent getRenderer(Object o, String column) {
        try {
            int index = this.columnModel.getColumnIndex(column);
            return ((MyCellRenderer)this.columnModel.getColumn(index).getCellRenderer()).getRenderer(o);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    JComponent getDeviceRenderer(String deviceName) {
        return this.getRenderer(deviceName, DEVICE);
    }

    protected abstract StringBuffer getPreferencePrefix();

    protected abstract boolean isExecuteColumn(int var1);

    protected abstract void initColumns();

    protected abstract void addEntity(IEntity var1);

    public void load(String name) throws ConnectionException {
        this.load(name, null, null);
    }

    public abstract void load(String var1, String var2, String var3) throws ConnectionException;

    public DeviceList getDeviceList() {
        return this.deviceList;
    }

    public void setDeviceList(DeviceList deviceList) {
        this.deviceList = deviceList;
    }

    public boolean isRefresherStarted() {
        return this.refresherStarted;
    }

    public void setSynchronizedPeriod(boolean synchro) {
        this.entities.setSynchronizedPeriod(synchro);
    }
}

