/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.CommandTableModel;
import explorer.EntityTable;
import explorer.EntityTableModel;
import explorer.Preferences;
import explorer.ViewDialog;
import explorer.ui.PreferencesDialog;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.command.AnyCommandViewer;
import fr.esrf.tangoatk.widget.dnd.NodeFactory;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CommandTable
extends EntityTable {
    protected JMenuItem execute;
    protected AnyCommandViewer commandViewer;
    protected JDialog commandDialog;

    public CommandTable(CommandTableModel model, Preferences prefs, boolean isAdmin) {
        this.setAdmin(isAdmin);
        this.preferences = prefs;
        this.initComponents(model, isAdmin);
        this.flavor = NodeFactory.MIME_COMMAND;
        this.setModel(model);
        this.initBorder();
    }

    protected void showExecuteDialog() {
        String title;
        if (this.getSelectedRow() == -1) {
            return;
        }
        ICommand command = (ICommand)this.model.getEntityAt(this.getSelectedRow());
        if (command instanceof VoidVoidCommand) {
            command.execute();
            return;
        }
        this.commandViewer = new AnyCommandViewer();
        this.commandDialog = new JDialog();
        this.commandViewer.initialize(command);
        this.commandViewer.setDeviceButtonVisible(false);
        this.commandViewer.setDescriptionVisible(true);
        this.commandViewer.setBorder(null);
        String string = title = command.getAlias() != null ? command.getAlias() : command.getName();
        if (!command.takesInput()) {
            command.execute();
        }
        this.commandDialog.setTitle(title);
        this.commandDialog.getContentPane().add((Component)this.commandViewer);
        this.commandDialog.pack();
        this.commandDialog.show();
    }

    protected void initHelp() {
        this.helpUrl = "/explorer/html/CommandTableHelp.html";
        HelpWindow.getInstance().addCategory("Command Table", "Command table", this.getClass().getResource(this.helpUrl));
    }

    protected void initMenus() {
        this.execute = new JMenuItem("Execute last selected...");
        this.execute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandTable.this.showExecuteDialog();
            }
        });
    }

    protected void initPreferences() {
        PreferencesDialog.getInstance().addCategory("Command table", "visible fields", new ViewDialog(this.model));
    }

    protected void dtHandleDrop(String name, DataFlavor flavor) {
        String mimeType = flavor.getMimeType();
        if (mimeType.startsWith(NodeFactory.MIME_COMMAND)) {
            ((CommandTableModel)this.model).addCommand(name);
            return;
        }
    }

    protected void showPopup(MouseEvent evt) {
        int row = this.getRowAtPoint(evt.getPoint());
        if (row == -1) {
            return;
        }
        int[] rows = this.getSelectedRows();
        if (evt.isPopupTrigger()) {
            if (evt.isControlDown()) {
                this.table.addRowSelectionInterval(row, row);
                rows = this.getSelectedRows();
            } else if (evt.isShiftDown()) {
                rows = this.getSelectedRows();
                int min = rows[0];
                int i = 0;
                while (i < rows.length) {
                    if (rows[i] < min) {
                        min = rows[i];
                    }
                    ++i;
                }
                this.table.addRowSelectionInterval(min, row);
                rows = this.getSelectedRows();
            } else {
                boolean isInSelection = false;
                int i = 0;
                while (i < rows.length) {
                    if (rows[i] == row) {
                        isInSelection = true;
                        break;
                    }
                    ++i;
                }
                if (!isInSelection) {
                    this.table.setRowSelectionInterval(row, row);
                }
            }
            this.popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    protected void entityTableMouseClicked(MouseEvent evt) {
        int row = this.getRowAtPoint(evt.getPoint());
        if (row == -1) {
            return;
        }
        if (this.model.isExecuteColumn(this.getColumnAtPoint(evt.getPoint())) && !evt.isPopupTrigger()) {
            this.showExecuteDialog();
        }
    }

    protected TableColumn createTableColumn(String name, int i) {
        if (EntityTableModel.DEVICE.equals(name)) {
            return new TableColumn(i, 75, this.deviceRenderer, null);
        }
        return new TableColumn(i, 75, new TableCellRenderer(){
            JButton renderer;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean focus, int row, int column) {
                if (this.renderer == null) {
                    this.renderer = new JButton();
                }
                JButton dummy = new JButton();
                if (isSelected) {
                    this.renderer.setBackground(Color.DARK_GRAY);
                    this.renderer.setForeground(Color.WHITE);
                } else {
                    this.renderer.setBackground(dummy.getBackground());
                    this.renderer.setForeground(dummy.getForeground());
                }
                try {
                    String commandName = CommandTable.this.model.getValueAt(row, column).toString();
                    this.renderer.setText(commandName);
                }
                catch (Exception e) {
                    System.out.println("CommandTableModel " + e);
                }
                return this.renderer;
            }
        }, null);
    }

    private void initBorder() {
        TitledBorder tb;
        Font font = new Font("Arial", 0, 10);
        Color color = new Color(0, 0, 150);
        String title = "Command Panel";
        TitledBorder border = tb = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, color), title, 2, 2, font, color);
        this.setBorder(border);
    }
}

