/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import pogo.gene.PogoClass;

public class InheritanceTree
extends JTree {
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tango:DeviceImpl");

    InheritanceTree() {
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        this.setCellRenderer(new InheritanceRenderer());
    }

    void updateInheritance(PogoClass server) {
        DefaultMutableTreeNode node;
        if (this.root != null) {
            this.root.removeAllChildren();
        }
        int cnt = 2;
        this.root = new DefaultMutableTreeNode("Tango:DeviceImpl");
        if (server.inherited_from != null && !server.inherited_from.equals("Device_3Impl")) {
            node = new DefaultMutableTreeNode(new AbstractClass(server.inherited_from));
            this.root.add(node);
            ++cnt;
        } else {
            node = this.root;
        }
        node.add(new DefaultMutableTreeNode(server.class_name));
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new InheritanceRenderer());
        for (int i = 0; i < cnt; ++i) {
            this.expandRow(i);
        }
    }

    class AbstractClass {
        String name;
        String path = "";

        AbstractClass(String name) {
            int start = name.lastIndexOf(47);
            if (start < 0) {
                this.name = name;
            } else {
                this.name = name.substring(start + 1);
                this.path = name.substring(0, start);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class InheritanceRenderer
    extends DefaultTreeCellRenderer {
        private Font font = new Font("helvetica", 1, 12);
        private ImageIcon icon = null;

        public InheritanceRenderer() {
            this.setTextSelectionColor(Color.blue);
            this.setBorderSelectionColor(Color.blue);
            this.setBackgroundSelectionColor(Color.white);
            this.setTextNonSelectionColor(Color.blue);
            this.setBackgroundNonSelectionColor(Color.white);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String tip = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (node.isRoot()) {
                tip = "TANGO device";
            } else if (obj instanceof AbstractClass) {
                tip = "Abstract Class " + ((AbstractClass)obj).name + " :\n" + ((AbstractClass)obj).path;
            }
            this.setFont(this.font);
            this.setIcon(this.icon);
            this.setToolTipText(tip);
            return this;
        }
    }
}

