/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class StringImageHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;
    String[][] retval = new String[1][1];

    public StringImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireImageValueChanged(String[][] stringArray, long l) {
        this.propChanges.fireStringImageEvent((IStringImage)this.attribute, stringArray, l);
    }

    void insert(String[][] stringArray) {
        String[] stringArray2 = this.flatten(stringArray);
        this.attribute.getAttribute().insert(stringArray2, stringArray.length, stringArray[0].length);
    }

    String[] flatten(String[][] stringArray) {
        int n = stringArray.length * stringArray[0].length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            System.arraycopy(stringArray[i], 0, stringArray2, i * stringArray.length, stringArray.length);
        }
        return stringArray2;
    }

    String[][] getStringImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        String[] stringArray = deviceAttribute.extractStringArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new String[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = stringArray[n3++];
            }
        }
        return this.retval;
    }

    void addStringImageListener(IStringImageListener iStringImageListener) {
        this.propChanges.addStringImageListener(iStringImageListener);
    }

    void removeStringImageListener(IStringImageListener iStringImageListener) {
        this.propChanges.removeStringImageListener(iStringImageListener);
    }

    public String getVersion() {
        return "$Id: StringImageHelper.java,v 1.2 2007/11/14 17:55:27 poncet Exp $";
    }
}

