/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeScalarHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringScalarHistory;
import java.io.Serializable;
import java.util.Vector;

public class StringAttributeHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;

    public StringAttributeHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    protected StringScalarHistory[] getStringScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        Vector<StringScalarHistory> vector = new Vector<StringScalarHistory>();
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            StringScalarHistory stringScalarHistory = new StringScalarHistory();
            try {
                stringScalarHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                stringScalarHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    stringScalarHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    stringScalarHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    stringScalarHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    stringScalarHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    stringScalarHistory.setState("CHANGING");
                } else {
                    stringScalarHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                stringScalarHistory.setState("UNKNOWN");
            }
            try {
                stringScalarHistory.setValue(deviceDataHistoryArray[i].extractString());
            }
            catch (Exception exception) {
                stringScalarHistory.setValue(null);
            }
            vector.add(i, stringScalarHistory);
        }
        StringScalarHistory[] stringScalarHistoryArray = vector.toArray(new StringScalarHistory[0]);
        return stringScalarHistoryArray;
    }

    protected IAttributeScalarHistory[] getScalarAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getStringScalarAttHistory(deviceDataHistoryArray);
    }

    public String getStringScalarSetPoint(DeviceAttribute deviceAttribute) {
        String[] stringArray = null;
        try {
            stringArray = deviceAttribute.extractStringArray();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (stringArray == null) {
            return "???";
        }
        if (stringArray.length < 1) {
            return "???";
        }
        if (stringArray.length > 1) {
            return stringArray[1];
        }
        return stringArray[0];
    }

    public String getVersion() {
        return "$Id: StringAttributeHelper.java,v 1.9 2007/07/03 15:31:46 poncet Exp $";
    }
}

