/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.EditDialog;
import admin.astor.access.UsersTree;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class TangoAccess
extends JFrame {
    String access_devname;
    private UsersTree tree = null;
    private AccessProxy access_dev;
    private EditDialog check_dlg = null;
    private boolean from_another_appli = false;
    private JMenu actionMenu;
    private JMenuItem addUserBtn;
    private JMenuItem checkAccessBtn;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JRadioButtonMenuItem registerItem;

    public TangoAccess(JFrame parent) throws DevFailed {
        this(parent, null);
    }

    public TangoAccess(JFrame parent, String devname) throws DevFailed {
        if (parent != null) {
            this.from_another_appli = true;
        }
        if (devname == null) {
            String[] services = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
            if (services.length == 0) {
                Except.throw_communication_failed((String)"Service_DoesNotExist", (String)"There is no AccessControl service defined !", (String)"TangoAccess.TangoAccess()");
            }
            this.access_devname = services[0];
        } else {
            this.access_devname = devname;
        }
        this.initComponents();
        this.initOwnComponents();
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/app_util/img/tango_icon.jpg"));
        this.setIconImage(icon.getImage());
        this.setTitle("Tango Access Control Manager");
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
    }

    private void initOwnComponents() throws DevFailed {
        this.fileMenu.setMnemonic('F');
        this.addUserBtn.setMnemonic('U');
        this.addUserBtn.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.checkAccessBtn.setMnemonic('T');
        this.checkAccessBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.access_dev = new AccessProxy(this.access_devname);
        if (this.access_dev.getAccessControl() == 0) {
            this.actionMenu.setVisible(false);
        } else {
            this.actionMenu.setMnemonic('A');
            this.registerItem.setMnemonic('R');
        }
        this.tree = new UsersTree(this, this.access_dev);
        JScrollPane scrowllPane = new JScrollPane();
        scrowllPane.setPreferredSize(new Dimension(350, 550));
        scrowllPane.setViewportView(this.tree);
        this.getContentPane().add((Component)scrowllPane, "Center");
    }

    private void initComponents() {
        JMenuBar jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.addUserBtn = new JMenuItem();
        this.checkAccessBtn = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.actionMenu = new JMenu();
        this.registerItem = new JRadioButtonMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TangoAccess.this.exitForm(evt);
            }
        });
        this.fileMenu.setText("File");
        this.addUserBtn.setText("Add User");
        this.addUserBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.addUserBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.addUserBtn);
        this.checkAccessBtn.setText("Test Tango Acces");
        this.checkAccessBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.checkAccessBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.checkAccessBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar1.add(this.fileMenu);
        this.actionMenu.setText("Action");
        this.actionMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TangoAccess.this.actionMenuItemStateChanged(evt);
            }
        });
        this.registerItem.setText("Register Service");
        this.registerItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.registerItemActionPerformed(evt);
            }
        });
        this.actionMenu.add(this.registerItem);
        jMenuBar1.add(this.actionMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void actionMenuItemStateChanged(ItemEvent evt) {
        if (!this.actionMenu.isSelected()) {
            return;
        }
        try {
            String[] services = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
            this.registerItem.setSelected(services.length != 0);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)e);
        }
    }

    private void registerItemActionPerformed(ActionEvent evt) {
        try {
            boolean b = this.registerItem.getSelectedObjects() != null;
            this.access_dev.registerService(b);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)e);
        }
    }

    private void checkAccessBtnActionPerformed(ActionEvent evt) {
        if (this.check_dlg == null) {
            this.check_dlg = new EditDialog(this, this.access_dev);
            this.check_dlg.showDialog();
        } else {
            this.check_dlg.setVisible(true);
        }
    }

    private void addUserBtnActionPerformed(ActionEvent evt) {
        EditDialog dlg = new EditDialog(this);
        if (dlg.showDialog() == 0) {
            this.tree.addUserNode(dlg.getInputs());
        }
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.from_another_appli) {
            this.setVisible(false);
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            String devname = null;
            if (args.length > 0) {
                devname = args[0];
            }
            new TangoAccess((JFrame)null, devname).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"Cannot start TangoAccess class", (DevFailed)e);
            System.exit(0);
        }
    }
}

