/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.TangoServer;
import admin.astor.tools.PollingProfiler;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ManagePollingDialog
extends JDialog
implements TangoConst {
    private Component parent;
    private String[] commands;
    private String[] attributes;
    private TangoServer server;
    private JButton addBtn;
    private JRadioButton attrBtn;
    private JComboBox cmdBox;
    private JRadioButton cmdBtn;
    private JLabel cmdLabel;
    private JComboBox devicesBox;
    private JButton dismissBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton profilerBtn;
    private JButton removeBtn;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JButton updateBtn;

    private void setCmdAttrBox() {
        String[] strArray;
        if (this.cmdBtn.getSelectedObjects() != null) {
            this.cmdLabel.setText("Command Selection");
            strArray = this.commands;
        } else {
            this.cmdLabel.setText("Attribute Selection");
            strArray = this.attributes;
        }
        this.cmdBox.removeAllItems();
        for (int i = 0; i < strArray.length; ++i) {
            this.cmdBox.addItem(strArray[i]);
        }
        this.pack();
    }

    private void initComponentsFromDevices() {
        try {
            String[] devices = this.server.queryDevice();
            for (int i = 0; i < devices.length; ++i) {
                this.devicesBox.addItem(devices[i]);
            }
            this.devicesBox.addItem("*");
            this.devicesBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ManagePollingDialog.this.devSelectionActionPerformed(evt);
                }
            });
            this.cmdBtn.setSelected(false);
            this.attrBtn.setSelected(true);
            this.getAttrCmdLists(devices[0]);
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
    }

    private void getAttrCmdLists(String devname) {
        try {
            int i;
            DeviceProxy dev = new DeviceProxy(devname);
            CommandInfo[] cmd_list = dev.command_list_query();
            int nb = 0;
            for (i = 0; i < cmd_list.length; ++i) {
                if (cmd_list[i].in_type != 0 || cmd_list[i].cmd_name.equals("Init")) continue;
                ++nb;
            }
            this.commands = new String[nb];
            int j = 0;
            for (i = 0; i < cmd_list.length; ++i) {
                if (cmd_list[i].in_type != 0 || cmd_list[i].cmd_name.equals("Init")) continue;
                this.commands[j++] = cmd_list[i].cmd_name;
            }
            this.attributes = dev.get_attribute_list();
            this.setCmdAttrBox();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
            return;
        }
    }

    private void devSelectionActionPerformed(ActionEvent evt) {
        String devname = this.devicesBox.getSelectedItem().toString();
        if (!devname.equals("*")) {
            this.getAttrCmdLists(devname);
        }
    }

    public ManagePollingDialog(JDialog parent, TangoServer server) {
        super((Dialog)parent, false);
        this.server = server;
        this.parent = parent;
        this.setTitle("Device Polling Management Window");
        this.initComponents();
        this.initComponentsFromDevices();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.displayStatus();
        this.pack();
    }

    public ManagePollingDialog(JFrame parent, String devname, String attname) throws DevFailed {
        super((Frame)parent, false);
        this.server = new TangoServer(new DeviceProxy(devname).adm_name());
        this.parent = parent;
        this.setTitle("Device Polling Management Window");
        this.initComponents();
        this.initComponentsFromDevices();
        this.devicesBox.setSelectedItem(devname);
        this.cmdBox.setSelectedItem(attname);
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.displayStatus();
        this.pack();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.updateBtn = new JButton();
        this.jLabel8 = new JLabel();
        this.profilerBtn = new JButton();
        this.jLabel9 = new JLabel();
        this.dismissBtn = new JButton();
        this.jPanel3 = new JPanel();
        this.devicesBox = new JComboBox();
        this.cmdBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cmdLabel = new JLabel();
        this.addBtn = new JButton();
        this.jLabel3 = new JLabel();
        this.removeBtn = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cmdBtn = new JRadioButton();
        this.attrBtn = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ManagePollingDialog.this.closeDialog(evt);
            }
        });
        this.updateBtn.setText("Update Status");
        this.updateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.updateBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.updateBtn);
        this.jLabel8.setText("        ");
        this.jPanel2.add(this.jLabel8);
        this.profilerBtn.setText("Show Profiler");
        this.profilerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.profilerBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.profilerBtn);
        this.jLabel9.setText("        ");
        this.jPanel2.add(this.jLabel9);
        this.dismissBtn.setText("Dismiss");
        this.dismissBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.dismissBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.dismissBtn);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel3.setLayout(new GridBagLayout());
        this.devicesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.devicesBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.devicesBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.cmdBox, gridBagConstraints);
        this.jLabel2.setText("Device Selection");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.cmdLabel.setText("command :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel3.add((Component)this.cmdLabel, gridBagConstraints);
        this.addBtn.setText("Add / Update");
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.addBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.addBtn, gridBagConstraints);
        this.jLabel3.setFont(new Font("Dialog", 0, 36));
        this.jLabel3.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.removeBtn.setText("Remove");
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.removeBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.removeBtn, gridBagConstraints);
        this.jLabel4.setFont(new Font("Dialog", 0, 36));
        this.jLabel4.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Polling  on   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.cmdBtn.setText("Command");
        this.cmdBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.cmdBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.cmdBtn, gridBagConstraints);
        this.attrBtn.setText("Attribute");
        this.attrBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.attrBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.attrBtn, gridBagConstraints);
        this.jLabel7.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel3, "West");
        this.textScrollPane.setPreferredSize(new Dimension(450, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier New", 1, 12));
        this.textScrollPane.setViewportView(this.textArea);
        this.getContentPane().add((Component)this.textScrollPane, "Center");
        this.pack();
    }

    private void profilerBtnActionPerformed(ActionEvent evt) {
        String[] devnames = this.selectedDevices();
        try {
            if (this.parent instanceof JFrame) {
                new PollingProfiler((JFrame)this.parent, devnames).setVisible(true);
            } else {
                new PollingProfiler((JDialog)this.parent, devnames).setVisible(true);
            }
        }
        catch (DevFailed e) {
            PopupError.show((Component)this, e);
        }
    }

    private String[] selectedDevices() {
        String[] names;
        String item = this.devicesBox.getSelectedItem().toString();
        if (item.equals("*")) {
            int nb = this.devicesBox.getItemCount() - 1;
            names = new String[nb];
            for (int i = 0; i < nb; ++i) {
                names[i] = this.devicesBox.getItemAt(i).toString();
            }
        } else {
            names = new String[]{item};
        }
        return names;
    }

    private void displayStatus() {
        String[] devnames = this.selectedDevices();
        String message = "        Polling Status\n\n";
        for (int i = 0; i < devnames.length; ++i) {
            try {
                message = message + "=============================================\n";
                message = message + devnames[i] + " :\n\n";
                DeviceProxy dev = new DeviceProxy(devnames[i]);
                String[] status = dev.polling_status();
                for (int st = 0; st < status.length; ++st) {
                    message = message + status[st] + "\n";
                    if (st >= status.length - 1) continue;
                    message = message + "   ---------------------------------\n";
                }
                if (status.length <= 0) continue;
                message = message + "\n\n";
                continue;
            }
            catch (DevFailed e) {
                PopupError.show((Component)this, e);
                return;
            }
        }
        this.textArea.setText(message);
        this.textArea.setCaretPosition(0);
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        int i;
        String[] devnames = this.selectedDevices();
        String polled_obj_name = this.cmdBox.getSelectedItem().toString();
        String message = "Remove polling on " + polled_obj_name + " for:\n";
        for (i = 0; i < devnames.length; ++i) {
            message = message + devnames[i] + ",  ";
        }
        if (JOptionPane.showConfirmDialog(this, message, "Question ?", 0) == 0) {
            message = polled_obj_name + " polling has been removed for:\n";
            for (i = 0; i < devnames.length; ++i) {
                try {
                    DeviceProxy dev = new DeviceProxy(devnames[i]);
                    if (this.cmdBtn.getSelectedObjects() != null) {
                        dev.stop_poll_command(polled_obj_name);
                    } else {
                        dev.stop_poll_attribute(polled_obj_name);
                    }
                    message = message + devnames[i] + "\n";
                    continue;
                }
                catch (DevFailed e) {
                    PopupError.show((Component)this, e);
                    return;
                }
            }
            PopupMessage.show((Component)this, message);
            this.displayStatus();
        }
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        String[] devnames = this.selectedDevices();
        boolean ok = false;
        String strval = "";
        int polling_period = 0;
        while (!ok) {
            if ((strval = (String)JOptionPane.showInputDialog(this, "Polling period (ms)  ?", "Polling period", 1, null, null, strval)) == null) {
                return;
            }
            try {
                polling_period = Integer.parseInt(strval);
                if (polling_period < 20) {
                    PopupError.show((Component)this, "The polling period minimum value is 20ms");
                    continue;
                }
                ok = true;
            }
            catch (NumberFormatException e) {
                PopupError.show((Component)this, e.toString() + "\n\nBad Value in Polling period field !");
            }
        }
        String polled_obj_name = this.cmdBox.getSelectedItem().toString();
        StringBuffer message = new StringBuffer(polled_obj_name + " polling has been added for:\n");
        for (int i = 0; i < devnames.length; ++i) {
            try {
                DeviceProxy dev = new DeviceProxy(devnames[i]);
                if (this.cmdBtn.getSelectedObjects() != null) {
                    dev.poll_command(polled_obj_name, polling_period);
                } else {
                    dev.poll_attribute(polled_obj_name, polling_period);
                }
                message.append(devnames[i] + "\n");
                continue;
            }
            catch (DevFailed e) {
                PopupError.show((Component)this, e);
            }
        }
        PopupMessage.show((Component)this, message.toString());
        this.displayStatus();
    }

    private void attrBtnActionPerformed(ActionEvent evt) {
        if (this.attrBtn.getSelectedObjects() != null) {
            this.cmdBtn.setSelected(false);
        }
        this.setCmdAttrBox();
    }

    private void cmdBtnActionPerformed(ActionEvent evt) {
        if (this.cmdBtn.getSelectedObjects() != null) {
            this.attrBtn.setSelected(false);
        }
        this.setCmdAttrBox();
    }

    private void devicesBoxActionPerformed(ActionEvent evt) {
        this.displayStatus();
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        this.displayStatus();
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

