/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;

public class HostStateThread
extends Thread
implements AstorDefs {
    private AstorTree parent;
    private TangoHost host;
    private int readInfoPeriod;
    boolean stop_it = false;
    private String[] attributes = new String[]{"state", "NotifdState"};
    private static final int StateAtt = 0;
    private static final int NotifdAtt = 1;
    private DevState previous_state = DevState.UNKNOWN;
    private static String[] filters = new String[0];
    private StateEventListener state_listener = null;

    public HostStateThread(AstorTree parent, TangoHost host) {
        this.parent = parent;
        this.host = host;
        host.thread = this;
        this.readInfoPeriod = AstorUtil.getStarterReadPeriod() / 2;
    }

    public synchronized void updateData() {
        this.notify();
    }

    public void run() {
        while (!this.stop_it) {
            long t0 = System.currentTimeMillis();
            if (!this.host.use_events && this.host.do_polling) {
                this.manageSynchronousAttributes();
            }
            this.wait_next_loop(t0);
        }
    }

    public synchronized void wait_next_loop(long t0) {
        try {
            long t1 = System.currentTimeMillis();
            long time_to_sleep = (long)this.readInfoPeriod - (t1 - t0);
            if (time_to_sleep <= 0L) {
                time_to_sleep = 100L;
            }
            this.wait(time_to_sleep);
        }
        catch (InterruptedException e) {
            System.out.println(e);
        }
    }

    public synchronized void updateHost(DevState state) {
        if (state == this.previous_state) {
            return;
        }
        this.previous_state = state;
        this.host.state = state == DevState.ON ? 3 : (state == DevState.MOVING ? 4 : (state == DevState.ALARM ? 2 : (state == DevState.FAULT ? 1 : 0)));
        if (this.parent != null) {
            this.parent.updateState();
        }
        if (this.host.info_dialog != null) {
            this.host.info_dialog.updateHostState();
        }
    }

    public synchronized void updateNotifdHost(DevState notifd_state) {
        int notifyd_state = 0;
        if (notifd_state == DevState.ON) {
            notifyd_state = 3;
        } else if (notifd_state == DevState.FAULT) {
            notifyd_state = 1;
        }
        if (this.host.notifyd_state == notifyd_state) {
            return;
        }
        this.host.notifyd_state = notifyd_state;
        if (this.parent != null) {
            this.parent.updateState();
        }
        if (this.host.info_dialog != null) {
            this.host.info_dialog.updateHostState();
        }
    }

    private void manageSynchronousAttributes() {
        DevState notifd_state;
        DevState host_state;
        String[] starting = new String[]{};
        try {
            DeviceAttribute[] att = this.host.read_attribute(this.attributes);
            host_state = att[0].hasFailed() ? DevState.FAULT : att[0].extractState();
            notifd_state = att[1].hasFailed() ? DevState.UNKNOWN : att[1].extractState();
        }
        catch (DevFailed e) {
            if (e instanceof DevFailed) {
                this.host.except = e;
            } else {
                DevError[] errors = new DevError[1];
                errors[0].reason = "manageSynchronousAttributes_Failed";
                errors[0].desc = e.toString();
                errors[0].origin = "HostStateThread(" + this.host.name() + ").manageSynchronousAttributes()";
                this.host.except = new DevFailed(errors);
                e.printStackTrace();
            }
            notifd_state = DevState.UNKNOWN;
            host_state = DevState.FAULT;
        }
        this.updateHost(host_state);
        if (this.host.check_notifd) {
            this.updateNotifdHost(notifd_state);
        }
    }

    public void subscribeChangeStateEvent() {
        long t0 = System.currentTimeMillis();
        String strerror = null;
        try {
            if (this.host.supplier == null) {
                this.host.supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
            if (this.state_listener == null) {
                this.state_listener = new StateEventListener();
                this.host.supplier.addTangoChangeListener((ITangoChangeListener)this.state_listener, this.attributes[0], filters);
            }
        }
        catch (DevFailed e) {
            this.state_listener = null;
            this.host.use_events = false;
            strerror = "subscribeChangeStateEvent() for " + this.host.name() + " FAILED !\n" + e.errors[0].desc;
            Except.print_exception((Exception)((Object)e));
        }
        catch (Exception e) {
            this.state_listener = null;
            this.host.use_events = false;
            strerror = "subscribeChangeStateEvent() for " + this.host.name() + " FAILED !" + e.toString();
            e.printStackTrace();
        }
        long t1 = System.currentTimeMillis();
        if (strerror != null) {
            System.out.println(strerror);
        }
        this.parent.updateMonitor(strerror);
    }

    class StateEventListener
    implements ITangoChangeListener {
        StateEventListener() {
        }

        public void change(TangoChangeEvent event) {
            TangoChange tc = (TangoChange)event.getSource();
            String devname = tc.getEventSupplier().name();
            DevState host_state = DevState.UNKNOWN;
            DevState notifd_state = DevState.UNKNOWN;
            try {
                DeviceAttribute attr = event.getValue();
                host_state = attr.hasFailed() ? DevState.UNKNOWN : attr.extractState();
            }
            catch (DevFailed e) {
                host_state = DevState.ALARM;
                notifd_state = DevState.UNKNOWN;
                if (e.errors[0].reason.equals("API_EventTimeout")) {
                    System.out.println("HostStateThread.StateEventListener" + devname + " : API_EventTimeout");
                    try {
                        HostStateThread.this.host.ping();
                    }
                    catch (DevFailed e2) {
                        host_state = DevState.FAULT;
                    }
                } else if (e.errors[0].reason.equals("TangoApi_CANNOT_IMPORT_DEVICE")) {
                    System.out.println("HostStateThread.StateEventListener" + devname + " : TangoApi_CANNOT_IMPORT_DEVICE");
                    host_state = DevState.FAULT;
                }
            }
            catch (Exception e) {
                notifd_state = DevState.UNKNOWN;
                System.out.println("AstorEvent." + devname);
                System.out.println(e);
                System.out.println("HostStateThread.StateEventListener : could not extract data!");
                host_state = DevState.UNKNOWN;
            }
            try {
                DeviceAttribute att_synch = HostStateThread.this.host.read_attribute(HostStateThread.this.attributes[1]);
                notifd_state = att_synch.hasFailed() ? DevState.UNKNOWN : att_synch.extractState();
            }
            catch (Exception e) {
                notifd_state = DevState.UNKNOWN;
            }
            HostStateThread.this.updateNotifdHost(notifd_state);
            HostStateThread.this.updateHost(host_state);
        }
    }
}

