/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.PartialDerivative;
import org.lsmp.djep.xjep.PrintVisitor;
import org.lsmp.djep.xjep.XVariable;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DVariable
extends XVariable {
    protected Hashtable derivatives = new Hashtable();

    protected PartialDerivative createDerivative(String[] stringArray, Node node) {
        return new PartialDerivative(this, stringArray, node);
    }

    protected DVariable(String string) {
        super(string);
    }

    protected DVariable(String string, Object object) {
        super(string, object);
    }

    public void setEquation(Node node) {
        super.setEquation(node);
        this.derivatives.clear();
    }

    public void invalidateAll() {
        if (this.isConstant()) {
            return;
        }
        this.setValidValue(false);
        Enumeration enumeration = this.derivatives.elements();
        while (enumeration.hasMoreElements()) {
            PartialDerivative partialDerivative = (PartialDerivative)enumeration.nextElement();
            partialDerivative.setValidValue(false);
        }
    }

    public static String makeDerivString(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('d');
        if (stringArray.length != 1) {
            stringBuffer.append("^" + stringArray.length);
        }
        stringBuffer.append(string);
        stringBuffer.append('/');
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append('d');
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String[] sortedNames(String[] stringArray) {
        Object[] objectArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Arrays.sort(objectArray);
        return objectArray;
    }

    void setDerivative(String[] stringArray, PartialDerivative partialDerivative) {
        String[] stringArray2 = this.sortedNames(stringArray);
        this.derivatives.put(DVariable.makeDerivString(this.name, stringArray2), partialDerivative);
    }

    void setDerivativeSorted(String[] stringArray, PartialDerivative partialDerivative) {
        this.derivatives.put(DVariable.makeDerivString(this.name, stringArray), partialDerivative);
    }

    PartialDerivative getDerivative(String[] stringArray) {
        String[] stringArray2 = this.sortedNames(stringArray);
        return (PartialDerivative)this.derivatives.get(DVariable.makeDerivString(this.name, stringArray2));
    }

    PartialDerivative getDerivativeSorted(String[] stringArray) {
        return (PartialDerivative)this.derivatives.get(DVariable.makeDerivString(this.name, stringArray));
    }

    PartialDerivative findDerivativeSorted(String[] stringArray, DJep dJep) throws ParseException {
        Object object;
        Node node;
        if (this.getEquation() == null) {
            return null;
        }
        if (stringArray == null) {
            throw new ParseException("findDerivativeSorted: Null array of names");
        }
        PartialDerivative partialDerivative = this.getDerivativeSorted(stringArray);
        if (partialDerivative != null) {
            return partialDerivative;
        }
        int n = stringArray.length;
        if (n < 1) {
            throw new ParseException("findDerivativeSorted: Empty Array of names");
        }
        if (n == 1) {
            node = this.getEquation();
        } else {
            object = new String[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                object[i] = stringArray[i];
            }
            node = this.findDerivativeSorted((String[])object, dJep).getEquation();
        }
        if (node == null) {
            return null;
        }
        object = dJep.differentiate(node, stringArray[n - 1]);
        Node node2 = dJep.simplify((Node)object);
        partialDerivative = this.createDerivative(stringArray, node2);
        this.setDerivative(stringArray, partialDerivative);
        return partialDerivative;
    }

    PartialDerivative findDerivative(String[] stringArray, DJep dJep) throws ParseException {
        String[] stringArray2 = this.sortedNames(stringArray);
        return this.findDerivativeSorted(stringArray2, dJep);
    }

    PartialDerivative findDerivative(String string, DJep dJep) throws ParseException {
        String[] stringArray = new String[]{string};
        return this.findDerivativeSorted(stringArray, dJep);
    }

    PartialDerivative findDerivative(PartialDerivative partialDerivative, String string, DJep dJep) throws ParseException {
        int n = partialDerivative.getDnames().length;
        String[] stringArray = new String[n + 1];
        System.arraycopy(partialDerivative.getDnames(), 0, stringArray, 0, n);
        stringArray[n] = string;
        return this.findDerivative(stringArray, dJep);
    }

    public String toString(PrintVisitor printVisitor) {
        boolean bl = printVisitor.getMode(32);
        printVisitor.setMode(32, false);
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append(":\t");
        if (this.hasValidValue()) {
            stringBuffer.append(this.getValue());
        } else {
            stringBuffer.append("NA");
        }
        stringBuffer.append("\t");
        if (this.isConstant()) {
            stringBuffer.append("constant");
        } else if (this.getEquation() != null) {
            stringBuffer.append("eqn " + printVisitor.toString(this.getEquation()));
        } else {
            stringBuffer.append("no equation");
        }
        Enumeration enumeration = this.derivatives.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n");
            PartialDerivative partialDerivative = (PartialDerivative)enumeration.nextElement();
            stringBuffer.append("\t" + partialDerivative.toString() + ": ");
            if (partialDerivative.hasValidValue()) {
                stringBuffer.append(partialDerivative.getValue());
            } else {
                stringBuffer.append("NA");
            }
            stringBuffer.append("\t");
            stringBuffer.append(printVisitor.toString(partialDerivative.getEquation()));
        }
        printVisitor.setMode(32, bl);
        return stringBuffer.toString();
    }

    public Enumeration allDerivatives() {
        return this.derivatives.elements();
    }
}

