/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.UCharImageHelper;

public class UCharSpectrumHelper
extends ANumberSpectrumHelper {
    public UCharSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.imageHelper = new UCharImageHelper(iAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        short[] sArray = new short[dArray.length];
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(dArray[i] / d);
        }
        deviceAttribute.insert_uc(sArray);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Double(d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Double(d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Double(d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Double(d));
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Double(d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Double(d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Double(d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Double(d), bl);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Double(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Double(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Double(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Double(d), bl);
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        short[] sArray = deviceAttribute.extractUCharArray();
        double[] dArray = new double[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            dArray[i] = sArray[i];
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        short[] sArray = deviceAttribute.extractUCharArray();
        double d = this.attribute.getDisplayUnitFactor();
        double[] dArray = new double[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            dArray[i] = (double)sArray[i] * d;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: UCharSpectrumHelper.java,v 1.4 2007/10/08 14:17:33 jlpons Exp $";
    }
}

