/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.LongImageHelper;

public class LongSpectrumHelper
extends ANumberSpectrumHelper {
    public LongSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.imageHelper = new LongImageHelper(iAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        int[] nArray = new int[dArray.length];
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(dArray[i] / d);
        }
        deviceAttribute.insert(nArray);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Long((long)d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Long((long)d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Long((long)d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Long((long)d));
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Long((long)d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Long((long)d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Long((long)d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Long((long)d), bl);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Long((long)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Long((long)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Long((long)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Long((long)d), bl);
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractLongArray();
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractLongArray();
        double d = this.attribute.getDisplayUnitFactor();
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = (double)nArray[i] * d;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: LongSpectrumHelper.java,v 1.8 2007/10/08 14:17:33 jlpons Exp $";
    }
}

