/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.GetTextDialog;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class PreferenceDialog
extends JDialog {
    private JFrame parent;
    private String[] last_collection = new String[0];
    private String[] known_tango_hosts = new String[0];
    private String[] tools = new String[0];
    private String[] pages = new String[]{"Device Servers", "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/index.html"};
    private String rl_user = "";
    private String rl_cmd = "rlogin";
    private boolean jiveReadOnly = false;
    private JButton cancelBtn;
    private JButton helpPagesBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator5;
    private JSeparator jSeparator7;
    private JRadioButton jiveRObtn;
    private JButton lastCollectionBtn;
    private JButton okBtn;
    private JPanel prefPanel;
    private JTextField rshCmdTxt;
    private JTextField rshUserTxt;
    private JButton tangoHostsBtn;
    private JLabel titleLabel;
    private JButton toolsBtn;

    public PreferenceDialog(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.initialize();
        this.titleLabel.setText(AstorUtil.getTangoHost() + "  preferences");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void storePreferences() {
        this.rl_user = this.rshUserTxt.getText();
        this.rl_cmd = this.rshCmdTxt.getText();
        if (this.rl_user == null) {
            this.rl_user = "";
        }
        if (this.rl_cmd == null) {
            this.rl_cmd = "";
        }
        if (this.tools == null) {
            this.tools = new String[0];
        }
        if (this.last_collection == null) {
            this.last_collection = new String[0];
        }
        if (this.known_tango_hosts == null) {
            this.known_tango_hosts = new String[0];
        }
        if (this.pages == null) {
            this.pages = new String[0];
        }
        AstorUtil util = AstorUtil.getInstance();
        util.setJiveReadOnly(this.jiveReadOnly);
        AstorUtil.setRloginUser(this.rl_user);
        AstorUtil.setRloginCmd(this.rl_cmd);
        util.setLastCollectionList(this.last_collection);
        AstorUtil.setKnownTangoHosts(this.known_tango_hosts);
        AstorUtil.setTools(this.tools);
        AstorUtil.setHtmlHelps(this.pages);
        try {
            util.putAstorProperties();
            PopupMessage.show((Component)this, "The preferences have been saved for " + AstorUtil.getTangoHost());
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot put Astor properties", (DevFailed)e);
        }
    }

    private void initialize() {
        AstorUtil util = AstorUtil.getInstance();
        this.last_collection = util.getLastCollectionList();
        this.known_tango_hosts = util.getKnownTangoHosts();
        this.tools = util.getTools();
        this.pages = util.getHtmlHelps();
        this.jiveReadOnly = util.jiveIsReadOnly();
        this.setJiveBtn(this.jiveReadOnly);
        this.rl_user = util.getRloginUser();
        if (this.rl_user != null) {
            this.rshUserTxt.setText(this.rl_user);
        }
        this.rl_cmd = util.getRloginCmd();
        if (this.rl_cmd != null) {
            this.rshCmdTxt.setText(this.rl_cmd);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.prefPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.rshUserTxt = new JTextField();
        this.jLabel2 = new JLabel();
        this.rshCmdTxt = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.jiveRObtn = new JRadioButton();
        this.jSeparator5 = new JSeparator();
        this.jSeparator7 = new JSeparator();
        this.lastCollectionBtn = new JButton();
        this.tangoHostsBtn = new JButton();
        this.toolsBtn = new JButton();
        this.helpPagesBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PreferenceDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.prefPanel.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jLabel1.setText("Remote login user :");
        this.jLabel1.setToolTipText("Default user name used for remote login on a host.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.rshUserTxt.setColumns(12);
        this.rshUserTxt.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.rshUserTxt.setToolTipText("Default user name used for remote login on a host.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.rshUserTxt, gridBagConstraints);
        this.jLabel2.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jLabel2.setText("Remote login command :");
        this.jLabel2.setToolTipText("Command used for remote login on a host (rlogin, ssh, ...).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.rshCmdTxt.setColumns(12);
        this.rshCmdTxt.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.rshCmdTxt.setText("rlogin");
        this.rshCmdTxt.setToolTipText("Command used for remote login on a host (rlogin, ssh, ...).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.rshCmdTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator3, gridBagConstraints);
        this.jLabel5.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jLabel5.setText("Start Jive in READ_ONLY mode :");
        this.jLabel5.setToolTipText("Mode to start jive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.jiveRObtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jiveRObtn.setText("false");
        this.jiveRObtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jiveRObtn.setMargin(new Insets(0, 0, 0, 0));
        this.jiveRObtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.jiveRObtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        this.prefPanel.add((Component)this.jiveRObtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.prefPanel.add((Component)this.jSeparator7, gridBagConstraints);
        this.lastCollectionBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.lastCollectionBtn.setText("Last Collections :");
        this.lastCollectionBtn.setToolTipText("List of collections (families) displayed at the end of the control system tree.");
        this.lastCollectionBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.lastCollectionBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.lastCollectionBtn, gridBagConstraints);
        this.tangoHostsBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.tangoHostsBtn.setText("Known Tango Hosts");
        this.tangoHostsBtn.setToolTipText("List of   TANGO_HOST known (used to change during execution).");
        this.tangoHostsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.tangoHostsBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.tangoHostsBtn, gridBagConstraints);
        this.toolsBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.toolsBtn.setText("Additional tools :");
        this.toolsBtn.setToolTipText("List of  additiannal tools (see  Astor pages).");
        this.toolsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.toolsBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.toolsBtn, gridBagConstraints);
        this.helpPagesBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.helpPagesBtn.setText("Help pages");
        this.helpPagesBtn.setToolTipText("List of   help  pages (as tools see Astor pages).");
        this.helpPagesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.helpPagesBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.prefPanel.add((Component)this.helpPagesBtn, gridBagConstraints);
        this.getContentPane().add((Component)this.prefPanel, "Center");
        this.pack();
    }

    private void helpPagesBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        GetTextDialog dlg = new GetTextDialog(this, btn.getText(), btn.getToolTipText(), this.pages);
        if (dlg.showDialog() == 0) {
            this.pages = dlg.getTextLines();
        }
    }

    private void toolsBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        GetTextDialog dlg = new GetTextDialog(this, btn.getText(), btn.getToolTipText(), this.tools);
        if (dlg.showDialog() == 0) {
            this.tools = dlg.getTextLines();
        }
    }

    private void tangoHostsBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        GetTextDialog dlg = new GetTextDialog(this, btn.getText(), btn.getToolTipText(), this.known_tango_hosts);
        if (dlg.showDialog() == 0) {
            this.known_tango_hosts = dlg.getTextLines();
            for (int i = 0; i < this.known_tango_hosts.length; ++i) {
                System.out.println(this.known_tango_hosts[i]);
            }
        }
    }

    private void lastCollectionBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        GetTextDialog dlg = new GetTextDialog(this, btn.getText(), btn.getToolTipText(), this.last_collection);
        if (dlg.showDialog() == 0) {
            this.last_collection = dlg.getTextLines();
        }
    }

    private void setJiveBtn(boolean b) {
        this.jiveRObtn.setSelected(b);
        this.jiveRObtn.setText("" + b);
    }

    private void jiveRObtnActionPerformed(ActionEvent evt) {
        this.jiveReadOnly = this.jiveRObtn.getSelectedObjects() != null;
        this.setJiveBtn(this.jiveReadOnly);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.storePreferences();
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.parent instanceof Astor) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        new PreferenceDialog(new JFrame()).setVisible(true);
    }
}

