/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.helpers;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.StateUtilities;
import fr.esrf.TangoDs.Except;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;

public class CommandHelper {
    public static void insert(Object value, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        if (value instanceof Short) {
            CommandHelper.insertFromShort((Short)value, deviceDataArgin, dataType);
        } else if (value instanceof String) {
            CommandHelper.insertFromString((String)value, deviceDataArgin, dataType);
        } else if (value instanceof Integer) {
            CommandHelper.insertFromInteger((Integer)value, deviceDataArgin, dataType);
        } else if (value instanceof Long) {
            CommandHelper.insertFromLong((Long)value, deviceDataArgin, dataType);
        } else if (value instanceof Float) {
            CommandHelper.insertFromFloat((Float)value, deviceDataArgin, dataType);
        } else if (value instanceof Boolean) {
            CommandHelper.insertFromBoolean((Boolean)value, deviceDataArgin, dataType);
        } else if (value instanceof Double) {
            CommandHelper.insertFromDouble((Double)value, deviceDataArgin, dataType);
        } else if (value instanceof DevState) {
            CommandHelper.insertFromDevState((DevState)value, deviceDataArgin, dataType);
        } else if (value instanceof DevVarDoubleStringArray) {
            CommandHelper.insertFromDevVarDoubleStringArray((DevVarDoubleStringArray)value, deviceDataArgin, dataType);
        } else if (value instanceof DevVarLongStringArray) {
            CommandHelper.insertFromDevVarLongStringArray((DevVarLongStringArray)value, deviceDataArgin, dataType);
        } else if (value instanceof Vector) {
            CommandHelper.insertFromArray(((Vector)value).toArray(), deviceDataArgin, dataType);
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + value.getClass() + " not supported", "CommandHelper.insert(Object value,deviceDataArgin)");
        }
    }

    public static Object extract(DeviceData deviceDataArgout) throws DevFailed {
        Object argout = null;
        switch (deviceDataArgout.getType()) {
            case 2: {
                argout = deviceDataArgout.extractShort();
                break;
            }
            case 6: {
                argout = Integer.valueOf(deviceDataArgout.extractUShort()).shortValue();
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "out type Tango_DEV_CHAR not supported", "CommandHelper.extract(deviceDataArgout)");
                break;
            }
            case 22: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "out type Tango_DEV_UCHAR not supported", "CommandHelper.extract(deviceDataArgout)");
                break;
            }
            case 3: {
                argout = deviceDataArgout.extractLong();
                break;
            }
            case 7: {
                argout = deviceDataArgout.extractULong();
                break;
            }
            case 23: {
                argout = deviceDataArgout.extractLong64();
                break;
            }
            case 24: {
                argout = deviceDataArgout.extractULong64();
                break;
            }
            case 27: {
                argout = deviceDataArgout.extractLong();
                break;
            }
            case 4: {
                argout = Float.valueOf(deviceDataArgout.extractFloat());
                break;
            }
            case 5: {
                argout = deviceDataArgout.extractDouble();
                break;
            }
            case 8: {
                argout = deviceDataArgout.extractString();
                break;
            }
            case 1: {
                argout = deviceDataArgout.extractBoolean();
                break;
            }
            case 19: {
                argout = deviceDataArgout.extractDevState();
                break;
            }
            case 18: {
                argout = deviceDataArgout.extractDoubleStringArray();
                break;
            }
            case 17: {
                argout = deviceDataArgout.extractLongStringArray();
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + deviceDataArgout.getType() + " not supported", "CommandHelper.extract(Short value,deviceDataArgout)");
            }
        }
        return argout;
    }

    public static Object[] extractArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] argout = null;
        switch (deviceDataArgout.getType()) {
            case 2: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 6: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 21: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 22: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 3: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 7: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 23: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 24: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 27: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 4: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 5: {
                argout = new Object[]{deviceDataArgout.extractDouble()};
                break;
            }
            case 8: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 1: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 19: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 10: {
                short[] shortValues = deviceDataArgout.extractShortArray();
                argout = new Object[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    argout[i] = shortValues[i];
                }
                break;
            }
            case 14: {
                int[] ushortValues = deviceDataArgout.extractUShortArray();
                argout = new Object[ushortValues.length];
                for (int i = 0; i < ushortValues.length; ++i) {
                    argout[i] = ushortValues[i];
                }
                break;
            }
            case 9: {
                byte[] charValues = deviceDataArgout.extractByteArray();
                argout = new Object[charValues.length];
                for (int i = 0; i < charValues.length; ++i) {
                    argout[i] = charValues[i];
                }
                break;
            }
            case 11: {
                int[] longValues = deviceDataArgout.extractLongArray();
                argout = new Object[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    argout[i] = longValues[i];
                }
                break;
            }
            case 15: {
                long[] ulongValues = deviceDataArgout.extractULongArray();
                argout = new Object[ulongValues.length];
                for (int i = 0; i < ulongValues.length; ++i) {
                    argout[i] = ulongValues[i];
                }
                break;
            }
            case 25: {
                long[] long64Values = deviceDataArgout.extractLong64Array();
                argout = new Object[long64Values.length];
                for (int i = 0; i < long64Values.length; ++i) {
                    argout[i] = long64Values[i];
                }
                break;
            }
            case 26: {
                long[] ulong64Values = deviceDataArgout.extractULong64Array();
                argout = new Object[ulong64Values.length];
                for (int i = 0; i < ulong64Values.length; ++i) {
                    argout[i] = ulong64Values[i];
                }
                break;
            }
            case 12: {
                float[] floatValues = deviceDataArgout.extractFloatArray();
                argout = new Object[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    argout[i] = Float.valueOf(floatValues[i]);
                }
                break;
            }
            case 13: {
                double[] doubleValues = deviceDataArgout.extractDoubleArray();
                argout = new Object[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    argout[i] = doubleValues[i];
                }
                break;
            }
            case 16: {
                String[] stringValues = deviceDataArgout.extractStringArray();
                argout = new Object[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    argout[i] = stringValues[i];
                }
                break;
            }
            case 17: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            case 18: {
                argout = new Object[]{CommandHelper.extract(deviceDataArgout)};
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + deviceDataArgout.getType() + " not supported", "CommandHelper.insertFromShort(Short value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static void insertFromShort(Short shortValue, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(shortValue);
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(shortValue.intValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromShort(Short value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(shortValue);
                break;
            }
            case 3: {
                deviceDataArgin.insert(shortValue.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(shortValue.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(shortValue.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(shortValue.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(shortValue.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(shortValue.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(shortValue.doubleValue());
                break;
            }
            case 8: {
                deviceDataArgin.insert(shortValue.toString());
                break;
            }
            case 1: {
                if (shortValue.doubleValue() == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceDataArgin.insert(DevState.from_int(shortValue.intValue()));
                }
                catch (BAD_PARAM badParam) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + shortValue.intValue() + "for input Tango_DEV_STATE type", "CommandHelper.insertFromShort(Short value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromShort(Short value,deviceDataArgin)");
            }
        }
    }

    public static Short extractToShort(DeviceData deviceDataArgout) throws DevFailed {
        Object value = CommandHelper.extract(deviceDataArgout);
        Short argout = null;
        if (value instanceof Short) {
            argout = (Short)value;
        } else if (value instanceof String) {
            try {
                argout = Short.valueOf((String)value);
            }
            catch (Exception e) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value + " is not a numerical", "CommandHelper.extractToShort(deviceDataArgin)");
            }
        } else if (value instanceof Integer) {
            argout = ((Integer)value).shortValue();
        } else if (value instanceof Long) {
            argout = ((Long)value).shortValue();
        } else if (value instanceof Float) {
            argout = ((Float)value).shortValue();
        } else if (value instanceof Boolean) {
            argout = ((Boolean)value).booleanValue() ? Short.valueOf((short)1) : Short.valueOf((short)0);
        } else if (value instanceof Double) {
            argout = ((Double)value).shortValue();
        } else if (value instanceof DevState) {
            argout = Integer.valueOf(((DevState)value).value()).shortValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value.getClass() + " not supported", "CommandHelper.extractToShort(Object value,deviceDataArgin)");
        }
        return argout;
    }

    public static String extractToString(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        Object value = null;
        String argout = "";
        if (values.length == 1) {
            value = values[0];
            if (value instanceof DevState) {
                argout = StateUtilities.getNameForState((DevState)value);
            } else if (value instanceof DevVarLongStringArray) {
                int[] intValues = ((DevVarLongStringArray)value).lvalue;
                String[] stringValues = ((DevVarLongStringArray)value).svalue;
                for (int i = 0; i < stringValues.length; ++i) {
                    argout = argout + "DevVarLongStringArray[" + i + "]=(" + intValues[i] + "," + stringValues[i] + ")\n";
                }
            } else if (value instanceof DevVarDoubleStringArray) {
                double[] doubleValues = ((DevVarDoubleStringArray)value).dvalue;
                String[] stringValues = ((DevVarDoubleStringArray)value).svalue;
                for (int i = 0; i < stringValues.length; ++i) {
                    argout = argout + "DevVarDoubleStringArray[" + i + "]=(" + doubleValues[i] + "," + stringValues[i] + ")\n";
                }
            } else {
                argout = value.toString();
            }
        } else if (values.length > 1) {
            for (int i = 0; i < values.length; ++i) {
                argout = values[i] instanceof DevState ? argout + values[i].getClass().getSimpleName() + "[" + i + "]=" + StateUtilities.getNameForState((DevState)values[i]) + "\n" : argout + values[i].getClass().getSimpleName() + "[" + i + "]=" + values[i].toString() + "\n";
            }
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value.getClass() + " not supported", "CommandHelper.extractToString(Object value,deviceDataArgin)");
        }
        return argout;
    }

    public static Integer extractToInteger(DeviceData deviceDataArgout) throws DevFailed {
        Object value = CommandHelper.extract(deviceDataArgout);
        Integer argout = null;
        if (value instanceof Short) {
            argout = ((Short)value).intValue();
        } else if (value instanceof String) {
            try {
                argout = Integer.valueOf((String)value);
            }
            catch (Exception e) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value + " is not a numerical", "CommandHelper.extractToInteger(deviceDataArgin)");
            }
        } else if (value instanceof Integer) {
            argout = (Integer)value;
        } else if (value instanceof Long) {
            argout = ((Long)value).intValue();
        } else if (value instanceof Float) {
            argout = ((Float)value).intValue();
        } else if (value instanceof Boolean) {
            argout = ((Boolean)value).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (value instanceof Double) {
            argout = ((Double)value).intValue();
        } else if (value instanceof DevState) {
            argout = ((DevState)value).value();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value.getClass() + " not supported", "CommandHelper.extractToInteger(Object value,deviceDataArgin)");
        }
        return argout;
    }

    public static Long extractToLong(DeviceData deviceDataArgout) throws DevFailed {
        Object value = CommandHelper.extract(deviceDataArgout);
        Long argout = null;
        if (value instanceof Short) {
            argout = ((Short)value).longValue();
        } else if (value instanceof String) {
            try {
                argout = Long.valueOf((String)value);
            }
            catch (Exception e) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value + " is not a numerical", "CommandHelper.extractToLong(deviceDataArgin)");
            }
        } else if (value instanceof Integer) {
            argout = ((Integer)value).longValue();
        } else if (value instanceof Long) {
            argout = (long)((Long)value);
        } else if (value instanceof Float) {
            argout = ((Float)value).longValue();
        } else if (value instanceof Boolean) {
            argout = ((Boolean)value).booleanValue() ? Long.valueOf(1L) : Long.valueOf(0L);
        } else if (value instanceof Double) {
            argout = ((Double)value).longValue();
        } else if (value instanceof DevState) {
            argout = Integer.valueOf(((DevState)value).value()).longValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value.getClass() + " not supported", "CommandHelper.extractToLong(Object value,deviceDataArgin)");
        }
        return argout;
    }

    public static Float extractToFloat(DeviceData deviceDataArgout) throws DevFailed {
        Object value = CommandHelper.extract(deviceDataArgout);
        Float argout = null;
        if (value instanceof Short) {
            argout = Float.valueOf(((Short)value).floatValue());
        } else if (value instanceof String) {
            try {
                argout = Float.valueOf((String)value);
            }
            catch (Exception e) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value + " is not a numerical", "CommandHelper.extractToFloat(deviceDataArgin)");
            }
        } else if (value instanceof Integer) {
            argout = Float.valueOf(((Integer)value).floatValue());
        } else if (value instanceof Long) {
            argout = Float.valueOf(((Long)value).floatValue());
        } else if (value instanceof Float) {
            argout = Float.valueOf(((Float)value).floatValue());
        } else if (value instanceof Boolean) {
            argout = ((Boolean)value).booleanValue() ? Float.valueOf(1.0f) : Float.valueOf(0.0f);
        } else if (value instanceof Double) {
            argout = Float.valueOf(((Double)value).floatValue());
        } else if (value instanceof DevState) {
            argout = Float.valueOf(Integer.valueOf(((DevState)value).value()).floatValue());
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value.getClass() + " not supported", "CommandHelper.extractToFloat(Object value,deviceDataArgin)");
        }
        return argout;
    }

    public static Boolean extractToBoolean(DeviceData deviceDataArgout) throws DevFailed {
        Object value = CommandHelper.extract(deviceDataArgout);
        int boolValue = 0;
        Boolean argout = Boolean.FALSE;
        if (value instanceof Short) {
            boolValue = ((Short)value).intValue();
        } else if (value instanceof String) {
            try {
                if (Boolean.getBoolean((String)value)) {
                    boolValue = 1;
                }
            }
            catch (Exception e) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value + " is not a boolean", "CommandHelper.extractToBoolean(deviceDataArgin)");
            }
        } else if (value instanceof Integer) {
            boolValue = (Integer)value;
        } else if (value instanceof Long) {
            boolValue = ((Long)value).intValue();
        } else if (value instanceof Float) {
            boolValue = ((Float)value).intValue();
        } else if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                boolValue = 1;
            }
        } else if (value instanceof Double) {
            boolValue = ((Double)value).intValue();
        } else if (value instanceof DevState) {
            boolValue = ((DevState)value).value();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value.getClass() + " not supported", "CommandHelper.extractToBoolean(Object value,deviceDataArgin)");
        }
        if (boolValue == 1) {
            argout = Boolean.TRUE;
        }
        return argout;
    }

    public static Double extractToDouble(DeviceData deviceDataArgout) throws DevFailed {
        Object value = CommandHelper.extract(deviceDataArgout);
        Double argout = null;
        if (value instanceof Short) {
            argout = ((Short)value).doubleValue();
        } else if (value instanceof String) {
            try {
                argout = Double.valueOf((String)value);
            }
            catch (Exception e) {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value + " is not a numerical", "CommandHelper.extractToFloat(deviceDataArgin)");
            }
        } else if (value instanceof Integer) {
            argout = ((Integer)value).doubleValue();
        } else if (value instanceof Long) {
            argout = ((Long)value).doubleValue();
        } else if (value instanceof Float) {
            argout = ((Float)value).doubleValue();
        } else if (value instanceof Boolean) {
            argout = ((Boolean)value).booleanValue() ? Double.valueOf(1.0) : Double.valueOf(0.0);
        } else if (value instanceof Double) {
            argout = (Double)value;
        } else if (value instanceof DevState) {
            argout = Integer.valueOf(((DevState)value).value()).doubleValue();
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value.getClass() + " not supported", "CommandHelper.extractToFloat(Object value,deviceDataArgin)");
        }
        return argout;
    }

    public static DevState extractToDevState(DeviceData deviceDataArgout) throws DevFailed {
        DevState argout;
        block29: {
            Object value = CommandHelper.extract(deviceDataArgout);
            argout = null;
            if (value instanceof Short) {
                try {
                    argout = DevState.from_int(((Short)value).intValue());
                }
                catch (Exception e) {
                    argout = DevState.UNKNOWN;
                }
            } else if (value instanceof String) {
                argout = StateUtilities.getStateForName((String)value);
            } else if (value instanceof Integer) {
                try {
                    argout = DevState.from_int((Integer)value);
                }
                catch (Exception e) {
                    argout = DevState.UNKNOWN;
                }
            } else if (value instanceof Long) {
                try {
                    argout = DevState.from_int(((Long)value).intValue());
                }
                catch (Exception e) {
                    argout = DevState.UNKNOWN;
                }
            } else if (value instanceof Float) {
                try {
                    argout = DevState.from_int(((Float)value).intValue());
                }
                catch (Exception e) {
                    argout = DevState.UNKNOWN;
                }
            } else if (value instanceof Boolean) {
                try {
                    if (((Boolean)value).booleanValue()) {
                        argout = DevState.from_int(1);
                        break block29;
                    }
                    argout = DevState.from_int(0);
                }
                catch (Exception e) {
                    argout = DevState.UNKNOWN;
                }
            } else if (value instanceof Double) {
                try {
                    argout = DevState.from_int(((Double)value).intValue());
                }
                catch (Exception e) {
                    argout = DevState.UNKNOWN;
                }
            } else if (value instanceof DevState) {
                argout = (DevState)value;
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + value.getClass() + " not supported", "CommandHelper.extractToDevState(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static short[] extractToShortArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToShortArray(deviceDataArgin)");
        }
        short[] argout = new short[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Short)values[i];
                }
            } else if (values[0] instanceof String) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        argout[i] = Double.valueOf((String)values[i]).shortValue();
                    }
                }
                catch (Exception e) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToShortArray(deviceDataArgin)");
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Integer)values[i]).shortValue();
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Long)values[i]).shortValue();
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Float)values[i]).shortValue();
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Boolean)values[i] != false ? (short)1 : 0;
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Double)values[i]).shortValue();
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Byte)values[i]).shortValue();
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = Integer.valueOf(((DevState)values[i]).value()).shortValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToShortArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static String[] extractToStringArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToStringArray(deviceDataArgin)");
        }
        String[] argout = new String[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Short)values[i]).toString();
                }
            } else if (values[0] instanceof String) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (String)values[i];
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Integer)values[i]).toString();
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Long)values[i]).toString();
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Float)values[i]).toString();
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Boolean)values[i]).toString();
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Double)values[i]).toString();
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Byte)values[i]).toString();
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = StateUtilities.getNameForState((DevState)values[0]);
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToStringArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static int[] extractToIntegerArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToIntegerArray(deviceDataArgin)");
        }
        int[] argout = new int[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Short)values[i]).intValue();
                }
            } else if (values[0] instanceof String) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        argout[i] = Integer.valueOf((String)values[i]);
                    }
                }
                catch (Exception e) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToIntegerArray(deviceDataArgin)");
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Integer)values[i];
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Long)values[i]).intValue();
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Float)values[i]).intValue();
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Boolean)values[i] != false ? 1 : 0;
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Double)values[i]).intValue();
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Byte)values[i]).intValue();
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((DevState)values[i]).value();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToIntegerArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static long[] extractToLongArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToLongArray(deviceDataArgin)");
        }
        long[] argout = new long[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Short)values[i]).longValue();
                }
            } else if (values[0] instanceof String) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        argout[i] = Long.valueOf((String)values[i]);
                    }
                }
                catch (Exception e) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToLongArray(deviceDataArgin)");
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Integer)values[i]).longValue();
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Long)values[i];
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Float)values[i]).longValue();
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Boolean)values[i] != false ? 1L : 0L;
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Double)values[i]).longValue();
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Byte)values[i]).longValue();
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = Integer.valueOf(((DevState)values[i]).value()).longValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToLongArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static float[] extractToFloatArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToFloatArray(deviceDataArgin)");
        }
        float[] argout = new float[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Short)values[i]).floatValue();
                }
            } else if (values[0] instanceof String) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        argout[i] = Float.valueOf((String)values[i]).floatValue();
                    }
                }
                catch (Exception e) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToFloatArray(deviceDataArgin)");
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Integer)values[i]).floatValue();
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Long)values[i]).floatValue();
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Float)values[i]).floatValue();
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Boolean)values[i] != false ? 1.0f : 0.0f;
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Double)values[i]).floatValue();
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Byte)values[i]).floatValue();
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = Integer.valueOf(((DevState)values[i]).value()).floatValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToFloatArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static boolean[] extractToBooleanArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToBooleanArray(deviceDataArgin)");
        }
        boolean[] argout = new boolean[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Short)values[i]).intValue() == 1;
                }
            } else if (values[0] instanceof String) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        argout[i] = Boolean.getBoolean((String)values[i]);
                    }
                }
                catch (Exception e) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToBooleanArray(deviceDataArgin)");
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Integer)values[i] == 1;
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Long)values[i]).intValue() == 1;
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Float)values[i]).intValue() == 1;
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Boolean)values[i];
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Double)values[i]).intValue() == 1;
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Byte)values[i]).intValue() == 1;
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((DevState)values[i]).value() == 1;
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToBooleanArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static byte[] extractToByteArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToFloatArray(deviceDataArgin)");
        }
        byte[] argout = new byte[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Short)values[i]).byteValue();
                }
            } else if (values[0] instanceof String) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        argout[i] = Float.valueOf((String)values[i]).byteValue();
                    }
                }
                catch (Exception e) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToFloatArray(deviceDataArgin)");
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Integer)values[i]).byteValue();
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Long)values[i]).byteValue();
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Float)values[i]).byteValue();
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Boolean)values[i] != false ? (byte)1 : 0;
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Double)values[i]).byteValue();
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Byte)values[i];
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = Integer.valueOf(((DevState)values[i]).value()).byteValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToFloatArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static double[] extractToDoubleArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToDoubleArray(deviceDataArgin)");
        }
        double[] argout = new double[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Short)values[i]).doubleValue();
                }
            } else if (values[0] instanceof String) {
                try {
                    for (int i = 0; i < values.length; ++i) {
                        argout[i] = Double.valueOf((String)values[i]);
                    }
                }
                catch (Exception e) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type not numerical", "CommandHelper.extractToDoubleArray(deviceDataArgin)");
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Integer)values[i]).doubleValue();
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Long)values[i]).doubleValue();
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Float)values[i]).doubleValue();
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Boolean)values[i] != false ? 1.0 : 0.0;
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (Double)values[i];
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = ((Byte)values[i]).doubleValue();
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = Integer.valueOf(((DevState)values[i]).value()).doubleValue();
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToDoubleArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static DevState[] extractToDevStateArray(DeviceData deviceDataArgout) throws DevFailed {
        Object[] values = CommandHelper.extractArray(deviceDataArgout);
        if (values == null) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output is empty ", "CommandHelper.extractToFloatArray(deviceDataArgin)");
        }
        DevState[] argout = new DevState[values.length];
        if (values.length > 0) {
            if (values[0] instanceof Short) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        argout[i] = DevState.from_int(((Short)values[i]).intValue());
                        continue;
                    }
                    catch (Exception e) {
                        argout[i] = DevState.UNKNOWN;
                    }
                }
            } else if (values[0] instanceof String) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = StateUtilities.getStateForName((String)values[i]);
                }
            } else if (values[0] instanceof Integer) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        argout[i] = DevState.from_int((Integer)values[i]);
                        continue;
                    }
                    catch (Exception e) {
                        argout[i] = DevState.UNKNOWN;
                    }
                }
            } else if (values[0] instanceof Long) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        argout[i] = DevState.from_int(((Long)values[i]).intValue());
                        continue;
                    }
                    catch (Exception e) {
                        argout[i] = DevState.UNKNOWN;
                    }
                }
            } else if (values[0] instanceof Float) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        argout[i] = DevState.from_int(((Float)values[i]).intValue());
                        continue;
                    }
                    catch (Exception e) {
                        argout[i] = DevState.UNKNOWN;
                    }
                }
            } else if (values[0] instanceof Boolean) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        if (((Boolean)values[i]).booleanValue()) {
                            argout[i] = DevState.from_int(1);
                            continue;
                        }
                        argout[i] = DevState.from_int(0);
                        continue;
                    }
                    catch (Exception e) {
                        argout[i] = DevState.UNKNOWN;
                    }
                }
            } else if (values[0] instanceof Double) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        argout[i] = DevState.from_int(((Double)values[i]).intValue());
                        continue;
                    }
                    catch (Exception e) {
                        argout[i] = DevState.UNKNOWN;
                    }
                }
            } else if (values[0] instanceof Byte) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        argout[i] = DevState.from_int(((Byte)values[i]).intValue());
                        continue;
                    }
                    catch (Exception e) {
                        argout[i] = DevState.UNKNOWN;
                    }
                }
            } else if (values[0] instanceof DevState) {
                for (int i = 0; i < values.length; ++i) {
                    argout[i] = (DevState)values[i];
                }
            } else {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "output type " + values[0].getClass() + " not supported", "CommandHelper.extractToFloatArray(Object value,deviceDataArgin)");
            }
        }
        return argout;
    }

    public static void insertFromShortArray(short[] shortValues, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Double doubleSum = new Double(0.0);
        for (int i = 0; i < shortValues.length; ++i) {
            doubleSum = doubleSum + (double)shortValues[i];
        }
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(doubleSum.intValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromShortArray(short[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(doubleSum.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(doubleSum.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(doubleSum.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(doubleSum);
                break;
            }
            case 8: {
                deviceDataArgin.insert(doubleSum.toString());
                break;
            }
            case 1: {
                if (doubleSum == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                DevState devStateValue = DevState.UNKNOWN;
                if (shortValues.length > 0) {
                    try {
                        devStateValue = DevState.from_int(Short.valueOf(shortValues[0]).intValue());
                    }
                    catch (BAD_PARAM badParam) {
                        devStateValue = DevState.UNKNOWN;
                    }
                }
                deviceDataArgin.insert(devStateValue);
                break;
            }
            case 10: {
                deviceDataArgin.insert(shortValues);
                break;
            }
            case 14: {
                deviceDataArgin.insert_us(shortValues);
                break;
            }
            case 9: {
                byte[] byteValues = new byte[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    byteValues[i] = Short.valueOf(shortValues[i]).byteValue();
                }
                deviceDataArgin.insert(byteValues);
                break;
            }
            case 11: {
                int[] longValues = new int[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    longValues[i] = Short.valueOf(shortValues[i]).intValue();
                }
                deviceDataArgin.insert(longValues);
                break;
            }
            case 15: {
                long[] ulongValues = new long[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    ulongValues[i] = Short.valueOf(shortValues[i]).longValue();
                }
                deviceDataArgin.insert_ul(ulongValues);
                break;
            }
            case 25: {
                int[] long64Values = new int[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    long64Values[i] = Short.valueOf(shortValues[i]).intValue();
                }
                deviceDataArgin.insert(long64Values);
                break;
            }
            case 26: {
                long[] uLong64Values = new long[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    uLong64Values[i] = Short.valueOf(shortValues[i]).longValue();
                }
                deviceDataArgin.insert_u64(uLong64Values);
                break;
            }
            case 12: {
                float[] floatValues = new float[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    floatValues[i] = Short.valueOf(shortValues[i]).floatValue();
                }
                deviceDataArgin.insert(floatValues);
                break;
            }
            case 13: {
                double[] doubleValues = new double[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    doubleValues[i] = Short.valueOf(shortValues[i]).doubleValue();
                }
                deviceDataArgin.insert(doubleValues);
                break;
            }
            case 16: {
                String[] stringValues = new String[shortValues.length];
                for (int i = 0; i < shortValues.length; ++i) {
                    stringValues[i] = Short.valueOf(shortValues[i]).toString();
                }
                deviceDataArgin.insert(stringValues);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromShortArray(short[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromStringArray(String[] stringValues, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        String firsString = "";
        Double numericalValue = Double.NaN;
        try {
            numericalValue = Double.valueOf(firsString);
        }
        catch (Exception e) {
            numericalValue = Double.NaN;
        }
        if (stringValues.length > 0) {
            firsString = stringValues[0];
        }
        switch (dataType) {
            case 2: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert(numericalValue.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_SHORT", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 6: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert_us(numericalValue.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_USHORT", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 21: {
                deviceDataArgin.insert(numericalValue.byteValue());
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert(numericalValue.shortValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_UCHAR", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 3: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert(numericalValue.intValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_LONG", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 7: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert_ul(numericalValue.longValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_ULONG", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 23: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_LONG64 not supported", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 24: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert_u64(numericalValue.longValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_ULONG64", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 27: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert(numericalValue.intValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_INT", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 4: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert(numericalValue.floatValue());
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_FLOAT", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 5: {
                if (!numericalValue.isNaN()) {
                    deviceDataArgin.insert(numericalValue);
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_DOUBLE", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 8: {
                deviceDataArgin.insert(firsString);
                break;
            }
            case 1: {
                if (!numericalValue.isNaN()) {
                    if (numericalValue == 1.0) {
                        deviceDataArgin.insert(true);
                        break;
                    }
                    deviceDataArgin.insert(false);
                    break;
                }
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", firsString + " is not a Tango_DEV_BOOLEAN", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 19: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Tango_DEV_STATE is not supported", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                break;
            }
            case 10: {
                short[] shortValues = new short[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        shortValues[i] = Double.valueOf(stringValues[i]).shortValue();
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_SHORTARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert(shortValues);
                break;
            }
            case 14: {
                short[] ushortValues = new short[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        ushortValues[i] = Double.valueOf(stringValues[i]).shortValue();
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_USHORTARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert_us(ushortValues);
                break;
            }
            case 9: {
                byte[] byteValues = new byte[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        byteValues[i] = Double.valueOf(stringValues[i]).byteValue();
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_CHARARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert(byteValues);
                break;
            }
            case 11: {
                int[] longValues = new int[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        longValues[i] = Double.valueOf(stringValues[i]).intValue();
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert(longValues);
                break;
            }
            case 15: {
                long[] ulongValues = new long[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        ulongValues[i] = Double.valueOf(stringValues[i]).longValue();
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert_ul(ulongValues);
                break;
            }
            case 25: {
                int[] long64Values = new int[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        long64Values[i] = Double.valueOf(stringValues[i]).intValue();
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert(long64Values);
                break;
            }
            case 26: {
                long[] ulong64Values = new long[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        ulong64Values[i] = Double.valueOf(stringValues[i]).longValue();
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_LONGARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert_u64(ulong64Values);
                break;
            }
            case 12: {
                float[] floatValues = new float[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        floatValues[i] = Double.valueOf(stringValues[i]).floatValue();
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_FLOATARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert(floatValues);
                break;
            }
            case 13: {
                double[] doubleValues = new double[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    try {
                        doubleValues[i] = Double.valueOf(stringValues[i]);
                        continue;
                    }
                    catch (Exception e) {
                        Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input is not a Tango_DEVVAR_DOUBLEARRAY", "CommandHelper.insertFromStringArray(String[] values,deviceDataArgin)");
                    }
                }
                deviceDataArgin.insert(doubleValues);
                break;
            }
            case 16: {
                deviceDataArgin.insert(stringValues);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromStringArray(String[] value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromIntegerArray(int[] intValues, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Double doubleSum = new Double(0.0);
        for (int i = 0; i < intValues.length; ++i) {
            doubleSum = doubleSum + (double)intValues[i];
        }
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(doubleSum.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromIntegerArray(int[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(doubleSum.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(doubleSum.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(doubleSum.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(doubleSum);
                break;
            }
            case 8: {
                deviceDataArgin.insert(doubleSum.toString());
                break;
            }
            case 1: {
                if (doubleSum == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                DevState devStateValue = DevState.UNKNOWN;
                if (intValues.length > 0) {
                    try {
                        devStateValue = DevState.from_int(intValues[0]);
                    }
                    catch (BAD_PARAM badParam) {
                        devStateValue = DevState.UNKNOWN;
                    }
                }
                deviceDataArgin.insert(devStateValue);
                break;
            }
            case 10: {
                short[] shortValues = new short[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    shortValues[i] = Integer.valueOf(intValues[i]).shortValue();
                }
                deviceDataArgin.insert(shortValues);
                break;
            }
            case 14: {
                short[] ushortValues = new short[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    ushortValues[i] = Integer.valueOf(intValues[i]).shortValue();
                }
                deviceDataArgin.insert_us(ushortValues);
                break;
            }
            case 9: {
                byte[] byteValues = new byte[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    byteValues[i] = Integer.valueOf(intValues[i]).byteValue();
                }
                deviceDataArgin.insert(byteValues);
                break;
            }
            case 11: {
                deviceDataArgin.insert(intValues);
                break;
            }
            case 15: {
                long[] ulongValues = new long[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    ulongValues[i] = Integer.valueOf(intValues[i]).longValue();
                }
                deviceDataArgin.insert_ul(ulongValues);
                break;
            }
            case 25: {
                int[] long64Values = new int[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    long64Values[i] = intValues[i];
                }
                deviceDataArgin.insert_ul(long64Values);
                break;
            }
            case 26: {
                long[] ulong64Values = new long[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    ulong64Values[i] = Integer.valueOf(intValues[i]).longValue();
                }
                deviceDataArgin.insert_u64(ulong64Values);
                break;
            }
            case 12: {
                float[] floatValues = new float[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    floatValues[i] = Integer.valueOf(intValues[i]).floatValue();
                }
                deviceDataArgin.insert(floatValues);
                break;
            }
            case 13: {
                double[] doubleValues = new double[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    doubleValues[i] = Integer.valueOf(intValues[i]).doubleValue();
                }
                deviceDataArgin.insert(doubleValues);
                break;
            }
            case 16: {
                String[] stringValues = new String[intValues.length];
                for (int i = 0; i < intValues.length; ++i) {
                    stringValues[i] = Integer.valueOf(intValues[i]).toString();
                }
                deviceDataArgin.insert(stringValues);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromIntegerArray(int[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromLongArray(long[] longValues, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Double doubleSum = new Double(0.0);
        for (int i = 0; i < longValues.length; ++i) {
            doubleSum = doubleSum + (double)longValues[i];
        }
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(doubleSum.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromLongArray(long[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(doubleSum.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(doubleSum.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(doubleSum.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(doubleSum);
                break;
            }
            case 8: {
                deviceDataArgin.insert(doubleSum.toString());
                break;
            }
            case 1: {
                if (doubleSum == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                DevState devStateValue = DevState.UNKNOWN;
                if (longValues.length > 0) {
                    try {
                        devStateValue = DevState.from_int(Long.valueOf(longValues[0]).intValue());
                    }
                    catch (BAD_PARAM badParam) {
                        devStateValue = DevState.UNKNOWN;
                    }
                }
                deviceDataArgin.insert(devStateValue);
                break;
            }
            case 10: {
                short[] shortValues = new short[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    shortValues[i] = Long.valueOf(longValues[i]).shortValue();
                }
                deviceDataArgin.insert(shortValues);
                break;
            }
            case 14: {
                short[] ushortValues = new short[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    ushortValues[i] = Long.valueOf(longValues[i]).shortValue();
                }
                deviceDataArgin.insert_us(ushortValues);
                break;
            }
            case 9: {
                byte[] byteValues = new byte[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    byteValues[i] = Long.valueOf(longValues[i]).byteValue();
                }
                deviceDataArgin.insert(byteValues);
                break;
            }
            case 11: {
                int[] intValues = new int[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    intValues[i] = Long.valueOf(longValues[i]).intValue();
                }
                deviceDataArgin.insert(intValues);
                break;
            }
            case 15: {
                deviceDataArgin.insert_ul(longValues);
                break;
            }
            case 25: {
                int[] long64Values = new int[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    long64Values[i] = Long.valueOf(longValues[i]).intValue();
                }
                deviceDataArgin.insert(long64Values);
                break;
            }
            case 26: {
                deviceDataArgin.insert_u64(longValues);
                break;
            }
            case 12: {
                float[] floatValues = new float[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    floatValues[i] = Long.valueOf(longValues[i]).floatValue();
                }
                deviceDataArgin.insert(floatValues);
                break;
            }
            case 13: {
                double[] doubleValues = new double[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    doubleValues[i] = Long.valueOf(longValues[i]).doubleValue();
                }
                deviceDataArgin.insert(doubleValues);
                break;
            }
            case 16: {
                String[] stringValues = new String[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    stringValues[i] = Long.valueOf(longValues[i]).toString();
                }
                deviceDataArgin.insert(stringValues);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromLongArray(long[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromFloatArray(float[] floatValues, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Double doubleSum = new Double(0.0);
        for (int i = 0; i < floatValues.length; ++i) {
            doubleSum = doubleSum + (double)floatValues[i];
        }
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(doubleSum.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromFloatArray(float[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(doubleSum.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert_ul(doubleSum.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(doubleSum.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(doubleSum.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(doubleSum);
                break;
            }
            case 8: {
                deviceDataArgin.insert(doubleSum.toString());
                break;
            }
            case 1: {
                if (doubleSum == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                DevState devStateValue = DevState.UNKNOWN;
                if (floatValues.length > 0) {
                    try {
                        devStateValue = DevState.from_int(Float.valueOf(floatValues[0]).intValue());
                    }
                    catch (BAD_PARAM badParam) {
                        devStateValue = DevState.UNKNOWN;
                    }
                }
                deviceDataArgin.insert(devStateValue);
                break;
            }
            case 10: {
                short[] shortValues = new short[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    shortValues[i] = Float.valueOf(floatValues[i]).shortValue();
                }
                deviceDataArgin.insert(shortValues);
                break;
            }
            case 14: {
                short[] ushortValues = new short[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    ushortValues[i] = Float.valueOf(floatValues[i]).shortValue();
                }
                deviceDataArgin.insert(ushortValues);
                break;
            }
            case 9: {
                byte[] byteValues = new byte[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    byteValues[i] = Float.valueOf(floatValues[i]).byteValue();
                }
                deviceDataArgin.insert(byteValues);
                break;
            }
            case 11: {
                int[] longValues = new int[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    longValues[i] = Float.valueOf(floatValues[i]).intValue();
                }
                deviceDataArgin.insert(longValues);
                break;
            }
            case 15: {
                long[] ulongValues = new long[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    ulongValues[i] = Float.valueOf(floatValues[i]).longValue();
                }
                deviceDataArgin.insert_ul(ulongValues);
                break;
            }
            case 25: {
                int[] long64Values = new int[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    long64Values[i] = Float.valueOf(floatValues[i]).intValue();
                }
                deviceDataArgin.insert(long64Values);
                break;
            }
            case 26: {
                long[] ulong64Values = new long[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    ulong64Values[i] = Float.valueOf(floatValues[i]).longValue();
                }
                deviceDataArgin.insert_u64(ulong64Values);
                break;
            }
            case 12: {
                deviceDataArgin.insert(floatValues);
                break;
            }
            case 13: {
                double[] doubleValues = new double[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    doubleValues[i] = Float.valueOf(floatValues[i]).doubleValue();
                }
                deviceDataArgin.insert(doubleValues);
                break;
            }
            case 16: {
                String[] stringValues = new String[floatValues.length];
                for (int i = 0; i < floatValues.length; ++i) {
                    stringValues[i] = Float.valueOf(floatValues[i]).toString();
                }
                deviceDataArgin.insert(stringValues);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "insertFromFloatArray.insertFromLongArray(float[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromBooleanArray(boolean[] booleanValues, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        boolean firstBoolean = false;
        if (booleanValues.length > 0) {
            firstBoolean = booleanValues[0];
        }
        Integer intValue = new Integer(0);
        if (firstBoolean) {
            intValue = new Integer(1);
        }
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(intValue.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(intValue.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromBooleanArray(boolean[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(intValue.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(intValue);
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(intValue.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(intValue);
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(intValue.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(intValue);
                break;
            }
            case 4: {
                deviceDataArgin.insert(intValue.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(intValue.doubleValue());
                break;
            }
            case 8: {
                deviceDataArgin.insert(intValue.toString());
                break;
            }
            case 1: {
                deviceDataArgin.insert(firstBoolean);
                break;
            }
            case 19: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_STATE not supported", "CommandHelper.insertFromBooleanArray(boolean[] values,deviceDataArgin)");
                break;
            }
            case 10: {
                short[] shortValues = new short[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    shortValues[i] = booleanValues[i] ? (short)1 : 0;
                }
                deviceDataArgin.insert(shortValues);
                break;
            }
            case 14: {
                short[] ushortValues = new short[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    ushortValues[i] = booleanValues[i] ? (short)1 : 0;
                }
                deviceDataArgin.insert(ushortValues);
                break;
            }
            case 9: {
                byte[] byteValues = new byte[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    byteValues[i] = booleanValues[i] ? Short.valueOf((short)1).byteValue() : Short.valueOf((short)0).byteValue();
                }
                deviceDataArgin.insert(byteValues);
                break;
            }
            case 11: {
                int[] longValues = new int[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    longValues[i] = booleanValues[i] ? 1 : 0;
                }
                deviceDataArgin.insert(longValues);
                break;
            }
            case 15: {
                long[] ulongValues = new long[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    ulongValues[i] = booleanValues[i] ? 1L : 0L;
                }
                deviceDataArgin.insert_ul(ulongValues);
                break;
            }
            case 25: {
                int[] long64Values = new int[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    long64Values[i] = booleanValues[i] ? 1 : 0;
                }
                deviceDataArgin.insert(long64Values);
                break;
            }
            case 26: {
                long[] ulong64Values = new long[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    ulong64Values[i] = booleanValues[i] ? 1L : 0L;
                }
                deviceDataArgin.insert_u64(ulong64Values);
                break;
            }
            case 12: {
                float[] floatValues = new float[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    floatValues[i] = booleanValues[i] ? 1.0f : 0.0f;
                }
                deviceDataArgin.insert(floatValues);
                break;
            }
            case 13: {
                double[] doubleValues = new double[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    doubleValues[i] = booleanValues[i] ? 1.0 : 0.0;
                }
                deviceDataArgin.insert(doubleValues);
                break;
            }
            case 16: {
                String[] stringValues = new String[booleanValues.length];
                for (int i = 0; i < booleanValues.length; ++i) {
                    stringValues[i] = Boolean.valueOf(booleanValues[i]).toString();
                }
                deviceDataArgin.insert(stringValues);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "insertFromBooleanArray.insertFromLongArray(boolean[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromDoubleArray(double[] doubleValues, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Double doubleSum = new Double(0.0);
        for (int i = 0; i < doubleValues.length; ++i) {
            doubleSum = doubleSum + doubleValues[i];
        }
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(doubleSum.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromDoubleArray(double[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(doubleSum.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(doubleSum.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(doubleSum.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(doubleSum);
                break;
            }
            case 8: {
                deviceDataArgin.insert(doubleSum.toString());
                break;
            }
            case 1: {
                if (doubleSum == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                DevState devStateValue = DevState.UNKNOWN;
                if (doubleValues.length > 0) {
                    try {
                        devStateValue = DevState.from_int(Double.valueOf(doubleValues[0]).intValue());
                    }
                    catch (BAD_PARAM badParam) {
                        devStateValue = DevState.UNKNOWN;
                    }
                }
                deviceDataArgin.insert(devStateValue);
                break;
            }
            case 10: {
                short[] shortValues = new short[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    shortValues[i] = Double.valueOf(doubleValues[i]).shortValue();
                }
                deviceDataArgin.insert(shortValues);
                break;
            }
            case 14: {
                short[] ushortValues = new short[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    ushortValues[i] = Double.valueOf(doubleValues[i]).shortValue();
                }
                deviceDataArgin.insert_us(ushortValues);
                break;
            }
            case 9: {
                byte[] byteValues = new byte[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    byteValues[i] = Double.valueOf(doubleValues[i]).byteValue();
                }
                deviceDataArgin.insert(byteValues);
                break;
            }
            case 11: {
                int[] intValues = new int[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    intValues[i] = Double.valueOf(doubleValues[i]).intValue();
                }
                deviceDataArgin.insert(intValues);
                break;
            }
            case 15: {
                long[] ulongValues = new long[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    ulongValues[i] = Double.valueOf(doubleValues[i]).longValue();
                }
                deviceDataArgin.insert_ul(ulongValues);
                break;
            }
            case 25: {
                int[] long64Values = new int[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    long64Values[i] = Double.valueOf(doubleValues[i]).intValue();
                }
                deviceDataArgin.insert(long64Values);
                break;
            }
            case 26: {
                long[] ulong64Values = new long[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    ulong64Values[i] = Double.valueOf(doubleValues[i]).longValue();
                }
                deviceDataArgin.insert_u64(ulong64Values);
                break;
            }
            case 12: {
                float[] floatValues = new float[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    floatValues[i] = Double.valueOf(doubleValues[i]).floatValue();
                }
                deviceDataArgin.insert(floatValues);
                break;
            }
            case 13: {
                deviceDataArgin.insert(doubleValues);
                break;
            }
            case 16: {
                String[] stringValues = new String[doubleValues.length];
                for (int i = 0; i < doubleValues.length; ++i) {
                    stringValues[i] = Double.valueOf(doubleValues[i]).toString();
                }
                deviceDataArgin.insert(stringValues);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "insertFromFloatArray.insertFromDoubleArray(double[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromString(String stringValue, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Double doubleValue = Double.NaN;
        try {
            doubleValue = Double.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            doubleValue = Double.NaN;
        }
        if (doubleValue.isNaN() && dataType != 8) {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot insert " + stringValue + " as a numerical value.", "CommandHelper.insertFromString(String value,deviceDataArgin)");
        }
        switch (dataType) {
            case 2: {
                if (doubleValue.isNaN()) break;
                deviceDataArgin.insert(doubleValue.shortValue());
                break;
            }
            case 6: {
                if (doubleValue.isNaN()) break;
                deviceDataArgin.insert_us(doubleValue.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromString(String value,deviceDataArgin)");
                break;
            }
            case 22: {
                if (doubleValue.isNaN()) break;
                deviceDataArgin.insert(doubleValue.shortValue());
                break;
            }
            case 3: {
                if (doubleValue.isNaN()) break;
                deviceDataArgin.insert(doubleValue.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(doubleValue.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(doubleValue.intValue());
                break;
            }
            case 24: {
                if (doubleValue.isNaN()) break;
                deviceDataArgin.insert_u64(doubleValue.longValue());
                break;
            }
            case 27: {
                if (doubleValue.isNaN()) break;
                deviceDataArgin.insert(doubleValue.intValue());
                break;
            }
            case 4: {
                if (doubleValue.isNaN()) break;
                deviceDataArgin.insert(doubleValue.floatValue());
                break;
            }
            case 5: {
                if (doubleValue.isNaN()) break;
                deviceDataArgin.insert(doubleValue);
                break;
            }
            case 8: {
                deviceDataArgin.insert(stringValue);
                break;
            }
            case 1: {
                if (doubleValue.isNaN()) break;
                if (doubleValue == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                if (doubleValue.isNaN()) break;
                DevState tmpDevState = StateUtilities.getStateForName(stringValue);
                deviceDataArgin.insert(tmpDevState);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromString(String value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromInteger(Integer integerValue, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(integerValue.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(integerValue.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromInteger(Integer value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(integerValue.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(integerValue);
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(integerValue.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(integerValue);
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(integerValue.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(integerValue);
                break;
            }
            case 4: {
                deviceDataArgin.insert(integerValue.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(integerValue.doubleValue());
                break;
            }
            case 8: {
                deviceDataArgin.insert(integerValue.toString());
                break;
            }
            case 1: {
                if (integerValue.doubleValue() == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceDataArgin.insert(DevState.from_int(integerValue));
                }
                catch (BAD_PARAM badParam) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + integerValue + "for input Tango_DEV_STATE type", "CommandHelper.insertFromInteger(Integer value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromInteger(Integer value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromLong(Long longValue, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(longValue.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(longValue.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromLong(Long value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(longValue.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(longValue.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(longValue);
                break;
            }
            case 23: {
                deviceDataArgin.insert(longValue.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(longValue);
                break;
            }
            case 27: {
                deviceDataArgin.insert(longValue.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(longValue.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(longValue.doubleValue());
                break;
            }
            case 8: {
                deviceDataArgin.insert(longValue.toString());
                break;
            }
            case 1: {
                if (longValue.doubleValue() == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceDataArgin.insert(DevState.from_int(longValue.intValue()));
                }
                catch (BAD_PARAM badParam) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + longValue.intValue() + "for input Tango_DEV_STATE type", "CommandHelper.insertFromLong(Long value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromLong(Long value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromFloat(Float floatValue, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(floatValue.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(floatValue.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromFloat(Float value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(floatValue.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(floatValue.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(floatValue.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert_ul(floatValue.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(floatValue.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(floatValue.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(floatValue.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(floatValue.doubleValue());
                break;
            }
            case 8: {
                deviceDataArgin.insert(floatValue.toString());
                break;
            }
            case 1: {
                if (floatValue.doubleValue() == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceDataArgin.insert(DevState.from_int(floatValue.intValue()));
                }
                catch (BAD_PARAM badParam) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + floatValue.intValue() + "for input Tango_DEV_STATE type", "CommandHelper.insertFromFloat(Float value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromFloat(Float value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromByteArray(byte[] byteValues, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Double doubleSum = new Double(0.0);
        for (int i = 0; i < byteValues.length; ++i) {
            doubleSum = doubleSum + Byte.valueOf(byteValues[i]).doubleValue();
        }
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(doubleSum.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromByteArray(float[] values,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(doubleSum.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(doubleSum.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(doubleSum.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(doubleSum.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(doubleSum.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(doubleSum);
                break;
            }
            case 8: {
                deviceDataArgin.insert(doubleSum.toString());
                break;
            }
            case 1: {
                if (doubleSum == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                DevState devStateValue = DevState.UNKNOWN;
                if (byteValues.length > 0) {
                    try {
                        devStateValue = DevState.from_int(Byte.valueOf(byteValues[0]).intValue());
                    }
                    catch (BAD_PARAM badParam) {
                        devStateValue = DevState.UNKNOWN;
                    }
                }
                deviceDataArgin.insert(devStateValue);
                break;
            }
            case 10: {
                short[] shortValues = new short[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    shortValues[i] = Byte.valueOf(byteValues[i]).shortValue();
                }
                deviceDataArgin.insert(shortValues);
                break;
            }
            case 14: {
                short[] ushortValues = new short[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    ushortValues[i] = Byte.valueOf(byteValues[i]).shortValue();
                }
                deviceDataArgin.insert(ushortValues);
                break;
            }
            case 9: {
                deviceDataArgin.insert(byteValues);
                break;
            }
            case 11: {
                int[] longValues = new int[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    longValues[i] = Byte.valueOf(byteValues[i]).intValue();
                }
                deviceDataArgin.insert(longValues);
                break;
            }
            case 15: {
                long[] ulongValues = new long[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    ulongValues[i] = Byte.valueOf(byteValues[i]).longValue();
                }
                deviceDataArgin.insert_ul(ulongValues);
                break;
            }
            case 25: {
                int[] long64Values = new int[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    long64Values[i] = Byte.valueOf(byteValues[i]).intValue();
                }
                deviceDataArgin.insert(long64Values);
                break;
            }
            case 26: {
                long[] ulong64Values = new long[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    ulong64Values[i] = Byte.valueOf(byteValues[i]).longValue();
                }
                deviceDataArgin.insert_u64(ulong64Values);
                break;
            }
            case 12: {
                float[] floatValues = new float[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    floatValues[i] = Byte.valueOf(byteValues[i]).longValue();
                }
                deviceDataArgin.insert(floatValues);
                break;
            }
            case 13: {
                double[] doubleValues = new double[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    doubleValues[i] = Byte.valueOf(byteValues[i]).doubleValue();
                }
                deviceDataArgin.insert(doubleValues);
                break;
            }
            case 16: {
                String[] stringValues = new String[byteValues.length];
                for (int i = 0; i < byteValues.length; ++i) {
                    stringValues[i] = Byte.valueOf(byteValues[i]).toString();
                }
                deviceDataArgin.insert(stringValues);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "insertFromFloatArray.insertFromLongArray(float[] values,deviceDataArgin)");
            }
        }
    }

    public static void insertFromBoolean(Boolean booleanValue, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Integer integerValue = 0;
        if (booleanValue.booleanValue()) {
            integerValue = 1;
        }
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(integerValue.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(integerValue.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromBoolean(Boolean value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(integerValue.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(integerValue);
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(integerValue.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert_ul(integerValue);
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(integerValue.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(integerValue);
                break;
            }
            case 4: {
                deviceDataArgin.insert(integerValue.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(integerValue.doubleValue());
                break;
            }
            case 8: {
                deviceDataArgin.insert(Boolean.toString(booleanValue));
                break;
            }
            case 1: {
                deviceDataArgin.insert(booleanValue);
                break;
            }
            case 19: {
                deviceDataArgin.insert(DevState.from_int(integerValue));
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromBoolean(Boolean value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromDouble(Double doubleValue, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        switch (dataType) {
            case 2: {
                deviceDataArgin.insert(doubleValue.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(doubleValue.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromDouble(Double value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(doubleValue.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(doubleValue.intValue());
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(doubleValue.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(doubleValue.intValue());
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(doubleValue.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(doubleValue.intValue());
                break;
            }
            case 4: {
                deviceDataArgin.insert(doubleValue.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(doubleValue);
                break;
            }
            case 8: {
                deviceDataArgin.insert(doubleValue.toString());
                break;
            }
            case 1: {
                if (doubleValue == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                try {
                    deviceDataArgin.insert(DevState.from_int(doubleValue.intValue()));
                }
                catch (BAD_PARAM badParam) {
                    Except.throw_exception("TANGO_WRONG_DATA_ERROR", "Cannot sent" + doubleValue.intValue() + "for input Tango_DEV_STATE type", "CommandHelper.insertFromDouble(Double value,deviceDataArgin)");
                }
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromDouble(Double value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromDevState(DevState devStateValue, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        Integer integerValue = devStateValue.value();
        switch (deviceDataArgin.getType()) {
            case 2: {
                deviceDataArgin.insert(integerValue.shortValue());
                break;
            }
            case 6: {
                deviceDataArgin.insert_us(integerValue.shortValue());
                break;
            }
            case 21: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type Tango_DEV_CHAR not supported", "CommandHelper.insertFromDevState(DevState value,deviceDataArgin)");
                break;
            }
            case 22: {
                deviceDataArgin.insert(integerValue.shortValue());
                break;
            }
            case 3: {
                deviceDataArgin.insert(integerValue);
                break;
            }
            case 7: {
                deviceDataArgin.insert_ul(integerValue.longValue());
                break;
            }
            case 23: {
                deviceDataArgin.insert(integerValue);
                break;
            }
            case 24: {
                deviceDataArgin.insert_u64(integerValue.longValue());
                break;
            }
            case 27: {
                deviceDataArgin.insert(integerValue);
                break;
            }
            case 4: {
                deviceDataArgin.insert(integerValue.floatValue());
                break;
            }
            case 5: {
                deviceDataArgin.insert(integerValue.doubleValue());
                break;
            }
            case 8: {
                deviceDataArgin.insert(integerValue.toString());
                break;
            }
            case 1: {
                if (integerValue.doubleValue() == 1.0) {
                    deviceDataArgin.insert(true);
                    break;
                }
                deviceDataArgin.insert(false);
                break;
            }
            case 19: {
                deviceDataArgin.insert(devStateValue);
                break;
            }
            default: {
                Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromDevState(DevState value,deviceDataArgin)");
            }
        }
    }

    public static void insertFromDevVarDoubleStringArray(DevVarDoubleStringArray value, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        if (dataType == 18) {
            deviceDataArgin.insert(value);
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromDevVarDoubleStringArray(DevVarDoubleStringArray value,deviceDataArgin)");
        }
    }

    public static void insertFromDevVarLongStringArray(DevVarLongStringArray value, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        if (dataType == 17) {
            deviceDataArgin.insert(value);
        } else {
            Except.throw_exception("TANGO_WRONG_DATA_ERROR", "input type " + deviceDataArgin.getType() + " not supported", "CommandHelper.insertFromDevVarLongStringArray(DevVarLongStringArray value,deviceDataArgin)");
        }
    }

    public static void insertFromArray(Object[] values, DeviceData deviceDataArgin, int dataType) throws DevFailed {
        if (values.length > 0) {
            Object firstValue = values[0];
            if (firstValue instanceof Short) {
                short[] tmpValues = new short[values.length];
                for (int i = 0; i < tmpValues.length; ++i) {
                    tmpValues[i] = (Short)values[i];
                }
                CommandHelper.insertFromShortArray(tmpValues, deviceDataArgin, dataType);
            } else if (firstValue instanceof String) {
                String[] tmpValues = new String[values.length];
                for (int i = 0; i < tmpValues.length; ++i) {
                    tmpValues[i] = (String)values[i];
                }
                CommandHelper.insertFromStringArray(tmpValues, deviceDataArgin, dataType);
            } else if (firstValue instanceof Integer) {
                int[] tmpValues = new int[values.length];
                for (int i = 0; i < tmpValues.length; ++i) {
                    tmpValues[i] = (Integer)values[i];
                }
                CommandHelper.insertFromIntegerArray(tmpValues, deviceDataArgin, dataType);
            } else if (firstValue instanceof Long) {
                long[] tmpValues = new long[values.length];
                for (int i = 0; i < tmpValues.length; ++i) {
                    tmpValues[i] = ((Long)values[i]).intValue();
                }
                CommandHelper.insertFromLongArray(tmpValues, deviceDataArgin, dataType);
            } else if (firstValue instanceof Float) {
                float[] tmpValues = new float[values.length];
                for (int i = 0; i < tmpValues.length; ++i) {
                    tmpValues[i] = ((Float)values[i]).floatValue();
                }
                CommandHelper.insertFromFloatArray(tmpValues, deviceDataArgin, dataType);
            } else if (firstValue instanceof Byte) {
                byte[] tmpValues = new byte[values.length];
                for (int i = 0; i < tmpValues.length; ++i) {
                    tmpValues[i] = (Byte)values[i];
                }
                CommandHelper.insertFromByteArray(tmpValues, deviceDataArgin, dataType);
            } else if (firstValue instanceof Boolean) {
                boolean[] tmpValues = new boolean[values.length];
                for (int i = 0; i < tmpValues.length; ++i) {
                    tmpValues[i] = (Boolean)values[i];
                }
                CommandHelper.insertFromBooleanArray(tmpValues, deviceDataArgin, dataType);
            } else if (firstValue instanceof Double) {
                double[] tmpValues = new double[values.length];
                for (int i = 0; i < tmpValues.length; ++i) {
                    tmpValues[i] = (Double)values[i];
                }
                CommandHelper.insertFromDoubleArray(tmpValues, deviceDataArgin, dataType);
            }
        }
    }
}

