/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;

public class AttributeProxy
implements ApiDefs,
Serializable {
    private String full_attname = null;
    private String attname = null;
    private String alias = null;
    private DeviceProxy dev;
    private int idl_version = -1;

    public AttributeProxy(String attname) throws DevFailed {
        if (attname.indexOf(47) < 0) {
            this.alias = attname;
            attname = ApiUtil.get_db_obj().get_attribute_alias(this.alias);
        }
        String devname = attname.substring(0, attname.lastIndexOf("/", attname.length() - 1));
        this.full_attname = attname;
        this.attname = attname.substring(attname.lastIndexOf("/", attname.length() - 1) + 1);
        this.dev = new DeviceProxy(devname);
    }

    public int get_idl_version() throws DevFailed {
        if (this.idl_version < 0) {
            this.idl_version = this.dev.get_idl_version();
        }
        return this.idl_version;
    }

    public String fullName() {
        return this.full_attname;
    }

    public String name() {
        return this.attname;
    }

    public long ping() throws DevFailed {
        return this.dev.ping();
    }

    public DevState state() throws DevFailed {
        return this.dev.state();
    }

    public String status() throws DevFailed {
        return this.dev.status();
    }

    public DbAttribute get_property() throws DevFailed {
        return this.dev.get_attribute_property(this.attname);
    }

    public void put_property(DbDatum property) throws DevFailed {
        DbAttribute db_att = new DbAttribute(this.attname);
        db_att.add(property);
        this.dev.put_attribute_property(db_att);
    }

    public void put_property(DbDatum[] properties) throws DevFailed {
        DbAttribute db_att = new DbAttribute(this.attname);
        for (int i = 0; i < properties.length; ++i) {
            db_att.add(properties[i]);
        }
        this.dev.put_attribute_property(db_att);
    }

    public void delete_property(String propname) throws DevFailed {
        this.dev.delete_attribute_property(this.attname, propname);
    }

    public void delete_property(String[] propnames) throws DevFailed {
        this.dev.delete_attribute_property(this.attname, propnames);
    }

    public AttributeInfo get_info() throws DevFailed {
        return this.dev.get_attribute_info(this.attname);
    }

    public AttributeInfoEx get_info_ex() throws DevFailed {
        return this.dev.get_attribute_info_ex(this.attname);
    }

    public void set_info(AttributeInfo[] attr) throws DevFailed {
        this.dev.set_attribute_info(attr);
    }

    public void set_info(AttributeInfoEx[] attr) throws DevFailed {
        this.dev.set_attribute_info(attr);
    }

    public DeviceAttribute read() throws DevFailed {
        return this.dev.read_attribute(this.attname);
    }

    public void write(DeviceAttribute devattr) throws DevFailed {
        this.dev.write_attribute(devattr);
    }

    public DeviceDataHistory[] history(int nb) throws DevFailed {
        return this.dev.attribute_history(this.attname, nb);
    }

    public DeviceDataHistory[] history() throws DevFailed {
        return this.dev.attribute_history(this.attname);
    }

    public void poll(int period) throws DevFailed {
        this.dev.poll_attribute(this.attname, period);
    }

    public void stop_poll() throws DevFailed {
        this.dev.stop_poll_attribute(this.attname);
    }

    public int read_asynch() throws DevFailed {
        return this.dev.read_attribute_asynch(this.attname);
    }

    public void read_asynch(CallBack cb) throws DevFailed {
        this.dev.read_attribute_asynch(this.attname, cb);
    }

    public DeviceAttribute[] read_reply(int id, int timeout) throws DevFailed, AsynReplyNotArrived {
        return this.dev.read_attribute_reply(id, timeout);
    }

    public DeviceAttribute[] read_reply(int id) throws DevFailed, AsynReplyNotArrived {
        return this.dev.read_attribute_reply(id);
    }

    public int write_asynch(DeviceAttribute attr) throws DevFailed {
        return this.dev.write_attribute_asynch(attr);
    }

    public int write_asynch(DeviceAttribute attr, boolean forget) throws DevFailed {
        return this.dev.write_attribute_asynch(attr, forget);
    }

    public void write_asynch(DeviceAttribute attr, CallBack cb) throws DevFailed {
        this.dev.write_attribute_asynch(attr, cb);
    }

    public void write_reply(int id) throws DevFailed, AsynReplyNotArrived {
        this.dev.write_attribute_reply(id);
    }

    public void write_reply(int id, int timeout) throws DevFailed, AsynReplyNotArrived {
        this.dev.write_attribute_reply(id, timeout);
    }

    public int subscribe_event(int event, CallBack callback, String[] filters) throws DevFailed {
        return this.dev.subscribe_event(this.attname, event, callback, filters);
    }

    public static void main(String[] args) {
        String attname = "tango/admin/corvus/hoststate";
        try {
            AttributeProxy att = new AttributeProxy(attname);
            att.ping();
            System.out.println(att.name() + " is alive");
            DbAttribute db_att = att.get_property();
            for (int i = 0; i < db_att.size(); ++i) {
                DbDatum datum = db_att.datum(i);
                System.out.println(datum.name + " : " + datum.extractString());
            }
            DeviceAttribute da = att.read();
            System.out.println(att.name() + " : " + da.extractShort());
            System.out.println(att.name() + " state  : " + ApiUtil.stateName(att.state()));
            System.out.println(att.name() + " status : " + att.status());
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
    }
}

