/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.Tango.factory;

import fr.esrf.TangoApi.IApiUtilDAO;
import fr.esrf.TangoApi.IConnectionDAO;
import fr.esrf.TangoApi.IDatabaseDAO;
import fr.esrf.TangoApi.IDeviceAttributeDAO;
import fr.esrf.TangoApi.IDeviceDataDAO;
import fr.esrf.TangoApi.IDeviceDataHistoryDAO;
import fr.esrf.TangoApi.IDeviceProxyDAO;
import fr.esrf.TangoApi.IIORDumpDAO;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TangoFactory {
    public static final String FACTORY_PROPERTIES = "tango_factory.properties";
    public static final String TANGORB_VERSION_IMPL = "TANGORB_VERSION_IMPL";
    public static final String DEVICE_PROXY_IMPL = "DEVICE_PROXY_IMPL";
    public static final String CONNECTION_IMPL = "CONNECTION_IMPL";
    public static final String DATABASE_IMPL = "DATABASE_IMPL";
    public static final String DEVICE_ATTRIBUTE_IMPL = "DEVICE_ATTRIBUTE_IMPL";
    public static final String DEVICE_DATA_IMPL = "DEVICE_DATA_IMPL";
    public static final String DEVICE_DATA_HISTORY_IMPL = "DEVICE_DATA_HISTORY_IMPL";
    public static final String API_UTIL_IMPL = "API_UTIL_IMPL";
    public static final String IOR_DUMP_IMPL = "IOR_DUMP_IMPL";
    private static TangoFactory singleton = null;
    private Map<String, Object> implMap = null;
    private Properties properties = null;

    public TangoFactory() {
        this.initTangoFactory();
    }

    public void initTangoFactory() {
        this.implMap = new HashMap<String, Object>();
        this.properties = TangoFactory.getPropertiesFile();
    }

    public static TangoFactory getSingleton() {
        if (singleton == null) {
            TangoFactory.createSingleton();
        }
        return singleton;
    }

    public static void createSingleton() {
        singleton = new TangoFactory();
    }

    public IConnectionDAO getConnectionDAO() {
        String className = this.properties.getProperty(CONNECTION_IMPL);
        return (IConnectionDAO)TangoFactory.getObject(className);
    }

    public IDeviceProxyDAO getDeviceProxyDAO() {
        String className = this.properties.getProperty(DEVICE_PROXY_IMPL);
        return (IDeviceProxyDAO)TangoFactory.getObject(className);
    }

    public IDatabaseDAO getDatabaseDAO() {
        String className = this.properties.getProperty(DATABASE_IMPL);
        return (IDatabaseDAO)TangoFactory.getObject(className);
    }

    public IDeviceAttributeDAO getDeviceAttributeDAO() {
        String className = this.properties.getProperty(DEVICE_ATTRIBUTE_IMPL);
        return (IDeviceAttributeDAO)TangoFactory.getObject(className);
    }

    public IDeviceDataDAO getDeviceDataDAO() {
        String className = this.properties.getProperty(DEVICE_DATA_IMPL);
        return (IDeviceDataDAO)TangoFactory.getObject(className);
    }

    public IDeviceDataHistoryDAO getDeviceDataHistoryDAO() {
        String className = this.properties.getProperty(DEVICE_DATA_HISTORY_IMPL);
        return (IDeviceDataHistoryDAO)TangoFactory.getObject(className);
    }

    public IApiUtilDAO getApiUtilDAO() {
        String className = this.properties.getProperty(API_UTIL_IMPL);
        return (IApiUtilDAO)TangoFactory.getObject(className);
    }

    public IIORDumpDAO getIORDumpDAO() {
        String className = this.properties.getProperty(IOR_DUMP_IMPL);
        return (IIORDumpDAO)TangoFactory.getObject(className);
    }

    private static Properties getPropertiesFile() {
        InputStream stream = null;
        BufferedInputStream bufStream = null;
        try {
            stream = TangoFactory.class.getClassLoader().getResourceAsStream(FACTORY_PROPERTIES);
            Properties properties = new Properties();
            if (stream != null) {
                bufStream = new BufferedInputStream(stream);
                properties.clear();
                properties.load(bufStream);
            }
            return properties;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getObject(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> contructor = clazz.getConstructor(new Class[0]);
            Object object = contructor.newInstance(new Object[0]);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

