/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.command.AnyCommandViewer;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CommandMenuViewer
extends JPanel {
    JFrame argFrame = null;
    AnyCommandViewer acv = null;
    JMenuBar commands = new JMenuBar();
    JMenu commands_menu = null;
    JMenuItem[] commands_items = null;
    private CommandList commandList;
    boolean borderVisble;
    boolean infoButtonVisible;
    boolean cancelButtonVisible;
    boolean deviceButtonVisible;
    boolean descriptionVisible;

    public CommandMenuViewer() {
        this.commands.setBorder(null);
        this.commands_menu = new JMenu();
        this.commands_menu.setText("...");
        this.commands.add(this.commands_menu);
        this.updateMenuItem();
        this.setLayout(new GridLayout(1, 1));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.add(this.commands);
    }

    public void setMenuTitle(String string) {
        this.commands_menu.setText(string);
    }

    public void setModel(CommandList commandList) {
        this.commandList = commandList;
        this.commands_items = new JMenuItem[commandList.size()];
        for (int i = 0; i < commandList.size(); ++i) {
            this.commands_items[i] = new JMenuItem();
            this.commands_items[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CommandMenuViewer.this.commandsActionPerformed(actionEvent);
                }
            });
            this.commands_menu.add(this.commands_items[i]);
        }
        this.updateMenuItem();
    }

    public CommandList getModel() {
        return this.commandList;
    }

    public void updateMenuItem() {
        if (this.commandList != null) {
            for (int i = 0; i < this.commandList.size(); ++i) {
                this.commands_items[i].setText(this.commandList.get(i).toString());
                this.commands_items[i].setFont(this.getFont());
                this.commands_items[i].setBackground(this.getBackground());
                this.commands_items[i].setForeground(this.getForeground());
            }
        }
        if (this.commands != null) {
            this.commands_menu.setFont(this.getFont());
            this.commands_menu.setBackground(this.getBackground());
            this.commands_menu.setForeground(this.getForeground());
            this.commands.setFont(this.getFont());
            this.commands.setBackground(this.getBackground());
            this.commands.setForeground(this.getForeground());
        }
    }

    protected void commandsActionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        int n = 0;
        boolean bl = false;
        while (n < this.commandList.size() && !bl) {
            bl = jMenuItem == this.commands_items[n];
            if (bl) continue;
            ++n;
        }
        if (!bl) {
            return;
        }
        ICommand iCommand = (ICommand)this.commandList.get(n);
        if (iCommand instanceof InvalidCommand) {
            JOptionPane.showMessageDialog(this, iCommand.getName() + " is not supported. It probably takes an array as input.", "Error", 1);
            return;
        }
        if (iCommand instanceof VoidVoidCommand) {
            iCommand.execute();
            return;
        }
        if (this.acv == null) {
            this.acv = new AnyCommandViewer();
            this.argFrame = new JFrame();
            this.argFrame.getContentPane().add(this.acv);
        }
        this.acv.initialize(iCommand);
        this.acv.setDeviceButtonVisible(this.deviceButtonVisible);
        this.acv.setDescriptionVisible(this.descriptionVisible);
        this.acv.setInfoButtonVisible(this.infoButtonVisible);
        this.acv.setBorder(null);
        this.acv.setInputVisible(true);
        if (!iCommand.takesInput()) {
            iCommand.execute();
        }
        this.argFrame.setTitle(iCommand.getName());
        this.argFrame.pack();
        this.argFrame.setVisible(true);
    }

    public boolean isBorderVisible() {
        return this.borderVisble;
    }

    public void setBorderVisible(boolean bl) {
        this.borderVisble = bl;
    }

    public boolean isInfoButtonVisible() {
        return this.infoButtonVisible;
    }

    public void setInfoButtonVisible(boolean bl) {
        this.infoButtonVisible = bl;
    }

    public boolean isCancelButtonVisible() {
        return this.cancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean bl) {
        this.cancelButtonVisible = bl;
    }

    public boolean isDeviceButtonVisible() {
        return this.deviceButtonVisible;
    }

    public void setDeviceButtonVisible(boolean bl) {
        this.deviceButtonVisible = bl;
    }

    public boolean isDescriptionVisible() {
        return this.descriptionVisible;
    }

    public void setDescriptionVisible(boolean bl) {
        this.descriptionVisible = bl;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.updateMenuItem();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.updateMenuItem();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateMenuItem();
    }

    public static void main(String[] stringArray) throws Exception {
        CommandList commandList = new CommandList();
        CommandMenuViewer commandMenuViewer = new CommandMenuViewer();
        commandList.add("eas/test-api/1/*");
        commandMenuViewer.setModel(commandList);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(commandMenuViewer);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

