/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.spectrum_histo;

import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tool_panels.spectrum_histo.Histo_3D;

public class SpectrumHisto
extends JDialog {
    private static String className = "SpectrumHisto";
    private static String revNumber = "Release 1.0  -  Fri Apr 18 09:40:52 CEST 2008";
    private Component parent;
    private String attname;
    private Splash splash;
    private JLabel titleLabel;
    private long period = 3000L;
    private SpectrumViewer viewer;
    private static final String[] menu_labels = new String[]{"Set refresher period"};
    private static final int REFRESHER_PERIOD = 0;
    private int splash_progress = 5;
    private JButton exceptionBtn;
    static String[] labels = null;

    public SpectrumHisto(JFrame parent, String attname) throws DevFailed {
        this(parent, attname, true);
    }

    public SpectrumHisto(JFrame parent, String attname, boolean modal) throws DevFailed {
        super((Frame)parent, modal);
        this.createDialog(parent, attname);
    }

    public SpectrumHisto(JDialog parent, String attname) throws DevFailed {
        this(parent, attname, true);
    }

    public SpectrumHisto(JDialog parent, String attname, boolean modal) throws DevFailed {
        super((Dialog)parent, modal);
        this.createDialog(parent, attname);
    }

    private void createDialog(Component parent, String attname) throws DevFailed {
        String title = className;
        int end = revNumber.indexOf("-");
        if (end > 0) {
            title = title + " - " + revNumber.substring(0, end).trim();
        }
        this.splash = new Splash();
        this.splash.setTitle(title);
        this.increaseSplashProgress(5, "Building UI");
        this.parent = parent;
        this.attname = attname;
        this.initComponents();
        this.titleLabel.setText(attname + "   History");
        this.viewer = new SpectrumViewer(this);
        if (labels != null) {
            this.viewer.setYLabels(labels);
        }
        this.getContentPane().add((Component)((Object)this.viewer), "Center");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.setTitle(className + " - " + revNumber);
        this.splash.progress(100);
        this.splash.setVisible(false);
    }

    private void increaseSplashProgress(int i, String message) {
        this.splash_progress += i;
        if (this.splash_progress > 99) {
            this.splash_progress = 99;
        }
        this.splash.progress(this.splash_progress);
        this.splash.setMessage(message);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SpectrumHisto.this.closeDialog(evt);
            }
        });
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpectrumHisto.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.exceptionBtn = new JButton();
        this.exceptionBtn.setText("Error");
        this.exceptionBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpectrumHisto.this.exceptionBtnActionPerformed(evt);
            }
        });
        this.exceptionBtn.setVisible(false);
        jPanel1.add(this.exceptionBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void exceptionBtnActionPerformed(ActionEvent evt) {
        DevFailed e = this.viewer.getException();
        if (e != null) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    static void checkSyntax(String[] args) throws Exception {
        if (args.length == 0) {
            throw new Exception("Attribute name ?");
        }
        StringTokenizer stk = new StringTokenizer(args[0], "/");
        Vector<String> v = new Vector<String>();
        while (stk.hasMoreTokens()) {
            v.add(stk.nextToken());
        }
        if (v.size() != 4) {
            throw new Exception(args[0] + "  is not an attribute name !");
        }
        if (args.length > 1) {
            FileInputStream fid = new FileInputStream(args[1]);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            nb = fid.read(inStr);
            fid.close();
            String code = new String(inStr).trim();
            stk = new StringTokenizer(code, "\n");
            v = new Vector();
            while (stk.hasMoreTokens()) {
                v.add(stk.nextToken());
            }
            labels = new String[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                SpectrumHisto.labels[i] = (String)v.get(i);
            }
            System.out.println(labels.length + " labels found");
        }
    }

    public static void main(String[] args) {
        try {
            SpectrumHisto.checkSyntax(args);
            new SpectrumHisto(new JFrame(), args[0]).setVisible(true);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (Exception)e);
            System.exit(0);
        }
    }

    class Refresher
    extends Thread {
        private AttributeProxy att;
        private SpectrumViewer viewer;
        private DevFailed dev_failed;
        private int length = 0;

        Refresher(SpectrumViewer viewer, AttributeProxy att) {
            this.viewer = viewer;
            this.att = att;
        }

        DevFailed getException() {
            return this.dev_failed;
        }

        public void run() {
            while (true) {
                try {
                    DeviceAttribute da = this.att.read();
                    switch (da.getType()) {
                        case 5: {
                            this.viewer.addData(da.extractDoubleArray());
                            break;
                        }
                        case 3: {
                            int i;
                            Object[] values = da.extractLongArray();
                            double[] d_values = new double[values.length];
                            for (i = 0; i < values.length; ++i) {
                                d_values[i] = values[i];
                            }
                            this.viewer.addData(d_values);
                            break;
                        }
                        case 6: {
                            int i;
                            Object[] values = da.extractUShortArray();
                            double[] d_values = new double[values.length];
                            for (i = 0; i < values.length; ++i) {
                                d_values[i] = values[i];
                            }
                            this.viewer.addData(d_values);
                            break;
                        }
                        case 2: {
                            int i;
                            Object[] values = da.extractShortArray();
                            double[] d_values = new double[values.length];
                            for (i = 0; i < values.length; ++i) {
                                d_values[i] = values[i];
                            }
                            this.viewer.addData(d_values);
                            break;
                        }
                        case 4: {
                            int i;
                            Object[] values = da.extractFloatArray();
                            double[] d_values = new double[values.length];
                            for (i = 0; i < values.length; ++i) {
                                d_values[i] = values[i];
                            }
                            this.viewer.addData(d_values);
                            break;
                        }
                        default: {
                            Except.throw_exception((String)"TYPE_NOT_SUPPORTED", (String)(TangoConst.Tango_CmdArgTypeName[da.getType()] + "\n   is a non supported type !"), (String)"SpectrumHisto.Refresher.run()");
                        }
                    }
                    SpectrumHisto.this.exceptionBtn.setVisible(false);
                }
                catch (DevFailed e) {
                    if (e.errors[0].reason.equals("TYPE_NOT_SUPPORTED")) {
                        ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
                        System.exit(0);
                    }
                    Except.print_exception((Exception)((Object)e));
                    this.dev_failed = e;
                    SpectrumHisto.this.exceptionBtn.setVisible(true);
                    this.viewer.addData(null);
                }
                try {
                    Refresher.sleep(SpectrumHisto.this.period);
                }
                catch (Exception exception) {
                }
            }
        }
    }

    class SpectrumViewer
    extends Histo_3D {
        private AttributeProxy attribute;
        private Refresher refresher;
        private JDialog parent;

        SpectrumViewer(JDialog parent) throws DevFailed {
            super(parent);
            this.parent = parent;
            this.setSearchBestFitVisible(true);
            this.attribute = new AttributeProxy(SpectrumHisto.this.attname);
            this.readHistory();
            this.refresher = new Refresher(this, this.attribute);
            this.refresher.start();
            for (int i = 0; i < menu_labels.length; ++i) {
                JMenuItem btn = new JMenuItem(menu_labels[i]);
                btn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        SpectrumViewer.this.histoMenuActionPerformed(evt);
                    }
                });
                this.addToMenu(btn);
            }
        }

        private void histoMenuActionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if (cmd.equals(menu_labels[0])) {
                int nb_sec = (int)SpectrumHisto.this.period / 1000;
                String strval = "" + nb_sec;
                boolean ok = false;
                while (!ok) {
                    if ((strval = (String)JOptionPane.showInputDialog(this.parent, "Refresher Period in seconds : ", "", 3, null, null, strval)) == null) {
                        return;
                    }
                    try {
                        nb_sec = Integer.parseInt(strval);
                        if (nb_sec < 1) {
                            PopupError.show((Component)((Object)this), "The period must be higher than 1 second");
                            continue;
                        }
                        ok = true;
                    }
                    catch (NumberFormatException e) {
                        PopupError.show((Component)((Object)this), e.toString());
                    }
                }
                SpectrumHisto.this.period = 1000 * nb_sec;
            }
        }

        private void readHistory() {
            try {
                SpectrumHisto.this.increaseSplashProgress(50, "Reading History");
                DeviceDataHistory[] histo = this.attribute.history();
                SpectrumHisto.this.increaseSplashProgress(20, "Updating image");
                this.addHistoData(histo);
                this.setBestFitMinMax();
                this.setPreferredSize(new Dimension(histo.length, this.getYSize() + 50));
            }
            catch (DevFailed e) {
                Except.print_exception((Exception)((Object)e));
            }
        }

        void addData(double[] data) {
            this.addHistoData(data);
            this.updateImage();
        }

        DevFailed getException() {
            return this.refresher.getException();
        }
    }
}

