/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.spectrum_histo;

import app_util.PopupChart;
import com.braju.format.Format;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Gradient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Histo_3D
extends NumberImageViewer {
    private Component parent;
    private double[][] data;
    private Vector histo = new Vector();
    private int NbMeasMax;
    private SetBestFitDialog best_fit_dialog;
    private ThresholdsDialog threshold_dialog;
    private String mainClassName;
    private String propname;
    private String[] y_labels = null;
    private HistoMenu menu;
    private MarkerMenu marker;
    private int y_step = 1;
    private int y_size = 0;
    private int y_real_size = 0;
    private double fit_max = 3.0;
    private double fit_min = 0.0;
    private boolean[] displayed = null;
    private static final int DefaultMaxSize = 1200;

    public Histo_3D(Component parent) {
        this(parent, 1200);
    }

    public Histo_3D(Component parent, int nbMeasMax) {
        this.parent = parent;
        this.NbMeasMax = nbMeasMax;
        Gradient g = this.getGradient();
        g.buildRainbowGradient();
        g.setColorAt(0, Color.black);
        g.setPosAt(1, 0.01);
        int nb = g.getEntryNumber();
        g.setColorAt(nb - 1, Color.red);
        g.setPosAt(nb - 2, 0.99);
        g.setColorAt(nb - 2, Color.yellow);
        this.setGradient(g);
        this.setBestFit(true);
        this.setAutoBestFit(false);
        this.setBackground(Color.white);
        this.setToolbarVisible(false);
        this.setStatusLineVisible(false);
        this.setShowingMenu(false);
        this.setSelectionMode(0);
        this.setSelectionEnabled(false);
        this.setPreferredSize(new Dimension(720, 350));
        this.menu = new HistoMenu();
        if (parent instanceof JDialog) {
            this.best_fit_dialog = new SetBestFitDialog((JDialog)parent);
            this.threshold_dialog = new ThresholdsDialog((JDialog)parent);
        } else {
            this.best_fit_dialog = new SetBestFitDialog((JFrame)parent);
            this.threshold_dialog = new ThresholdsDialog((JFrame)parent);
        }
        JMenuBar menuBar = new JMenuBar();
        this.marker = new MarkerMenu(this);
        this.marker.setEnabled(false);
        menuBar.add(this.marker);
        menuBar.add(new JLabel("   "));
        menuBar.add(this.marker.label);
        this.add(menuBar, "North");
    }

    protected void setYLabels(String[] labels) {
        this.y_labels = labels;
    }

    protected void setBestFitProperty(String classname, String propname) {
        this.mainClassName = classname;
        this.propname = propname;
    }

    protected void readBestFitMinMax() {
        try {
            DbDatum db_data = ApiUtil.get_db_obj().get_property(this.mainClassName, this.propname);
            if (!db_data.is_empty()) {
                double[] val = db_data.extractDoubleArray();
                this.fit_min = val[0];
                this.fit_max = val[1];
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)((Object)this), (String)"Cannot read values in Database", (DevFailed)e);
        }
        this.setBestFitMinMax(this.fit_min, this.fit_max);
    }

    protected void setBestFitMinMax() {
        this.fit_min = 1.6777215E7;
        this.fit_max = -1.6777215E7;
        for (int x = 0; x < this.histo.size() && x < this.NbMeasMax; ++x) {
            double[] val = ((_3D_Record)this.histo.get((int)x)).values;
            for (int v = 0; v < val.length; ++v) {
                if (val[v] < this.fit_min) {
                    this.fit_min = val[v];
                    continue;
                }
                if (!(val[v] > this.fit_max)) continue;
                this.fit_max = val[v];
            }
        }
        this.setBestFitMinMax(this.fit_min, this.fit_max);
    }

    protected void setSearchBestFitVisible(boolean b) {
        this.best_fit_dialog.searchBtn.setVisible(b);
        this.best_fit_dialog.pack();
    }

    protected String[] getUpperThan(double threshold) {
        Vector<String> vector = new Vector<String>();
        for (int y = 0; y < this.y_size; ++y) {
            if (this.displayed != null && y < this.displayed.length && !this.displayed[y]) continue;
            boolean found = false;
            for (int x = 0; !found && x < this.histo.size() && x < this.NbMeasMax; ++x) {
                double[] val = ((_3D_Record)this.histo.get((int)x)).values;
                found = val[y] > threshold;
                if (!found) continue;
                if (this.y_labels == null || y >= this.y_labels.length) {
                    vector.add("" + y);
                    continue;
                }
                vector.add(this.y_labels[y]);
            }
        }
        String[] str = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            str[i] = (String)vector.get(i);
        }
        return str;
    }

    protected _3D_Point getMaxPoint() {
        double z_max = -1.6777215E7;
        int x_max = 0;
        int y_max = 0;
        for (int x = 0; x < this.histo.size() && x < this.NbMeasMax; ++x) {
            double[] val = ((_3D_Record)this.histo.get((int)x)).values;
            int y_displayed = 0;
            for (int v = 0; v < val.length; ++v) {
                if (this.displayed != null && v < this.displayed.length && !this.displayed[v]) continue;
                if (val[v] > z_max) {
                    z_max = val[v];
                    x_max = x;
                    y_max = y_displayed;
                }
                ++y_displayed;
            }
        }
        return new _3D_Point(x_max, y_max, z_max);
    }

    protected void setMarkerPosition(Point p) {
        ++p.x;
        p.y *= this.y_step;
        this.marker.setValue(p);
        this.marker.setEnabled(true);
    }

    private void moveToMaxi() {
        _3D_Point p = this.getMaxPoint();
        this.setMarkerPosition(new Point(p.x, p.y));
    }

    protected void displayHistory(String[] names) {
        int n;
        Vector<Integer> v = new Vector<Integer>();
        if (this.y_labels != null) {
            for (n = 0; n < names.length; ++n) {
                for (int i = 0; i < this.y_labels.length; ++i) {
                    if (!this.y_labels[i].equals(names[n])) continue;
                    v.add(new Integer(i));
                }
            }
        } else {
            for (n = 0; n < names.length; ++n) {
                try {
                    v.add(new Integer(names[n]));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (v.size() > 0) {
            int[] array = new int[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                array[i] = (Integer)v.get(i);
            }
            this.displayHistory(array);
        }
    }

    protected void displayHistory(String name) {
        this.displayHistory(new String[]{name});
    }

    protected void displayHistory(int y) {
        this.displayHistory(new int[]{y});
    }

    protected void displaySelectionHistory() {
        if (this.isSelectionEnabled()) {
            Rectangle r = this.getSelection();
            if (this.y_labels == null) {
                int[] idx = new int[r.height];
                for (int i = 0; i < r.height; ++i) {
                    idx[i] = i + r.y;
                }
                this.displayHistory(idx);
            } else {
                String[] lbl = new String[r.height];
                for (int i = 0; i < r.height; ++i) {
                    lbl[i] = this.y_labels[i + r.y];
                }
                this.displayHistory(lbl);
            }
        }
    }

    protected void displayHistory(int[] y) {
        long[] t = new long[this.histo.size()];
        double[][] d_meas = new double[y.length][];
        for (int i = 0; i < y.length; ++i) {
            double[] values = new double[this.histo.size()];
            for (int x = 0; x < this.histo.size() && x < this.NbMeasMax; ++x) {
                _3D_Record rec = this.record3D(x);
                t[x] = rec.time;
                values[x] = rec.values[y[i]];
            }
            d_meas[i] = values;
        }
        String[] labels = new String[y.length];
        for (int i = 0; i < y.length; ++i) {
            labels[i] = this.y_labels == null ? "History at index " + y[i] : this.y_labels[y[i]];
        }
        PopupChart panel = this.parent instanceof JDialog ? new PopupChart((JDialog)this.parent, "History") : new PopupChart((JFrame)this.parent, "History");
        panel.setLabelVisible(false);
        panel.setY1Data(labels, t, d_meas);
        panel.setVisible(true);
    }

    protected void setHistoryDepth(int nb) {
        this.NbMeasMax = nb;
    }

    protected int getNbRecords() {
        return this.histo.size();
    }

    protected void showMenu(MouseEvent e) {
        this.menu.showMenu(e);
    }

    protected void addToMenu(JMenuItem jmi) {
        this.menu.add(jmi);
    }

    protected void addToMenu(JRadioButtonMenuItem jrbmi) {
        this.menu.add(jrbmi);
    }

    protected void setYStep(int step) {
        this.y_step = step;
    }

    protected int getYStep() {
        return this.y_step;
    }

    protected double getData(int x, int y) {
        if (this.data == null) {
            return 0.0;
        }
        return this.data[y][x];
    }

    protected int getYSize() {
        return this.y_size;
    }

    protected void setDisplayed(boolean[] displayed) {
        this.displayed = displayed;
    }

    protected void updateImage() {
        if (!this.isVisible()) {
            return;
        }
        if (this.y_size > this.y_real_size) {
            this.y_real_size = this.y_size;
        }
        int img_height = this.y_real_size * this.y_step;
        if (this.displayed != null) {
            int cnt = 0;
            for (int i = 0; i < this.displayed.length; ++i) {
                if (!this.displayed[i]) continue;
                ++cnt;
            }
            img_height = cnt * this.y_step;
        }
        if (this.data == null || img_height != this.data.length) {
            this.data = new double[img_height][this.NbMeasMax + 1];
        }
        for (int x = 0; x < this.histo.size() && x < this.NbMeasMax; ++x) {
            double[] val = ((_3D_Record)this.histo.get((int)x)).values;
            int y = 0;
            for (int n = 0; n < this.y_size && n < val.length; ++n) {
                if (this.displayed != null && n < this.displayed.length && !this.displayed[n]) continue;
                for (int st = 0; st < this.y_step; ++st) {
                    this.data[y++][x] = val[n];
                }
            }
        }
        this.setData(this.data);
        this.repaint();
    }

    protected void setMarkerText(String text) {
        this.marker.label.setText(text);
    }

    public void mouseClicked(MouseEvent e) {
        int mask = e.getModifiers();
        if ((mask & 4) != 0) {
            this.menu.showMenu(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int mask = e.getModifiers();
        if ((mask & 0x10) != 0) {
            if ((mask & 2) == 0) {
                this.marker.setEnabled(true);
            }
            this.manageMouseEvent(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        int mask = e.getModifiers();
        if ((mask & 0x10) != 0) {
            this.manageMouseEvent(e);
        }
    }

    protected boolean isInsideImage(Point p) {
        Dimension d = this.getCurrentImageSize();
        return p.x >= 0 && p.x < this.histo.size() && p.y >= 0 && p.y < d.height;
    }

    protected boolean yIsInsideImage(int y) {
        Dimension d = this.getCurrentImageSize();
        return y >= 0 && y < d.height;
    }

    private void manageMouseEvent(MouseEvent e) {
        Point p;
        if (!this.isVisible()) {
            return;
        }
        int mask = e.getModifiers();
        if ((mask & 0x10) != 0 && this.isInsideImage(p = new Point(this.getImageXCoord(e.getX()), this.getImageYCoord(e.getY())))) {
            if ((mask & 2) != 0) {
                this.manageSelection(p);
            } else {
                this.manageMarker(p);
            }
        }
    }

    private void manageSelection(Point p) {
        Rectangle r;
        if (!this.isSelectionEnabled()) {
            p.x = 0;
            this.setSelectionMode(1);
            this.setSelectionEnabled(true);
            r = new Rectangle(p);
        } else {
            r = this.getSelection();
        }
        r.width = this.NbMeasMax - 1;
        r.height = p.y - r.y;
        this.setSelection(r);
    }

    private void manageMarker(Point p) {
        this.setSelectionMode(0);
        this.setSelectionEnabled(false);
        _3D_Record rec = (_3D_Record)this.histo.get(p.x);
        if (rec.time > 0L) {
            this.marker.setValue(p);
        } else {
            this.marker.label.setText("   ");
        }
    }

    protected void displayHistoValues(Point p, _3D_Record rec) {
        if (rec == null) {
            return;
        }
        Object[] o = new Object[]{new Double(this.getData(p.x, p.y))};
        String strval = Format.sprintf((String)"%.3f", (Object[])o);
        String strdate = Histo_3D.formatDate(rec.time);
        String str = this.y_labels == null ? strdate + ":  " + strval + "  at index " + p.y : strdate + ":  " + strval + "  on " + this.y_labels[p.y];
        this.setMarkerText(str);
    }

    protected void addHistoData(double[] values) {
        if (values != null) {
            this.y_size = values.length;
            this.histo.add(new _3D_Record(values));
            if (this.histo.size() >= this.NbMeasMax) {
                this.histo.remove(0);
                if (this.hasMarker()) {
                    this.marker.decreaseXValue();
                }
            }
        } else {
            values = new double[this.y_size];
            for (int i = 0; i < this.y_size; ++i) {
                values[i] = Double.NaN;
            }
            this.addHistoData(values);
        }
    }

    protected void addHistoData(double[] values, long t) {
        this.y_size = values.length;
        if (this.histo.size() >= this.NbMeasMax) {
            this.histo.remove(0);
        }
        this.histo.add(new _3D_Record(values, t));
    }

    protected void addHistoData(DeviceDataHistory[] devhisto) {
        int nb_val = 0;
        if (devhisto != null) {
            if (this.NbMeasMax < devhisto.length) {
                this.NbMeasMax = devhisto.length;
            }
            for (int i = 0; i < devhisto.length; ++i) {
                long t = devhisto[i].getTime();
                try {
                    double[] d = devhisto[i].extractDoubleArray();
                    nb_val = d.length;
                    this.addHistoData(d, t);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(i + "/" + devhisto.length + ":\t" + e);
                }
            }
            System.out.println("Read " + this.histo.size() + " x " + nb_val + "  = " + this.histo.size() * nb_val + " data");
        }
    }

    protected void resetHistoData() {
        this.histo.removeAllElements();
    }

    protected void updateChart() {
    }

    protected void bestFitChanged() {
    }

    protected _3D_Record record3D(int idx) {
        return (_3D_Record)this.histo.get(idx);
    }

    public static String formatDate(long ms) {
        StringTokenizer st = new StringTokenizer(new Date(ms).toString());
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        String month = (String)v.get(1);
        String day = (String)v.get(2);
        String time = (String)v.get(3);
        String year = (String)v.get(v.size() - 1);
        if (year.indexOf(41) > 0) {
            year = year.substring(0, year.indexOf(41));
        }
        return day + " " + month + " " + year + "  " + time;
    }

    class ThresholdsDialog
    extends JDialog {
        private JTextField thresholdTxt;
        private JList list;
        private JScrollPane jsp;

        ThresholdsDialog(JDialog parent) {
            super((Dialog)parent, false);
            this.initComponents();
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        ThresholdsDialog(JFrame parent) {
            super((Frame)parent, false);
            this.initComponents();
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        protected void initComponents() {
            GridBagConstraints gbc = new GridBagConstraints();
            JPanel jPanel1 = new JPanel();
            JButton profileBtn = new JButton();
            JButton okBtn = new JButton();
            JButton cancelBtn = new JButton();
            JPanel jPanel2 = new JPanel();
            JLabel titleLabel = new JLabel();
            JPanel configPanel = new JPanel();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ThresholdsDialog.this.closeDialog(evt);
                }
            });
            okBtn.setText(" Apply Threshod ");
            okBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ThresholdsDialog.this.okBtnActionPerformed(evt);
                }
            });
            jPanel1.add(okBtn);
            profileBtn.setText(" History ");
            profileBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ThresholdsDialog.this.profileBtnActionPerformed(evt);
                }
            });
            jPanel1.add(profileBtn);
            cancelBtn.setText(" Dismiss ");
            cancelBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ThresholdsDialog.this.cancelBtnActionPerformed(evt);
                }
            });
            jPanel1.add(cancelBtn);
            this.getContentPane().add((Component)jPanel1, "South");
            titleLabel.setFont(new Font("Dialog", 1, 14));
            titleLabel.setText("Dialog Title");
            jPanel2.add(titleLabel);
            this.getContentPane().add((Component)jPanel2, "North");
            int x = 0;
            int y = 0;
            configPanel.setLayout(new GridBagLayout());
            JLabel lbl = new JLabel("Threshold : ");
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            configPanel.add((Component)lbl, gbc);
            this.thresholdTxt = new JTextField();
            this.thresholdTxt.setColumns(6);
            this.thresholdTxt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ThresholdsDialog.this.okBtnActionPerformed(evt);
                }
            });
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.fill = 2;
            configPanel.add((Component)this.thresholdTxt, gbc);
            this.getContentPane().add((Component)configPanel, "West");
            titleLabel.setText("Threshold Management");
            this.jsp = new JScrollPane();
            this.jsp.setPreferredSize(new Dimension(300, 500));
            this.list = new JList();
            this.jsp.setViewportView(this.list);
            this.getContentPane().add((Component)this.jsp, "East");
            MouseAdapter mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ThresholdsDialog.this.listSelectionPerformed(e);
                }
            };
            this.list.addMouseListener(mouseListener);
        }

        private void applyThreshold() {
            double threshold;
            try {
                threshold = Double.parseDouble(this.thresholdTxt.getText());
            }
            catch (Exception e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)e);
                return;
            }
            this.list.setListData(Histo_3D.this.getUpperThan(threshold));
        }

        private void listSelectionPerformed(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                String name = new String((String)this.list.getSelectedValue());
                Histo_3D.this.displayHistory(name);
            }
        }

        private void profileBtnActionPerformed(ActionEvent evt) {
            Object[] o = this.list.getSelectedValues();
            if (o.length == 0) {
                ErrorPane.showErrorMessage((Component)new JFrame(), (String)"", (Exception)new Exception("No item selected !"));
                return;
            }
            String[] names = new String[o.length];
            for (int i = 0; i < o.length; ++i) {
                names[i] = (String)o[i];
            }
            Histo_3D.this.displayHistory(names);
        }

        private void okBtnActionPerformed(ActionEvent evt) {
            this.applyThreshold();
        }

        private void cancelBtnActionPerformed(ActionEvent evt) {
            this.doClose();
        }

        private void closeDialog(WindowEvent evt) {
            this.doClose();
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }

        private void showDialog() {
            Object[] o = new Object[]{new Double(Histo_3D.this.getBestFitMax())};
            String strval = Format.sprintf((String)"%.3f", (Object[])o);
            this.thresholdTxt.setText(strval);
            this.applyThreshold();
            this.setVisible(true);
        }
    }

    public class SetBestFitDialog
    extends JDialog {
        private JTextField miniTxt;
        private JTextField maxiTxt;
        private JButton searchBtn;

        public SetBestFitDialog(JDialog parent) {
            super((Dialog)parent, true);
            this.initComponents();
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        public SetBestFitDialog(JFrame parent) {
            super((Frame)parent, true);
            this.initComponents();
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        protected void initComponents() {
            GridBagConstraints gbc = new GridBagConstraints();
            JPanel jPanel1 = new JPanel();
            JButton okBtn = new JButton();
            JButton cancelBtn = new JButton();
            JPanel jPanel2 = new JPanel();
            JLabel titleLabel = new JLabel();
            JPanel configPanel = new JPanel();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    SetBestFitDialog.this.closeDialog(evt);
                }
            });
            okBtn.setText("Apply");
            okBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetBestFitDialog.this.okBtnActionPerformed(evt);
                }
            });
            jPanel1.add(okBtn);
            this.searchBtn = new JButton();
            this.searchBtn.setText("Search");
            this.searchBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetBestFitDialog.this.searchBtnActionPerformed(evt);
                }
            });
            this.searchBtn.setVisible(false);
            jPanel1.add(this.searchBtn);
            cancelBtn.setText("Dismiss");
            cancelBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetBestFitDialog.this.cancelBtnActionPerformed(evt);
                }
            });
            jPanel1.add(cancelBtn);
            this.getContentPane().add((Component)jPanel1, "South");
            titleLabel.setFont(new Font("Dialog", 1, 14));
            titleLabel.setText("Dialog Title");
            jPanel2.add(titleLabel);
            this.getContentPane().add((Component)jPanel2, "North");
            int x = 0;
            int y = 0;
            configPanel.setLayout(new GridBagLayout());
            JLabel lbl = new JLabel("Mini : ");
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            configPanel.add((Component)lbl, gbc);
            this.miniTxt = new JTextField();
            this.miniTxt.setColumns(6);
            this.miniTxt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetBestFitDialog.this.okBtnActionPerformed(evt);
                }
            });
            gbc.gridx = x;
            gbc.gridy = y++;
            gbc.fill = 2;
            configPanel.add((Component)this.miniTxt, gbc);
            x = 0;
            lbl = new JLabel("Maxi : ");
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            configPanel.add((Component)lbl, gbc);
            this.maxiTxt = new JTextField();
            this.maxiTxt.setColumns(6);
            this.maxiTxt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetBestFitDialog.this.okBtnActionPerformed(evt);
                }
            });
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.fill = 2;
            configPanel.add((Component)this.maxiTxt, gbc);
            this.getContentPane().add((Component)configPanel, "Center");
            titleLabel.setText("Fit Range");
        }

        private void okBtnActionPerformed(ActionEvent evt) {
            this.setBestFit();
        }

        private void searchBtnActionPerformed(ActionEvent evt) {
            Histo_3D.this.setBestFitMinMax();
            this.showDialog();
        }

        private void cancelBtnActionPerformed(ActionEvent evt) {
            this.doClose();
        }

        private void closeDialog(WindowEvent evt) {
            this.doClose();
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }

        void showDialog() {
            Object[] o = new Object[]{new Double(Histo_3D.this.getBestFitMin())};
            String strval = Format.sprintf((String)"%.3f", (Object[])o);
            this.miniTxt.setText("" + strval);
            o[0] = new Double(Histo_3D.this.getBestFitMax());
            strval = Format.sprintf((String)"%.3f", (Object[])o);
            this.maxiTxt.setText("" + strval);
            this.setVisible(true);
        }

        private void setBestFit() {
            double d1 = 0.0;
            double d2 = 0.0;
            try {
                try {
                    d1 = Double.parseDouble(this.miniTxt.getText());
                }
                catch (NumberFormatException e) {
                    Except.throw_exception((String)"BAD_VALUE", (String)("Minimum Value:\n" + e.toString()), (String)"Histo_3D.setBestFit()");
                }
                try {
                    d2 = Double.parseDouble(this.maxiTxt.getText());
                }
                catch (NumberFormatException e) {
                    Except.throw_exception((String)"BAD_VALUE", (String)("Maximum Value:\n" + e.toString()), (String)"Histo_3D.setBestFit()");
                }
                if (d1 >= d2) {
                    Except.throw_exception((String)"BAD_VALUE", (String)"Maximum value must be greater than minimum value !", (String)"Histo_3D.setBestFit()");
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)Histo_3D.this.parent, null, (DevFailed)e);
                return;
            }
            Histo_3D.this.setBestFitMinMax(d1, d2);
            this.repaint();
            if (Histo_3D.this.mainClassName != null) {
                try {
                    double[] val = new double[]{d1, d2};
                    DbDatum[] db_data = new DbDatum[]{new DbDatum(Histo_3D.this.propname, val)};
                    ApiUtil.get_db_obj().put_property(Histo_3D.this.mainClassName, db_data);
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this, (String)"Cannot store values in Database", (DevFailed)e);
                }
            }
            Histo_3D.this.bestFitChanged();
        }
    }

    protected class MarkerMenu
    extends JMenu {
        private JMenuItem left;
        private JMenuItem right;
        private JMenuItem up;
        private JMenuItem down;
        private JMenuItem remove;
        private JMenuItem history;
        private JMenuItem move_maxi;
        private JLabel label;
        private Point position;
        private NumberImageViewer viewer;

        public MarkerMenu(NumberImageViewer viewer) {
            super("Marker");
            this.viewer = viewer;
            this.label = new JLabel("    ");
            this.position = new Point();
            this.position.x = Histo_3D.this.NbMeasMax - 1;
            this.position.y = 0;
            this.up = new JMenuItem("Up");
            this.up.setAccelerator(KeyStroke.getKeyStroke(85, 2));
            this.up.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MarkerMenu.this.moveMarkerActionPerformed(evt);
                }
            });
            this.add(this.up);
            this.down = new JMenuItem("Down");
            this.down.setAccelerator(KeyStroke.getKeyStroke(68, 2));
            this.down.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MarkerMenu.this.moveMarkerActionPerformed(evt);
                }
            });
            this.add(this.down);
            this.left = new JMenuItem("Left");
            this.left.setAccelerator(KeyStroke.getKeyStroke(76, 2));
            this.left.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MarkerMenu.this.moveMarkerActionPerformed(evt);
                }
            });
            this.add(this.left);
            this.right = new JMenuItem("Right");
            this.right.setAccelerator(KeyStroke.getKeyStroke(82, 2));
            this.right.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MarkerMenu.this.moveMarkerActionPerformed(evt);
                }
            });
            this.add(this.right);
            this.remove = new JMenuItem("Remove");
            this.remove.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MarkerMenu.this.moveMarkerActionPerformed(evt);
                }
            });
            this.add(this.remove);
            this.history = new JMenuItem("History");
            this.history.setAccelerator(KeyStroke.getKeyStroke(72, 2));
            this.history.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MarkerMenu.this.moveMarkerActionPerformed(evt);
                }
            });
            this.add(this.history);
            this.move_maxi = new JMenuItem("Move to Maximum");
            this.move_maxi.setAccelerator(KeyStroke.getKeyStroke(77, 2));
            this.move_maxi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MarkerMenu.this.moveMarkerActionPerformed(evt);
                }
            });
            this.add(this.move_maxi);
        }

        protected void setValue(Point p) {
            this.position = p;
            Histo_3D.this.clearMarkers();
            Histo_3D.this.addHorizontalLineMarker(this.position.y, Color.white);
            Histo_3D.this.addVerticalLineMarker(this.position.x, Color.white);
            this.displayPositionValues();
        }

        protected void setXValue(int x) {
            this.position.x = x;
            Histo_3D.this.clearMarkers();
            Histo_3D.this.addHorizontalLineMarker(this.position.y, Color.white);
            Histo_3D.this.addVerticalLineMarker(this.position.x, Color.white);
            if (this.viewer.isVisible()) {
                this.displayPositionValues();
            }
        }

        protected void setYValue(int y) {
            this.position.y = y;
            Histo_3D.this.clearMarkers();
            Histo_3D.this.addHorizontalLineMarker(this.position.y, Color.white);
            Histo_3D.this.addVerticalLineMarker(this.position.x, Color.white);
            this.displayPositionValues();
        }

        void displayPositionValues() {
            if (Histo_3D.this.hasMarker()) {
                if (this.position.y < 0 || this.position.y / Histo_3D.this.y_step >= Histo_3D.this.data.length) {
                    return;
                }
                _3D_Record rec = (_3D_Record)Histo_3D.this.histo.get(this.position.x);
                Histo_3D.this.displayHistoValues(this.position, rec);
            }
        }

        protected void moveMarkerActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            if (obj == this.up) {
                this.position.y -= Histo_3D.this.y_step;
                if (!Histo_3D.this.yIsInsideImage(this.position.y)) {
                    this.position.y += Histo_3D.this.y_step;
                }
                this.setYValue(this.position.y);
            } else if (obj == this.down) {
                this.position.y += Histo_3D.this.y_step;
                if (!Histo_3D.this.yIsInsideImage(this.position.y)) {
                    this.position.y -= Histo_3D.this.y_step;
                }
                this.setYValue(this.position.y);
            } else if (obj == this.left) {
                this.decreaseXValue();
            } else if (obj == this.right) {
                this.increaseXValue();
            } else if (obj == this.remove) {
                Histo_3D.this.clearMarkers();
                ((Histo_3D)Histo_3D.this).marker.label.setText("   ");
                this.setEnabled(false);
            } else if (obj == this.history) {
                Histo_3D.this.displayHistory(this.position.y);
            } else if (obj == this.move_maxi) {
                Histo_3D.this.moveToMaxi();
            }
        }

        void decreaseXValue() {
            if (this.position.x > 0) {
                --this.position.x;
            }
            this.setXValue(this.position.x);
        }

        void increaseXValue() {
            if (this.position.x < Histo_3D.this.histo.size() - 1) {
                ++this.position.x;
            }
            this.setXValue(this.position.x);
        }
    }

    class HistoMenu
    extends JPopupMenu {
        private String[] labels = new String[]{"Set Fit Scale", "Zoom In", "Zoom Out", "Thresholds", "Selection History"};
        private static final int OFFSET = 2;
        private static final int SET_FIT = 0;
        private static final int ZOOM_IN = 1;
        private static final int ZOOM_OUT = 2;
        private static final int THRESHOLDS = 3;
        private static final int SELECTION = 4;
        private static final int ZOOM_100 = 3;
        private int zoom_factor = 3;

        public HistoMenu() {
            JLabel title = new JLabel("Derivative History :");
            title.setFont(new Font("Dialog", 1, 16));
            this.add(title);
            this.add(new JPopupMenu.Separator());
            for (int i = 0; i < this.labels.length; ++i) {
                JMenuItem btn = new JMenuItem(this.labels[i]);
                btn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        HistoMenu.this.histoActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt) {
            this.getComponent(3).setEnabled(true);
            this.getComponent(4).setEnabled(true);
            if (this.zoom_factor > 3) {
                this.getComponent(4).setEnabled(false);
            } else if (this.zoom_factor < 3) {
                this.getComponent(3).setEnabled(false);
            }
            this.getComponent(6).setEnabled(Histo_3D.this.isSelectionEnabled());
            this.show((Component)Histo_3D.this.imagePanel, evt.getX(), evt.getY());
        }

        private void histoActionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            int idx = -1;
            for (int i = 0; i < this.labels.length; ++i) {
                if (!cmd.equals(this.labels[i])) continue;
                idx = i;
            }
            switch (idx) {
                case 0: {
                    Histo_3D.this.best_fit_dialog.showDialog();
                    break;
                }
                case 1: {
                    --this.zoom_factor;
                    Histo_3D.this.setZoom(this.zoom_factor);
                    Histo_3D.this.updateChart();
                    break;
                }
                case 2: {
                    ++this.zoom_factor;
                    Histo_3D.this.setZoom(this.zoom_factor);
                    Histo_3D.this.updateChart();
                    break;
                }
                case 3: {
                    Histo_3D.this.threshold_dialog.showDialog();
                    break;
                }
                case 4: {
                    Histo_3D.this.displaySelectionHistory();
                }
            }
        }
    }

    protected class _3D_Record {
        public double[] values;
        public long time;

        public _3D_Record(double[] val) {
            this.values = new double[val.length];
            for (int i = 0; i < val.length; ++i) {
                this.values[i] = val[i];
            }
            this.time = System.currentTimeMillis();
        }

        public _3D_Record(double[] val, long t) {
            this.values = new double[val.length];
            for (int i = 0; i < val.length; ++i) {
                this.values[i] = val[i];
            }
            this.time = t;
        }

        public String toString() {
            return Histo_3D.formatDate(this.time) + ": " + this.values[6];
        }
    }

    protected class _3D_Point {
        public long time;
        public int x;
        public int y;
        public double z;

        _3D_Point(int x, int y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.time = ((_3D_Record)((Histo_3D)Histo_3D.this).histo.get((int)x)).time;
        }

        public String toString() {
            return "Value: " + this.z + "  at " + Histo_3D.formatDate(this.time) + " - index= " + this.y;
        }
    }
}

