/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.atktable;

import app_util.PopupHtml;
import app_util.PopupMessage;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import tool_panels.atktable.DevBrowser;
import tool_panels.atktable.TableConfig;
import tool_panels.atktable.TableScalarViewer;

public class MainPanel
extends JFrame {
    private static String revNumber = "Release 1.4  -  Wed May 07 09:16:44 CEST 2008";
    private boolean exit_leave = true;
    private TableScalarViewer viewer = null;
    private DevBrowser browser = null;
    private JMenuItem aboutAppliItem;
    private JMenuItem atkStatItem;
    private JMenuItem errorItem;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar jMenuBar1;
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem releaseItem;
    private JMenuItem saveItem;
    private JMenuItem trendItem;
    private JMenu viewMenu;

    public MainPanel() {
        this.createPanel();
        this.viewer = new TableScalarViewer();
        this.getContentPane().add((Component)this.viewer, "Center");
        this.pack();
    }

    public MainPanel(String[] args) {
        this.createPanel();
        TableConfig config = null;
        String devname = "";
        try {
            if (args.length == 1) {
                this.viewer = new TableScalarViewer(args[0], 0);
            } else if (args.length > 1 && args[0].equals("-file")) {
                this.viewer = new TableScalarViewer(args[1], 0);
            } else if (args[0].equals("-dev")) {
                this.viewer = new TableScalarViewer(args[1], 1);
            } else {
                throw new Exception("atktable  -dev  devname\natktable  -file  filename\natktable  filename");
            }
            this.getContentPane().add((Component)this.viewer, "Center");
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Syntax:", (Exception)e);
            config = new TableConfig(null, 3, 2);
        }
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
    }

    public MainPanel(String[] rownames, String[] colnames, String[][] attnames) {
        this(rownames, colnames, attnames, null);
    }

    public MainPanel(String[] rownames, String[] colnames, String[][] attnames, Dimension d) {
        this.createPanel();
        this.viewer = new TableScalarViewer(rownames, colnames, attnames);
        this.getContentPane().add((Component)this.viewer, "Center");
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
    }

    private void createPanel() {
        this.initComponents();
        this.customizeMenus();
        this.setTitle("atktable - " + revNumber);
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
    }

    public void setExitWhenLeaving(boolean b) {
        this.exit_leave = b;
    }

    public boolean isEditable() {
        return this.viewer.isEditable();
    }

    public void setEditable(boolean b) {
        this.viewer.setEditable(b);
        this.saveItem.setVisible(b);
        this.openItem.setVisible(b);
        this.newItem.setVisible(b);
    }

    public void setPanelTitle(String title) {
        this.viewer.setPanelTitle(title);
    }

    public void setSize(Dimension d) {
        this.viewer.setSize(d);
        this.pack();
    }

    private void customizeMenus() {
        this.fileMenu.setMnemonic('F');
        this.viewMenu.setMnemonic('V');
        this.newItem.setMnemonic('N');
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem.setMnemonic('O');
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveItem.setMnemonic('S');
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.exitItem.setMnemonic('E');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.trendItem.setMnemonic('T');
        this.trendItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.errorItem.setMnemonic('E');
        this.errorItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.saveItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.trendItem = new JMenuItem();
        this.errorItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.atkStatItem = new JMenuItem();
        this.releaseItem = new JMenuItem();
        this.aboutAppliItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainPanel.this.exitForm(evt);
            }
        });
        this.fileMenu.setText("File");
        this.newItem.setText("New");
        this.newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.newItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newItem);
        this.openItem.setText("Open");
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.openItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openItem);
        this.saveItem.setText("Save");
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.saveItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveItem);
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.exitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.trendItem.setText("Trend");
        this.trendItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.trendItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.trendItem);
        this.errorItem.setText("Error History");
        this.errorItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.errorItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.errorItem);
        this.jMenuBar1.add(this.viewMenu);
        this.helpMenu.setText("help");
        this.atkStatItem.setText("ATK Statistics");
        this.atkStatItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.atkStatItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.atkStatItem);
        this.releaseItem.setText("Release Note");
        this.releaseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.releaseItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.releaseItem);
        this.aboutAppliItem.setText("About");
        this.aboutAppliItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.aboutAppliItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutAppliItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void trendItemActionPerformed(ActionEvent evt) {
        this.viewer.showTrend();
    }

    private void releaseItemActionPerformed(ActionEvent evt) {
        new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> Release Note </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n<Center>\t<h2>atktable Release Note</h2>\n\t(Generated Wed May 07 09:16:44 CEST 2008)</Center><Br>\n<li><b>atktable-1.4 - 20/12/07:</b><Br>\n&nbsp; &nbsp; Trend added.<Br>\n<li><b>atktable-1.3 - 29/08/07:</b><Br>\n&nbsp; &nbsp; Now in tool_panels.atktable package.<Br>\n<li><b>atktable-1.2 - 15/06/07:</b><Br>\n&nbsp; &nbsp; Class names have changed.<Br>\n&nbsp; &nbsp; TableScalarViewer is now a viewer.<Br>\n<li><b>atktable-1.1 - 12/06/07:</b><Br>\n&nbsp; &nbsp; First installed revision.<Br>\n<li><b>atktable-1.0 - 30/05/07:</b><Br>\n&nbsp; &nbsp; Initial Revision<Br>\n</Body>\n</Html>\n", 380, 450);
    }

    private void openItemActionPerformed(ActionEvent evt) {
        if (this.viewer.openConfigFile()) {
            this.viewer.stopTrend();
            this.pack();
        }
    }

    private void saveItemActionPerformed(ActionEvent evt) {
        this.viewer.saveConfigFile();
    }

    private void newItemActionPerformed(ActionEvent evt) {
        if (this.viewer.newTable()) {
            this.viewer.stopTrend();
        }
    }

    private void aboutAppliItemActionPerformed(ActionEvent evt) {
        String message = "atktable\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
        PopupMessage.showImage((Component)this, message, "/app_util/img/tango_icon.jpg");
    }

    private void atkStatItemActionPerformed(ActionEvent evt) {
        ATKDiagnostic.showDiagnostic();
    }

    private void errorItemActionPerformed(ActionEvent evt) {
        this.viewer.showErrorHistory();
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        if (this.exit_leave) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void exitForm(WindowEvent evt) {
        if (this.exit_leave) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        MainPanel panel = args.length > 0 ? new MainPanel(args) : new MainPanel();
        panel.setVisible(true);
    }

    public class AtkTableFilter
    extends FileFilter {
        private Hashtable filters = new Hashtable();
        private String description = null;
        private String fullDescription = null;
        private boolean useExtensionsInDescription = true;

        public AtkTableFilter() {
        }

        public AtkTableFilter(String extension) {
            this(extension, null);
        }

        public AtkTableFilter(String extension, String description) {
            this();
            if (extension != null) {
                this.addExtension(extension);
            }
            if (description != null) {
                this.setDescription(description);
            }
        }

        public AtkTableFilter(String[] filters) {
            this(filters, null);
        }

        public AtkTableFilter(String[] filters, String description) {
            this();
            for (int i = 0; i < filters.length; ++i) {
                this.addExtension(filters[i]);
            }
            if (description != null) {
                this.setDescription(description);
            }
        }

        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                    return true;
                }
            }
            return false;
        }

        public String getExtension(File f) {
            if (f != null) {
                String filename = f.getName();
                return this.getExtension(filename);
            }
            return null;
        }

        public String getExtension(String filename) {
            int i;
            if (filename != null && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                return filename.substring(i + 1).toLowerCase();
            }
            return null;
        }

        public void addExtension(String extension) {
            if (this.filters == null) {
                this.filters = new Hashtable(5);
            }
            this.filters.put(extension.toLowerCase(), this);
            this.fullDescription = null;
        }

        public String getDescription() {
            if (this.fullDescription == null) {
                if (this.description == null || this.isExtensionListInDescription()) {
                    this.fullDescription = this.description == null ? "(" : this.description + " (";
                    Enumeration extensions = this.filters.keys();
                    if (extensions != null) {
                        this.fullDescription = this.fullDescription + "." + extensions.nextElement();
                        while (extensions.hasMoreElements()) {
                            this.fullDescription = this.fullDescription + ", " + extensions.nextElement();
                        }
                    }
                    this.fullDescription = this.fullDescription + ")";
                } else {
                    this.fullDescription = this.description;
                }
            }
            return this.fullDescription;
        }

        public void setDescription(String description) {
            this.description = description;
            this.fullDescription = null;
        }

        public void setExtensionListInDescription(boolean b) {
            this.useExtensionsInDescription = b;
            this.fullDescription = null;
        }

        public boolean isExtensionListInDescription() {
            return this.useExtensionsInDescription;
        }
    }
}

