/*
 * Decompiled with CFR 0.152.
 */
package atkpanel;

import atkpanel.ImagePanel;
import atkpanel.SpectrumPanel;
import atkpanel.StringImagePanel;
import atkpanel.StringSpectrumPanel;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringSpectrum;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class RefresherUtil {
    public static void activateRefresh(Component comp) {
        JPanel imgComp;
        if (comp instanceof ImagePanel) {
            imgComp = (ImagePanel)comp;
            ((ImagePanel)imgComp).getModel().setSkippingRefresh(false);
        }
        if (comp instanceof SpectrumPanel) {
            imgComp = (SpectrumPanel)comp;
            ((SpectrumPanel)imgComp).getModel().setSkippingRefresh(false);
        }
        if (comp instanceof StringSpectrumPanel) {
            imgComp = (StringSpectrumPanel)comp;
            ((StringSpectrumPanel)imgComp).getModel().setSkippingRefresh(false);
        }
    }

    public static void refresh(Component comp) {
        if (comp instanceof ImagePanel) {
            ImagePanel imgComp = (ImagePanel)comp;
            INumberImage ini = imgComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)ini);
        }
        if (comp instanceof SpectrumPanel) {
            SpectrumPanel spectComp = (SpectrumPanel)comp;
            INumberSpectrum ins = spectComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)ins);
        }
        if (comp instanceof StringSpectrumPanel) {
            StringSpectrumPanel strSpectComp = (StringSpectrumPanel)comp;
            IStringSpectrum iss = strSpectComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)iss);
        }
        if (comp instanceof StringImagePanel) {
            StringImagePanel strImageComp = (StringImagePanel)comp;
            IStringImage isi = strImageComp.getModel();
            RefresherUtil.refreshIfNeeded((IAttribute)isi);
        }
    }

    public static void skippingRefresh(Component comp) {
        JPanel imgComp;
        if (comp instanceof ImagePanel) {
            imgComp = (ImagePanel)comp;
            ((ImagePanel)imgComp).getModel().setSkippingRefresh(true);
        }
        if (comp instanceof SpectrumPanel) {
            imgComp = (SpectrumPanel)comp;
            ((SpectrumPanel)imgComp).getModel().setSkippingRefresh(true);
        }
        if (comp instanceof StringSpectrumPanel) {
            imgComp = (StringSpectrumPanel)comp;
            ((StringSpectrumPanel)imgComp).getModel().setSkippingRefresh(true);
        }
    }

    public static void activateRefreshForAllComponent(JTabbedPane jtabbedPane) {
        Component[] components = jtabbedPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            RefresherUtil.activateRefresh(components[i]);
        }
    }

    public static void skippingRefreshForAllComponent(JTabbedPane jtabbedPane) {
        Component[] components = jtabbedPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            RefresherUtil.skippingRefresh(components[i]);
        }
    }

    public static void refreshIfNeeded(IAttribute iatt) {
        if (!iatt.hasEvents()) {
            iatt.refresh();
        }
    }
}

