/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.PolledAttributeFactory;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

class PolledAttributeTableModel
extends AbstractTableModel {
    private AAttribute[] allAttributes = new AAttribute[0];
    private static final String[] colNames = new String[]{"Attribute name", "Listeners", "", "Polling count"};

    public PolledAttributeTableModel() {
        this.refresh();
    }

    public void refresh() {
        this.allAttributes = PolledAttributeFactory.getPolledInstance().getAttributes();
    }

    public AAttribute getAttribute(int n) {
        return this.allAttributes[n];
    }

    public int getRowCount() {
        return this.allAttributes.length;
    }

    public int getColumnCount() {
        return colNames.length;
    }

    public String getColumnName(int n) {
        return colNames[n];
    }

    public Class getColumnClass(int n) {
        if (n == 2) {
            return JButton.class;
        }
        return String.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.allAttributes[n].getName();
            }
            case 1: {
                return Integer.toString(this.allAttributes[n].getPropChanges().getListenerCount());
            }
            case 2: {
                return "";
            }
            case 3: {
                return Long.toString(this.allAttributes[n].getRefreshCount());
            }
        }
        return "";
    }
}

