/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class SimpleEnumScalarViewer
extends JAutoScrolledText
implements IEnumScalarListener,
IErrorListener {
    private IEnumScalar model = null;
    private String invalidText = "-----";
    private Color backgroundColor = ATKConstant.getColor4Quality("VALID");
    private boolean alarmEnabled = true;

    public SimpleEnumScalarViewer() {
        this.setOpaque(true);
    }

    public void setInvalidText(String string) {
        this.invalidText = string;
    }

    public String getInvalidText() {
        return this.invalidText;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setAlarmEnabled(boolean bl) {
        this.alarmEnabled = bl;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public IEnumScalar getModel() {
        return this.model;
    }

    public void setModel(IEnumScalar iEnumScalar) {
        this.clearModel();
        if (iEnumScalar != null) {
            this.model = iEnumScalar;
            this.model.addEnumScalarListener((IEnumScalarListener)this);
            this.model.refresh();
        }
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeEnumScalarListener((IEnumScalarListener)this);
            this.model = null;
        }
    }

    public void enumScalarChange(EnumScalarEvent enumScalarEvent) {
        String string = enumScalarEvent.getValue();
        if (string == null) {
            this.setText(this.invalidText);
            return;
        }
        String string2 = this.getText();
        if (!string.equals(string2)) {
            this.setText(string);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        String string = attributeStateEvent.getState();
        if (string.equals("INVALID")) {
            this.setText(this.invalidText);
        }
        if (!this.alarmEnabled) {
            return;
        }
        if (string.equals("VALID")) {
            this.setBackground(this.backgroundColor);
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(string));
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setText(this.invalidText);
        if (!this.alarmEnabled) {
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    public static void main(String[] stringArray) throws Exception {
        AttributeList attributeList = new AttributeList();
        SimpleEnumScalarViewer simpleEnumScalarViewer = new SimpleEnumScalarViewer();
        IEnumScalar iEnumScalar = (IEnumScalar)attributeList.add("jlp/test/1/Att_six");
        simpleEnumScalarViewer.setModel(iEnumScalar);
        simpleEnumScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
        simpleEnumScalarViewer.setBackgroundColor(Color.WHITE);
        simpleEnumScalarViewer.setForeground(Color.BLACK);
        simpleEnumScalarViewer.setFont(new Font("Dialog", 1, 30));
        simpleEnumScalarViewer.setAutoScroll(30);
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(simpleEnumScalarViewer);
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.startRefresher();
    }
}

