/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScalarInput
extends JPanel
implements ActionListener {
    private String textButton = "Write";
    private boolean buttonEnabled = true;
    private boolean valueEditable = true;
    private Color backgroundButton = Color.GRAY;
    private Color backgroundField = Color.WHITE;
    private IAttribute scalarModel = null;
    private JTextField attributeTextField = new JTextField();
    private JButton writeButton = new JButton();

    public ScalarInput() {
        this.attributeTextField.setPreferredSize(new Dimension(100, 20));
        this.attributeTextField.setEditable(this.valueEditable);
        this.attributeTextField.setBackground(this.backgroundField);
        this.attributeTextField.addActionListener(this);
        this.add((Component)this.attributeTextField, "West");
        this.writeButton.setText(this.textButton);
        this.writeButton.setEnabled(this.buttonEnabled);
        this.writeButton.setBackground(this.backgroundButton);
        this.writeButton.addActionListener(this);
        this.add((Component)this.writeButton, "East");
    }

    public IAttribute getScalarModel() {
        return this.scalarModel;
    }

    public void setScalarModel(IAttribute iAttribute) {
        this.scalarModel = iAttribute;
        if (iAttribute == null) {
            return;
        }
        if (!iAttribute.isWritable()) {
            this.setValueEditable(false);
            this.setButtonEnabled(false);
        }
    }

    public void clearModel() {
        this.scalarModel = null;
        this.textButton = "Write";
        this.attributeTextField.setText("");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.scalarModel == null || actionEvent.getSource() instanceof JTextField) {
            return;
        }
        try {
            if (this.scalarModel instanceof INumberScalar) {
                ((INumberScalar)this.scalarModel).setValue(this.getValue());
            } else if (this.scalarModel instanceof IStringScalar) {
                ((IStringScalar)this.scalarModel).setValue(this.attributeTextField.getText());
            } else if (this.scalarModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.scalarModel).setValue(Boolean.getBoolean(this.attributeTextField.getText()));
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Cannot write attribute because " + exception.getMessage());
        }
    }

    private double getValue() {
        String string = this.attributeTextField.getText();
        if (string.equals("")) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public boolean isButtonEnabled() {
        return this.buttonEnabled;
    }

    public void setButtonEnabled(boolean bl) {
        this.buttonEnabled = bl;
        this.writeButton.setEnabled(bl);
    }

    public String getTextButton() {
        return this.textButton;
    }

    public void setTextButton(String string) {
        this.textButton = string;
        this.writeButton.setText(string);
    }

    public boolean isValueEditable() {
        return this.valueEditable;
    }

    public void setValueEditable(boolean bl) {
        this.valueEditable = bl;
        this.attributeTextField.setEditable(bl);
    }

    public Color getBackgroundButton() {
        return this.backgroundButton;
    }

    public void setBackgroundButton(Color color) {
        if (color == null) {
            return;
        }
        this.backgroundButton = color;
        this.writeButton.setBackground(color);
    }

    public Color getBackgroundField() {
        return this.backgroundField;
    }

    public void setBackgroundField(Color color) {
        if (color == null) {
            return;
        }
        this.backgroundField = color;
        this.attributeTextField.setBackground(color);
    }

    public void setFont(Font font) {
        if (font == null || this.writeButton == null || this.attributeTextField == null) {
            return;
        }
        this.writeButton.setFont(font);
        this.attributeTextField.setFont(font);
        super.setFont(font);
    }

    public void setNumberValue(double d) {
        if (!this.attributeTextField.hasFocus()) {
            this.attributeTextField.setText(Double.toString(d));
        }
    }

    public void setStringValue(String string) {
        if (!this.attributeTextField.hasFocus()) {
            this.attributeTextField.setText(string);
        }
    }

    public void setBooleanValue(boolean bl) {
        if (!this.attributeTextField.hasFocus()) {
            this.attributeTextField.setText(Boolean.toString(bl));
        }
    }

    public void writeNumberValue(double d) {
        this.attributeTextField.setText(Double.toString(d));
        if (this.scalarModel != null && this.scalarModel.isWritable() && this.scalarModel instanceof INumberScalar) {
            ((INumberScalar)this.scalarModel).setValue(d);
        }
    }

    public void writeStringValue(String string) {
        this.attributeTextField.setText(string);
        if (this.scalarModel != null && this.scalarModel.isWritable() && this.scalarModel instanceof IStringScalar) {
            try {
                ((IStringScalar)this.scalarModel).setValue(string);
            }
            catch (AttributeSetException attributeSetException) {
                attributeSetException.printStackTrace();
            }
        }
    }

    public String getText() {
        return this.attributeTextField.getText();
    }

    public void writeBooleanValue(boolean bl) {
        this.attributeTextField.setText(Boolean.toString(bl));
        if (this.scalarModel != null && this.scalarModel.isWritable() && this.scalarModel instanceof IBooleanScalar) {
            ((IBooleanScalar)this.scalarModel).setValue(bl);
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        ScalarInput scalarInput = new ScalarInput();
        try {
            if (stringArray.length != 0) {
                scalarInput.setScalarModel((IAttribute)attributeList.add(stringArray[0]));
            } else {
                scalarInput.setScalarModel((IAttribute)attributeList.add("LT1/AE/CH.1/current"));
            }
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(scalarInput);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

