/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class NumberScalarProgressBar
extends JProgressBar
implements INumberScalarListener {
    protected INumberScalar nsModel = null;
    protected int min = -1;
    protected int max = -1;
    protected boolean printVal = true;
    protected String nsDispFormat = null;
    private static final String ERROR = "Error";

    public NumberScalarProgressBar() {
        this.setStringPainted(true);
        this.setIndeterminate(true);
    }

    public INumberScalar getNsModel() {
        return this.nsModel;
    }

    public void setNsModel(INumberScalar iNumberScalar) {
        if (this.nsModel != null) {
            this.nsModel.removeNumberScalarListener((INumberScalarListener)this);
            this.nsModel = null;
        }
        this.progressString = null;
        this.setIndeterminate(true);
        this.nsDispFormat = null;
        if (iNumberScalar == null) {
            return;
        }
        this.nsModel = iNumberScalar;
        if (this.nsModel instanceof NumberScalar) {
            NumberScalar numberScalar = (NumberScalar)this.nsModel;
            double d = numberScalar.getNumberScalarValue();
            if (this.min == -1 && this.max == -1) {
                double d2 = numberScalar.getMinValue();
                double d3 = numberScalar.getMaxValue();
                this.min = (int)d2;
                this.max = (int)d3;
            }
            if (this.min == this.max && this.min < 0) {
                this.min = -1;
                this.max = -1;
            } else {
                this.setMinimum(this.min);
                this.setMaximum(this.max);
            }
            this.nsDispFormat = this.nsModel.getProperty("format").getPresentation();
            int n = (int)d;
            this.setValue(n);
            this.setIndeterminate(false);
            if (this.printVal) {
                this.progressString = this.getDisplayString(d);
                this.setToolTipText(this.getString());
            } else if (Double.isNaN(this.getPercentComplete())) {
                this.progressString = ERROR;
                this.setToolTipText("Min: " + this.getMinimum() + ", Max: " + this.getMaximum() + ", Value: " + n);
            } else {
                this.setToolTipText(this.getString());
            }
        }
        this.nsModel.addNumberScalarListener((INumberScalarListener)this);
        this.repaint();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int n) {
        this.min = n;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public boolean getPrintVal() {
        return this.printVal;
    }

    public void setPrintVal(boolean bl) {
        this.printVal = bl;
        if (!this.printVal) {
            this.progressString = null;
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = numberScalarEvent.getValue();
        int n = (int)Math.rint(d);
        this.setValue(n);
        if (this.printVal) {
            this.progressString = this.getDisplayString(d);
            this.setToolTipText(this.getString());
        } else if (Double.isNaN(this.getPercentComplete())) {
            this.progressString = ERROR;
            this.setToolTipText("Min: " + this.getMinimum() + ", Max: " + this.getMaximum() + ", Value: " + numberScalarEvent.getValue());
        } else {
            this.setToolTipText(this.getString());
        }
        this.repaint();
    }

    protected String getDisplayString(double d) {
        Double d2 = new Double(d);
        Object[] objectArray = new Object[]{d2};
        try {
            if (this.nsDispFormat == null) {
                String string = Format.sprintf((String)"%3.0f", (Object[])objectArray);
                return string;
            }
            if (this.nsDispFormat.equalsIgnoreCase("Not Specified")) {
                String string = Format.sprintf((String)"%3.0f", (Object[])objectArray);
                return string;
            }
            if (this.nsDispFormat.indexOf(37) < 0) {
                String string = Format.sprintf((String)"%3.0f", (Object[])objectArray);
                return string;
            }
            String string = Format.sprintf((String)this.nsDispFormat, (Object[])objectArray);
            return string;
        }
        catch (Exception exception) {
            return "Exception while formating";
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        NumberScalarProgressBar numberScalarProgressBar = new NumberScalarProgressBar();
        String string = "elin/gun/aux/Temporization";
        INumberScalar iNumberScalar = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (stringArray.length == 3) {
            numberScalarProgressBar.setPrintVal(false);
            numberScalarProgressBar.setMin(Integer.parseInt(stringArray[1]));
            numberScalarProgressBar.setMax(Integer.parseInt(stringArray[2]));
        } else {
            numberScalarProgressBar.setPrintVal(true);
        }
        try {
            iNumberScalar = (INumberScalar)attributeList.add(string);
            numberScalarProgressBar.setNsModel(iNumberScalar);
            attributeList.startRefresher();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        JFrame jFrame = iNumberScalar != null ? new JFrame(iNumberScalar.getName()) : new JFrame(ERROR);
        jFrame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jFrame.getContentPane().add((Component)numberScalarProgressBar, gridBagConstraints);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public String toString() {
        return "{NumberScalarProgressBar}";
    }
}

