static const char *RcsId = "$Id: except.cpp,v 3.8 2007/06/06 09:37:58 jensmeyer Exp $\n$Name:  $";

//+=============================================================================
//
// file :               except.cpp
//
// description :        C++ source for all the utilities used by Tango device
//			server and mainly for the Tango class
//
// project :            TANGO
//
// author(s) :          A.Gotz + E.Taurel
//
// $Revision: 3.8 $
//
// $Log: except.cpp,v $
// Revision 3.8  2007/06/06 09:37:58  jensmeyer
// Added null pointer check for all corba system exceptions.
//
// Revision 3.7  2007/04/20 14:41:33  taurel
// - Ported to Windows 64 bits x64 architecture
//
// Revision 3.6  2007/04/16 14:57:42  taurel
// - Added 3 new attributes data types (DevULong, DevULong64 and DevState)
// - Ported to omniORB4.1
// - Increased the MAX_TRANSFER_SIZE to 256 MBytes
// - Added a new filterable field in the archive event
//
// Revision 3.5  2007/03/02 09:49:06  jensmeyer
// Added the method compare_exception() to find out whether to DevFailed
// exceptions are equal or different.
//
// Revision 3.4  2006/05/18 07:57:19  taurel
// - Updated to gcc 4 (minor changes)
// - With the change done by SourceForge on their CVS servers, previous release
// of these files has disappeared from CVS !!
//
// Revision 3.4  2006/05/08 07:16:08  taurel
// - Small changes for GCC 4
//
// Revision 3.3  2004/07/07 08:40:11  taurel
//
// - Fisrt commit after merge between Trunk and release 4 branch
// - Add EventData copy ctor, asiignement operator and dtor
// - Add Database and DeviceProxy::get_alias() method
// - Add AttributeProxy ctor from "device_alias/attribute_name"
// - Exception thrown when subscribing two times for exactly yhe same event
//
// Revision 3.2  2003/08/21 07:23:46  taurel
// - End of the implementation of the new way to transfer data for read and
//   write attributes (better use of exception)
// - Added Attribute::set_date() and Attribute::set_value_date_quality() methods
// - Added DeviceAttribute ctors from "const char *"
// - Enable writing of spectrum and image attributes
// - Many new DeviceAttribute ctors/inserters to enable easy image and spectrums
//   attribute writing
// - Attribute date automatically set in case of attribute quality factor set to INVALID
// - Change in the polling thread discarding element algo. to support case of polling
//   several cmd/atts at the same polling period with cmd/attr having a long response time
// - Take cmd/attr execution time into account in the "Data not updated since" polling
//   status string
// - Split "str().c_str()" code in two lines of code. It was the reason of some problem
//   on Windows device server
// - Add the possibility to set a cmd/attr polling as "externally triggered". Add method
//   to send trigger to the polling thread
//
// Revision 3.1.2.3  2004/04/07 11:22:10  taurel
// - Add some import/export declaration for Windows DLL
// - Add test on minor code for the CORBA::IMP_LIMIT exception before
//   printing it
//
// Revision 3.1.2.2  2004/03/09 16:36:36  taurel
// - Added HP aCC port (thanks to Claudio from Elettra)
// - Some last small bugs fixes
//
// Revision 3.1.2.1  2003/09/30 11:50:43  taurel
// Add some changes foreseen for release 4.1 and already implemented on
// the trunck into this release 4.0 branch
//
// Revision 3.1  2003/05/28 14:55:09  taurel
// Add the include (conditionally) of the include files generated by autoconf
//
// Revision 3.0  2003/03/25 16:43:12  taurel
// Many changes for Tango release 3.0 including
// - Added full logging features
// - Added asynchronous calls
// - Host name of clients now stored in black-box
// - Three serialization model in DS
// - Fix miscellaneous bugs
// - Ported to gcc 3.2
// - Added ApiUtil::cleanup() and destructor methods
// - Some internal cleanups
// - Change the way how TangoMonitor class is implemented. It's a recursive
//   mutex
//
// Revision 2.9  2003/01/09 12:03:16  taurel
// - Ported to gcc 3.2
// - Added ApiUtil::cleanup() and ApiUtil::~ApiUtil() methods
// - Replace some ORB * by ORB_ptr
// - Use CORBA::ORB::is_nil() instead of comparing to NULL
//
// Revision 2.8  2002/12/16 12:07:19  taurel
// No change in code at all but only forgot th emost important line in
// list of updates in the previous release :
// - Change underlying ORB from ORBacus to omniORB
//
// Revision 2.7  2002/12/16 10:16:22  taurel
// - New method get_device_list() in Util class
// - Util::get_class_list takes DServer device into account
// - Util::get_device_by_name() takes DServer device into account
// - Util::get_device_list_by_class() takes DServer device into account
// - New parameter to the attribute::set_value() method to enable CORBA to free
// memory allocated for the attribute
//
// Revision 2.6  2002/10/17 07:43:06  taurel
// Fix bug in history stored by the polling thread :
// - We need one copy of the attribute data to build an history!!! It is true
// also for command which return data created by the DeviceImpl::create_xxx
// methods. Chnage in pollring.cpp/pollring.h/dserverpoll.cpp/pollobj.cpp
// and pollobj.h
//
// Revision 2.5  2002/10/15 11:27:19  taurel
// Fix bugs in device.cpp file :
// - Protect the state and status CORBA attribute with the device monitor
// Add the "TgLibVers" string as a #define in tango_config.h
//
// Revision 2.4  2002/08/12 15:06:54  taurel
// Several big fixes and changes
//   - Remove HP-UX specific code
//   - Fix bug in polling alogorithm which cause the thread to enter an infinite
//     loop (pollthread.cpp)
//   - For bug for Win32 device when trying to set attribute config
//     (attribute.cpp)
//
// Revision 2.3  2002/07/02 15:22:24  taurel
// Miscellaneous small changes/bug fixes for Tango CPP release 2.1.0
//     - classes reference documentation now generated using doxygen instead of doc++
//     - A little file added to the library which summarizes version number.
//       The RCS/CVS "ident" command will now tells you that release library x.y.z is composed
//       by C++ client classes set release a.b and C++ server classes set release c.d
//     - Fix incorrect field setting for DevFailed exception re-thrown from a CORBA exception
//     - It's now not possible to poll the Init command
//     - It's now possible to define a default class doc. per control system
//       instance (using property)
//     - The test done to check if attribute value has been set before it is
//       returned to caller is done only if the attribute quality is set to VALID
//     - The JTCInitialize object is now stored in the Util
//     - Windows specific : The tango.h file now also include winsock.h
//
// Revision 2.2  2002/04/30 10:50:41  taurel
// Don't check alarm on attribute if attribute quality factor is INVALID
//
// Revision 2.1  2002/04/29 12:24:04  taurel
// Fix bug in attribute::set_value method and on the check against min and max value when writing attributes
//
// Revision 2.0  2002/04/09 14:45:10  taurel
// See Tango WEB pages for list of changes
//
// Revision 1.6  2001/10/08 09:03:13  taurel
// See tango WEB pages for list of changes
//
// Revision 1.5  2001/07/04 12:27:11  taurel
// New methods re_throw_exception(). Read_attributes supports AllAttr mnemonic A new add_attribute()method in DeviceImpl class New way to define attribute properties New pattern to prevent full re-compile For multi-classes DS, it is now possible to use the Util::get_device_by_name() method in device constructor Adding << operator ovebloading Fix devie CORBA ref. number when device constructor sends an excep.
//
// Revision 1.4  2001/05/04 09:28:14  taurel
// Fix bugs in DServer::restart() method and in Util::get_device_by_name() method
//
// Revision 1.3  2001/03/30 08:03:45  taurel
// Fix bugs in attributes. For linux, add signal_handler in its own thread, change the way to kill server. For all system, change DevRestart philosophy.
//
// Revision 1.2  2001/03/09 08:20:16  taurel
// Fix bug in the MultiClassAttribute::init_class_attribute() method. Also remove the DbErr_DeviceNotDefined define.
//
// Revision 1.1.1.1  2001/02/27 08:46:21  taurel
// Imported sources
//
// Revision 1.3  2000/04/13 10:40:43  taurel
// Added attribute support
//
// Revision 1.2  2000/02/04 11:00:16  taurel
// Just update revision number
//
// Revision 1.1.1.1  2000/02/04 10:58:28  taurel
// Imported sources
//
//
// copyleft :           European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
//-=============================================================================

#if HAVE_CONFIG_H
#include <ac_config.h>
#endif

#if __GNUC__ >= 3
	#if __GNUC__ == 3
		#if __GNUC_MINOR__ >= 2
			#define GCC_STD
		#endif
	#else
		#define GCC_STD
	#endif
#endif

#include <tango_config.h>
#include <except.h>
#include <apiexcept.h>

#if ((defined _TG_WINDOWS_) || (defined __SUNPRO_CC) || (defined GCC_STD))
	#include <iostream>
	#include <sstream>
	#include <fstream>
#else
	#include <iostream.h>
	#include <strstream.h>
#endif

namespace Tango
{

char Except::mess[256];

//+----------------------------------------------------------------------------
//
// method : 		print_exception
// 
// description : 	This method prints the information embedded in
//			a Tango exception.
//
// in :			e : Reference to the exception object
//
//-----------------------------------------------------------------------------

void Except::print_exception(const CORBA::Exception &e)
{

	const CORBA::SystemException *se;
	const CORBA::UserException *ue;

//
// For a CORBA::SystemException, use the OB function
//

	if ((se = dynamic_cast<const CORBA::SystemException *>(&e)) != NULL)
	{
		cerr << print_CORBA_SystemException(se) << endl;
	}

//	
// If it is a CORBA::UserException
//

	else if ((ue = dynamic_cast<const CORBA::UserException *>(&e)) != NULL)
	{
		const Tango::DevFailed *te;
		const Tango::NamedDevFailedList *mdf;

//				
// Print the Tango::NamedDevFailedList exception contents
//

		if ((mdf = dynamic_cast<const Tango::NamedDevFailedList *>(&e)) != NULL)
		{
			cerr << "Tango NamedDevFailedList exception" << endl;
			for (unsigned long i = 0;i < mdf->err_list.size();i++)
			{
				cerr << "   Exception for object " << mdf->err_list[i].name << endl;
				cerr << "   Index of object in call (starting at 0) = " << mdf->err_list[i].idx_in_call << endl;
				for (unsigned long j =0;j < mdf->err_list[i].err_stack.length();j++)
				{
					cerr << "       Severity = ";
					switch (mdf->err_list[i].err_stack[j].severity)
					{
						case Tango::WARN :
							cerr << "WARNING ";
							break;
						
						case Tango::ERR :
							cerr << "ERROR ";
							break;
					
						case Tango::PANIC :
							cerr << "PANIC ";
							break;
						
						default :
							cerr << "Unknown severity code";
							break;
					}
					cerr << endl;
					cerr << "       Error reason = " << mdf->err_list[i].err_stack[j].reason.in() << endl;
					cerr << "       Desc : " << mdf->err_list[i].err_stack[j].desc.in() << endl;
					cerr << "       Origin : " << mdf->err_list[i].err_stack[j].origin.in() << endl;
				}
			}
			cerr << "   Summary exception" << endl;
			for (unsigned long j =0;j < mdf->errors.length();j++)
			{
				cerr << "       Severity = ";
				switch (mdf->errors[j].severity)
				{
					case Tango::WARN :
						cerr << "WARNING ";
						break;
						
					case Tango::ERR :
						cerr << "ERROR ";
						break;
					
					case Tango::PANIC :
						cerr << "PANIC ";
						break;
						
					default :
						cerr << "Unknown severity code";
						break;
				}
				cerr << endl;
				cerr << "       Error reason = " << mdf->errors[j].reason.in() << endl;
				cerr << "       Desc : " << mdf->errors[j].desc.in() << endl;
				cerr << "       Origin : " << mdf->errors[j].origin.in() << endl;
				cerr << endl;
			}
			
		}
		
//				
// Print the Tango::DevFailed exception contents
//

		else if ((te = dynamic_cast<const Tango::DevFailed *>(&e)) != NULL)
		{
			for (unsigned long i =0;i < te->errors.length();i++)
			{
				cerr << "Tango exception" << endl;
				cerr << "Severity = ";
				switch (te->errors[i].severity)
				{
					case Tango::WARN :
						cerr << "WARNING ";
						break;
						
					case Tango::ERR :
						cerr << "ERROR ";
						break;
					
					case Tango::PANIC :
						cerr << "PANIC ";
						break;
						
					default :
						cerr << "Unknown severity code";
						break;
				}
				cerr << endl;
				cerr << "Error reason = " << te->errors[i].reason.in() << endl;
				cerr << "Desc : " << te->errors[i].desc.in() << endl;
				cerr << "Origin : " << te->errors[i].origin.in() << endl;
				cerr << endl;
			}
		}

//		
// For an unknown CORBA::UserException
//

		else
		{
			cerr << "Unknown CORBA user exception" << endl;
		}
	}

//	
// For an unknown exception type
//

	else
	{
		cerr << "Unknown exception type !!!!!!" << endl;
	}

}

//+----------------------------------------------------------------------------
//
// method : 		print_CORBA_SystemException
// 
// description : 	This method prints the information embedded in
//			a CORBA system exception.
//
// in :			e : Pointer to the exception object
//
//-----------------------------------------------------------------------------

char *Except::print_CORBA_SystemException(const CORBA::SystemException *e)
{
	const CORBA::UNKNOWN *unk;
	const CORBA::BAD_PARAM *bad;
	const CORBA::NO_MEMORY *mem;
	const CORBA::IMP_LIMIT *lim;
	const CORBA::COMM_FAILURE *comm;
	const CORBA::INV_OBJREF *inv;
	const CORBA::NO_PERMISSION *perm;
	const CORBA::INTERNAL *inter;
	const CORBA::MARSHAL *mar;
	const CORBA::INITIALIZE *ini;
	const CORBA::NO_IMPLEMENT *impl;
	const CORBA::BAD_TYPECODE *type;
	const CORBA::BAD_OPERATION *op;
	const CORBA::NO_RESOURCES *res;
	const CORBA::NO_RESPONSE *resp;
	const CORBA::BAD_INV_ORDER *inv_ord;
	const CORBA::TRANSIENT *tra;
	const CORBA::OBJ_ADAPTER *adap;
	const CORBA::OBJECT_NOT_EXIST *not_ex;
	const CORBA::INV_POLICY *pol;

//
// It seems that omniORB for Win32 is not compiled with the RTTI enabled
// (/GR option). We can't use dynamic_casting here.
// We are using CORBA _downcast() method !!!
//

	if ((unk = CORBA::UNKNOWN::_downcast(e)) != 0)
	{
		::strcpy(mess,"UNKNOWN CORBA system exception");
	}
	else if ((bad = CORBA::BAD_PARAM::_downcast(e)) != 0)
	{
		::strcpy(mess,"BAD_PARAM CORBA system exception: ");
		const char *err_msg = bad->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);
	}
	else if ((mem = CORBA::NO_MEMORY::_downcast(e)) != 0)
	{
		::strcpy(mess,"NO_MEMORY CORBA system exception: ");
		const char *err_msg = mem->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);
	}
	else if ((lim = CORBA::IMP_LIMIT::_downcast(e)) != 0)
	{
		::strcpy(mess,"IMP_LIMIT CORBA system exception: ");
		const char *tmp = lim->NP_minorString();
		if (tmp == NULL)
		{
			::strcat(mess,"Unknown minor code: ");
			TangoSys_MemStream st;
			st << hex << lim->minor() << dec << ends;
#if ((defined _TG_WINDOWS_) || (defined __SUNPRO_CC) || (defined GCC_STD))
			string s = st.str();
			::strcat(mess,s.c_str());
#else
			::strcat(mess,st.str());
#endif
		}
		else
			::strcat(mess,tmp);
	}
	else if ((comm = CORBA::COMM_FAILURE::_downcast(e)) != NULL)
	{
		::strcpy(mess,"COMM_FAILURE CORBA system exception: ");
		const char *tmp = comm->NP_minorString();
		if (tmp == NULL)
		{
			::strcat(mess,"Unknown minor code: ");
			TangoSys_MemStream st;
			st << hex << comm->minor() << dec << ends;

#if ((defined _TG_WINDOWS_) || (defined __SUNPRO_CC) || (defined GCC_STD))
			string s = st.str();
			::strcat(mess,s.c_str());
#else
			::strcat(mess,st.str());
#endif
		}
		else
			::strcat(mess,tmp);
	}
	else if ((inv = CORBA::INV_OBJREF::_downcast(e)) != NULL)
	{
		::strcpy(mess,"INV_OBJREF CORBA system exception: ");
		const char *err_msg = inv->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((perm = CORBA::NO_PERMISSION::_downcast(e)) != NULL)
	{
		::strcpy(mess,"NO_PERMISSION CORBA system exception: ");
		const char *err_msg = perm->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((inter = CORBA::INTERNAL::_downcast(e)) != NULL)
	{
		::strcpy(mess,"INTERNAL CORBA system exception: ");
		const char *err_msg = inter->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((mar = CORBA::MARSHAL::_downcast(e)) != NULL)
	{
		::strcpy(mess,"MARSHAL CORBA system exception: ");
		const char *err_msg = mar->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((ini = CORBA::INITIALIZE::_downcast(e)) != NULL)
	{
		::strcpy(mess,"INITIALIZE CORBA system exception: ");
		const char *err_msg = ini->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((impl = CORBA::NO_IMPLEMENT::_downcast(e)) != NULL)
	{
		::strcpy(mess,"NO_IMPLEMENT CORBA system exception: ");
		const char *err_msg = impl->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);
	}
	else if ((type = CORBA::BAD_TYPECODE::_downcast(e)) != NULL)
	{
		::strcpy(mess,"BAD_TYPECODE CORBA system exception: ");
		const char *err_msg = type->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((op = CORBA::BAD_OPERATION::_downcast(e)) != NULL)
	{
		::strcpy(mess,"BAD_OPERATION CORBA system exception: ");
		const char *err_msg = op->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((res = CORBA::NO_RESOURCES::_downcast(e)) != NULL)
	{
		::strcpy(mess,"NO_RESOURCES CORBA system exception: ");
		const char *err_msg = res->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((resp = CORBA::NO_RESPONSE::_downcast(e)) != NULL)
	{
		::strcpy(mess,"NO_RESPONSE CORBA system exception: ");
		const char *err_msg = resp->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);
	}
	else if ((inv_ord = CORBA::BAD_INV_ORDER::_downcast(e)) != NULL)
	{
		::strcpy(mess,"BAD_INV_ORDER CORBA system exception: ");
		const char *err_msg = inv_ord->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);
	}
	else if ((tra = CORBA::TRANSIENT::_downcast(e)) != NULL)
	{
		::strcpy(mess,"TRANSIENT CORBA system exception: ");
		const char *tmp = tra->NP_minorString();
		if (tmp == NULL)
		{
			::strcat(mess,"Unknown minor code: ");
			TangoSys_MemStream st;
			st << hex << tra->minor() << dec << ends;
#if ((defined _TG_WINDOWS_) || (defined __SUNPRO_CC) || (defined GCC_STD))
			string s = st.str();
			::strcat(mess,s.c_str());
#else
			::strcat(mess,st.str());
#endif
		}
		else
			::strcat(mess,tmp);
	}
	else if ((adap = CORBA::OBJ_ADAPTER::_downcast(e)) != NULL)
	{
		::strcpy(mess,"OBJ_ADAPTER CORBA system exception: ");
		const char *err_msg = adap->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((not_ex = CORBA::OBJECT_NOT_EXIST::_downcast(e)) != NULL)
	{
		::strcpy(mess,"OBJECT_NOT_EXIST CORBA system exception: ");
		const char *err_msg = not_ex->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);		
	}
	else if ((pol = CORBA::INV_POLICY::_downcast(e)) != NULL)
	{
		::strcpy(mess,"INV_POLICY CORBA system exception: ");
		const char *err_msg = pol->NP_minorString();
		if ( err_msg == NULL )
			::strcat(mess,"ORB has returned NULL pointer !");
		else
			::strcat(mess,err_msg);
	}	
	else
		::strcpy(mess,"CORBA unknown system exception !!!!!!!!");
	
	return mess;
}

//+----------------------------------------------------------------------------
//
// method : 		print_error_stack
// 
// description : 	This method prints the a Tango error stack 
//
// in :			e : Reference to the error stack
//
//-----------------------------------------------------------------------------

void Except::print_error_stack(const Tango::DevErrorList &e)
{

	for (unsigned long i = 0;i < e.length();i++)
	{
		cerr << "Tango error stack" << endl;
		cerr << "Severity = ";
		switch (e[i].severity)
		{
			case Tango::WARN :
				cerr << "WARNING ";
				break;
						
			case Tango::ERR :
				cerr << "ERROR ";
				break;
					
			case Tango::PANIC :
				cerr << "PANIC ";
				break;
						
			default :
				cerr << "Unknown severity code";
				break;
		}
		cerr << endl;
		cerr << "Error reason = " << e[i].reason.in() << endl;
		cerr << "Desc : " << e[i].desc.in() << endl;
		cerr << "Origin : " << e[i].origin.in() << endl;
		cerr << endl;
	}
}

//+----------------------------------------------------------------------------
//
// method : 		throw_exception
// 
// description : 	These methods throws a Tango DevFailed exception from
//			a CORBA system exception.
//			Note that there is no CORBA::string_dup memory
//			for the reason field because it it is returned by
//			the print_CORBA_SystemException which in turn is
//			using an OB method (_OB_defaultToString) which
//			internally used a CORBA::String_var and its method
//			_retn() to return the string. Therefore, its
//			memory is allocated using CORBA::string_alloc.
//
// in :			e : Pointer to the exception object
//
//-----------------------------------------------------------------------------

void Except::throw_exception(const CORBA::SystemException &c_ex,const char *origin)
{
	Tango::DevErrorList errors(1);
	
	errors.length(1);
	errors[0].severity = Tango::ERR;
	errors[0].origin = CORBA::string_dup(origin);
	errors[0].reason = CORBA::string_dup("API_CorbaSysException");
	errors[0].desc = print_CORBA_SystemException(&c_ex);
	
	throw Tango::DevFailed(errors);
}

void Except::throw_exception(const CORBA::SystemException &c_ex,char *origin)
{
	Tango::DevErrorList errors(1);
	
	errors.length(1);
	errors[0].severity = Tango::ERR;
	errors[0].origin = CORBA::string_dup(origin);
	delete [] origin;
	errors[0].reason = CORBA::string_dup("API_CorbaSysException");
	errors[0].desc = print_CORBA_SystemException(&c_ex);
	
	throw Tango::DevFailed(errors);
}

void Except::throw_exception(const CORBA::SystemException &c_ex,const string &origin)
{
	Tango::DevErrorList errors(1);
	
	errors.length(1);
	errors[0].severity = Tango::ERR;
	errors[0].origin = CORBA::string_dup(origin.c_str());
	errors[0].reason = CORBA::string_dup("API_CorbaSysException");
	errors[0].desc = print_CORBA_SystemException(&c_ex);
	
	throw Tango::DevFailed(errors);
}

//+----------------------------------------------------------------------------
//
// method : 		Compare two Tango DevFailed exceptions for equality
// 
// description : 	The two DevFailed exceptions are verified by comparing the
// reason, origin, description and severity of all exceptions in the error stack.
// The strings reason, origin and description are compared literally.
//
// in :			ex1 The first DevFailed exception
//             ex1 The first DevFailed exception
//
// return:     a boolean set to true if the two exceptions are equal
//-----------------------------------------------------------------------------

bool Except::compare_exception(Tango::DevFailed &ex1, Tango::DevFailed &ex2)
{
	// check the length of the exception stack
	
	long nb_err = ex1.errors.length();
	if ( nb_err != ex2.errors.length() )
		{
		return false;
		}
	
	// check all exceptions in the stack
	
	for (long i=0; i<nb_err; i++)
		{
		// check the severity
		if ( ex1.errors[i].severity != ex2.errors[i].severity )
			{
			return false;
			}
			
		// check the origin
		string org1 = ex1.errors[i].origin.in();
		string org2 = ex2.errors[i].origin.in();
		if ( org1 != org2 )
			{
			return false;
			}
			
		// check the reason
		string re1 = ex1.errors[i].reason.in();
		string re2 = ex2.errors[i].reason.in();
		if ( re1 != re2 )
			{
			return false;
			}
		
		// check the description
		string desc1 = ex1.errors[i].desc.in();
		string desc2 = ex2.errors[i].desc.in();
		if ( desc1 != desc2 )
			{
			return false;
			}	
		}
	
	return true;
}

} // End of Tango namespace
