//=============================================================================
//
// file :         TangoTestClass.h
//
// description :  Include for the TangoTestClass  class.
//                This class is represents the singleton class for
//                the TangoTest device class.
//                It contains all properties and methods which the 
//                TangoTest requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author: jensmeyer $
//
// $Revision: 1.6 $
//
// $Log: TangoTestClass.h,v $
// Revision 1.6  2006/03/20 15:21:51  jensmeyer
// Added some castings for porting to VC8
//
// Revision 1.5  2006/02/08 16:14:28  nleclercq
// Minor modifs in RW spectrum and image attributes
//
//
// copyleft :     Synchrotron SOLEIL
//                L'Orme des Merisiers
//                Saint-Aubin - BP 48
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#ifndef _TANGOTESTCLASS_H
#define _TANGOTESTCLASS_H

#include <tango.h>
#include <TangoTest.h>


namespace TangoTest_ns
{
//=====================================
//	Define classes for attributes
//=====================================
class double_imageAttrib: public Tango::ImageAttr
{
public:
	double_imageAttrib():ImageAttr("double_image", Tango::DEV_DOUBLE, Tango::READ_WRITE, 251, 251) {};
	~double_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_double_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_image_allowed(ty);}
};

class float_imageAttrib: public Tango::ImageAttr
{
public:
	float_imageAttrib():ImageAttr("float_image", Tango::DEV_FLOAT, Tango::READ_WRITE, 251, 251) {};
	~float_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_float_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_float_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_float_image_allowed(ty);}
};

class long_imageAttrib: public Tango::ImageAttr
{
public:
	long_imageAttrib():ImageAttr("long_image", Tango::DEV_LONG, Tango::READ_WRITE, 251, 251) {};
	~long_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_long_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_image_allowed(ty);}
};

class ushort_imageAttrib: public Tango::ImageAttr
{
public:
	ushort_imageAttrib():ImageAttr("ushort_image", Tango::DEV_USHORT, Tango::READ_WRITE, 251, 251) {};
	~ushort_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_ushort_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_ushort_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_ushort_image_allowed(ty);}
};

class short_imageAttrib: public Tango::ImageAttr
{
public:
	short_imageAttrib():ImageAttr("short_image", Tango::DEV_SHORT, Tango::READ_WRITE, 251, 251) {};
	~short_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_short_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_image_allowed(ty);}
};

class uchar_imageAttrib: public Tango::ImageAttr
{
public:
	uchar_imageAttrib():ImageAttr("uchar_image", Tango::DEV_UCHAR, Tango::READ_WRITE, 251, 251) {};
	~uchar_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_uchar_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_uchar_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_uchar_image_allowed(ty);}
};

class boolean_imageAttrib: public Tango::ImageAttr
{
public:
	boolean_imageAttrib():ImageAttr("boolean_image", Tango::DEV_BOOLEAN, Tango::READ_WRITE, 251, 251) {};
	~boolean_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_boolean_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_boolean_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_boolean_image_allowed(ty);}
};

class ushort_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	ushort_spectrum_roAttrib():SpectrumAttr("ushort_spectrum_ro", Tango::DEV_USHORT, Tango::READ, 4096) {};
	~ushort_spectrum_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_ushort_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_ushort_spectrum_ro_allowed(ty);}
};

class uchar_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	uchar_spectrum_roAttrib():SpectrumAttr("uchar_spectrum_ro", Tango::DEV_UCHAR, Tango::READ, 4096) {};
	~uchar_spectrum_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_uchar_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_uchar_spectrum_ro_allowed(ty);}
};

class boolean_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	boolean_spectrum_roAttrib():SpectrumAttr("boolean_spectrum_ro", Tango::DEV_BOOLEAN, Tango::READ, 4096) {};
	~boolean_spectrum_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_boolean_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_boolean_spectrum_ro_allowed(ty);}
};

class double_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	double_spectrum_roAttrib():SpectrumAttr("double_spectrum_ro", Tango::DEV_DOUBLE, Tango::READ, 4096) {};
	~double_spectrum_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_spectrum_ro_allowed(ty);}
};

class long_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	long_spectrum_roAttrib():SpectrumAttr("long_spectrum_ro", Tango::DEV_LONG, Tango::READ, 4096) {};
	~long_spectrum_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_spectrum_ro_allowed(ty);}
};

class float_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	float_spectrum_roAttrib():SpectrumAttr("float_spectrum_ro", Tango::DEV_FLOAT, Tango::READ, 4096) {};
	~float_spectrum_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_float_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_float_spectrum_ro_allowed(ty);}
};

class short_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	short_spectrum_roAttrib():SpectrumAttr("short_spectrum_ro", Tango::DEV_SHORT, Tango::READ, 4096) {};
	~short_spectrum_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_spectrum_ro_allowed(ty);}
};

class waveAttrib: public Tango::SpectrumAttr
{
public:
	waveAttrib():SpectrumAttr("wave", Tango::DEV_DOUBLE, Tango::READ, 4096) {};
	~waveAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_wave(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_wave_allowed(ty);}
};

class ampliAttrib: public Tango::Attr
{
public:
	ampliAttrib():Attr("ampli", Tango::DEV_DOUBLE, Tango::WRITE) {};
	~ampliAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_ampli(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_ampli(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_ampli_allowed(ty);}
};

class boolean_image_roAttrib: public Tango::ImageAttr
{
public:
	boolean_image_roAttrib():ImageAttr("boolean_image_ro", Tango::DEV_BOOLEAN, Tango::READ, 251, 251) {};
	~boolean_image_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_boolean_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_boolean_image_ro_allowed(ty);}
};

class double_image_roAttrib: public Tango::ImageAttr
{
public:
	double_image_roAttrib():ImageAttr("double_image_ro", Tango::DEV_DOUBLE, Tango::READ, 251, 251) {};
	~double_image_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_image_ro_allowed(ty);}
};

class long_image_roAttrib: public Tango::ImageAttr
{
public:
	long_image_roAttrib():ImageAttr("long_image_ro", Tango::DEV_LONG, Tango::READ, 251, 251) {};
	~long_image_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_image_ro_allowed(ty);}
};

class short_image_roAttrib: public Tango::ImageAttr
{
public:
	short_image_roAttrib():ImageAttr("short_image_ro", Tango::DEV_SHORT, Tango::READ, 251, 251) {};
	~short_image_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_image_ro_allowed(ty);}
};

class float_image_roAttrib: public Tango::ImageAttr
{
public:
	float_image_roAttrib():ImageAttr("float_image_ro", Tango::DEV_FLOAT, Tango::READ, 251, 251) {};
	~float_image_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_float_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_float_image_ro_allowed(ty);}
};

class ushort_image_roAttrib: public Tango::ImageAttr
{
public:
	ushort_image_roAttrib():ImageAttr("ushort_image_ro", Tango::DEV_USHORT, Tango::READ, 251, 251) {};
	~ushort_image_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_ushort_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_ushort_image_ro_allowed(ty);}
};

class uchar_image_roAttrib: public Tango::ImageAttr
{
public:
	uchar_image_roAttrib():ImageAttr("uchar_image_ro", Tango::DEV_UCHAR, Tango::READ, 251, 251) {};
	~uchar_image_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_uchar_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_uchar_image_ro_allowed(ty);}
};

class float_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	float_spectrumAttrib():SpectrumAttr("float_spectrum", Tango::DEV_FLOAT, Tango::READ_WRITE, 4096) {};
	~float_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_float_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_float_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_float_spectrum_allowed(ty);}
};

class ushort_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	ushort_spectrumAttrib():SpectrumAttr("ushort_spectrum", Tango::DEV_USHORT, Tango::READ_WRITE, 4096) {};
	~ushort_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_ushort_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_ushort_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_ushort_spectrum_allowed(ty);}
};

class uchar_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	uchar_spectrumAttrib():SpectrumAttr("uchar_spectrum", Tango::DEV_UCHAR, Tango::READ_WRITE, 4096) {};
	~uchar_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_uchar_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_uchar_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_uchar_spectrum_allowed(ty);}
};

class boolean_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	boolean_spectrumAttrib():SpectrumAttr("boolean_spectrum", Tango::DEV_BOOLEAN, Tango::READ_WRITE, 4096) {};
	~boolean_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_boolean_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_boolean_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_boolean_spectrum_allowed(ty);}
};

class double_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	double_spectrumAttrib():SpectrumAttr("double_spectrum", Tango::DEV_DOUBLE, Tango::READ_WRITE, 4096) {};
	~double_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_double_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_spectrum_allowed(ty);}
};

class long_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	long_spectrumAttrib():SpectrumAttr("long_spectrum", Tango::DEV_LONG, Tango::READ_WRITE, 4096) {};
	~long_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_long_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_spectrum_allowed(ty);}
};

class short_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	short_spectrumAttrib():SpectrumAttr("short_spectrum", Tango::DEV_SHORT, Tango::READ_WRITE, 4096) {};
	~short_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_short_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_spectrum_allowed(ty);}
};

class ushort_scalarAttrib: public Tango::Attr
{
public:
	ushort_scalarAttrib():Attr("ushort_scalar", Tango::DEV_USHORT, Tango::READ_WRITE) {};
	~ushort_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_ushort_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_ushort_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_ushort_scalar_allowed(ty);}
};

class uchar_scalarAttrib: public Tango::Attr
{
public:
	uchar_scalarAttrib():Attr("uchar_scalar", Tango::DEV_UCHAR, Tango::READ_WRITE) {};
	~uchar_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_uchar_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_uchar_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_uchar_scalar_allowed(ty);}
};

class float_scalarAttrib: public Tango::Attr
{
public:
	float_scalarAttrib():Attr("float_scalar", Tango::DEV_FLOAT, Tango::READ_WRITE) {};
	~float_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_float_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_float_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_float_scalar_allowed(ty);}
};

class boolean_scalarAttrib: public Tango::Attr
{
public:
	boolean_scalarAttrib():Attr("boolean_scalar", Tango::DEV_BOOLEAN, Tango::READ_WRITE) {};
	~boolean_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_boolean_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_boolean_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_boolean_scalar_allowed(ty);}
};

class string_scalarAttrib: public Tango::Attr
{
public:
	string_scalarAttrib():Attr("string_scalar", Tango::DEV_STRING, Tango::READ_WRITE) {};
	~string_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_string_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_string_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_string_scalar_allowed(ty);}
};

class double_scalar_rwwAttrib: public Tango::Attr
{
public:
	double_scalar_rwwAttrib():Attr("double_scalar_rww", Tango::DEV_DOUBLE, Tango::READ_WITH_WRITE, "double_scalar_w") {};
	~double_scalar_rwwAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_scalar_rww_allowed(ty);}
};

class double_scalar_wAttrib: public Tango::Attr
{
public:
	double_scalar_wAttrib():Attr("double_scalar_w", Tango::DEV_DOUBLE, Tango::WRITE) {};
	~double_scalar_wAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_scalar_w(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_double_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_scalar_w_allowed(ty);}
};

class double_scalarAttrib: public Tango::Attr
{
public:
	double_scalarAttrib():Attr("double_scalar", Tango::DEV_DOUBLE, Tango::READ_WRITE) {};
	~double_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_double_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_scalar_allowed(ty);}
};

class long_scalar_rwwAttrib: public Tango::Attr
{
public:
	long_scalar_rwwAttrib():Attr("long_scalar_rww", Tango::DEV_LONG, Tango::READ_WITH_WRITE, "long_scalar_w") {};
	~long_scalar_rwwAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_scalar_rww_allowed(ty);}
};

class long_scalar_wAttrib: public Tango::Attr
{
public:
	long_scalar_wAttrib():Attr("long_scalar_w", Tango::DEV_LONG, Tango::WRITE) {};
	~long_scalar_wAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_scalar_w(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_long_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_scalar_w_allowed(ty);}
};

class long_scalarAttrib: public Tango::Attr
{
public:
	long_scalarAttrib():Attr("long_scalar", Tango::DEV_LONG, Tango::READ_WRITE) {};
	~long_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_long_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_scalar_allowed(ty);}
};

class short_scalar_rwwAttrib: public Tango::Attr
{
public:
	short_scalar_rwwAttrib():Attr("short_scalar_rww", Tango::DEV_SHORT, Tango::READ_WITH_WRITE, "short_scalar_w") {};
	~short_scalar_rwwAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_scalar_rww_allowed(ty);}
};

class short_scalar_wAttrib: public Tango::Attr
{
public:
	short_scalar_wAttrib():Attr("short_scalar_w", Tango::DEV_SHORT, Tango::WRITE) {};
	~short_scalar_wAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_scalar_w(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_short_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_scalar_w_allowed(ty);}
};

class short_scalarAttrib: public Tango::Attr
{
public:
	short_scalarAttrib():Attr("short_scalar", Tango::DEV_SHORT, Tango::READ_WRITE) {};
	~short_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_short_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_scalar_allowed(ty);}
};

class short_scalar_roAttrib: public Tango::Attr
{
public:
	short_scalar_roAttrib():Attr("short_scalar_ro", Tango::DEV_SHORT, Tango::READ) {};
	~short_scalar_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_scalar_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_scalar_ro_allowed(ty);}
};

//=========================================
//	Define classes for commands
//=========================================
class SwitchStatesClass : public Tango::Command
{
public:
	SwitchStatesClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	SwitchStatesClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~SwitchStatesClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_SwitchStates_allowed(any);}
};



class DevVarDoubleStringArrayCmd : public Tango::Command
{
public:
	DevVarDoubleStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarDoubleStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarDoubleStringArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarDoubleStringArray_allowed(any);}
};



class DevVarLongStringArrayCmd : public Tango::Command
{
public:
	DevVarLongStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarLongStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarLongStringArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarLongStringArray_allowed(any);}
};



class DevVarStringArrayCmd : public Tango::Command
{
public:
	DevVarStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarStringArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarStringArray_allowed(any);}
};



class DevVarDoubleArrayCmd : public Tango::Command
{
public:
	DevVarDoubleArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarDoubleArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarDoubleArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarDoubleArray_allowed(any);}
};



class DevVarFloatArrayCmd : public Tango::Command
{
public:
	DevVarFloatArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarFloatArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarFloatArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarFloatArray_allowed(any);}
};



class DevVarULongArrayCmd : public Tango::Command
{
public:
	DevVarULongArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarULongArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarULongArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarULongArray_allowed(any);}
};



class DevVarLongArrayCmd : public Tango::Command
{
public:
	DevVarLongArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarLongArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarLongArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarLongArray_allowed(any);}
};



class DevVarUShortArrayCmd : public Tango::Command
{
public:
	DevVarUShortArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarUShortArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarUShortArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarUShortArray_allowed(any);}
};



class DevVarShortArrayCmd : public Tango::Command
{
public:
	DevVarShortArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarShortArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarShortArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarShortArray_allowed(any);}
};



class DevVarCharArrayCmd : public Tango::Command
{
public:
	DevVarCharArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarCharArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarCharArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarCharArray_allowed(any);}
};



class DevStringCmd : public Tango::Command
{
public:
	DevStringCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevStringCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevStringCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevString_allowed(any);}
};



class DevDoubleCmd : public Tango::Command
{
public:
	DevDoubleCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevDoubleCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevDoubleCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevDouble_allowed(any);}
};



class DevFloatCmd : public Tango::Command
{
public:
	DevFloatCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevFloatCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevFloatCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevFloat_allowed(any);}
};



class DevULongCmd : public Tango::Command
{
public:
	DevULongCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevULongCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevULongCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevULong_allowed(any);}
};



class DevLongCmd : public Tango::Command
{
public:
	DevLongCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevLongCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevLongCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevLong_allowed(any);}
};



class DevUShortCmd : public Tango::Command
{
public:
	DevUShortCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevUShortCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevUShortCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevUShort_allowed(any);}
};



class DevShortCmd : public Tango::Command
{
public:
	DevShortCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevShortCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevShortCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevShort_allowed(any);}
};



class DevBooleanCmd : public Tango::Command
{
public:
	DevBooleanCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevBooleanCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevBooleanCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevBoolean_allowed(any);}
};



class DevVoidCmd : public Tango::Command
{
public:
	DevVoidCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVoidCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVoidCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVoid_allowed(any);}
};



//
// The TangoTestClass singleton definition
//

class TangoTestClass : public Tango::DeviceClass
{
public:
//	properties member data

//	add your own data members here
//------------------------------------

public:
	Tango::DbData	cl_prop;
	Tango::DbData	cl_def_prop;
	Tango::DbData	dev_def_prop;

//	Method prototypes
	static TangoTestClass *init(const char *);
	static TangoTestClass *instance();
	~TangoTestClass();
	Tango::DbDatum	get_class_property(string &);
	Tango::DbDatum	get_default_device_property(string &);
	Tango::DbDatum	get_default_class_property(string &);
	
protected:
	TangoTestClass(string &);
	static TangoTestClass *_instance;
	void command_factory();
	void get_class_property();
	void attribute_factory(vector<Tango::Attr *> &);
	void write_class_property();
	void set_default_property();

private:
	void device_factory(const Tango::DevVarStringArray *);
};


}	//	namespace TangoTest_ns

#endif // _TANGOTESTCLASS_H
