/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberProperty;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberImageHelper;
import fr.esrf.tangoatk.core.attribute.NumberAttributeHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberImage
extends AAttribute
implements INumberImage {
    protected NumberAttributeHelper numberHelper;
    ANumberImageHelper numberImageHelper;
    double[][] imageValue;

    public void setNumberHelper(ANumberImageHelper aNumberImageHelper) {
        this.numberHelper = aNumberImageHelper;
        this.numberImageHelper = aNumberImageHelper;
    }

    public void addNumberImageListener(IImageListener iImageListener) {
        this.numberImageHelper.addImageListener(iImageListener);
    }

    public void removeNumberImageListener(IImageListener iImageListener) {
        this.numberImageHelper.removeImageListener(iImageListener);
    }

    protected void insert(String[][] stringArray) {
        this.checkDimensions(stringArray);
        this.insert(NumberAttributeHelper.flatten2double(stringArray));
    }

    public void refresh() {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.imageValue = this.numberImageHelper.getNumberImageDisplayValue(this.readValueFromNetwork());
                this.numberImageHelper.fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.imageValue = null;
            System.out.println("NumberImage.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.numberImageHelper.getNumberImageDisplayValue(deviceAttribute);
                this.numberImageHelper.fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            this.imageValue = null;
            System.out.println("NumberImage.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.imageValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public void setValue(double[][] dArray) {
        try {
            this.checkDimensions(dArray);
            this.insert(NumberAttributeHelper.flatten(dArray));
            this.writeAtt();
            this.numberImageHelper.fireImageValueChanged(dArray, System.currentTimeMillis());
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    protected double getNumberProperty(String string) {
        NumberProperty numberProperty = (NumberProperty)this.getProperty(string);
        if (numberProperty != null && numberProperty.isSpecified()) {
            return ((Number)numberProperty.getValue()).doubleValue();
        }
        return Double.NaN;
    }

    public double getMinValue() {
        return this.getNumberProperty("min_value");
    }

    public double getMaxValue() {
        return this.getNumberProperty("max_value");
    }

    public double getMinAlarm() {
        return this.getNumberProperty("min_alarm");
    }

    public double getMaxAlarm() {
        return this.getNumberProperty("max_alarm");
    }

    public void setConfiguration(AttributeInfo attributeInfo) {
        super.setConfiguration(attributeInfo);
        try {
            this.setMinValue(new Double(this.config.min_value), true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMinValue(Double.NaN, true);
            this.getProperty("min_value").setSpecified(false);
        }
        try {
            this.setMaxValue(new Double(this.config.max_value), true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMaxValue(Double.NaN, true);
            this.getProperty("max_value").setSpecified(false);
        }
        try {
            this.setMinAlarm(new Double(this.config.min_alarm), true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMinAlarm(Double.NaN, true);
            this.getProperty("min_alarm").setSpecified(false);
        }
        try {
            this.setMaxAlarm(new Double(this.config.max_alarm), true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMaxAlarm(Double.NaN, true);
            this.getProperty("max_alarm").setSpecified(false);
        }
    }

    public void setMinValue(double d) {
        this.numberHelper.setMinValue(d);
    }

    public void setMaxValue(double d) {
        this.numberHelper.setMaxValue(d);
    }

    public void setMinAlarm(double d) {
        this.numberHelper.setMinAlarm(d);
    }

    public void setMaxAlarm(double d) {
        this.numberHelper.setMaxAlarm(d);
    }

    public void setMinValue(double d, boolean bl) {
        this.numberHelper.setMinValue(d, bl);
    }

    public void setMaxValue(double d, boolean bl) {
        this.numberHelper.setMaxValue(d, bl);
    }

    public void setMinAlarm(double d, boolean bl) {
        this.numberHelper.setMinAlarm(d, bl);
    }

    public void setMaxAlarm(double d, boolean bl) {
        this.numberHelper.setMaxAlarm(d, bl);
    }

    void insert(double[] dArray) {
        this.numberImageHelper.insert(dArray);
    }

    public String[][] extract() throws DevFailed {
        return this.numberImageHelper.getImageValue(this.readValueFromNetwork());
    }

    public double[][] getValue() {
        return this.imageValue;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "NumberImage.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "NumberImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.imageValue = null;
            System.out.println("NumberImage.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.numberImageHelper.getNumberImageDisplayValue(deviceAttribute);
                this.numberImageHelper.fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.imageValue = null;
                System.out.println("NumberImage.periodic.getNumberImageDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberImage.periodic.getNumberImageDisplayValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "NumberImage.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "NumberImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.imageValue = null;
            System.out.println("NumberImage.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberImage.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.numberImageHelper.getNumberImageDisplayValue(deviceAttribute);
                this.numberImageHelper.fireImageValueChanged(this.imageValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.imageValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.imageValue = null;
                System.out.println("NumberImage.change.getNumberImageDisplayValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberImage.change.getNumberImageDisplayValue()------------------------------------------------");
            }
        }
    }

    public void freeInternalData() {
        super.freeInternalData();
        this.imageValue = null;
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: NumberImage.java,v 1.17 2007/04/27 15:55:05 poncet Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

