/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.DoubleImageHelper;

public class DoubleSpectrumHelper
extends ANumberSpectrumHelper {
    public DoubleSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.imageHelper = new DoubleImageHelper(iAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        if (d == 1.0) {
            deviceAttribute.insert(dArray);
        } else {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray[i] / d;
            }
            deviceAttribute.insert(dArray2);
        }
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Double(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Double(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Double(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Double(d), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        return deviceAttribute.extractDoubleArray();
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double d = this.attribute.getDisplayUnitFactor();
        if (d == 1.0) {
            return deviceAttribute.extractDoubleArray();
        }
        double[] dArray = deviceAttribute.extractDoubleArray();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    public String getVersion() {
        return "$Id: DoubleSpectrumHelper.java,v 1.7 2006/10/11 15:21:39 jlpons Exp $";
    }
}

