/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import java.util.EventListener;

public class AtkEventListenerList {
    private static final Object[] nullArray = new Object[0];
    Object[] listenerList = nullArray;

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public synchronized void add(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            System.out.print("AtkEventListenerList.add() : Trying to register a null listener object [" + clazz + "]");
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        if (this.foundEntry(clazz, eventListener) < 0) {
            int n = this.listenerList.length;
            Object[] objectArray = new Object[n + 2];
            System.arraycopy(this.listenerList, 0, objectArray, 0, n);
            objectArray[n] = clazz;
            objectArray[n + 1] = eventListener;
            this.listenerList = objectArray;
        }
    }

    public synchronized void remove(Class clazz, EventListener eventListener) {
        int n = this.foundEntry(clazz, eventListener);
        if (n < 0) {
            return;
        }
        Object[] objectArray = new Object[this.listenerList.length - 2];
        System.arraycopy(this.listenerList, 0, objectArray, 0, n);
        if (n < objectArray.length) {
            System.arraycopy(this.listenerList, n + 2, objectArray, n, objectArray.length - n);
        }
        this.listenerList = objectArray.length == 0 ? nullArray : objectArray;
    }

    public synchronized void removeAtkEventListeners() {
        this.listenerList = nullArray;
    }

    public synchronized int getListenerCount() {
        return this.listenerList.length / 2;
    }

    private int foundEntry(Class clazz, EventListener eventListener) {
        int n = -1;
        for (int i = this.listenerList.length - 2; i >= 0; i -= 2) {
            if (this.listenerList[i] != clazz || !this.listenerList[i + 1].equals(eventListener)) continue;
            n = i;
            break;
        }
        return n;
    }
}

