/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.queue.EventQueueFactory;
import org.jacorb.notification.queue.MessageQueueAdapter;
import org.jacorb.notification.queue.RWLockEventQueueDecorator;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetAdapter;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublish;
import org.omg.CosNotifyComm.NotifyPublishHelper;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribeOperations;
import org.omg.PortableServer.POA;

public abstract class AbstractProxySupplier
extends AbstractProxy
implements MessageConsumer,
NotifySubscribeOperations {
    private static final Runnable EMPTY_RUNNABLE = new Runnable(){

        public void run() {
        }
    };
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    private static final Message[] EMPTY_MESSAGE = new Message[0];
    private final RWLockEventQueueDecorator pendingMessages_;
    private final int errorThreshold_;
    private final ConsumerAdmin consumerAdmin_;
    private final EventQueueFactory eventQueueFactory_;
    private NotifyPublishOperations proxyOfferListener_;
    private NotifyPublish offerListener_;
    private PropertySetAdapter eventQueueConfigurationChangedCB = new PropertySetAdapter(){

        public void actionPropertySetChanged(PropertySet propertySet) throws UnsupportedQoS {
            AbstractProxySupplier.this.configureEventQueue();
        }
    };

    protected AbstractProxySupplier(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, offerManager, subscriptionManager);
        this.consumerAdmin_ = consumerAdmin;
        this.eventQueueFactory_ = new EventQueueFactory(configuration);
        this.errorThreshold_ = configuration.getAttributeAsInteger("jacorb.notification.consumer.error_threshold", 3);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set Error Threshold to : " + this.errorThreshold_);
        }
        this.qosSettings_.addPropertySetListener(new String[]{"OrderPolicy", "DiscardPolicy"}, (PropertySetListener)this.eventQueueConfigurationChangedCB);
        try {
            MessageQueueAdapter messageQueueAdapter = this.getMessageQueueFactory().newMessageQueue(this.qosSettings_);
            this.pendingMessages_ = new RWLockEventQueueDecorator(messageQueueAdapter);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException();
        }
    }

    protected EventQueueFactory getMessageQueueFactory() {
        return this.eventQueueFactory_;
    }

    private final void configureEventQueue() {
        MessageQueueAdapter messageQueueAdapter = this.getMessageQueueFactory().newMessageQueue(this.qosSettings_);
        try {
            this.pendingMessages_.replaceDelegate(messageQueueAdapter);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getPendingMessagesCount() {
        try {
            return this.pendingMessages_.getPendingMessagesCount();
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }

    public boolean hasPendingData() {
        try {
            return this.pendingMessages_.hasPendingMessages();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    protected void enqueue(Message message) {
        Message message2 = (Message)message.clone();
        try {
            this.pendingMessages_.enqeue(message);
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("added " + message + " to pending Messages.");
            }
        }
        catch (InterruptedException interruptedException) {
            message2.dispose();
            this.logger_.info("enqueue was interrupted", interruptedException);
        }
    }

    public Message getMessageBlocking() throws InterruptedException {
        return this.pendingMessages_.getMessageBlocking();
    }

    protected Message getMessageNoBlock() {
        try {
            return this.pendingMessages_.getMessageNoBlock();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected Message[] getAllMessages() {
        try {
            return this.pendingMessages_.getAllMessages();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return EMPTY_MESSAGE;
        }
    }

    public void deliverMessage(Message message) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("deliverMessage() connected=" + this.isConnected() + " suspended=" + this.isSuspended());
        }
        if (this.isConnected()) {
            this.enqueue(message);
            this.messageDelivered();
        }
    }

    protected void messageDelivered() {
    }

    protected Message[] getUpToMessages(int n) {
        try {
            return this.pendingMessages_.getUpToMessages(n);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return EMPTY_MESSAGE;
        }
    }

    protected Message[] getAtLeastMessages(int n) {
        try {
            return this.pendingMessages_.getAtLeastMessages(n);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return EMPTY_MESSAGE;
        }
    }

    public int getErrorThreshold() {
        return this.errorThreshold_;
    }

    public final void dispose() {
        super.dispose();
        this.pendingMessages_.clear();
        this.getTaskProcessor().executeTaskAfterDelay(1000L, EMPTY_RUNNABLE);
    }

    public final ConsumerAdmin MyAdmin() {
        return this.consumerAdmin_;
    }

    public final void subscription_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        this.subscriptionManager_.subscription_change(eventTypeArray, eventTypeArray2);
    }

    public final EventType[] obtain_offered_types(ObtainInfoMode obtainInfoMode) {
        EventType[] eventTypeArray = EMPTY_EVENT_TYPE_ARRAY;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                eventTypeArray = this.offerManager_.obtain_offered_types();
                break;
            }
            case 0: {
                eventTypeArray = this.offerManager_.obtain_offered_types();
                this.removeListener();
                break;
            }
            case 3: {
                this.registerListener();
                break;
            }
            case 2: {
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode");
            }
        }
        return eventTypeArray;
    }

    private void registerListener() {
        NotifyPublishOperations notifyPublishOperations;
        if (this.proxyOfferListener_ == null && (notifyPublishOperations = this.getOfferListener()) != null) {
            this.proxyOfferListener_ = new NotifyPublishOperations(){

                public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) {
                    try {
                        notifyPublishOperations.offer_change(eventTypeArray, eventTypeArray2);
                    }
                    catch (NO_IMPLEMENT nO_IMPLEMENT) {
                        AbstractProxySupplier.this.logger_.info("disable offer_change for connected Consumer.", nO_IMPLEMENT);
                        AbstractProxySupplier.this.removeListener();
                    }
                    catch (InvalidEventType invalidEventType) {
                        AbstractProxySupplier.this.logger_.error("invalid event type", invalidEventType);
                    }
                    catch (Exception exception) {
                        AbstractProxySupplier.this.logger_.error("offer_change failed", exception);
                    }
                }
            };
            this.offerManager_.addListener(this.proxyOfferListener_);
        }
    }

    protected void removeListener() {
        if (this.proxyOfferListener_ != null) {
            this.offerManager_.removeListener(this.proxyOfferListener_);
            this.proxyOfferListener_ = null;
        }
    }

    final NotifyPublishOperations getOfferListener() {
        return this.offerListener_;
    }

    public void connectClient(Object object) {
        super.connectClient(object);
        try {
            this.offerListener_ = NotifyPublishHelper.narrow(object);
            this.logger_.debug("successfully narrowed connecting Client to IF NotifyPublish");
        }
        catch (Throwable throwable) {
            this.logger_.info("disable offer_change for connecting Consumer");
        }
    }

    public boolean isRetryAllowed() {
        return !this.isDisposed() && this.getErrorCounter() < this.getErrorThreshold();
    }

    protected abstract long getCost();

    public int compareTo(java.lang.Object object) {
        AbstractProxySupplier abstractProxySupplier = (AbstractProxySupplier)object;
        return (int)(this.getCost() - abstractProxySupplier.getCost());
    }

    public final boolean hasMessageConsumer() {
        return true;
    }
}

