/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import EDU.oswego.cs.dl.util.concurrent.Heap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.Heap2;
import org.jacorb.notification.queue.HeapEntry;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedPriorityEventQueue
extends AbstractBoundedEventQueue {
    private Heap heap_;
    private long counter_ = 0L;
    private final int maxCapacity_;

    public BoundedPriorityEventQueue(int n, EventQueueOverflowStrategy eventQueueOverflowStrategy) {
        super(n, eventQueueOverflowStrategy, new Object());
        this.maxCapacity_ = n;
        this.heap_ = this.newHeap();
    }

    private Heap newHeap() {
        return new Heap2(this.maxCapacity_, QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
    }

    protected Message getNextElement() {
        return ((HeapEntry)this.heap_.extract()).event_;
    }

    protected Message getEarliestTimeout() {
        List list = this.getAllElementsInternal();
        Collections.sort(list, QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
        HeapEntry heapEntry = (HeapEntry)list.remove(0);
        Heap heap = this.newHeap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HeapEntry heapEntry2 = (HeapEntry)iterator.next();
            heap.insert((Object)heapEntry2);
        }
        this.heap_ = heap;
        return heapEntry.event_;
    }

    protected Message getOldestElement() {
        List list = this.getAllElementsInternal();
        Collections.sort(list, QueueUtil.ASCENDING_AGE_COMPARATOR);
        HeapEntry heapEntry = (HeapEntry)list.remove(0);
        Heap heap = this.newHeap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HeapEntry heapEntry2 = (HeapEntry)iterator.next();
            heap.insert((Object)heapEntry2);
        }
        return heapEntry.event_;
    }

    protected Message getYoungestElement() {
        List list = this.getAllElementsInternal();
        Collections.sort(list, QueueUtil.DESCENDING_AGE_COMPARATOR);
        HeapEntry heapEntry = (HeapEntry)list.remove(0);
        Heap heap = this.newHeap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HeapEntry heapEntry2 = (HeapEntry)iterator.next();
            heap.insert((Object)heapEntry2);
        }
        this.heap_ = heap;
        return heapEntry.event_;
    }

    protected Message getLeastPriority() {
        List list = this.getAllElementsInternal();
        Collections.sort(list, QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
        HeapEntry heapEntry = (HeapEntry)list.remove(0);
        Heap heap = this.newHeap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HeapEntry heapEntry2 = (HeapEntry)iterator.next();
            heap.insert((Object)heapEntry2);
        }
        this.heap_ = heap;
        return heapEntry.event_;
    }

    protected Message[] getElements(int n) {
        Object object;
        ArrayList<Message> arrayList = new ArrayList<Message>();
        while ((object = this.heap_.extract()) != null && arrayList.size() <= n) {
            arrayList.add(((HeapEntry)object).event_);
        }
        return arrayList.toArray(QueueUtil.MESSAGE_ARRAY_TEMPLATE);
    }

    protected void addElement(Message message) {
        this.heap_.insert((Object)new HeapEntry(message, this.counter_++));
    }

    private List getAllElementsInternal() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while ((object = this.heap_.extract()) != null) {
            arrayList.add(object);
        }
        this.heap_.clear();
        return arrayList;
    }

    protected Message[] getAllElements() {
        List list = this.getAllElementsInternal();
        Message[] messageArray = new Message[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            HeapEntry heapEntry = (HeapEntry)iterator.next();
            messageArray[n++] = heapEntry.event_;
        }
        return messageArray;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSize() {
        return this.heap_.size();
    }

    public String toString() {
        return this.heap_.toString();
    }
}

