/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.EventTypeWrapper;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.conf.Default;
import org.jacorb.notification.filter.CallbackManager;
import org.jacorb.notification.filter.ConstraintEntry;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.FilterConstraint;
import org.jacorb.notification.filter.FilterUsageDecorator;
import org.jacorb.notification.filter.PropertyDoesNotExistException;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.EvaluationContextFactory;
import org.jacorb.notification.interfaces.GCDisposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.notification.util.WildcardMap;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterOperations;
import org.omg.CosNotifyFilter.FilterPOATie;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public abstract class AbstractFilter
implements GCDisposable,
ManageableServant,
Configurable,
FilterOperations {
    static final RuntimeException NOT_SUPPORTED = new UnsupportedOperationException("this operation is not supported");
    public static final int NO_CONSTRAINTS_MATCH = -2;
    public static final int CONSTRAINTS_EMPTY = -1;
    private static final String EMPTY_EVENT_TYPE_CONSTRAINT_KEY = AbstractMessage.calcConstraintKey("*", "*");
    private final FilterPOATie servant_;
    private final DisposableManager disposables_ = new DisposableManager();
    private final CallbackManager callbackManager_ = new CallbackManager();
    protected final Map constraints_ = new HashMap();
    protected final WildcardMap wildcardMap_;
    protected final ReadWriteLock constraintsLock_;
    private final SynchronizedInt constraintIdPool_ = new SynchronizedInt(0);
    protected final MessageFactory messageFactory_;
    private final FilterUsageDecorator filterUsageDecorator_;
    private final POA poa_;
    private final ORB orb_;
    private Filter thisRef_;
    private final Logger logger_;
    private final EvaluationContextFactory evaluationContextFactory_;
    private final SynchronizedBoolean isActivated = new SynchronizedBoolean(false);
    private static final ConstraintInfo[] EMPTY_CONSTRAINT_INFO = new ConstraintInfo[0];
    private final long maxIdleTime_;

    protected AbstractFilter(Configuration configuration, EvaluationContextFactory evaluationContextFactory, MessageFactory messageFactory, ORB oRB, POA pOA) throws ConfigurationException {
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.logger_ = LogUtil.getLogger(configuration, this.getClass().getName());
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Created filter for Grammar: " + this.constraint_grammar());
        }
        this.messageFactory_ = messageFactory;
        this.evaluationContextFactory_ = evaluationContextFactory;
        this.constraintsLock_ = new WriterPreferenceReadWriteLock();
        this.wildcardMap_ = this.newWildcardMap(configuration);
        this.disposables_.addDisposable(this.callbackManager_);
        this.filterUsageDecorator_ = new FilterUsageDecorator(this);
        this.servant_ = new FilterPOATie(this.filterUsageDecorator_.getFilterOperations());
        this.maxIdleTime_ = configuration.getAttributeAsLong("jacorb.notification.filter.dead_interval", 0L);
    }

    private WildcardMap newWildcardMap(Configuration configuration) throws ConfigurationException {
        String string = configuration.getAttribute("jacorb.notification.filter.wildcardmap_impl", Default.DEFAULT_WILDCARDMAP_IMPL);
        try {
            Class clazz = ObjectUtil.classForName(string);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (WildcardMap)constructor.newInstance(new java.lang.Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ConfigurationException(string + " is no valid WildcardMap Implementation");
    }

    public final void configure(Configuration configuration) {
    }

    public Object activate() {
        if (this.thisRef_ == null) {
            this.thisRef_ = this.servant_._this(this.orb_);
            this.isActivated.set(true);
        }
        return this.thisRef_;
    }

    public void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.servant_));
        }
        catch (WrongPolicy wrongPolicy) {
            this.logger_.fatalError("error deactivating object", wrongPolicy);
        }
        catch (ObjectNotActive objectNotActive) {
            this.logger_.fatalError("error deactivating object", objectNotActive);
        }
        catch (ServantNotActive servantNotActive) {
            this.logger_.fatalError("error deactivating object", servantNotActive);
        }
    }

    protected int newConstraintId() {
        return this.constraintIdPool_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] add_constraints(ConstraintExp[] constraintExpArray) throws InvalidConstraint {
        ConstraintInfo[] constraintInfoArray;
        FilterConstraint[] filterConstraintArray = this.newFilterConstraints(constraintExpArray);
        this.constraintsLock_.writeLock().acquire();
        try {
            constraintInfoArray = this.add_constraint(constraintExpArray, filterConstraintArray);
        }
        catch (Throwable throwable) {
            try {
                this.constraintsLock_.writeLock().release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return EMPTY_CONSTRAINT_INFO;
            }
        }
        this.constraintsLock_.writeLock().release();
        return constraintInfoArray;
    }

    private ConstraintInfo[] add_constraint(ConstraintExp[] constraintExpArray, FilterConstraint[] filterConstraintArray) throws InterruptedException {
        ConstraintInfo[] constraintInfoArray = new ConstraintInfo[filterConstraintArray.length];
        for (int i = 0; i < constraintExpArray.length; ++i) {
            int n = this.newConstraintId();
            constraintInfoArray[i] = new ConstraintInfo(constraintExpArray[i], n);
            ConstraintEntry constraintEntry = new ConstraintEntry(filterConstraintArray[i], constraintInfoArray[i]);
            this.addEventTypeMappingsForConstraint(constraintEntry);
            this.constraints_.put(new Integer(n), constraintEntry);
            this.notifyCallbacks();
        }
        return constraintInfoArray;
    }

    private void addEventTypeMappingsForConstraint(ConstraintEntry constraintEntry) {
        int n = constraintEntry.getEventTypeCount();
        if (n == 0) {
            this.addConstraintEntryToWildcardMap(EMPTY_EVENT_TYPE_CONSTRAINT_KEY, constraintEntry);
        } else {
            for (int i = 0; i < n; ++i) {
                EventTypeWrapper eventTypeWrapper = constraintEntry.getEventTypeWrapper(i);
                this.addConstraintEntryToWildcardMap(eventTypeWrapper.getConstraintKey(), constraintEntry);
            }
        }
    }

    private void addConstraintEntryToWildcardMap(String string, ConstraintEntry constraintEntry) {
        LinkedList<ConstraintEntry> linkedList = (LinkedList<ConstraintEntry>)this.wildcardMap_.getNoExpansion(string);
        if (linkedList == null) {
            linkedList = new LinkedList<ConstraintEntry>();
            this.wildcardMap_.put(string, linkedList);
        }
        linkedList.add(constraintEntry);
    }

    private FilterConstraint[] newFilterConstraints(ConstraintExp[] constraintExpArray) throws InvalidConstraint {
        FilterConstraint[] filterConstraintArray = new FilterConstraint[constraintExpArray.length];
        for (int i = 0; i < constraintExpArray.length; ++i) {
            filterConstraintArray[i] = this.newFilterConstraint(constraintExpArray[i]);
        }
        return filterConstraintArray;
    }

    protected abstract FilterConstraint newFilterConstraint(ConstraintExp var1) throws InvalidConstraint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify_constraints(int[] nArray, ConstraintInfo[] constraintInfoArray) throws ConstraintNotFound, InvalidConstraint {
        try {
            this.constraintsLock_.writeLock().acquire();
            try {
                Integer[] integerArray = this.checkConstraintsToBeDeleted(nArray);
                FilterConstraint[] filterConstraintArray = this.checkConstraintsToBeModified(constraintInfoArray);
                this.deleteConstraints(integerArray);
                this.modifyConstraints(constraintInfoArray, filterConstraintArray);
                this.notifyCallbacks();
            }
            finally {
                this.constraintsLock_.writeLock().release();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void modifyConstraints(ConstraintInfo[] constraintInfoArray, FilterConstraint[] filterConstraintArray) {
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            Integer n = new Integer(constraintInfoArray[i].constraint_id);
            ConstraintEntry constraintEntry = new ConstraintEntry(filterConstraintArray[i], constraintInfoArray[i]);
            this.constraints_.put(n, constraintEntry);
            int n2 = constraintEntry.getEventTypeCount();
            for (int j = 0; j < n2; ++j) {
                EventTypeWrapper eventTypeWrapper = constraintEntry.getEventTypeWrapper(j);
                List list = (List)this.wildcardMap_.getNoExpansion(eventTypeWrapper.getConstraintKey());
                list.add(constraintEntry);
            }
        }
    }

    private FilterConstraint[] checkConstraintsToBeModified(ConstraintInfo[] constraintInfoArray) throws InvalidConstraint, ConstraintNotFound {
        FilterConstraint[] filterConstraintArray = new FilterConstraint[constraintInfoArray.length];
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            if (!this.constraints_.containsKey(new Integer(constraintInfoArray[i].constraint_id))) {
                throw new ConstraintNotFound(constraintInfoArray[i].constraint_id);
            }
            filterConstraintArray[i] = this.newFilterConstraint(constraintInfoArray[i].constraint_expression);
        }
        return filterConstraintArray;
    }

    private Integer[] checkConstraintsToBeDeleted(int[] nArray) throws ConstraintNotFound {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = new Integer(nArray[i]);
            if (this.constraints_.containsKey(integerArray[i])) continue;
            throw new ConstraintNotFound(nArray[i]);
        }
        return integerArray;
    }

    private void deleteConstraints(Integer[] integerArray) {
        for (int i = 0; i < integerArray.length; ++i) {
            ConstraintEntry constraintEntry = (ConstraintEntry)this.constraints_.remove(integerArray[i]);
            this.removeEventTypeMappingForConstraint(integerArray[i], constraintEntry);
        }
    }

    private void removeEventTypeMappingForConstraint(Integer n, ConstraintEntry constraintEntry) {
        int n2 = constraintEntry.getEventTypeCount();
        block0: for (int i = 0; i < n2; ++i) {
            EventTypeWrapper eventTypeWrapper = constraintEntry.getEventTypeWrapper(i);
            List list = (List)this.wildcardMap_.getNoExpansion(eventTypeWrapper.getConstraintKey());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ConstraintEntry constraintEntry2 = (ConstraintEntry)iterator.next();
                if (constraintEntry2.getConstraintId() != n.intValue()) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] get_constraints(int[] nArray) throws ConstraintNotFound {
        ConstraintInfo[] constraintInfoArray;
        Sync sync = this.constraintsLock_.readLock();
        sync.acquire();
        try {
            ConstraintInfo[] constraintInfoArray2 = new ConstraintInfo[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                Integer n = new Integer(nArray[i]);
                if (!this.constraints_.containsKey(n)) {
                    throw new ConstraintNotFound(nArray[i]);
                }
                constraintInfoArray2[i] = ((ConstraintEntry)this.constraints_.get(n)).getConstraintInfo();
            }
            constraintInfoArray = constraintInfoArray2;
        }
        catch (Throwable throwable) {
            try {
                sync.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return EMPTY_CONSTRAINT_INFO;
            }
        }
        sync.release();
        return constraintInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] get_all_constraints() {
        ConstraintInfo[] constraintInfoArray;
        this.constraintsLock_.readLock().acquire();
        try {
            ConstraintInfo[] constraintInfoArray2 = new ConstraintInfo[this.constraints_.size()];
            Iterator iterator = this.constraints_.values().iterator();
            for (int i = 0; i < constraintInfoArray2.length; ++i) {
                constraintInfoArray2[i] = ((ConstraintEntry)iterator.next()).getConstraintInfo();
            }
            constraintInfoArray = constraintInfoArray2;
        }
        catch (Throwable throwable) {
            try {
                this.constraintsLock_.readLock().release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return EMPTY_CONSTRAINT_INFO;
            }
        }
        this.constraintsLock_.readLock().release();
        return constraintInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_all_constraints() {
        try {
            this.constraintsLock_.writeLock().acquire();
            try {
                this.constraints_.clear();
                this.wildcardMap_.clear();
                this.notifyCallbacks();
            }
            finally {
                this.constraintsLock_.writeLock().release();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void destroy() {
        this.dispose();
    }

    private Iterator getConstraintsForEvent(Message message) {
        String string = message.getConstraintKey();
        return this.getIterator(string);
    }

    public Iterator getIterator(java.lang.Object object) {
        java.lang.Object[] objectArray = this.wildcardMap_.getWithExpansion(object);
        return new ConstraintIterator(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int match_ReadLock(EvaluationContext evaluationContext, Message message) throws UnsupportedFilterableData {
        int n;
        this.constraintsLock_.readLock().acquire();
        try {
            n = this.match_NoLock(evaluationContext, message);
        }
        catch (Throwable throwable) {
            try {
                this.constraintsLock_.readLock().release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return -2;
            }
        }
        this.constraintsLock_.readLock().release();
        return n;
    }

    private int match_NoLock(EvaluationContext evaluationContext, Message message) throws UnsupportedFilterableData {
        if (!this.constraints_.isEmpty()) {
            Iterator iterator = this.getConstraintsForEvent(message);
            while (iterator.hasNext()) {
                ConstraintEntry constraintEntry = (ConstraintEntry)iterator.next();
                try {
                    boolean bl = constraintEntry.getFilterConstraint().evaluate(evaluationContext, message).getBool();
                    if (!bl) continue;
                    return constraintEntry.getConstraintId();
                }
                catch (PropertyDoesNotExistException propertyDoesNotExistException) {
                    this.logger_.info("tried to access non existing Property", propertyDoesNotExistException);
                }
                catch (EvaluationException evaluationException) {
                    this.logger_.fatalError("Error evaluating filter", evaluationException);
                    throw new UnsupportedFilterableData(evaluationException.getMessage());
                }
            }
            return -2;
        }
        this.logger_.info("Filter has no Expressions");
        return -1;
    }

    public boolean match(Any any) throws UnsupportedFilterableData {
        return this.match_internal(any) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_internal(Any any) throws UnsupportedFilterableData {
        EvaluationContext evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message message = this.messageFactory_.newMessage(any);
            try {
                n = this.match_ReadLock(evaluationContext, message);
            }
            catch (Throwable throwable) {
                message.dispose();
                throw throwable;
            }
            message.dispose();
            return n;
        }
        finally {
            evaluationContext.dispose();
        }
    }

    public boolean match_structured(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        return this.match_structured_internal(structuredEvent) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_structured_internal(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        EvaluationContext evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message message = this.messageFactory_.newMessage(structuredEvent);
            try {
                n = this.match_ReadLock(evaluationContext, message);
            }
            catch (Throwable throwable) {
                message.dispose();
                throw throwable;
            }
            message.dispose();
            return n;
        }
        finally {
            evaluationContext.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_typed_internal(Property[] propertyArray) throws UnsupportedFilterableData {
        EvaluationContext evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message message = this.messageFactory_.newMessage(propertyArray);
            try {
                n = this.match_ReadLock(evaluationContext, message);
            }
            catch (Throwable throwable) {
                message.dispose();
                throw throwable;
            }
            message.dispose();
            return n;
        }
        finally {
            evaluationContext.dispose();
        }
    }

    public boolean match_typed(Property[] propertyArray) throws UnsupportedFilterableData {
        return this.match_typed_internal(propertyArray) >= 0;
    }

    public int attach_callback(NotifySubscribe notifySubscribe) {
        return this.callbackManager_.attach_callback(notifySubscribe);
    }

    public void detach_callback(int n) {
        this.callbackManager_.detach_callback(n);
    }

    public int[] get_callbacks() {
        return this.callbackManager_.get_callbacks();
    }

    private void notifyCallbacks() throws InterruptedException {
        Iterator iterator = this.constraints_.keySet().iterator();
        ArrayList<EventType> arrayList = new ArrayList<EventType>();
        while (iterator.hasNext()) {
            java.lang.Object k = iterator.next();
            ConstraintEntry constraintEntry = (ConstraintEntry)this.constraints_.get(k);
            int n = constraintEntry.getEventTypeCount();
            for (int i = 0; i < n; ++i) {
                EventTypeWrapper eventTypeWrapper = constraintEntry.getEventTypeWrapper(i);
                arrayList.add(eventTypeWrapper.getEventType());
            }
        }
        this.callbackManager_.replaceWith(arrayList.toArray(EventTypeWrapper.EMPTY_EVENT_TYPE_ARRAY));
    }

    public POA _default_POA() {
        return this.poa_;
    }

    public void dispose() {
        if (this.isActivated.get()) {
            this.deactivate();
            this.isActivated.set(false);
        }
        this.disposables_.dispose();
    }

    public void addDisposeHook(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public Date getLastUsage() {
        return this.filterUsageDecorator_.getLastUsage();
    }

    public void attemptDispose() {
        AbstractFilter.attemptDispose(this, this.getLastUsage(), this.maxIdleTime_);
    }

    static void attemptDispose(Disposable disposable, Date date, long l) {
        if (l <= 0L) {
            return;
        }
        if (date.getTime() + l < System.currentTimeMillis()) {
            disposable.dispose();
        }
    }

    private static class ConstraintIterator
    implements Iterator {
        final java.lang.Object[] arrayOfLists_;
        Iterator current_;
        int currentListIdx_ = 0;

        ConstraintIterator(java.lang.Object[] objectArray) {
            this.arrayOfLists_ = objectArray;
            if (this.arrayOfLists_.length == 0) {
                this.current_ = null;
            } else {
                this.switchIterator();
            }
        }

        private void switchIterator() {
            this.current_ = ((List)this.arrayOfLists_[this.currentListIdx_]).iterator();
        }

        public boolean hasNext() {
            return this.current_ != null && this.current_.hasNext();
        }

        public java.lang.Object next() {
            if (this.current_ == null) {
                throw new NoSuchElementException();
            }
            java.lang.Object e = this.current_.next();
            if (!this.current_.hasNext() && this.currentListIdx_ < this.arrayOfLists_.length - 1) {
                ++this.currentListIdx_;
                this.switchIterator();
            }
            return e;
        }

        public void remove() {
            throw NOT_SUPPORTED;
        }
    }
}

