/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoAppender;
import fr.esrf.TangoDs.TangoConsoleAppender;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoDeviceAppender;
import fr.esrf.TangoDs.TangoRollingFileAppender;
import fr.esrf.TangoDs.Util;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Logging
implements TangoConst {
    private static Logging _instance = null;
    private static Logger _core_logger = null;
    private String logging_path = null;
    private long rft = 2048L;
    private int cmd_line_level = 0;
    final String _DefaultTargetName = "default";

    public static Logging instance() {
        if (_instance == null) {
            System.err.println("Logging is not initialised !!!");
            System.err.println("Exiting");
            System.exit(-1);
        }
        return _instance;
    }

    public static Logger core_logger() {
        return _core_logger;
    }

    public static Logging init(String ds_name, int trace_level, Database db) {
        if (_instance == null) {
            _instance = new Logging(ds_name, trace_level, db);
        }
        return _instance;
    }

    protected Logging(String ds_name, int trace_level, Database db) {
        this.cmd_line_level = trace_level;
        String ds_dev_name = "dserver/" + ds_name;
        this.verbose("Initializing logging for " + ds_dev_name);
        Logger logger = Logger.getLogger(ds_dev_name.toLowerCase());
        if (logger == null) {
            this.verbose("\tFailed to instanciate the TANGO core-logger");
            this.verbose("\tAborting logging intialization");
            return;
        }
        this.verbose("\tTANGO core-logger instanciated");
        logger.setAdditivity(false);
        String default_log_path = "/tmp/tango";
        try {
            String os_name = System.getProperty("os.name");
            this.verbose("\tRunning on " + os_name);
            if (os_name.toLowerCase().indexOf("windows") != -1) {
                default_log_path = new String("c:/tango");
            }
        }
        catch (Exception e) {
            this.verbose("\tException caught while trying to get <os.name> system property");
            this.verbose("\tAborting logging intialization");
            return;
        }
        String tango_log_path = System.getProperty("TANGO_LOG_PATH");
        if (tango_log_path == null || tango_log_path.length() == 0) {
            this.logging_path = default_log_path;
            this.verbose("\tEnv. variable TANGO_LOG_PATH not set");
        } else {
            this.logging_path = tango_log_path;
        }
        this.logging_path = this.logging_path + "/" + ds_name;
        this.verbose("\tDefault logging directory set to " + this.logging_path);
        boolean level_set_from_cmd_line = this.cmd_line_level != 0;
        Level initial_level = Level.WARN;
        if (level_set_from_cmd_line) {
            initial_level = this.cmd_line_level <= 2 ? Level.INFO : Level.DEBUG;
        }
        logger.setLevel(initial_level);
        this.verbose("\tTANGO core-logger intial level is " + initial_level.toString());
        if (db == null) {
            this.verbose("\tNot using the database. Logging Intialization complete");
            return;
        }
        this.verbose("\tReading logging properties from database");
        LoggingProperties properties = this.get_logging_properties(logger, db);
        if (properties == null) {
            this.verbose("\tFailed to obtain logging properties from database");
            this.verbose("\tAborting logging intialization");
            return;
        }
        if (properties.logging_path != null) {
            this.logging_path = properties.logging_path;
            this.verbose("\tLogging path changed to " + this.logging_path);
        }
        if (!level_set_from_cmd_line) {
            logger.setLevel(properties.logging_level);
            this.verbose("\tLogging level set to " + properties.logging_level.toString());
        }
        if (this.rft != properties.logging_rft) {
            this.rft = properties.logging_rft;
            this.verbose("\tRolling threshold changed to " + String.valueOf(this.rft));
        }
        this.verbose("\tAdding initial targets to TANGO core-logger");
        if (level_set_from_cmd_line) {
            try {
                this.add_logging_target(logger, "console");
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }
        if (properties.logging_targets != null) {
            for (int i = 0; i < properties.logging_targets.length; ++i) {
                try {
                    this.add_logging_target(logger, properties.logging_targets[i]);
                    continue;
                }
                catch (DevFailed e) {
                    // empty catch block
                }
            }
        }
        _core_logger = logger;
    }

    public LoggingProperties get_logging_properties(Logger logger, Database db) {
        LoggingProperties properties = new LoggingProperties();
        if (logger == null) {
            return properties;
        }
        try {
            if (db == null) {
                return properties;
            }
            String[] prop_names = new String[]{new String("logging_path"), new String("logging_rft"), new String("logging_level"), new String("logging_target")};
            DbDatum[] db_data = db.get_device_property(logger.getName(), prop_names);
            if (!db_data[0].is_empty()) {
                properties.logging_path = db_data[0].extractString();
            }
            if (!db_data[1].is_empty()) {
                properties.logging_rft = db_data[1].extractLong();
            }
            if (properties.logging_rft < 500L) {
                properties.logging_rft = 500L;
            } else if (properties.logging_rft > 20480L) {
                properties.logging_rft = 20480L;
            }
            if (!db_data[2].is_empty()) {
                String level_str = db_data[2].extractString();
                properties.logging_level = this.tango_to_log4j_level(level_str);
            }
            if (!db_data[3].is_empty()) {
                properties.logging_targets = db_data[3].extractStringArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public void add_logging_target(String[] dvsa) throws DevFailed {
        this.kill_zombie_appenders();
        if (dvsa.length % 2 != 0) {
            String desc = "Incorrect number of arguments";
            Except.throw_exception("API_MethodArgument", desc, "Logging::add_logging_target");
        }
        Vector dl = null;
        int t = 0;
        while (t < dvsa.length) {
            String pattern = dvsa[t++];
            pattern.toLowerCase();
            dl = Util.instance().get_device_list(pattern);
            if (dl.size() == 0) {
                String desc = "No device matching pattern <" + pattern + ">";
                Except.throw_exception("API_DeviceNotFound", desc, "Logging::add_logging_target");
            }
            Iterator it = dl.iterator();
            while (it.hasNext()) {
                Logger logger = ((DeviceImpl)it.next()).get_logger();
                this.add_logging_target(logger, dvsa[t++]);
            }
        }
    }

    public void add_logging_target(Logger logger, String ttype, String tname) throws DevFailed {
        this.add_logging_target(logger, ttype + "::" + tname);
    }

    public void add_logging_target(Logger logger, String ttype_tname) throws DevFailed {
        String desc;
        if (logger == null) {
            return;
        }
        ttype_tname.toLowerCase();
        String ttype = this.get_target_type(ttype_tname);
        String tname = this.get_target_name(ttype_tname);
        int type_id = -1;
        if ("file".equals(ttype)) {
            type_id = 0;
        } else if ("device".equals(ttype)) {
            type_id = 1;
        } else if ("console".equals(ttype)) {
            type_id = 2;
        } else {
            String desc2 = "Invalid logging target type specified (" + ttype + ")";
            Except.throw_exception("API_MethodArgument", desc2, "Logging::add_logging_target");
        }
        String full_file_name = null;
        String appender_name = ttype + "::";
        switch (type_id) {
            case 0: {
                if (tname.equals("default")) {
                    full_file_name = this.logging_path + "/";
                    full_file_name = full_file_name + this.device_to_file_name(logger.getName()) + ".log";
                } else {
                    full_file_name = tname.indexOf(47) != -1 ? tname : this.logging_path + "/" + tname;
                }
                File file = new File(full_file_name);
                File dir = new File(file.getParent());
                if (!dir.isDirectory()) {
                    try {
                        dir.mkdirs();
                    }
                    catch (Exception e) {
                        String desc3 = "Failed to create directory " + dir.getPath();
                        Except.throw_exception("API_SystemException", desc3, "Logging::add_logging_target");
                    }
                }
                tname = full_file_name;
                appender_name = appender_name + tname;
                break;
            }
            case 1: {
                if (tname.equals("default")) {
                    desc = "Device target name must be specified (no default value)";
                    Except.throw_exception("API_MethodArgument", desc, "Logging::add_logging_target");
                }
                appender_name = appender_name + tname;
                break;
            }
            case 2: {
                appender_name = appender_name + "console";
            }
        }
        Appender appender = logger.getAppender(appender_name);
        if (appender != null) {
            Util.out4.println("Target " + appender_name + " is already attached to " + logger.getName());
            return;
        }
        try {
            Util.out4.println("Adding " + appender_name + " to " + logger.getName());
            switch (type_id) {
                case 0: {
                    try {
                        appender = new TangoRollingFileAppender(appender_name, full_file_name, this.rft);
                    }
                    catch (IOException ioe) {
                        desc = "Could not open logging file " + full_file_name;
                        Util.out4.println(desc);
                        Except.throw_exception("API_CannotOpenFile", desc, "Logging::add_logging_target");
                    }
                    break;
                }
                case 1: {
                    appender = new TangoDeviceAppender(logger.getName(), appender_name, tname);
                    break;
                }
                case 2: {
                    appender = new TangoConsoleAppender(appender_name);
                }
            }
            logger.addAppender(appender);
            Util.out4.println("Added logging target " + appender_name + " to " + logger.getName());
        }
        catch (DevFailed df) {
            throw df;
        }
        catch (Exception e) {
            desc = "System exception caugth while trying to add target " + ttype_tname + " to " + logger.getName();
            Except.throw_exception("API_SystemException", desc, "Logging::add_logging_target");
        }
    }

    public void remove_logging_target(String[] dvsa) throws DevFailed {
        this.kill_zombie_appenders();
        if (dvsa.length % 2 != 0) {
            String desc = "Incorrect number of arguments";
            Except.throw_exception("API_MethodArgument", desc, "Logging::remove_logging_target");
        }
        Vector dl = null;
        int t = 0;
        while (t < dvsa.length) {
            String pattern = dvsa[t++];
            pattern.toLowerCase();
            dl = Util.instance().get_device_list(pattern);
            if (dl.size() == 0) {
                String desc = "No device matching pattern <" + pattern + ">";
                Except.throw_exception("API_DeviceNotFound", desc, "Logging::remove_logging_target");
            }
            String type = this.get_target_type(dvsa[t]).toLowerCase();
            String name = this.get_target_name(dvsa[t++]).toLowerCase();
            int type_id = -1;
            if ("file".equals(type)) {
                type_id = 0;
            } else if ("device".equals(type)) {
                type_id = 1;
            } else if ("console".equals(type)) {
                type_id = 2;
                name = "console";
            } else {
                String desc = "Invalid logging target type specified (" + type + ")";
                Except.throw_exception("API_MethodArgument", desc, "Logging::remove_logging_target");
            }
            boolean remove_all_targets = name.equals("*");
            Iterator it = dl.iterator();
            while (it.hasNext()) {
                Logger logger = ((DeviceImpl)it.next()).get_logger();
                if (!remove_all_targets) {
                    String full_name = type + "::";
                    if (type_id == 0) {
                        if (name.equals("default")) {
                            full_name = this.logging_path + "/";
                            full_name = full_name + this.device_to_file_name(logger.getName()) + ".log";
                        } else {
                            full_name = name.indexOf(47) != -1 ? name : this.logging_path + "/" + name;
                        }
                    } else {
                        full_name = full_name + name;
                    }
                    Util.out4.println("Removing target " + full_name + " from " + logger.getName());
                    logger.removeAppender(full_name);
                    continue;
                }
                Util.out4.println("Removing ALL <" + type + "> targets from " + logger.getName());
                Enumeration all_appenders = logger.getAllAppenders();
                String prefix = type + "::";
                while (all_appenders.hasMoreElements()) {
                    Appender appender = (Appender)all_appenders.nextElement();
                    if (appender.getName().indexOf(prefix) == -1) continue;
                    logger.removeAppender(appender.getName());
                }
            }
        }
    }

    public void set_logging_level(DevVarLongStringArray dvlsa) throws DevFailed {
        if (dvlsa.svalue.length != dvlsa.svalue.length) {
            String desc = "Imcompatible command argument type, long and string arrays must have the same length";
            Except.throw_exception("API_IncompatibleCmdArgumentType", desc, "Logging::set_logging_level");
        }
        for (int i = 0; i < dvlsa.svalue.length; ++i) {
            Level level = this.tango_to_log4j_level(dvlsa.lvalue[i]);
            String pattern = dvlsa.svalue[i].toLowerCase();
            Vector dl = Util.instance().get_device_list(pattern);
            Iterator it = dl.iterator();
            while (it.hasNext()) {
                Logger logger = ((DeviceImpl)it.next()).get_logger();
                if (logger == null) {
                    String desc = "Internal error. Got invalid logger for device " + logger.getName();
                    Except.throw_exception("API_InternalError", desc, "Logging::set_logging_level");
                }
                logger.setLevel(level);
                Util.out4.println("Logging level set to " + level.toString() + " for device " + logger.getName());
            }
        }
    }

    public DevVarLongStringArray get_logging_level(String[] dvsa) throws DevFailed {
        int i;
        Vector<String> tmp_name = new Vector<String>();
        Vector<Level> tmp_level = new Vector<Level>();
        for (i = 0; i < dvsa.length; ++i) {
            Vector dl = Util.instance().get_device_list(dvsa[i].toLowerCase());
            for (DeviceImpl dev : dl) {
                tmp_name.addElement(dev.get_name());
                tmp_level.addElement(dev.get_logger().getLevel());
            }
        }
        DevVarLongStringArray dvlsa = new DevVarLongStringArray();
        dvlsa.lvalue = new int[tmp_level.size()];
        dvlsa.svalue = new String[tmp_name.size()];
        i = 0;
        Iterator name_it = tmp_name.iterator();
        Iterator level_it = tmp_level.iterator();
        while (name_it.hasNext() && level_it.hasNext()) {
            dvlsa.svalue[i] = (String)name_it.next();
            dvlsa.lvalue[i] = this.log4j_to_tango_level((Level)level_it.next());
            ++i;
        }
        return dvlsa;
    }

    public String[] get_logging_target(String dev_name) throws DevFailed {
        DeviceImpl dev = Util.instance().get_device_by_name(dev_name);
        Enumeration all_appenders = dev.get_logger().getAllAppenders();
        int num_appenders = 0;
        Enumeration a_shame_copy = dev.get_logger().getAllAppenders();
        while (a_shame_copy.hasMoreElements()) {
            ++num_appenders;
            a_shame_copy.nextElement();
        }
        String[] targets = new String[num_appenders];
        num_appenders = 0;
        while (all_appenders.hasMoreElements()) {
            Appender appender = (Appender)all_appenders.nextElement();
            targets[num_appenders++] = appender.getName();
        }
        return targets;
    }

    public void stop_logging() {
        Vector dl = Util.instance().get_device_list("*");
        Iterator it = dl.iterator();
        while (it.hasNext()) {
            ((DeviceImpl)it.next()).stop_logging();
        }
    }

    public void start_logging() {
        Vector dl = Util.instance().get_device_list("*");
        Iterator it = dl.iterator();
        while (it.hasNext()) {
            ((DeviceImpl)it.next()).start_logging();
        }
    }

    public void kill_zombie_appenders() {
        Vector dl = Util.instance().get_device_list("*");
        for (DeviceImpl dev : dl) {
            Logger logger = dev.get_logger();
            if (logger == null) continue;
            Enumeration all_appenders = logger.getAllAppenders();
            while (all_appenders.hasMoreElements()) {
                Appender appender = (Appender)all_appenders.nextElement();
                if (((TangoAppender)((Object)appender)).isValid()) continue;
                Util.out4.println("Removing zombie appender " + dev.get_name() + "::" + appender.getName());
                logger.removeAppender(appender);
            }
        }
    }

    private String get_target_type(String ttype_tname) {
        String[] split = null;
        try {
            split = ttype_tname.split("::");
        }
        catch (Exception e) {
            return new String("unknown");
        }
        return split[0];
    }

    private String get_target_name(String ttype_tname) {
        String[] split = null;
        try {
            split = ttype_tname.split("::");
        }
        catch (Exception e) {
            return "default";
        }
        return split.length > 1 ? split[1] : "default";
    }

    private String device_to_file_name(String dev_name) {
        return dev_name.replace('/', '_');
    }

    private void verbose(String msg) {
        if (this.cmd_line_level >= 4) {
            System.out.println(msg);
        }
    }

    public Level tango_to_log4j_level(int level) throws DevFailed {
        switch (level) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.FATAL;
            }
            case 2: {
                return Level.ERROR;
            }
            case 3: {
                return Level.WARN;
            }
            case 4: {
                return Level.INFO;
            }
            case 5: {
                return Level.DEBUG;
            }
        }
        String desc = "Invalid logging level specified (out of range)";
        Except.throw_exception("API_MethodArgument", desc, "Logging::tango_to_log4j_level");
        return Level.WARN;
    }

    public Level tango_to_log4j_level(String level) {
        if ((level = level.toUpperCase()).equals(LOGGING_LEVELS[0])) {
            return Level.OFF;
        }
        if (level.equals(LOGGING_LEVELS[1])) {
            return Level.FATAL;
        }
        if (level.equals(LOGGING_LEVELS[2])) {
            return Level.ERROR;
        }
        if (level.equals(LOGGING_LEVELS[4])) {
            return Level.INFO;
        }
        if (level.equals(LOGGING_LEVELS[5])) {
            return Level.DEBUG;
        }
        return Level.WARN;
    }

    public int log4j_to_tango_level(Level level) {
        if (level.equals(Level.OFF)) {
            return 0;
        }
        if (level.equals(Level.FATAL)) {
            return 1;
        }
        if (level.equals(Level.ERROR)) {
            return 2;
        }
        if (level.equals(Level.WARN)) {
            return 3;
        }
        if (level.equals(Level.INFO)) {
            return 4;
        }
        return 5;
    }

    public void set_rolling_file_threshold(Logger logger, long rft) {
        if (logger == null) {
            return;
        }
        if (rft < 500L) {
            rft = 500L;
        } else if (rft > 20480L) {
            rft = 20480L;
        }
        String prefix = "file::";
        Enumeration all_appenders = logger.getAllAppenders();
        while (all_appenders.hasMoreElements()) {
            Appender appender = (Appender)all_appenders.nextElement();
            if (appender.getName().indexOf(prefix) == -1) continue;
            TangoRollingFileAppender trfa = (TangoRollingFileAppender)appender;
            trfa.setMaximumFileSize(rft * 1024L);
        }
    }

    public class LoggingProperties {
        public String logging_path = null;
        public String[] logging_targets = null;
        public Level logging_level = Level.WARN;
        public long logging_rft = 2048L;
    }
}

