/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarLong64ArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStateArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULong64ArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.Device_2POA;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.Attribute;
import fr.esrf.TangoDs.BlackBox;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DServer;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.Logging;
import fr.esrf.TangoDs.MultiAttribute;
import fr.esrf.TangoDs.PollObj;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoMonitor;
import fr.esrf.TangoDs.Util;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;

public abstract class DeviceImpl
extends Device_2POA
implements TangoConst {
    protected BlackBox blackbox;
    protected int blackbox_depth;
    protected String device_name;
    protected String adm_device_name;
    protected String desc;
    protected String device_status;
    protected DevState device_state;
    protected byte[] access;
    protected int version;
    protected DeviceClass device_class;
    protected MultiAttribute dev_attr;
    protected DbDevice db_dev;
    private byte[] obj_id;
    private boolean exported = false;
    private Logger logger = null;
    private Level last_level = Level.OFF;
    private long rft = 2048L;
    private DeviceImplExt ext;

    public DeviceImpl(DeviceClass cl, String d_name, String de, DevState st, String sta) throws DevFailed {
        this.device_class = cl;
        this.device_name = d_name;
        this.desc = de;
        this.device_state = st;
        this.device_status = sta;
        this.version = 2;
        this.blackbox_depth = 0;
        this.ext = new DeviceImplExt();
        Util.instance();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer tmp_adm_name = new StringBuffer("dserver/");
        tmp_adm_name.append(Util.instance().get_ds_name());
        this.adm_device_name = tmp_adm_name.toString();
        this.init_logger();
    }

    public DeviceImpl(DeviceClass cl, String d_name) throws DevFailed {
        this.device_class = cl;
        this.device_name = d_name;
        this.desc = new String("A Tango device");
        this.device_state = DevState.UNKNOWN;
        this.device_status = new String("Not Initialised");
        this.version = 2;
        this.blackbox_depth = 0;
        this.ext = new DeviceImplExt();
        Util.instance();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer tmp_adm_name = new StringBuffer("dserver/");
        tmp_adm_name.append(Util.instance().get_ds_name());
        this.adm_device_name = tmp_adm_name.toString();
        this.init_logger();
    }

    public DeviceImpl(DeviceClass cl, String d_name, String desc) throws DevFailed {
        this.device_class = cl;
        this.device_name = d_name;
        this.desc = desc;
        this.device_state = DevState.UNKNOWN;
        this.device_status = new String("Not Initialised");
        this.version = 2;
        this.blackbox_depth = 0;
        this.ext = new DeviceImplExt();
        Util.instance();
        if (Util._UseDb) {
            this.db_dev = new DbDevice(this.device_name);
        }
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.device_name, this.device_class);
        StringBuffer tmp_adm_name = new StringBuffer("dserver/");
        tmp_adm_name.append(Util.instance().get_ds_name());
        this.adm_device_name = tmp_adm_name.toString();
        this.init_logger();
    }

    private void black_box_create() {
        this.blackbox = this.blackbox_depth == 0 ? new BlackBox() : new BlackBox(this.blackbox_depth);
    }

    private void get_dev_system_resource() throws DevFailed {
        Util.instance();
        if (Util._UseDb) {
            try {
                String[] prop_names = new String[]{"blackbox_depth", "description", "poll_ring_depth", "polled_cmd", "polled_attr", "non_auto_polled_cmd", "non_auto_polled_attr", "poll_old_factor"};
                DbDatum[] res_value = this.db_dev.get_property(prop_names);
                int i = 0;
                if (!res_value[i].is_empty()) {
                    this.blackbox_depth = res_value[i].extractLong();
                }
                if (!res_value[++i].is_empty()) {
                    this.desc = res_value[i].extractString();
                }
                if (!res_value[++i].is_empty()) {
                    this.set_poll_ring_depth(res_value[i].extractLong());
                }
                if (!res_value[++i].is_empty()) {
                    this.set_polled_cmd(res_value[i].extractStringArray());
                }
                if (!res_value[++i].is_empty()) {
                    this.set_polled_attr(res_value[i].extractStringArray());
                }
                if (!res_value[++i].is_empty()) {
                    this.set_non_auto_polled_cmd(res_value[i].extractStringArray());
                }
                if (!res_value[++i].is_empty()) {
                    this.set_non_auto_polled_attr(res_value[i].extractStringArray());
                }
                if (!res_value[++i].is_empty()) {
                    this.set_poll_old_factor(res_value[i].extractLong());
                } else {
                    this.set_poll_old_factor(4);
                }
                ++i;
            }
            catch (DevFailed e) {
                StringBuffer o = new StringBuffer("Database error while trying to retrieve device properties for device ");
                o.append(this.device_name);
                Except.throw_exception("API_DatabaseAccess", o.toString(), "DeviceImpl.get_dev_system_resource");
            }
            catch (BAD_OPERATION ex) {
                StringBuffer o = new StringBuffer("Database error while trying to retrieve device properties for device ");
                o.append(this.device_name);
                Except.throw_exception("API_DatabaseAccess", o.toString(), "DeviceImpl.get_dev_system_resource");
            }
        }
    }

    public Any command_inout(String in_cmd, Any in_any) throws DevFailed {
        Util.out4.println("DeviceImpl.command_inout(): command received : " + in_cmd);
        this.blackbox.insert_cmd(in_cmd, 1);
        Any out_any = this.device_class.command_handler(this, in_cmd, in_any);
        Util.out4.println("DeviceImpl.command_inout(): leaving method for command " + in_cmd);
        return out_any;
    }

    public Any command_inout_2(String in_cmd, Any in_data, DevSource source) throws DevFailed, SystemException {
        Util.out4.println("Device_2Impl.command_inout_2 arrived, source = " + source + ", command = " + in_cmd);
        PollObj polled_cmd = null;
        boolean polling_failed = false;
        if (source == DevSource.DEV) {
            return this.command_inout(in_cmd, in_data);
        }
        try {
            int tv_usec;
            double now_d;
            double diff_d;
            this.blackbox.insert_cmd(in_cmd, 2);
            String cmd_str = in_cmd.toLowerCase();
            this.check_command_exists(cmd_str);
            boolean found = false;
            Vector poll_list = this.get_poll_obj_list();
            for (int i = 0; i < poll_list.size(); ++i) {
                PollObj poll_obj = (PollObj)poll_list.elementAt(i);
                if (poll_obj.get_type() != 0 || !poll_obj.get_name().equals(in_cmd.toLowerCase())) continue;
                polled_cmd = poll_obj;
                found = true;
            }
            if (!found) {
                Command cmd = this.get_command(cmd_str);
                int poll_period = cmd.get_polling_period();
                if (poll_period == 0) {
                    Except.throw_exception("API_CmdNotPolled", "Command " + in_cmd + " not polled", "Device_2Impl.command_inout");
                }
                found = false;
                Vector napc = this.get_non_auto_polled_cmd();
                for (int i = 0; i < napc.size(); ++i) {
                    String s = (String)napc.elementAt(i);
                    if (!s.equals(cmd_str)) continue;
                    found = true;
                }
                if (found) {
                    Except.throw_exception("API_CmdNotPolled", "Command " + in_cmd + " not polled", "Device_2Impl.command_inout");
                } else {
                    Util tg = Util.instance();
                    DServer adm_dev = tg.get_dserver_device();
                    DevVarLongStringArray send = new DevVarLongStringArray();
                    send.lvalue = new int[1];
                    send.svalue = new String[3];
                    send.lvalue[0] = poll_period;
                    send.svalue[0] = this.device_name;
                    send.svalue[1] = "command";
                    send.svalue[2] = in_cmd;
                    adm_dev.add_obj_polling(send, false);
                    for (int i = 0; i < poll_list.size(); ++i) {
                        PollObj poll_obj = (PollObj)poll_list.elementAt(i);
                        if (poll_obj.get_type() != 0 || !poll_obj.get_name().equals(in_cmd)) continue;
                        polled_cmd = poll_obj;
                        break;
                    }
                }
            }
            if (polled_cmd == null) {
                Except.throw_exception("API_CommandNotPolled", "Command not found.", "Device_2Impl.command_inout");
            }
            if (polled_cmd.is_ring_empty()) {
                Except.throw_exception("API_NoDataYet", "No data available in cache for command " + in_cmd, "Device_2Impl.command_inout");
            }
            long ctm = System.currentTimeMillis();
            int tv_sec = (int)(ctm / 1000L);
            double last = polled_cmd.get_last_insert_date();
            if ((diff_d = (now_d = (double)(tv_sec -= 1002000000) + (double)(tv_usec = (int)(ctm - (long)(1000 * tv_sec)) * 1000) / 1000000.0) - last) > polled_cmd.get_authorized_delta()) {
                Except.throw_exception("API_NotUpdatedAnyMore", "Data in cache for command " + in_cmd + " not updated any more", "Device_2Impl.command_inout");
            }
        }
        catch (DevFailed e) {
            if (source == DevSource.CACHE) {
                throw e;
            }
            polling_failed = true;
        }
        if (source == DevSource.CACHE) {
            Util.out4.println("Device_2Impl: Returning data from polling buffer");
            return polled_cmd.get_last_cmd_result();
        }
        if (!polling_failed) {
            Util.out4.println("Device_2Impl: Returning data from polling buffer");
            return polled_cmd.get_last_cmd_result();
        }
        return this.command_inout(in_cmd, in_data);
    }

    public DevCmdHistory[] command_inout_history_2(String command, int n) throws DevFailed, SystemException {
        int in_buf;
        Util.out4.println("Device_2Impl.command_inout_history_2 arrived");
        String cmd_str = command.toLowerCase();
        this.blackbox.insert_op(16);
        this.check_command_exists(cmd_str);
        PollObj polled_cmd = null;
        Vector poll_list = this.get_poll_obj_list();
        for (int i = 0; i < poll_list.size(); ++i) {
            PollObj poll_obj = (PollObj)poll_list.elementAt(i);
            if (poll_obj.get_type() != 0 || !poll_obj.get_name().equals(cmd_str)) continue;
            polled_cmd = poll_obj;
        }
        if (polled_cmd == null) {
            Except.throw_exception("API_CmdNotPolled", "Command " + cmd_str + " not polled", "Device_2Impl.command_inout_history_2");
        }
        if (polled_cmd.is_ring_empty()) {
            Except.throw_exception("API_NoDataYet", "No data available in cache for command " + cmd_str, "Device_2Impl.command_inout_history_2");
        }
        if (n > (in_buf = polled_cmd.get_elt_nb_in_buffer())) {
            n = in_buf;
        }
        return polled_cmd.get_cmd_history(n);
    }

    public String name() {
        Util.out4.println("DeviceImpl.name() arrived");
        this.blackbox.insert_attr(1);
        Util.out4.println("Leaving DeviceImpl.name()");
        return this.device_name;
    }

    public String adm_name() {
        Util.out4.println("DeviceImpl.adm_name() arrived");
        this.blackbox.insert_attr(5);
        Util.out4.println("Leaving DeviceImpl.adm_name()");
        return this.adm_device_name;
    }

    public String description() {
        Util.out4.println("DeviceImpl.description() arrived");
        this.blackbox.insert_attr(2);
        Util.out4.println("Leaving DeviceImpl.description()");
        return this.desc;
    }

    public DevState state() {
        Util.out4.println("DeviceImpl.state() (attribute) arrived");
        this.blackbox.insert_attr(3);
        DevState tmp = null;
        try {
            tmp = this.dev_state();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        Util.out4.println("Leaving DeviceImpl.state() (attribute)");
        return tmp;
    }

    public String status() {
        Util.out4.println("DeviceImpl.status() (attibute) arrived");
        this.blackbox.insert_attr(4);
        String tmp = null;
        try {
            tmp = this.dev_status();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        Util.out4.println("Leaving DeviceImpl.status() (attribute)");
        return tmp;
    }

    public String[] black_box(int n) throws DevFailed {
        Util.out4.println("DeviceImpl.black_box() arrived");
        String[] ret = this.blackbox.read(n);
        this.blackbox.insert_op(2);
        Util.out4.println("Leaving DeviceImpl.black_box()");
        return ret;
    }

    public DevCmdInfo[] command_list_query() {
        Util.out4.println("DeviceImpl.command_list_query() arrived");
        int nb_cmd = this.device_class.get_command_list().size();
        Util.out4.println(nb_cmd + " command(s) for device");
        DevCmdInfo[] back = new DevCmdInfo[nb_cmd];
        for (int loop = 0; loop < nb_cmd; ++loop) {
            back[loop] = new DevCmdInfo();
        }
        for (int i = 0; i < nb_cmd; ++i) {
            back[i].cmd_name = ((Command)this.device_class.get_command_list().elementAt(i)).get_name();
            back[i].cmd_tag = ((Command)this.device_class.get_command_list().elementAt(i)).get_tag();
            back[i].in_type = ((Command)this.device_class.get_command_list().elementAt(i)).get_in_type();
            back[i].out_type = ((Command)this.device_class.get_command_list().elementAt(i)).get_out_type();
            String tmp_desc = ((Command)this.device_class.get_command_list().elementAt(i)).get_in_type_desc();
            back[i].in_type_desc = tmp_desc == null ? "Uninitialised" : tmp_desc;
            tmp_desc = ((Command)this.device_class.get_command_list().elementAt(i)).get_out_type_desc();
            back[i].out_type_desc = tmp_desc == null ? "Uninitialised" : tmp_desc;
        }
        this.blackbox.insert_op(5);
        Util.out4.println("Leaving DeviceImpl.command_list_query()");
        return back;
    }

    public DevCmdInfo_2[] command_list_query_2() {
        Util.out4.println("Device_2Impl.command_list_query_2 arrived");
        Vector cmd_list = this.device_class.get_command_list();
        Util.out4.println(cmd_list.size() + " command(s) for device");
        DevCmdInfo_2[] back = new DevCmdInfo_2[cmd_list.size()];
        for (int i = 0; i < cmd_list.size(); ++i) {
            Command cmd = (Command)cmd_list.elementAt(i);
            DevCmdInfo_2 tmp = new DevCmdInfo_2();
            tmp.cmd_name = cmd.get_name();
            tmp.cmd_tag = cmd.get_tag();
            tmp.level = cmd.get_disp_level();
            tmp.in_type = cmd.get_in_type();
            tmp.out_type = cmd.get_out_type();
            String str_in = cmd.get_in_type_desc();
            tmp.in_type_desc = str_in != null ? str_in : "Uninitialised";
            String str_out = cmd.get_out_type_desc();
            tmp.out_type_desc = str_out != null ? str_out : "Uninitialised";
            back[i] = tmp;
        }
        this.blackbox.insert_op(12);
        Util.out4.println("Device_2Impl.command_list_query_2 exiting");
        return back;
    }

    public DevCmdInfo_2 command_query_2(String command) throws DevFailed, SystemException {
        Util.out4.println("Device_2Impl.command_query_2(" + command + ") arrived");
        int nb_cmd = this.device_class.get_command_list().size();
        Util.out4.println(nb_cmd + " command(s) for device");
        DevCmdInfo_2 back = null;
        for (int i = 0; i < nb_cmd; ++i) {
            Command cmd = (Command)this.device_class.get_command_list().elementAt(i);
            if (!cmd.get_name().toLowerCase().equals(command.toLowerCase())) continue;
            DevCmdInfo_2 tmp = new DevCmdInfo_2();
            tmp.cmd_name = cmd.get_name();
            tmp.cmd_tag = cmd.get_tag();
            tmp.level = cmd.get_disp_level();
            tmp.in_type = cmd.get_in_type();
            tmp.out_type = cmd.get_out_type();
            String str_in = cmd.get_in_type_desc();
            tmp.in_type_desc = str_in.length() != 0 ? str_in : "Uninitialised";
            String str_out = cmd.get_out_type_desc();
            tmp.out_type_desc = str_out.length() != 0 ? str_out : "Uninitialised";
            back = tmp;
        }
        if (back == null) {
            Except.throw_exception("API_CommandNotFound", "Command " + command + " not found", "Device_2Impl.command_query_2");
        }
        this.blackbox.insert_op(12);
        Util.out4.println("Device_2Impl.command_list_query_2 exiting");
        return back;
    }

    public DevCmdInfo command_query(String command) throws DevFailed {
        int i;
        Util.out4.println("DeviceImpl.command_query() arrived");
        DevCmdInfo back = new DevCmdInfo();
        String cmd_name = command.toLowerCase();
        int nb_cmd = this.device_class.get_command_list().size();
        for (i = 0; i < nb_cmd; ++i) {
            Command cmd = (Command)this.device_class.get_command_list().elementAt(i);
            if (!cmd.get_name().toLowerCase().equals(cmd_name)) continue;
            back.cmd_name = command;
            back.cmd_tag = cmd.get_tag();
            back.in_type = cmd.get_in_type();
            back.out_type = cmd.get_out_type();
            String tmp_desc = cmd.get_in_type_desc();
            back.in_type_desc = tmp_desc == null ? "Uninitialised" : tmp_desc;
            tmp_desc = cmd.get_out_type_desc();
            if (tmp_desc == null) {
                back.out_type_desc = "Uninitialised";
                break;
            }
            back.out_type_desc = tmp_desc;
            break;
        }
        if (i == nb_cmd) {
            Util.out3.println("DeviceImpl.command_query(): operation " + command + " not found");
            Except.throw_exception("API_CommandNotFound", "Command " + command + " not found", new String("DeviceImpl.command_query()"));
        }
        this.blackbox.insert_op(6);
        Util.out4.println("Leaving DeviceImpl.command_query()");
        return back;
    }

    public DevInfo info() {
        Util.out4.println("DeviceImpl.info() arrived");
        DevInfo back = new DevInfo();
        Util tg = Util.instance();
        back.server_host = tg.get_host_name();
        back.dev_class = this.device_class.get_name();
        back.server_id = tg.get_ds_name();
        back.server_version = 2;
        back.doc_url = this.device_class.get_doc_url();
        this.blackbox.insert_op(4);
        Util.out4.println("Leaving DeviceImpl.info()");
        return back;
    }

    public void ping() {
        Util.out4.println("DeviceImpl.ping() arrived");
        this.blackbox.insert_op(3);
        Util.out4.println("Leaving DeviceImpl.ping()");
    }

    public AttributeConfig[] get_attribute_config(String[] names) throws DevFailed {
        int i;
        Util.out4.println("DeviceImpl.get_attribute_config arrived");
        int nb_attr = names.length;
        boolean all_attr = false;
        this.blackbox.insert_op(7);
        int nb_dev_attr = this.dev_attr.get_attr_nb();
        if (nb_dev_attr == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.get_attribute_config");
        }
        if (nb_attr == 1 && names[0].equals("All attributes")) {
            nb_attr = nb_dev_attr;
            all_attr = true;
        }
        AttributeConfig[] back = null;
        try {
            back = new AttributeConfig[nb_attr];
            for (i = 0; i < nb_attr; ++i) {
                back[i] = new AttributeConfig();
            }
        }
        catch (OutOfMemoryError ex) {
            Util.out3.println("Bad allocation while in DeviceImpl.get_attribute_config");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DeviceImpl.get_attribute_config");
        }
        for (i = 0; i < nb_attr; ++i) {
            Attribute attr;
            if (all_attr) {
                attr = this.dev_attr.get_attr_by_ind(i);
                attr.get_properties(back[i]);
                continue;
            }
            attr = this.dev_attr.get_attr_by_name(names[i]);
            attr.get_properties(back[i]);
        }
        Util.out4.println("Leaving DeviceImpl.get_attribute_config");
        return back;
    }

    public AttributeConfig_2[] get_attribute_config_2(String[] names) throws DevFailed, SystemException {
        Util.out4.println("Device_2Impl.get_attribute_config_2 arrived");
        int nb_attr = names.length;
        boolean all_attr = false;
        this.blackbox.insert_op(14);
        int nb_dev_attr = this.dev_attr.get_attr_nb();
        String in_name = names[0];
        if (nb_attr == 1 && in_name.equals("All attributes")) {
            nb_attr = nb_dev_attr;
            all_attr = true;
        }
        AttributeConfig_2[] back = new AttributeConfig_2[nb_attr];
        for (int i = 0; i < nb_attr; ++i) {
            Attribute attr;
            if (all_attr) {
                attr = this.dev_attr.get_attr_by_ind(i);
                back[i] = attr.get_properties_2();
                continue;
            }
            attr = this.dev_attr.get_attr_by_name(names[i]);
            back[i] = attr.get_properties_2();
        }
        Util.out4.println("Leaving Device_2Impl.get_attribute_config_2");
        return back;
    }

    public void set_attribute_config(AttributeConfig[] new_conf) throws DevFailed {
        Util.out4.println("DeviceImpl.set_attribute_config arrived");
        this.blackbox.insert_op(8);
        int nb_dev_attr = this.dev_attr.get_attr_nb();
        if (nb_dev_attr == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.set_attribute_config");
        }
        int nb_attr = new_conf.length;
        int i = 0;
        try {
            for (i = 0; i < nb_attr; ++i) {
                Attribute attr = this.dev_attr.get_attr_by_name(new_conf[i].name);
                if (Util._UseDb) {
                    attr.upd_database(new_conf[i], this.device_name);
                }
                attr.set_properties(new_conf[i], this.device_name);
            }
        }
        catch (DevFailed e) {
            this.dev_attr.get_alarm_list().removeAllElements();
            for (int j = 0; j < nb_dev_attr; ++j) {
                if (!this.dev_attr.get_attr_by_ind(j).is_alarmed()) continue;
                this.dev_attr.get_alarm_list().addElement(new Integer(j));
            }
            StringBuffer o = new StringBuffer(e.errors[0].reason);
            if (i != 0) {
                o.append("\nAll previous attribute(s) have been successfully updated");
            }
            if (i != nb_attr - 1) {
                o.append("\nAll remaining attribute(s) have not been updated");
            }
            e.errors[0].reason = o.toString();
            throw e;
        }
        this.dev_attr.get_alarm_list().removeAllElements();
        for (i = 0; i < nb_dev_attr; ++i) {
            if (!this.dev_attr.get_attr_by_ind(i).is_alarmed()) continue;
            this.dev_attr.get_alarm_list().addElement(new Integer(i));
        }
        Util.out4.println("Leaving DeviceImpl.set_attribute_config");
    }

    public AttributeValue[] read_attributes(String[] names) throws DevFailed {
        int i;
        Util.out4.println("DeviceImpl.read_attributes arrived");
        this.blackbox.insert_op(9);
        int nb_dev_attr = this.dev_attr.get_attr_nb();
        if (nb_dev_attr == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.read_attributes");
        }
        String[] real_names = null;
        int nb_names = names.length;
        if (nb_names == 1) {
            if (names[0].equals("All attributes")) {
                real_names = new String[nb_dev_attr];
                for (i = 0; i < nb_dev_attr; ++i) {
                    real_names[i] = this.dev_attr.get_attr_by_ind(i).get_name();
                }
            } else {
                real_names = names;
            }
        } else {
            real_names = names;
        }
        nb_names = real_names.length;
        Vector<Integer> wanted_attr = new Vector<Integer>();
        Vector<Integer> wanted_w_attr = new Vector<Integer>();
        for (i = 0; i < nb_names; ++i) {
            int j = this.dev_attr.get_attr_ind_by_name(real_names[i]);
            if (this.dev_attr.get_attr_by_ind(j).get_writable() == AttrWriteType.READ_WRITE) {
                wanted_w_attr.addElement(new Integer(j));
                wanted_attr.addElement(new Integer(j));
                this.dev_attr.get_attr_by_ind((Integer)wanted_attr.lastElement()).set_value_flag(false);
                continue;
            }
            if (this.dev_attr.get_attr_by_ind(j).get_writable() == AttrWriteType.WRITE) {
                wanted_w_attr.addElement(new Integer(j));
                continue;
            }
            wanted_attr.addElement(new Integer(j));
            this.dev_attr.get_attr_by_ind((Integer)wanted_attr.lastElement()).set_value_flag(false);
        }
        int nb_wanted_attr = wanted_attr.size();
        int nb_wanted_w_attr = wanted_w_attr.size();
        if (nb_wanted_attr != 0) {
            this.read_attr_hardware(wanted_attr);
        }
        for (i = 0; i < nb_wanted_attr; ++i) {
            this.read_attr(this.dev_attr.get_attr_by_ind((Integer)wanted_attr.elementAt(i)));
        }
        for (i = 0; i < nb_wanted_w_attr; ++i) {
            AttrWriteType w_type = this.dev_attr.get_attr_by_ind((Integer)wanted_w_attr.elementAt(i)).get_writable();
            if (w_type != AttrWriteType.READ_WITH_WRITE && w_type != AttrWriteType.WRITE) continue;
            this.dev_attr.get_attr_by_ind((Integer)wanted_w_attr.elementAt(i)).set_value();
        }
        AttributeValue[] back = null;
        try {
            back = new AttributeValue[nb_names];
            for (i = 0; i < nb_names; ++i) {
                back[i] = new AttributeValue();
            }
        }
        catch (OutOfMemoryError ex) {
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DeviceImpl.read_attributes");
        }
        block19: for (i = 0; i < nb_names; ++i) {
            Attribute att = this.dev_attr.get_attr_by_name(real_names[i]);
            if (!att.get_value_flag()) {
                StringBuffer o = new StringBuffer("Read value for attribute ");
                o.append(att.get_name());
                o.append(" has not been updated");
                Except.throw_exception("API_AttrValueNotSet", o.toString(), "DeviceImpl.read_attributes");
                continue;
            }
            AttrWriteType w_type = att.get_writable();
            if (w_type == AttrWriteType.READ || w_type == AttrWriteType.READ_WRITE || w_type == AttrWriteType.READ_WITH_WRITE) {
                if (w_type == AttrWriteType.READ_WRITE || w_type == AttrWriteType.READ_WITH_WRITE) {
                    this.dev_attr.add_write_value(att);
                }
                if (att.is_alarmed() && att.get_quality().value() != 1) {
                    att.check_alarm();
                }
            }
            back[i].time = att.get_when();
            back[i].quality = att.get_quality();
            back[i].name = att.get_name();
            back[i].dim_x = att.get_x();
            back[i].dim_y = att.get_y();
            Util tg = Util.instance();
            back[i].value = tg.get_orb().create_any();
            switch (att.get_data_type()) {
                case 1: {
                    DevVarBooleanArrayHelper.insert(back[i].value, att.get_boolean_value());
                    continue block19;
                }
                case 2: {
                    DevVarShortArrayHelper.insert(back[i].value, att.get_short_value());
                    continue block19;
                }
                case 6: {
                    DevVarUShortArrayHelper.insert(back[i].value, att.get_short_value());
                    continue block19;
                }
                case 3: {
                    DevVarLongArrayHelper.insert(back[i].value, att.get_long_value());
                    continue block19;
                }
                case 7: {
                    DevVarULongArrayHelper.insert(back[i].value, att.get_long_value());
                    continue block19;
                }
                case 23: {
                    DevVarLong64ArrayHelper.insert(back[i].value, att.get_long64_value());
                    continue block19;
                }
                case 24: {
                    DevVarULong64ArrayHelper.insert(back[i].value, att.get_long64_value());
                    continue block19;
                }
                case 5: {
                    DevVarDoubleArrayHelper.insert(back[i].value, att.get_double_value());
                    continue block19;
                }
                case 8: {
                    DevVarStringArrayHelper.insert(back[i].value, att.get_string_value());
                    continue block19;
                }
                case 19: {
                    DevVarStateArrayHelper.insert(back[i].value, att.get_state_value());
                    continue block19;
                }
                default: {
                    Except.throw_exception("API_DatTypeNotSupported", "Attribute " + real_names[i] + " data type not supported !", "Device_2Impl.read_attributes()");
                }
            }
        }
        Util.out4.println("Leaving DeviceImpl.read_attributes");
        return back;
    }

    public AttributeValue[] read_attributes_2(String[] names, DevSource source) throws DevFailed {
        Util.out4.println("DeviceImpl.read_attributes_2 arrived src=" + source.value());
        if (source == DevSource.DEV) {
            return this.read_attributes(names);
        }
        boolean att_in_fault = false;
        boolean polling_failed = false;
        this.blackbox.insert_op(15);
        AttributeValue[] back = null;
        try {
            int j;
            int i;
            String att_name;
            boolean all_attr = false;
            Vector poll_list = this.get_poll_obj_list();
            int nb_poll = poll_list.size();
            int nb_names = names.length;
            String[] real_names = names;
            if (nb_names == 1 && (att_name = names[0]).equals("All attributes")) {
                PollObj poll_obj;
                all_attr = true;
                int nb_real = 0;
                for (i = 0; i < nb_poll; ++i) {
                    poll_obj = (PollObj)poll_list.elementAt(i);
                    if (poll_obj.get_type() != 1) continue;
                    ++nb_real;
                }
                real_names = new String[nb_real];
                j = 0;
                for (i = 0; i < nb_poll && j < nb_real; ++i) {
                    poll_obj = (PollObj)poll_list.elementAt(i);
                    if (poll_obj.get_type() != 1) continue;
                    real_names[j++] = poll_obj.get_name();
                }
            }
            if (!all_attr) {
                for (i = 0; i < real_names.length; ++i) {
                    this.dev_attr.get_attr_ind_by_name(real_names[i]);
                }
            }
            Vector<String> non_polled = new Vector<String>();
            if (!all_attr) {
                for (i = 0; i < real_names.length; ++i) {
                    PollObj poll_obj;
                    for (j = 0; j < nb_poll && !(poll_obj = (PollObj)poll_list.elementAt(j)).get_name().equals(real_names[i].toLowerCase()); ++j) {
                    }
                    if (j != nb_poll) continue;
                    non_polled.add(real_names[i]);
                }
            }
            Vector<Integer> poll_period = new Vector<Integer>();
            if (non_polled.size() != 0) {
                for (i = 0; i < non_polled.size(); ++i) {
                    String non_polled_name = (String)non_polled.elementAt(i);
                    Attribute att = this.dev_attr.get_attr_by_name(non_polled_name);
                    poll_period.add(new Integer(att.get_polling_period()));
                    if (att.get_polling_period() == 0) {
                        Except.throw_exception("API_AttrNotPolled", "Attribute " + non_polled_name + " not polled", "Device_2Impl.read_attributes");
                        continue;
                    }
                    boolean found = false;
                    Vector napa = this.get_non_auto_polled_attr();
                    for (j = 0; j < napa.size(); ++j) {
                        String napa_str = ((String)napa.elementAt(j)).toLowerCase();
                        if (!napa_str.equals(non_polled_name.toLowerCase())) continue;
                        found = true;
                    }
                    if (!found) continue;
                    Except.throw_exception("API_AttrNotPolled", "Attribute " + non_polled_name + " not polled", "Device_2Impl.read_attributes");
                }
                Util tg = Util.instance();
                DServer adm_dev = tg.get_dserver_device();
                DevVarLongStringArray send = new DevVarLongStringArray();
                send.lvalue = new int[1];
                send.svalue = new String[3];
                send.svalue[0] = this.device_name;
                send.svalue[1] = "attribute";
                for (i = 0; i < non_polled.size(); ++i) {
                    send.lvalue[0] = (Integer)poll_period.elementAt(i);
                    send.svalue[2] = (String)non_polled.elementAt(i);
                    adm_dev.add_obj_polling(send, false);
                }
            }
            int nb_attr = real_names.length;
            back = new AttributeValue[nb_attr];
            for (i = 0; i < nb_attr; ++i) {
                AttributeValue att_val;
                int tv_usec;
                double now_d;
                double diff_d;
                PollObj polled_attr = null;
                for (j = 0; j < poll_list.size(); ++j) {
                    PollObj poll_obj = (PollObj)poll_list.elementAt(j);
                    if (poll_obj.get_type() != 1 || !poll_obj.get_name().toLowerCase().equals(real_names[i].toLowerCase())) continue;
                    polled_attr = poll_obj;
                    break;
                }
                if (polled_attr.is_ring_empty()) {
                    Except.throw_exception("API_NoDataYet", "No data available in cache for attribute " + real_names[i], "Device_2Impl.read_attributes");
                }
                long ctm = System.currentTimeMillis();
                int tv_sec = (int)(ctm / 1000L);
                double last = polled_attr.get_last_insert_date();
                if ((diff_d = (now_d = (double)(tv_sec -= 1002000000) + (double)(tv_usec = (int)(ctm - (long)(1000 * tv_sec)) * 1000) / 1000000.0) - last) > polled_attr.get_authorized_delta()) {
                    Except.throw_exception("API_NotUpdatedAnyMore", "Data in cache for attribute " + real_names[i] + " not updated any more", "Device_2Impl.read_attributes");
                }
                back[i] = att_val = polled_attr.get_last_attr_value();
            }
        }
        catch (DevFailed e) {
            if (source == DevSource.CACHE) {
                throw e;
            }
            if (att_in_fault) {
                throw e;
            }
            polling_failed = true;
        }
        if (source == DevSource.CACHE_DEV && polling_failed) {
            return this.read_attributes(names);
        }
        Util.out4.println("Device_2Impl: Returning attribute(s) value from polling buffer");
        return back;
    }

    public DevAttrHistory[] read_attribute_history_2(String name, int n) throws DevFailed, SystemException {
        int in_buf;
        Util.out4.println("Device_2Impl.read_attribute_history_2 arrived");
        this.blackbox.insert_op(17);
        Vector poll_list = this.get_poll_obj_list();
        int nb_poll = poll_list.size();
        Attribute att = this.dev_attr.get_attr_by_name(name);
        String attr_str = name.toLowerCase();
        PollObj polled_attr = null;
        for (int i = 0; i < nb_poll; ++i) {
            PollObj poll_obj = (PollObj)poll_list.elementAt(i);
            if (poll_obj.get_type() != 1 || !poll_obj.get_name().equals(attr_str)) continue;
            polled_attr = poll_obj;
            break;
        }
        if (polled_attr == null) {
            Except.throw_exception("API_AttrNotPolled", "No data available in cache for attribute " + attr_str, "Device_2Impl.read_attribute_history_2");
        }
        if (polled_attr.is_ring_empty()) {
            Except.throw_exception("API_NoDataYet", "No data available in cache for attribute " + attr_str, "Device_2Impl.read_attribute_history_2");
        }
        if (n > (in_buf = polled_attr.get_elt_nb_in_buffer())) {
            n = in_buf;
        }
        DevAttrHistory[] histo = polled_attr.get_attr_history(n, att.get_data_type());
        return histo;
    }

    public void write_attributes(AttributeValue[] values) throws DevFailed {
        Util.out4.println("DeviceImpl.write_attributes arrived");
        this.blackbox.insert_op(10);
        int nb_dev_attr = this.dev_attr.get_attr_nb();
        if (nb_dev_attr == 0) {
            Except.throw_exception("API_AttrNotFound", "The device does not have any attribute", "DeviceImpl.write_attributes");
        }
        long nb_updated_attr = values.length;
        Vector<Integer> updated_attr = new Vector<Integer>();
        int i = 0;
        i = 0;
        while ((long)i < nb_updated_attr) {
            updated_attr.addElement(new Integer(this.dev_attr.get_attr_ind_by_name(values[i].name)));
            ++i;
        }
        i = 0;
        while ((long)i < nb_updated_attr) {
            if (this.dev_attr.get_attr_by_ind((Integer)updated_attr.elementAt(i)).get_writable() == AttrWriteType.READ || this.dev_attr.get_attr_by_ind((Integer)updated_attr.elementAt(i)).get_writable() == AttrWriteType.READ_WITH_WRITE) {
                StringBuffer o = new StringBuffer("Attribute ");
                o.append(this.dev_attr.get_attr_by_ind((Integer)updated_attr.elementAt(i)).get_name());
                o.append(" is not writable");
                Except.throw_exception("API_AttrNotWritable", o.toString(), "DeviceImpl.write_attributes");
            }
            ++i;
        }
        i = 0;
        while ((long)i < nb_updated_attr) {
            try {
                this.dev_attr.get_w_attr_by_ind((Integer)updated_attr.elementAt(i)).set_write_value(values[i].value);
            }
            catch (DevFailed ex) {
                for (int j = 0; j < i; ++j) {
                    this.dev_attr.get_w_attr_by_ind((Integer)updated_attr.elementAt(j)).rollback();
                }
                throw ex;
            }
            ++i;
        }
        this.write_attr_hardware(updated_attr);
        Util.out4.println("Leaving DeviceImpl.write_attributes");
    }

    public void remove_attribute(String attname) throws DevFailed {
        if (Util._UseDb) {
            DeviceProxy dev = new DeviceProxy(this.device_name);
            DbAttribute da = dev.get_attribute_property(attname);
            dev.delete_attribute_property(da);
        }
        this.dev_attr.remove_attribute(attname);
    }

    public void add_attribute(Attr new_attr) throws DevFailed {
        int i;
        Vector attr_list = this.device_class.get_class_attr().get_attr_list();
        int old_attr_nb = attr_list.size();
        String attr_name = new_attr.get_name();
        boolean already_there = true;
        try {
            this.dev_attr.get_attr_by_name(attr_name);
        }
        catch (DevFailed ex) {
            already_there = false;
        }
        if (already_there) {
            return;
        }
        for (i = 0; i < old_attr_nb && !((Attr)attr_list.elementAt(i)).get_name().equals(attr_name); ++i) {
        }
        if (i == old_attr_nb) {
            attr_list.addElement(new_attr);
            this.device_class.get_class_attr().init_class_attribute(this.device_class.get_name(), old_attr_nb);
        }
        this.dev_attr.add_attribute(this.device_name, this.device_class, i);
    }

    public DevState dev_state() throws DevFailed {
        Vector attr_list;
        int nb_wanted_attr;
        if ((this.device_state.value() == 0 || this.device_state.value() == 11) && (nb_wanted_attr = (attr_list = this.dev_attr.get_alarm_list()).size()) != 0) {
            this.read_attr_hardware(attr_list);
            for (int i = 0; i < nb_wanted_attr; ++i) {
                Attribute att = this.dev_attr.get_attr_by_ind((Integer)attr_list.elementAt(i));
                att.wanted_date(false);
                try {
                    this.read_attr(att);
                }
                catch (DevFailed ex) {
                    att.wanted_date(true);
                    throw ex;
                }
                att.wanted_date(true);
            }
            if (this.dev_attr.check_alarm()) {
                this.device_state = DevState.ALARM;
            }
        }
        return this.device_state;
    }

    public String dev_status() throws DevFailed {
        if (this.device_state.value() == 11 || this.device_state.value() == 0) {
            StringBuffer alarm_status = new StringBuffer(this.device_status);
            this.dev_attr.read_alarm(alarm_status);
            return alarm_status.toString();
        }
        return this.device_status;
    }

    public void read_attr_hardware(Vector attr_list) throws DevFailed {
    }

    public void read_attr(Attribute attr) throws DevFailed {
    }

    public void write_attr_hardware(Vector attr_list) throws DevFailed {
    }

    public void always_executed_hook() throws DevFailed {
    }

    public abstract void init_device() throws DevFailed;

    public POA _default_POA() {
        return Util.instance().get_poa();
    }

    public String get_status() {
        return this.device_status;
    }

    public void set_status(String new_status) {
        this.device_status = new_status;
    }

    public DevState get_state() {
        return this.device_state;
    }

    public void set_state(DevState new_state) {
        this.device_state = new_state;
    }

    public String get_name() {
        return this.device_name;
    }

    public DeviceClass get_device_class() {
        return this.device_class;
    }

    public void set_device_attr(MultiAttribute new_multi_attr) {
        this.dev_attr = new_multi_attr;
    }

    public DbDevice get_db_device() {
        return this.db_dev;
    }

    public byte[] get_obj_id() {
        return this.obj_id;
    }

    public void set_obj_id(byte[] id) {
        this.obj_id = id;
    }

    void set_exported_flag(boolean exp) {
        this.exported = exp;
    }

    boolean get_exported_flag() {
        return this.exported;
    }

    public Logger get_logger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.get_name().toLowerCase());
            this.logger.setAdditivity(false);
            this.logger.setLevel(Level.WARN);
            this.last_level = Level.WARN;
        }
        return this.logger;
    }

    public void init_logger() {
        try {
            Level cmd_line_level;
            Util.out4.println("Initializing logging for " + this.get_name());
            Util util = Util.instance();
            int trace_level = util.get_trace_level();
            boolean level_set_from_cmd_line = true;
            if (trace_level <= 0) {
                level_set_from_cmd_line = false;
                cmd_line_level = Level.OFF;
            } else {
                cmd_line_level = trace_level <= 2 ? Level.INFO : Level.DEBUG;
            }
            if (level_set_from_cmd_line) {
                try {
                    Logging.instance().add_logging_target(this.get_logger(), "console");
                }
                catch (DevFailed df) {
                    // empty catch block
                }
            }
            if (!Util._UseDb) {
                Util.out4.println("Not using the database. Logging Intialization complete");
                return;
            }
            Logging.LoggingProperties properties = Logging.instance().get_logging_properties(this.get_logger(), util.get_database());
            if (properties == null) {
                Util.out4.println("Failed to obtain logging properties from database");
                Util.out4.println("Aborting logging intialization");
                this.get_logger().setLevel(cmd_line_level);
                return;
            }
            if (!level_set_from_cmd_line) {
                this.get_logger().setLevel(properties.logging_level);
                Util.out4.println("Logging level set to " + properties.logging_level.toString());
            } else {
                this.get_logger().setLevel(cmd_line_level);
            }
            this.last_level = this.get_logger().getLevel();
            if (this.rft != properties.logging_rft) {
                this.rft = properties.logging_rft;
                Util.out4.println("Rolling threshold changed to " + String.valueOf(this.rft));
            }
            if (properties.logging_targets != null) {
                Util.out4.println("Adding logging targets (" + properties.logging_targets.length + " entries in db)");
                for (int i = 0; i < properties.logging_targets.length; ++i) {
                    try {
                        Logging.instance().add_logging_target(this.get_logger(), properties.logging_targets[i]);
                        continue;
                    }
                    catch (DevFailed e) {
                        // empty catch block
                    }
                }
            }
            Logging.instance().set_rolling_file_threshold(this.get_logger(), this.rft);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop_logging() {
        this.last_level = this.get_logger().getLevel();
        this.get_logger().setLevel(Level.OFF);
    }

    public void start_logging() {
        this.get_logger().setLevel(this.last_level);
    }

    void check_command_exists(String cmd_name) throws DevFailed {
        Vector cmd_list = this.device_class.get_command_list();
        for (int i = 0; i < cmd_list.size(); ++i) {
            Command cmd = (Command)cmd_list.elementAt(i);
            if (!cmd.get_name().toLowerCase().equals(cmd_name)) continue;
            if (cmd.get_in_type() != 0) {
                Except.throw_exception("API_IncompatibleCmdArgumentType", "Command " + cmd_name + " cannot be polled because it needs input value", "DeviceImpl.check_command_exists");
            }
            return;
        }
        Except.throw_exception("API_CommandNotFound", "Command " + cmd_name + " not found", "DeviceImpl.check_command_exists");
    }

    int get_poll_old_factor() {
        return this.ext.poll_old_factor;
    }

    void set_poll_old_factor(int fact) {
        this.ext.poll_old_factor = fact;
    }

    boolean is_polled() {
        return this.ext.polled;
    }

    void is_polled(boolean b) {
        this.ext.polled = b;
    }

    Vector get_poll_obj_list() {
        return this.ext.poll_obj_list;
    }

    int get_poll_ring_depth() {
        return this.ext.poll_ring_depth;
    }

    public void set_poll_ring_depth(int size) {
        this.ext.poll_ring_depth = size;
    }

    MultiAttribute get_device_attr() {
        return this.dev_attr;
    }

    void set_non_auto_polled_cmd(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.ext.non_auto_polled_cmd.add(s[i]);
        }
    }

    Vector get_non_auto_polled_cmd() {
        return this.ext.non_auto_polled_cmd;
    }

    void set_non_auto_polled_attr(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.ext.non_auto_polled_attr.add(s[i]);
        }
    }

    Vector get_non_auto_polled_attr() {
        return this.ext.non_auto_polled_attr;
    }

    public void set_polled_cmd(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.ext.polled_cmd.add(s[i]);
        }
    }

    Vector get_polled_cmd() {
        return this.ext.polled_cmd;
    }

    public void set_polled_attr(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.ext.polled_attr.add(s[i]);
        }
    }

    Vector get_polled_attr() {
        return this.ext.polled_attr;
    }

    TangoMonitor get_dev_monitor() {
        return this.ext.only_one;
    }

    synchronized PollObj get_polled_obj_by_type_name(int obj_type, String obj_name) throws DevFailed {
        Vector po_list = this.get_poll_obj_list();
        for (int i = 0; i < po_list.size(); ++i) {
            PollObj polled_obj = (PollObj)po_list.elementAt(i);
            if (polled_obj.get_type_i() != obj_type || polled_obj.get_name_i() != obj_name) continue;
            return polled_obj;
        }
        Except.throw_exception("API_PollObjNotFound", obj_name + " not found in list of polled object", "DeviceImpl.get_polled_obj_by_type_name");
        return null;
    }

    Command get_command(String cmd_name) throws DevFailed {
        Command ret_cmd = null;
        Vector cmd_list = this.device_class.get_command_list();
        for (int i = 0; i < cmd_list.size(); ++i) {
            Command cmd = (Command)cmd_list.elementAt(i);
            if (!cmd.get_name().toLowerCase().equals(cmd_name.toLowerCase())) continue;
            ret_cmd = cmd;
        }
        if (ret_cmd == null) {
            Except.throw_exception("API_CommandNotFound", "Command " + cmd_name + " not found", "DeviceImpl.get_command");
        }
        return ret_cmd;
    }

    class DeviceImplExt {
        boolean exported = false;
        boolean polled = false;
        int poll_ring_depth = 0;
        int poll_old_factor;
        Vector polled_cmd = new Vector();
        Vector polled_attr = new Vector();
        Vector non_auto_polled_cmd = new Vector();
        Vector non_auto_polled_attr = new Vector();
        Vector poll_obj_list = new Vector();
        TangoMonitor only_one = new TangoMonitor();

        DeviceImplExt() {
        }
    }
}

