/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.TacoApi.TacoCommand;
import fr.esrf.TacoApi.TacoConst;
import fr.esrf.TacoApi.TacoData;
import fr.esrf.TacoApi.TacoDevice;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.StringTokenizer;
import java.util.Vector;

public class TacoTangoDevice
implements TangoConst,
TacoConst {
    private String devname;
    private TacoDevice dev;
    private AttributeConfig[] att_config = null;

    TacoTangoDevice(String devname, String nethost) throws DevFailed {
        if (nethost != null && nethost.length() > 0) {
            devname = "//" + nethost + "/" + devname;
        }
        try {
            this.dev = new TacoDevice(devname);
            this.devname = devname;
            this.set_source(DevSource.CACHE_DEV);
            this.set_rpc_protocol(1);
        }
        catch (TacoException e) {
            Except.throw_exception("Api_TacoFailed", e.getErrorString(), "TacoTangoDevice.TacoTangoDevice(" + devname + ")");
        }
    }

    DeviceData command_inout(String command, DeviceData argin) throws DevFailed {
        DeviceData argout = null;
        try {
            TacoData taco_in = this.dataToTaco(argin);
            TacoData taco_out = this.dev.putGet(this.dev.getCommandCode(command), taco_in);
            argout = this.dataToTango(taco_out);
        }
        catch (TacoException e) {
            String desc = e.getErrorString();
            if (desc.startsWith("Device command") && desc.indexOf("not found for this device") > 0) {
                Except.throw_exception("TACO_CMD_UNAVAILABLE", desc, "TacoTangoDevice.command_inout() for " + this.devname);
            }
            Except.throw_exception("Api_TacoFailed", desc, "TacoTangoDevice.command_inout() for " + this.devname);
        }
        return argout;
    }

    CommandInfo[] commandListQuery() throws DevFailed {
        CommandInfo[] info = null;
        try {
            TacoCommand[] tc = this.dev.commandQuery();
            info = this.dataToTango(tc);
        }
        catch (TacoException e) {
            Except.throw_exception("Api_TacoFailed", e.getErrorString(), "TacoTangoDevice.commandListQuery() for " + this.devname);
        }
        return info;
    }

    CommandInfo commandQuery(String cmdname) throws DevFailed {
        CommandInfo argout = null;
        CommandInfo[] cmdlist = this.commandListQuery();
        for (int i = 0; i < cmdlist.length && argout == null; ++i) {
            if (!cmdlist[i].cmd_name.equals(cmdname)) continue;
            argout = cmdlist[i];
        }
        if (argout == null) {
            Except.throw_exception("Api_TacoFailed", "Command '" + cmdname + "' Not Found", "TacoTangoDevice.commandQuery() for " + this.devname);
        }
        return argout;
    }

    void set_rpc_protocol(int mode) throws DevFailed {
        if (mode != 0 && mode != 1) {
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Bad parameter for dev_rpc_protocol command", "TacoTangoDevice.dev_rpc_protocol()");
        }
        try {
            this.dev.setProtocol(mode);
        }
        catch (TacoException e) {
            Except.throw_exception("Api_TacoFailed", e.getErrorString(), "TacoTangoDevice.commandListQuery() for " + this.devname);
        }
    }

    int get_rpc_protocol() throws DevFailed {
        return this.dev.getProtocol();
    }

    int get_rpc_timeout() throws DevFailed {
        return this.dev.getTimeout();
    }

    void set_rpc_timeout(int millis) throws DevFailed {
        this.dev.setTimeout(millis);
    }

    String[] dev_inform() throws DevFailed {
        String[] info = null;
        info = this.infoToTango(this.dev.getInfo());
        return info;
    }

    public DbDatum[] get_property(String[] propnames) throws DevFailed {
        DbDatum[] data = new DbDatum[propnames.length];
        try {
            for (int i = 0; i < propnames.length; ++i) {
                data[i] = new DbDatum(propnames[i]);
                String[] val = this.dev.getResource(propnames[i]);
                if (val.length <= 0) continue;
                data[i].insert(val[i]);
            }
        }
        catch (TacoException e) {
            Except.throw_exception("Api_TacoFailed", e.getErrorString(), "TacoTangoDevice.get_property() for " + this.devname);
        }
        return data;
    }

    void set_source(DevSource src) throws DevFailed {
        try {
            if (src == DevSource.DEV) {
                this.dev.setSource(0);
            } else if (src == DevSource.CACHE_DEV) {
                this.dev.setSource(2);
            } else if (src == DevSource.CACHE) {
                this.dev.setSource(1);
            }
        }
        catch (TacoException e) {
            Except.throw_exception("Api_TacoFailed", e.getErrorString(), "TacoTangoDevice.set_source() for " + this.devname);
        }
    }

    DevSource get_source() {
        DevSource src = DevSource.DEV;
        switch (this.dev.getSource()) {
            case 0: {
                src = DevSource.DEV;
                break;
            }
            case 2: {
                src = DevSource.CACHE_DEV;
                break;
            }
            case 1: {
                src = DevSource.CACHE;
            }
        }
        return src;
    }

    private String onlyAttName(String fullname) throws DevFailed {
        int start = 0;
        int i = 0;
        while (i < 3) {
            if ((start = fullname.indexOf(47, start)) < 0) {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute name not found in " + fullname, "TacoTangoDevice.onlyAttName()");
            }
            ++i;
            ++start;
        }
        return fullname.substring(start).trim();
    }

    private String fullName(String attname) {
        String fullname = new String(this.devname + "/" + attname);
        if (fullname.startsWith("//")) {
            return fullname.substring(fullname.indexOf(47, 2) + 1);
        }
        return fullname;
    }

    String[] get_attribute_list() throws DevFailed {
        if (this.att_config == null) {
            this.initializeAttributeConfig();
        }
        String[] list = new String[this.att_config.length];
        for (int i = 0; i < this.att_config.length; ++i) {
            list[i] = this.att_config[i].name;
        }
        return list;
    }

    AttributeConfig[] get_attribute_config(String[] attrnames) throws DevFailed {
        if (this.att_config == null) {
            this.initializeAttributeConfig();
        }
        if (attrnames[0].equals("All attributes")) {
            return this.att_config;
        }
        AttributeConfig[] tmp_config = new AttributeConfig[attrnames.length];
        for (int i = 0; i < attrnames.length; ++i) {
            for (int j = 0; j < this.att_config.length; ++j) {
                if (!this.att_config[j].name.equals(attrnames[i])) continue;
                tmp_config[i] = this.att_config[j];
            }
        }
        if (tmp_config[0] == null) {
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute " + attrnames[0] + " not found !", "TacoTangoDevice.get_attribute_config() for " + this.devname);
        }
        return tmp_config;
    }

    DeviceAttribute[] read_attribute(String[] attrnames) throws DevFailed {
        if (this.att_config == null) {
            this.initializeAttributeConfig();
        }
        DeviceData argout = this.command_inout("DevReadSigValues", null);
        CommandInfo cmd = this.commandQuery("DevReadSigValues");
        int orig_type = cmd.out_type;
        int[] l_val = null;
        float[] f_val = null;
        double[] d_val = null;
        switch (orig_type) {
            case 11: {
                l_val = argout.extractLongArray();
                break;
            }
            case 12: {
                f_val = argout.extractFloatArray();
                break;
            }
            case 13: {
                d_val = argout.extractDoubleArray();
            }
        }
        DeviceAttribute[] dev_attr = new DeviceAttribute[attrnames.length];
        block10: for (int i = 0; i < attrnames.length; ++i) {
            int idx = -1;
            for (int j = 0; j < this.att_config.length; ++j) {
                if (!this.att_config[j].name.toLowerCase().equals(attrnames[i].toLowerCase())) continue;
                idx = j;
            }
            if (idx == -1) {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute " + attrnames[i] + " not found for this device", "TacoTangoDevice.read_attribute()  for " + this.devname);
            }
            switch (orig_type) {
                case 11: {
                    dev_attr[i] = new DeviceAttribute(attrnames[i], l_val[idx]);
                    continue block10;
                }
                case 12: {
                    dev_attr[i] = new DeviceAttribute(attrnames[i], f_val[idx]);
                    continue block10;
                }
                case 13: {
                    dev_attr[i] = new DeviceAttribute(attrnames[i], d_val[idx]);
                }
            }
        }
        return dev_attr;
    }

    private void initializeAttributeConfig() throws DevFailed {
        int nb_x = 1;
        int nb_y = 0;
        int attr_data_type = 5;
        String[] attr_strconfig = new String[]{};
        try {
            DeviceData argout = this.command_inout("DevGetSigConfig", null);
            attr_strconfig = argout.extractStringArray();
            CommandInfo cmd = this.commandQuery("DevReadSigValues");
            attr_data_type = this.getAttrDataType(cmd.out_type);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("TACO_CMD_UNAVAILABLE")) {
                this.att_config = new AttributeConfig[0];
                return;
            }
            throw e;
        }
        int modulo = Integer.parseInt(attr_strconfig[0]);
        this.att_config = new AttributeConfig[attr_strconfig.length / modulo];
        String[] attrnames = new String[attr_strconfig.length / modulo];
        int i = 0;
        for (int j = 1; j < attr_strconfig.length; j += modulo) {
            attrnames[i++] = this.onlyAttName(attr_strconfig[j]);
        }
        this.att_config = new AttributeConfig[attrnames.length];
        for (i = 0; i < attrnames.length; ++i) {
            String fullname = this.fullName(attrnames[i]);
            boolean found = false;
            for (int j = 1; j < attr_strconfig.length; j += modulo) {
                if (!attr_strconfig[j].equals(fullname)) continue;
                String description = "";
                String label = "";
                String unit = "";
                String standard_unit = "";
                String display_unit = "";
                String format = "";
                String min_value = "";
                String max_value = "";
                String min_alarm = "";
                String max_alarm = "";
                String writable_attr_name = "";
                String[] extensions = null;
                found = true;
                String not_specified = "No Description";
                if (!attr_strconfig[j + 4].equals(not_specified)) {
                    description = attr_strconfig[j + 4];
                }
                if (!attr_strconfig[j + 1].equals(not_specified = "Not specified")) {
                    label = attr_strconfig[j + 1];
                }
                if (!attr_strconfig[j + 2].equals(not_specified)) {
                    unit = attr_strconfig[j + 2];
                    display_unit = attr_strconfig[j + 2];
                }
                if (!attr_strconfig[j + 3].equals(not_specified)) {
                    format = attr_strconfig[j + 3];
                }
                if (!attr_strconfig[j + 5].equals(not_specified)) {
                    max_value = attr_strconfig[j + 5];
                }
                if (!attr_strconfig[j + 6].equals(not_specified)) {
                    min_value = attr_strconfig[j + 6];
                }
                if (!attr_strconfig[j + 7].equals(not_specified)) {
                    max_alarm = attr_strconfig[j + 7];
                }
                if (!attr_strconfig[j + 8].equals(not_specified)) {
                    min_alarm = attr_strconfig[j + 8];
                }
                this.att_config[i] = new AttributeConfig(attrnames[i], AttrWriteType.READ, AttrDataFormat.SCALAR, attr_data_type, nb_x, nb_y, description, label, unit, standard_unit, display_unit, format, min_value, max_value, min_alarm, max_alarm, writable_attr_name, extensions);
            }
            if (found) continue;
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute name not found for this device", "TacoTangoDevice.initializeAttributeConfig()");
        }
    }

    private int getAttrDataType(int type) throws DevFailed {
        int attr_data_type = 0;
        switch (type) {
            case 11: {
                attr_data_type = 3;
                break;
            }
            case 12: {
                attr_data_type = 4;
                break;
            }
            case 13: {
                attr_data_type = 5;
                break;
            }
            default: {
                try {
                    Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Output parameter not supported.", "TacoTangoDevice.getAttrDataType()");
                    break;
                }
                catch (DevFailed e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        return attr_data_type;
    }

    int tangoType(int taco_type) {
        int tango_type = 0;
        switch (taco_type) {
            case 0: {
                tango_type = 0;
                break;
            }
            case 2: {
                tango_type = 2;
                break;
            }
            case 70: {
                tango_type = 6;
                break;
            }
            case 3: {
                tango_type = 3;
                break;
            }
            case 71: {
                tango_type = 7;
                break;
            }
            case 6: {
                tango_type = 8;
                break;
            }
            case 4: {
                tango_type = 4;
                break;
            }
            case 5: {
                tango_type = 5;
                break;
            }
            case 10: {
                tango_type = 10;
                break;
            }
            case 72: {
                tango_type = 14;
                break;
            }
            case 11: {
                tango_type = 11;
                break;
            }
            case 69: {
                tango_type = 15;
                break;
            }
            case 12: {
                tango_type = 12;
                break;
            }
            case 68: {
                tango_type = 13;
                break;
            }
            case 24: {
                tango_type = 16;
                break;
            }
            case 8: {
                tango_type = 12;
            }
        }
        return tango_type;
    }

    private TacoData dataToTaco(DeviceData argin) throws DevFailed {
        TacoData argout = new TacoData();
        if (argin == null) {
            return argout;
        }
        int type = argin.getType();
        switch (type) {
            case -1: 
            case 0: {
                break;
            }
            case 2: {
                argout.insert(argin.extractShort());
                break;
            }
            case 10: {
                argout.insert(argin.extractShortArray());
                break;
            }
            case 6: {
                argout.insertUShort(argin.extractUShort());
                break;
            }
            case 14: {
                argout.insertUShortArray(argin.extractUShortArray());
                break;
            }
            case 3: {
                argout.insert(argin.extractLong());
                break;
            }
            case 11: {
                argout.insert(argin.extractLongArray());
                break;
            }
            case 7: {
                argout.insertULong((long)argin.extractLong());
                break;
            }
            case 15: {
                break;
            }
            case 4: {
                argout.insert(argin.extractFloat());
                break;
            }
            case 12: {
                argout.insert(argin.extractFloatArray());
                break;
            }
            case 13: {
                argout.insert(argin.extractDouble());
                break;
            }
            case 5: {
                argout.insert(argin.extractDoubleArray());
                break;
            }
            case 8: {
                argout.insert(argin.extractString());
                break;
            }
            case 16: {
                argout.insert(argin.extractStringArray());
                break;
            }
            default: {
                Except.throw_exception("Api_TacoFailed", "Argument type " + Tango_CmdArgTypeName[type] + "Not supported for TACO interface", "TacoTangoDevice.dataToTaco() for " + this.devname);
            }
        }
        return argout;
    }

    private DeviceData dataToTango(TacoData argin) throws DevFailed {
        int type = argin.getType();
        DeviceData argout = new DeviceData();
        try {
            switch (type) {
                case -1: 
                case 0: {
                    break;
                }
                case 2: {
                    argout.insert(argin.extractShort());
                    break;
                }
                case 70: {
                    argout.insert_us(argin.extractUShort());
                    break;
                }
                case 3: {
                    argout.insert(argin.extractLong());
                    break;
                }
                case 71: {
                    argout.insert_ul(argin.extractULong());
                    break;
                }
                case 6: {
                    argout.insert(argin.extractString());
                    break;
                }
                case 4: {
                    argout.insert(argin.extractFloat());
                    break;
                }
                case 5: {
                    argout.insert(argin.extractDouble());
                    break;
                }
                case 10: {
                    argout.insert(argin.extractShortArray());
                    break;
                }
                case 72: {
                    argout.insert_us(argin.extractUShortArray());
                    break;
                }
                case 11: {
                    argout.insert(argin.extractLongArray());
                    break;
                }
                case 69: {
                    argout.insert_ul(argin.extractULongArray());
                    break;
                }
                case 12: {
                    argout.insert(argin.extractFloatArray());
                    break;
                }
                case 68: {
                    argout.insert(argin.extractDoubleArray());
                    break;
                }
                case 24: {
                    argout.insert(argin.extractStringArray());
                    break;
                }
                case 8: {
                    float[] ret = new float[3];
                    float[] f = argin.extractStateFloatReadPoint();
                    ret[0] = argin.extractStateofSFR();
                    ret[1] = f[0];
                    ret[2] = f[1];
                    argout.insert(ret);
                }
            }
        }
        catch (TacoException e) {
            Except.throw_exception("Api_TacoFailed", e.getErrorString(), "TacoTangoDevice.dataToTango() for " + this.devname);
        }
        return argout;
    }

    CommandInfo[] dataToTango(TacoCommand[] tc) {
        CommandInfo[] info = new CommandInfo[tc.length];
        for (int i = 0; i < tc.length; ++i) {
            info[i] = new CommandInfo(tc[i].cmdName, 0, this.tangoType(tc[i].inType), this.tangoType(tc[i].outType), tc[i].inName, tc[i].outName);
        }
        return info;
    }

    String[] infoToTango(String taco_info) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(taco_info, "\n");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        String[] info = new String[v.size()];
        if (v.size() == 1) {
            info[0] = (String)v.elementAt(0);
        } else {
            for (int i = 0; i < v.size(); ++i) {
                String line = (String)v.elementAt(i);
                int idx = line.indexOf(":");
                info[i] = idx > 0 ? line.substring(idx + 1).trim() : line;
            }
        }
        return info;
    }
}

