/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.Group;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.Group.GroupAttrReply;
import fr.esrf.TangoApi.Group.GroupAttrReplyList;
import fr.esrf.TangoApi.Group.GroupCmdReply;
import fr.esrf.TangoApi.Group.GroupCmdReplyList;
import fr.esrf.TangoApi.Group.GroupElement;
import fr.esrf.TangoApi.Group.GroupReply;
import fr.esrf.TangoApi.Group.GroupReplyList;
import java.util.TreeMap;

class GroupDeviceElement
extends GroupElement {
    private DeviceProxy proxy;
    private TreeMap arp;

    public GroupDeviceElement(String string) {
        super(string);
        try {
            this.proxy = new DeviceProxy(string);
        }
        catch (DevFailed devFailed) {
            this.proxy = null;
        }
        this.arp = new TreeMap();
    }

    void dump_i(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println("`-> Device: " + this.get_name());
    }

    DeviceProxy get_device_i(String string) {
        return this.name_equals(string) ? this.proxy : null;
    }

    DeviceProxy get_device_i(int n) {
        return --n == 0 ? this.proxy : null;
    }

    boolean ping_i(boolean bl) {
        if (this.proxy == null) {
            return false;
        }
        try {
            this.proxy.ping();
        }
        catch (DevFailed devFailed) {
            return false;
        }
        return true;
    }

    void set_timeout_millis(int n, boolean bl) throws DevFailed {
        try {
            this.proxy.set_timeout_millis(n);
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "unknown exception caught";
            devErrorArray[0].desc = "unknown error";
            devErrorArray[0].origin = "GroupDeviceElemnt.set_indidual_timeout_millis";
            DevFailed devFailed = new DevFailed(devErrorArray);
            throw devFailed;
        }
    }

    int command_inout_asynch_i(String string, boolean bl, boolean bl2, int n) throws DevFailed {
        block5: {
            try {
                int n2 = this.proxy.command_inout_asynch(string, bl);
                if (!bl) {
                    this.arp.put(new Integer(n), new AsynchRequest(n2, string));
                }
            }
            catch (DevFailed devFailed) {
                if (!bl) {
                    this.arp.put(new Integer(n), new AsynchRequest(-1, string, devFailed));
                }
            }
            catch (Exception exception) {
                if (bl) break block5;
                DevError[] devErrorArray = new DevError[]{new DevError()};
                devErrorArray[0].severity = ErrSeverity.ERR;
                devErrorArray[0].reason = "unknown exception caught";
                devErrorArray[0].desc = "unknown error";
                devErrorArray[0].origin = "GroupDeviceElemnt.command_inout";
                DevFailed devFailed = new DevFailed(devErrorArray);
                this.arp.put(new Integer(n), new AsynchRequest(-1, string, devFailed));
            }
        }
        return n;
    }

    int command_inout_asynch_i(String string, DeviceData deviceData, boolean bl, boolean bl2, int n) throws DevFailed {
        block5: {
            try {
                int n2 = this.proxy.command_inout_asynch(string, deviceData, bl);
                if (!bl) {
                    this.arp.put(new Integer(n), new AsynchRequest(n2, string));
                }
            }
            catch (DevFailed devFailed) {
                if (!bl) {
                    this.arp.put(new Integer(n), new AsynchRequest(-1, string, devFailed));
                }
            }
            catch (Exception exception) {
                if (bl) break block5;
                DevError[] devErrorArray = new DevError[]{new DevError()};
                devErrorArray[0].severity = ErrSeverity.ERR;
                devErrorArray[0].reason = "unknown exception caught";
                devErrorArray[0].desc = "unknown error";
                devErrorArray[0].origin = "GroupDeviceElemnt.command_inout";
                DevFailed devFailed = new DevFailed(devErrorArray);
                this.arp.put(new Integer(n), new AsynchRequest(-1, string, devFailed));
            }
        }
        return n;
    }

    GroupCmdReplyList command_inout_reply_i(int n, int n2, boolean bl) throws DevFailed {
        Integer n3 = new Integer(n);
        GroupCmdReplyList groupCmdReplyList = new GroupCmdReplyList();
        AsynchRequest asynchRequest = (AsynchRequest)this.arp.get(n3);
        if (asynchRequest == null) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "API_BadAsynPollId";
            devErrorArray[0].desc = "Invalid asynch. request identifier specified";
            devErrorArray[0].origin = "GroupDeviceElement.command_inout_reply";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupCmdReplyList.add(new GroupCmdReply(this.get_name(), "unknown", devFailed));
            return groupCmdReplyList;
        }
        if (asynchRequest.req_id == -1) {
            groupCmdReplyList.add(new GroupCmdReply(this.get_name(), asynchRequest.obj_name, asynchRequest.exception));
            this.arp.remove(n3);
            return groupCmdReplyList;
        }
        try {
            DeviceData deviceData = this.proxy.command_inout_reply(asynchRequest.req_id, n2);
            groupCmdReplyList.add(new GroupCmdReply(this.get_name(), asynchRequest.obj_name, deviceData));
        }
        catch (AsynReplyNotArrived asynReplyNotArrived) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "API_AsynReplyNotArrived";
            devErrorArray[0].desc = "No reply for asynch request";
            devErrorArray[0].origin = "GroupDeviceElement.command_inout_reply";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupCmdReplyList.add(new GroupCmdReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        catch (DevFailed devFailed) {
            groupCmdReplyList.add(new GroupCmdReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        catch (Exception exception) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "unknown exception caught";
            devErrorArray[0].desc = "unknown error";
            devErrorArray[0].origin = "GroupDeviceElemnt.command_inout";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupCmdReplyList.add(new GroupCmdReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        this.arp.remove(n3);
        return groupCmdReplyList;
    }

    int read_attribute_asynch_i(String string, boolean bl, int n) throws DevFailed {
        try {
            int n2 = this.proxy.read_attribute_asynch(string);
            this.arp.put(new Integer(n), new AsynchRequest(n2, string));
        }
        catch (DevFailed devFailed) {
            this.arp.put(new Integer(n), new AsynchRequest(-1, string, devFailed));
        }
        catch (Exception exception) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "unknown exception caught";
            devErrorArray[0].desc = "unknown error";
            devErrorArray[0].origin = "GroupDeviceElemnt.read_attribute";
            DevFailed devFailed = new DevFailed(devErrorArray);
            this.arp.put(new Integer(n), new AsynchRequest(-1, string, devFailed));
        }
        return n;
    }

    GroupAttrReplyList read_attribute_reply_i(int n, int n2, boolean bl) throws DevFailed {
        Integer n3 = new Integer(n);
        GroupAttrReplyList groupAttrReplyList = new GroupAttrReplyList();
        AsynchRequest asynchRequest = (AsynchRequest)this.arp.get(n3);
        if (asynchRequest == null) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "API_BadAsynPollId";
            devErrorArray[0].desc = "Invalid asynch. request identifier specified";
            devErrorArray[0].origin = "GroupDeviceElement.read_attribute_reply";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupAttrReplyList.add(new GroupAttrReply(this.get_name(), "unknown", devFailed));
            return groupAttrReplyList;
        }
        if (asynchRequest.req_id == -1) {
            groupAttrReplyList.add(new GroupAttrReply(this.get_name(), asynchRequest.obj_name, asynchRequest.exception));
            this.arp.remove(n3);
            return groupAttrReplyList;
        }
        try {
            DeviceAttribute[] deviceAttributeArray = this.proxy.read_attribute_reply(asynchRequest.req_id, n2);
            groupAttrReplyList.add(new GroupAttrReply(this.get_name(), asynchRequest.obj_name, deviceAttributeArray[0]));
        }
        catch (AsynReplyNotArrived asynReplyNotArrived) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "API_AsynReplyNotArrived";
            devErrorArray[0].desc = "No reply for asynch request";
            devErrorArray[0].origin = "GroupDeviceElement.read_attribute_reply";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupAttrReplyList.add(new GroupAttrReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        catch (DevFailed devFailed) {
            groupAttrReplyList.add(new GroupAttrReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        catch (Exception exception) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "unknown exception caught";
            devErrorArray[0].desc = "unknown error";
            devErrorArray[0].origin = "GroupDeviceElemnt.read_attribute_reply";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupAttrReplyList.add(new GroupAttrReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        this.arp.remove(n3);
        return groupAttrReplyList;
    }

    int write_attribute_asynch_i(DeviceAttribute deviceAttribute, boolean bl, int n) throws DevFailed {
        try {
            int n2 = this.proxy.write_attribute_asynch(deviceAttribute);
            this.arp.put(new Integer(n), new AsynchRequest(n2, deviceAttribute.getName()));
        }
        catch (DevFailed devFailed) {
            this.arp.put(new Integer(n), new AsynchRequest(-1, deviceAttribute.getName(), devFailed));
        }
        catch (Exception exception) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "unknown exception caught";
            devErrorArray[0].desc = "unknown error";
            devErrorArray[0].origin = "GroupDeviceElemnt.write_attribute";
            DevFailed devFailed = new DevFailed(devErrorArray);
            this.arp.put(new Integer(n), new AsynchRequest(-1, deviceAttribute.getName(), devFailed));
        }
        return n;
    }

    GroupReplyList write_attribute_reply_i(int n, int n2, boolean bl) throws DevFailed {
        Integer n3 = new Integer(n);
        GroupReplyList groupReplyList = new GroupReplyList();
        AsynchRequest asynchRequest = (AsynchRequest)this.arp.get(n3);
        if (asynchRequest == null) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "API_BadAsynPollId";
            devErrorArray[0].desc = "Invalid asynch. request identifier specified";
            devErrorArray[0].origin = "GroupDeviceElement.write_attribute_reply";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupReplyList.add(new GroupReply(this.get_name(), "unknown", devFailed));
            return groupReplyList;
        }
        if (asynchRequest.req_id == -1) {
            groupReplyList.add(new GroupReply(this.get_name(), asynchRequest.obj_name, asynchRequest.exception));
            this.arp.remove(n3);
            return groupReplyList;
        }
        try {
            this.proxy.write_attribute_reply(asynchRequest.req_id, n2);
            groupReplyList.add(new GroupReply(this.get_name(), asynchRequest.obj_name));
        }
        catch (AsynReplyNotArrived asynReplyNotArrived) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "API_AsynReplyNotArrived";
            devErrorArray[0].desc = "No reply for asynch request";
            devErrorArray[0].origin = "GroupDeviceElement.write_attribute_reply";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupReplyList.add(new GroupReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        catch (DevFailed devFailed) {
            groupReplyList.add(new GroupReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        catch (Exception exception) {
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].reason = "unknown exception caught";
            devErrorArray[0].desc = "unknown error";
            devErrorArray[0].origin = "GroupDeviceElemnt.write_attribute_reply";
            DevFailed devFailed = new DevFailed(devErrorArray);
            groupReplyList.add(new GroupReply(this.get_name(), asynchRequest.obj_name, devFailed));
        }
        this.arp.remove(n3);
        return groupReplyList;
    }

    private class AsynchRequest {
        public int req_id;
        public String obj_name;
        public DevFailed exception;

        AsynchRequest(int n, String string) {
            this.req_id = n;
            this.obj_name = string;
            this.exception = null;
        }

        AsynchRequest(int n, String string, DevFailed devFailed) {
            this.req_id = n;
            this.obj_name = string;
            this.exception = devFailed;
        }
    }
}

