/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.AttributeConfig_3;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.AttributeValueListHelper;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevAttrHistory_3;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevFailedHelper;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.MultiDevFailed;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AsyncCallObject;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.CallbackThread;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.DServer;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.T2Ttypes;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.NamedDevFailed;
import fr.esrf.TangoDs.NamedDevFailedList;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Request;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UnknownUserException;

public class DeviceProxy
extends Connection
implements ApiDefs {
    private static final boolean check_idl = false;
    private DbDevice db_dev;
    private String full_class_name;
    private DeviceProxy adm_dev = null;
    private String[] attnames_array = null;

    public DeviceProxy() throws DevFailed {
    }

    public DeviceProxy(String devname) throws DevFailed {
        super(devname);
        this.full_class_name = "DeviceProxy(" + this.name() + ")";
    }

    DeviceProxy(String devname, boolean check_access) throws DevFailed {
        super(devname, check_access);
        this.full_class_name = "DeviceProxy(" + this.name() + ")";
    }

    public DeviceProxy(String devname, String ior) throws DevFailed {
        super(devname, ior, 1);
        this.full_class_name = "DeviceProxy(" + this.name() + ")";
    }

    public DeviceProxy(String devname, String host, String port) throws DevFailed {
        super(devname, host, port);
        this.full_class_name = "DeviceProxy(" + this.name() + ")";
    }

    protected void import_admin_device(String origin) throws DevFailed {
        this.checkIfTango(origin);
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.adm_dev == null) {
            DServer ds = DServer.get_instance();
            this.adm_dev = ds.get_adm_dev(this.adm_name());
        }
    }

    public String name() {
        return this.get_name();
    }

    public String status() throws DevFailed {
        return this.status(true);
    }

    public String status(boolean src) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            String status = "Unknown";
            int retries = this.transparent_reconnection ? 2 : 1;
            boolean done = false;
            for (int i = 0; i < retries && !done; ++i) {
                try {
                    if (src) {
                        status = this.device.status();
                    } else {
                        DeviceData argout = this.command_inout("Status");
                        status = argout.extractString();
                    }
                    done = true;
                    continue;
                }
                catch (Exception e) {
                    if ((e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || e.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) && i == 0) {
                        this.device = null;
                        this.build_connection();
                        if (i != retries - 1) continue;
                        status = "Unknown";
                        this.throw_dev_failed(e, "DeviceProxy.status()", false);
                        continue;
                    }
                    status = "Unknown";
                    this.throw_dev_failed(e, "DeviceProxy.status()", false);
                }
            }
            return status;
        }
        return this.command_inout("DevStatus").extractString();
    }

    public DevState state() throws DevFailed {
        return this.state(true);
    }

    public DevState state(boolean src) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            DevState state = DevState.UNKNOWN;
            int retries = this.transparent_reconnection ? 2 : 1;
            boolean done = false;
            for (int i = 0; i < retries && !done; ++i) {
                try {
                    if (src) {
                        state = this.device.state();
                    } else {
                        DeviceData argout = this.command_inout("State");
                        state = argout.extractDevState();
                    }
                    done = true;
                    continue;
                }
                catch (Exception e) {
                    if ((e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || e.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) && i == 0) {
                        this.device = null;
                        this.build_connection();
                        if (i != retries - 1) continue;
                        state = DevState.UNKNOWN;
                        this.throw_dev_failed(e, "DeviceProxy.state()", false);
                        continue;
                    }
                    state = DevState.UNKNOWN;
                    this.throw_dev_failed(e, "DeviceProxy.state()", false);
                }
            }
            return state;
        }
        DeviceData argout = this.command_inout("DevState");
        short state = argout.extractShort();
        return T2Ttypes.tangoState(state);
    }

    public CommandInfo command_query(String cmdname) throws DevFailed {
        CommandInfo info;
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            if (this.device_2 != null) {
                DevCmdInfo_2 tmp = this.device_2.command_query_2(cmdname);
                info = new CommandInfo(tmp);
            } else {
                DevCmdInfo tmp = this.device.command_query(cmdname);
                info = new CommandInfo(tmp);
            }
        } else {
            info = this.taco_device.commandQuery(cmdname);
        }
        return info;
    }

    public String get_class() throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_class");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_class");
        return this.db_dev.get_class();
    }

    public String[] get_class_inheritance() throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_class_inheritance");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_class_inheritance");
        return this.db_dev.get_class_inheritance();
    }

    public void put_alias(String aliasname) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_alias()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_alias");
        this.db_dev.put_alias(aliasname);
    }

    public String get_alias() throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_alias()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_alias");
        return this.db_dev.get_alias();
    }

    public DeviceInfo get_info() throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").import_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        if (this.url.protocol == 0) {
            return this.db_dev.get_info();
        }
        return null;
    }

    public DbDevImportInfo import_device() throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").import_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        if (this.url.protocol == 0) {
            return this.db_dev.import_device();
        }
        return new DbDevImportInfo(this.dev_inform());
    }

    public void export_device(DbDevExportInfo devinfo) throws DevFailed {
        this.checkIfTango("export_device");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").export_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.db_dev.export_device(devinfo);
    }

    public void unexport_device() throws DevFailed {
        this.checkIfTango("unexport_device");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").unexport_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.db_dev.unexport_device();
    }

    public void add_device(DbDevInfo devinfo) throws DevFailed {
        this.checkIfTango("add_device");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").add_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.db_dev.add_device(devinfo);
    }

    public void delete_device() throws DevFailed {
        this.checkIfTango("delete_device");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").add_device()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.db_dev.delete_device();
    }

    public String[] get_property_list(String wildcard) throws DevFailed {
        this.checkIfTango("get_property_list");
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_property_list()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        return this.db_dev.get_property_list(wildcard);
    }

    public DbDatum[] get_property(String[] propnames) throws DevFailed {
        if (this.url.protocol == 0) {
            if (!this.url.use_db) {
                Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_property()");
            }
            if (this.db_dev == null) {
                this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
            }
            return this.db_dev.get_property(propnames);
        }
        return this.taco_device.get_property(propnames);
    }

    public DbDatum get_property(String propname) throws DevFailed {
        if (this.url.protocol == 0) {
            if (!this.url.use_db) {
                Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_property()");
            }
            if (this.db_dev == null) {
                this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
            }
            return this.db_dev.get_property(propname);
        }
        String[] propnames = new String[]{propname};
        return this.taco_device.get_property(propnames)[0];
    }

    public DbDatum[] get_property(DbDatum[] properties) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_property");
        return this.db_dev.get_property(properties);
    }

    public void put_property(DbDatum prop) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_property");
        DbDatum[] properties = new DbDatum[]{prop};
        this.put_property(properties);
    }

    public void put_property(DbDatum[] properties) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_property");
        this.db_dev.put_property(properties);
    }

    public void delete_property(String[] propnames) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(propnames);
    }

    public void delete_property(String propname) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(propname);
    }

    public void delete_property(DbDatum[] properties) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(properties);
    }

    public String[] get_attribute_list() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            String[] wildcard = new String[]{this.device_3 != null ? "All attributes_3" : "All attributes"};
            AttributeInfo[] ac = this.get_attribute_config(wildcard);
            String[] result = new String[ac.length];
            for (int i = 0; i < ac.length; ++i) {
                result[i] = ac[i].name;
            }
            return result;
        }
        return this.taco_device.get_attribute_list();
    }

    public void put_attribute_property(DbAttribute[] attr) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_attribute_property");
        this.db_dev.put_attribute_property(attr);
    }

    public void put_attribute_property(DbAttribute attr) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").put_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_attribute_property");
        this.db_dev.put_attribute_property(attr);
    }

    public void delete_attribute_property(String attname, String[] propnames) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(attname, propnames);
    }

    public void delete_attribute_property(String attname, String propname) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(attname, propname);
    }

    public void delete_attribute_property(DbAttribute attr) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(attr);
    }

    public void delete_attribute_property(DbAttribute[] attr) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(attr);
    }

    public DbAttribute[] get_attribute_property(String[] attnames) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_attribute_property");
        return this.db_dev.get_attribute_property(attnames);
    }

    public DbAttribute get_attribute_property(String attname) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").get_attribute_property()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_attribute_property");
        return this.db_dev.get_attribute_property(attname);
    }

    public void delete_attribute(String attname) throws DevFailed {
        if (!this.url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + this.name() + " do not use database", "DeviceProxy(" + this.name() + ").delete_attribute()");
        }
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute");
        this.db_dev.delete_attribute(attname);
    }

    public AttributeInfo[] get_attribute_info(String[] attnames) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            AttributeConfig[] ac = null;
            AttributeConfig_2[] ac_2 = null;
            if (this.url.protocol == 0) {
                if (this.device_2 != null) {
                    ac_2 = this.device_2.get_attribute_config_2(attnames);
                } else {
                    ac = this.device.get_attribute_config(attnames);
                }
            } else {
                ac = this.taco_device.get_attribute_config(attnames);
            }
            int size = ac_2 != null ? ac_2.length : ac.length;
            AttributeInfo[] result = new AttributeInfo[size];
            for (int i = 0; i < size; ++i) {
                result[i] = ac_2 != null ? new AttributeInfo(ac_2[i]) : new AttributeInfo(ac[i]);
            }
            return result;
        }
        catch (DevFailed e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.throw_dev_failed(e, "get_attribute_config", true);
            return null;
        }
    }

    public AttributeInfoEx[] get_attribute_info_ex(String[] attnames) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            AttributeInfoEx[] result = null;
            AttributeConfig_3[] ac_3 = null;
            AttributeConfig_2[] ac_2 = null;
            AttributeConfig[] ac = null;
            if (this.url.protocol == 0) {
                if (this.device_3 != null) {
                    ac_3 = this.device_3.get_attribute_config_3(attnames);
                } else if (this.device_2 != null) {
                    ac_2 = this.device_2.get_attribute_config_2(attnames);
                } else {
                    Except.throw_non_supported_exception("TangoApi_IDL_NOT_SUPPORTED", "Not supported by the IDL version used by device", new String(this.full_class_name + ".get_attribute_info_ex()"));
                }
            } else {
                ac = this.taco_device.get_attribute_config(attnames);
            }
            int size = ac_3 != null ? ac_3.length : (ac_2 != null ? ac_2.length : ac.length);
            result = new AttributeInfoEx[size];
            for (int i = 0; i < size; ++i) {
                if (ac_3 != null) {
                    result[i] = new AttributeInfoEx(ac_3[i]);
                    continue;
                }
                if (ac_2 != null) {
                    result[i] = new AttributeInfoEx(ac_2[i]);
                    continue;
                }
                if (ac == null) continue;
                result[i] = new AttributeInfoEx(ac[i]);
            }
            return result;
        }
        catch (DevFailed e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.throw_dev_failed(e, "get_attribute_config_ex", true);
            return null;
        }
    }

    public AttributeInfo[] get_attribute_config(String[] attnames) throws DevFailed {
        return this.get_attribute_info(attnames);
    }

    public AttributeInfo get_attribute_info(String attname) throws DevFailed {
        String[] attnames = ApiUtil.toStringArray(attname);
        AttributeInfo[] ac = this.get_attribute_info(attnames);
        return ac[0];
    }

    public AttributeInfoEx get_attribute_info_ex(String attname) throws DevFailed {
        String[] attnames = ApiUtil.toStringArray(attname);
        AttributeInfoEx[] ac = this.get_attribute_info_ex(attnames);
        return ac[0];
    }

    public AttributeInfo get_attribute_config(String attname) throws DevFailed {
        return this.get_attribute_info(attname);
    }

    public AttributeInfo[] get_attribute_info() throws DevFailed {
        String[] attnames = new String[]{this.device_3 != null ? "All attributes_3" : "All attributes"};
        AttributeInfo[] ac = this.get_attribute_info(attnames);
        return ac;
    }

    public AttributeInfoEx[] get_attribute_info_ex() throws DevFailed {
        String[] attnames = new String[]{this.device_3 != null ? "All attributes_3" : "All attributes"};
        AttributeInfoEx[] ac = this.get_attribute_info_ex(attnames);
        return ac;
    }

    public AttributeInfo[] get_attribute_config() throws DevFailed {
        return this.get_attribute_info();
    }

    public void set_attribute_info(AttributeInfo[] attr) throws DevFailed {
        this.checkIfTango("set_attribute_config");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            AttributeConfig[] config = new AttributeConfig[attr.length];
            for (int i = 0; i < attr.length; ++i) {
                config[i] = attr[i].get_attribute_config_obj();
            }
            this.device.set_attribute_config(config);
        }
        catch (DevFailed e) {
            throw e;
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "set_attribute_info", true);
        }
    }

    public void set_attribute_info(AttributeInfoEx[] attr) throws DevFailed {
        this.checkIfTango("set_attribute_config");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            if (this.device_3 != null) {
                AttributeConfig_3[] config = new AttributeConfig_3[attr.length];
                for (int i = 0; i < attr.length; ++i) {
                    config[i] = attr[i].get_attribute_config_obj_3();
                }
                this.device_3.set_attribute_config_3(config);
            } else {
                AttributeConfig[] config = new AttributeConfig[attr.length];
                for (int i = 0; i < attr.length; ++i) {
                    config[i] = attr[i].get_attribute_config_obj();
                }
                this.device.set_attribute_config(config);
            }
        }
        catch (DevFailed e) {
            throw e;
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "set_attribute_info", true);
        }
    }

    public void set_attribute_config(AttributeInfo[] attr) throws DevFailed {
        this.set_attribute_info(attr);
    }

    public DeviceAttribute read_attribute(String attname) throws DevFailed {
        String[] names = ApiUtil.toStringArray(attname);
        DeviceAttribute[] attval = this.read_attribute(names);
        return attval[0];
    }

    public AttributeValue read_attribute_value(String attname) throws DevFailed {
        this.checkIfTango("read_attribute_value");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.attnames_array == null) {
            this.attnames_array = new String[1];
        }
        this.attnames_array[0] = attname;
        try {
            AttributeValue[] attrval = this.device_2 != null ? this.device_2.read_attributes_2(this.attnames_array, this.dev_src) : this.device.read_attributes(this.attnames_array);
            return attrval[0];
        }
        catch (DevFailed e) {
            Except.throw_connection_failed(e, "TangoApi_CANNOT_READ_ATTRIBUTE", "Cannot read attribute:   " + attname, new String(this.full_class_name + ".read_attribute()"));
            return null;
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "device.read_attributes()", false);
            return null;
        }
    }

    public DeviceAttribute[] read_attribute(String[] attnames) throws DevFailed {
        DeviceAttribute[] attr;
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        AttributeValue[] attrval = new AttributeValue[]{};
        AttributeValue_3[] attrval_3 = new AttributeValue_3[]{};
        if (this.url.protocol == 0) {
            int i;
            boolean done = false;
            int retries = this.transparent_reconnection ? 2 : 1;
            for (i = 0; i < retries && !done; ++i) {
                try {
                    if (this.device_3 != null) {
                        attrval_3 = this.device_3.read_attributes_3(attnames, this.dev_src);
                    } else {
                        attrval = this.device_2 != null ? this.device_2.read_attributes_2(attnames, this.dev_src) : this.device.read_attributes(attnames);
                    }
                    done = true;
                    continue;
                }
                catch (DevFailed e) {
                    StringBuffer sb = new StringBuffer(attnames[0]);
                    for (int j = 1; j < attnames.length; ++j) {
                        sb.append(", " + attnames[j]);
                    }
                    Except.throw_connection_failed(e, "TangoApi_CANNOT_READ_ATTRIBUTE", "Cannot read attribute(s):   " + sb.toString(), new String(this.full_class_name + ".read_attribute()"));
                    continue;
                }
                catch (Exception e) {
                    if ((e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || e.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) && i == 0) {
                        this.device = null;
                        this.ior = null;
                        this.build_connection();
                        if (i != retries - 1) continue;
                        this.throw_dev_failed(e, "device.read_attributes()", false);
                        continue;
                    }
                    this.throw_dev_failed(e, "device.read_attributes()", false);
                }
            }
            if (this.device_3 != null) {
                attr = new DeviceAttribute[attrval_3.length];
                for (i = 0; i < attrval_3.length; ++i) {
                    attr[i] = new DeviceAttribute(attrval_3[i]);
                }
            } else {
                attr = new DeviceAttribute[attrval.length];
                for (i = 0; i < attrval.length; ++i) {
                    attr[i] = new DeviceAttribute(attrval[i]);
                }
            }
        } else {
            attr = this.taco_device.read_attribute(attnames);
        }
        return attr;
    }

    public void write_attribute(DeviceAttribute devattr) throws DevFailed {
        this.checkIfTango("write_attribute");
        try {
            DeviceAttribute[] array = new DeviceAttribute[]{devattr};
            this.write_attribute(array);
        }
        catch (NamedDevFailedList e) {
            NamedDevFailed namedDF = e.elementAt(0);
            DevFailed df = new DevFailed(namedDF.err_stack);
            throw df;
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "device.write_attributes()", false);
        }
    }

    public void write_attribute(DeviceAttribute[] devattr) throws DevFailed {
        this.checkIfTango("write_attribute");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.access == 0) {
            Except.throw_connection_failed("TangoApi_READ_ONLY_MODE", this.devname + ".write_attribute()  is not authorized !", "DeviceProxy.write_attribute()");
        }
        AttributeValue[] attrval = new AttributeValue[devattr.length];
        for (int i = 0; i < devattr.length; ++i) {
            attrval[i] = devattr[i].getAttributeValueObject_2();
        }
        boolean done = false;
        int retries = this.transparent_reconnection ? 2 : 1;
        for (int i = 0; i < retries && !done; ++i) {
            try {
                if (this.device_3 != null) {
                    this.device_3.write_attributes_3(attrval);
                } else {
                    this.device.write_attributes(attrval);
                }
                done = true;
                continue;
            }
            catch (DevFailed e) {
                throw e;
            }
            catch (MultiDevFailed e) {
                throw new NamedDevFailedList(e, this.name(), "DeviceProxy.write_attribute", "MultiDevFailed");
            }
            catch (Exception e) {
                if ((e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || e.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) && i == 0) {
                    this.device = null;
                    this.ior = null;
                    this.build_connection();
                    if (i != retries - 1) continue;
                    this.throw_dev_failed(e, "device.read_attributes()", false);
                    continue;
                }
                this.throw_dev_failed(e, "device.write_attributes()", false);
            }
        }
    }

    public DeviceProxy get_adm_dev() throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("get_adm_dev");
        }
        return this.adm_dev;
    }

    private void poll_object(String objname, String objtype, int period) throws DevFailed {
        DevVarLongStringArray lsa = new DevVarLongStringArray();
        lsa.lvalue = new int[1];
        lsa.svalue = new String[3];
        lsa.svalue[0] = this.devname;
        lsa.svalue[1] = objtype;
        lsa.svalue[2] = objname;
        lsa.lvalue[0] = period;
        if (this.adm_dev == null) {
            this.import_admin_device("poll_object");
        }
        DeviceData argin = new DeviceData();
        argin.insert(lsa);
        try {
            this.adm_dev.command_inout("AddObjPolling", argin);
        }
        catch (DevFailed e) {
            for (int i = 0; i < e.errors.length; ++i) {
                if (!e.errors[i].reason.equals("API_AlreadyPolled")) continue;
                this.adm_dev.command_inout("UpdObjPollingPeriod", argin);
                return;
            }
            Except.throw_communication_failed(e, "TangoApi_CANNOT_POLL_OBJECT", "Cannot poll object " + objname, new String(this.full_class_name + ".poll_object()"));
        }
    }

    public void poll_command(String cmdname, int period) throws DevFailed {
        this.poll_object(cmdname, "command", period);
    }

    public void poll_attribute(String attname, int period) throws DevFailed {
        this.poll_object(attname, "attribute", period);
    }

    private void remove_poll_object(String objname, String objtype) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("remove_poll_object");
        }
        DeviceData argin = new DeviceData();
        String[] params = new String[]{this.devname, objtype, objname};
        argin.insert(params);
        this.adm_dev.command_inout("RemObjPolling", argin);
    }

    public void stop_poll_command(String cmdname) throws DevFailed {
        this.remove_poll_object(cmdname, "command");
    }

    public void stop_poll_attribute(String attname) throws DevFailed {
        this.remove_poll_object(attname, "attribute");
    }

    public String[] polling_status() throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("polling_status");
        }
        DeviceData argin = new DeviceData();
        argin.insert(this.devname);
        DeviceData argout = this.adm_dev.command_inout("DevPollStatus", argin);
        String[] results = argout.extractStringArray();
        return results;
    }

    public DeviceDataHistory[] command_history(String cmdname, int nb) throws DevFailed {
        this.checkIfTango("command_history");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        DeviceDataHistory[] histo = new DeviceDataHistory[]{};
        try {
            DevCmdHistory[] cmd_histo = this.device_2.command_inout_history_2(cmdname, nb);
            histo = new DeviceDataHistory[cmd_histo.length];
            for (int i = 0; i < cmd_histo.length; ++i) {
                histo[i] = new DeviceDataHistory(cmdname, cmd_histo[i]);
            }
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            Except.throw_communication_failed(e.toString(), "API has catched a RuntimeException", this.full_class_name + ".command_history()");
        }
        return histo;
    }

    public DeviceDataHistory[] attribute_history(String attname, int nb) throws DevFailed {
        this.checkIfTango("attribute_history");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        DeviceDataHistory[] histo = new DeviceDataHistory[]{};
        try {
            if (this.device_3 != null) {
                DevAttrHistory_3[] att_histo = this.device_3.read_attribute_history_3(attname, nb);
                histo = new DeviceDataHistory[att_histo.length];
                for (int i = 0; i < att_histo.length; ++i) {
                    histo[i] = new DeviceDataHistory(att_histo[i]);
                }
            } else if (this.device_2 != null) {
                DevAttrHistory[] att_histo = this.device_2.read_attribute_history_2(attname, nb);
                histo = new DeviceDataHistory[att_histo.length];
                for (int i = 0; i < att_histo.length; ++i) {
                    histo[i] = new DeviceDataHistory(att_histo[i]);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            Except.throw_communication_failed(e.toString(), "API has catched a RuntimeException", this.full_class_name + ".attribute_history()");
        }
        return histo;
    }

    public DeviceDataHistory[] command_history(String cmdname) throws DevFailed {
        int hist_depth = 10;
        DbDatum data = this.get_property("poll_ring_depth");
        if (!data.is_empty()) {
            hist_depth = data.extractLong();
        }
        return this.command_history(cmdname, hist_depth);
    }

    public DeviceDataHistory[] attribute_history(String attname) throws DevFailed {
        int hist_depth = 10;
        DbDatum data = this.get_property("poll_ring_depth");
        if (!data.is_empty()) {
            hist_depth = data.extractLong();
        }
        return this.attribute_history(attname, hist_depth);
    }

    public int command_inout_asynch(String cmdname, DeviceData data_in) throws DevFailed {
        return this.command_inout_asynch(cmdname, data_in, false);
    }

    public int command_inout_asynch(String cmdname) throws DevFailed {
        return this.command_inout_asynch(cmdname, new DeviceData(), false);
    }

    public int command_inout_asynch(String cmdname, boolean forget) throws DevFailed {
        return this.command_inout_asynch(cmdname, new DeviceData(), forget);
    }

    public int command_inout_asynch(String cmdname, DeviceData data_in, boolean forget) throws DevFailed {
        Database db;
        this.checkIfTango("command_inout_asynch");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.access == 0 && !(db = ApiUtil.get_db_obj(this.url.host, this.url.strport)).isCommandAllowed(this.devname, cmdname)) {
            if (db.access_devfailed != null) {
                throw db.access_devfailed;
            }
            System.out.println(this.devname + "." + cmdname + "  -> TangoApi_READ_ONLY_MODE");
            Except.throw_connection_failed("TangoApi_READ_ONLY_MODE", this.devname + ".command_inout_asynch(" + cmdname + ")  is not authorized !", "Connection.command_inout_asynch()");
        }
        Request request = this.idl_version < 2 ? this.device._request("command_inout") : this.device_2._request("command_inout");
        ORB orb = ApiUtil.get_orb();
        request.add_in_arg().insert_string(cmdname);
        request.add_in_arg().insert_any(data_in.any);
        request.set_return_type(orb.get_primitive_tc(TCKind.tk_any));
        request.exceptions().add(DevFailedHelper.type());
        int id = 0;
        boolean done = false;
        int retries = this.transparent_reconnection ? 2 : 1;
        for (int i = 0; i < retries && !done; ++i) {
            try {
                if (forget) {
                    request.send_oneway();
                } else {
                    request.send_deferred();
                    String[] names = new String[]{cmdname};
                    id = ApiUtil.put_async_request(new AsyncCallObject(request, this, 0, names));
                }
                done = true;
                continue;
            }
            catch (Exception e) {
                if ((e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || e.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) && i == 0) {
                    this.device = null;
                    this.build_connection();
                    if (i != retries - 1) continue;
                    this.throw_dev_failed(e, cmdname, true);
                    continue;
                }
                this.throw_dev_failed(e, cmdname, true);
            }
        }
        return id;
    }

    public void command_inout_asynch(String cmdname, DeviceData argin, CallBack cb) throws DevFailed {
        int id = this.command_inout_asynch(cmdname, argin, false);
        ApiUtil.set_async_reply_model(id, 2);
        ApiUtil.set_async_reply_cb(id, cb);
        if (ApiUtil.get_asynch_cb_sub_model() == 0) {
            AsyncCallObject aco = ApiUtil.get_async_object(id);
            new CallbackThread(aco).start();
        }
    }

    public void command_inout_asynch(String cmdname, CallBack cb) throws DevFailed {
        this.command_inout_asynch(cmdname, new DeviceData(), cb);
    }

    public DeviceData command_inout_reply(int id, int timeout) throws DevFailed, AsynReplyNotArrived {
        return this.command_inout_reply(ApiUtil.get_async_object(id), timeout);
    }

    DeviceData command_inout_reply(AsyncCallObject aco, int timeout) throws DevFailed, AsynReplyNotArrived {
        long t0;
        DeviceData argout = null;
        int ms_to_sleep = 50;
        AsynReplyNotArrived except = null;
        long t1 = t0 = System.currentTimeMillis();
        while ((t1 - t0 < (long)timeout || timeout == 0) && argout == null) {
            try {
                argout = this.command_inout_reply(aco);
            }
            catch (AsynReplyNotArrived na) {
                except = na;
                this.sleep(ms_to_sleep);
                t1 = System.currentTimeMillis();
            }
            catch (DevFailed e) {
                throw e;
            }
        }
        if (argout == null && except != null) {
            throw except;
        }
        return argout;
    }

    public DeviceData command_inout_reply(int id) throws DevFailed, AsynReplyNotArrived {
        return this.command_inout_reply(ApiUtil.get_async_object(id));
    }

    DeviceData command_inout_reply(AsyncCallObject aco) throws DevFailed, AsynReplyNotArrived {
        DeviceData data = null;
        this.check_asynch_reply(aco.request, aco.id, "command_inout");
        Any any = aco.request.return_value().extract_any();
        data = new DeviceData();
        data.any = any;
        ApiUtil.remove_async_request(aco.id);
        return data;
    }

    public int read_attribute_asynch(String attname) throws DevFailed {
        String[] attnames = new String[]{attname};
        return this.read_attribute_asynch(attnames);
    }

    public int read_attribute_asynch(String[] attnames) throws DevFailed {
        this.checkIfTango("read_attributes_asynch");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        Request request = this.idl_version < 2 ? this.device._request("read_attributes") : this.device_2._request("read_attributes");
        Any any = request.add_in_arg();
        DevVarStringArrayHelper.insert(any, attnames);
        request.set_return_type(AttributeValueListHelper.type());
        request.exceptions().add(DevFailedHelper.type());
        request.send_deferred();
        int id = ApiUtil.put_async_request(new AsyncCallObject(request, this, 1, attnames));
        return id;
    }

    protected String get_asynch_idl_cmd(Request request, String idl_cmd) {
        NVList args = request.arguments();
        StringBuffer sb = new StringBuffer();
        try {
            if (idl_cmd.equals("command_inout")) {
                return args.item(0).value().extract_string();
            }
            String[] s_array = DevVarStringArrayHelper.extract(args.item(0).value());
            for (int i = 0; i < s_array.length; ++i) {
                sb.append(s_array[i]);
                if (i >= s_array.length - 1) continue;
                sb.append(", ");
            }
        }
        catch (Bounds e) {
            // empty catch block
        }
        return sb.toString();
    }

    protected void check_asynch_reply(Request request, int id, String idl_cmd) throws DevFailed, AsynReplyNotArrived {
        if (request == null) {
            Except.throw_connection_failed("TangoApi_CommandFailed", "Asynchronous call id not found", new String(this.full_class_name + "." + idl_cmd + "_reply()"));
        }
        if (!request.operation().equals(idl_cmd)) {
            Except.throw_connection_failed("TangoApi_CommandFailed", new String("Asynchronous call id not for " + idl_cmd), new String(this.full_class_name + "." + idl_cmd + "_reply()"));
        }
        if (!request.poll_response()) {
            Except.throw_asyn_reply_not_arrived("API_AsynReplyNotArrived", new String("Device " + this.devname + ": reply for asynchronous call (id = " + id + ") is not yet arrived"), new String(this.full_class_name + "." + idl_cmd + "_reply()"));
        } else {
            Exception except = request.env().exception();
            if (except != null) {
                if (except instanceof UnknownUserException) {
                    Any any = ((UnknownUserException)except).except;
                    DevFailed e = DevFailedHelper.extract(any);
                    Except.throw_connection_failed(e, "TangoApi_CommandFailed", "Asynchronous command failed", new String(this.full_class_name + "." + idl_cmd + "_reply(" + this.get_asynch_idl_cmd(request, idl_cmd) + ")"));
                } else {
                    ApiUtil.remove_async_request(id);
                    this.throw_dev_failed(except, new String(this.full_class_name + "." + idl_cmd + "_reply(" + this.get_asynch_idl_cmd(request, idl_cmd) + ")"), false);
                }
            }
        }
    }

    public DeviceAttribute[] read_attribute_reply(int id, int timeout) throws DevFailed, AsynReplyNotArrived {
        long t0;
        DeviceAttribute[] argout = null;
        int ms_to_sleep = 50;
        AsynReplyNotArrived except = null;
        long t1 = t0 = System.currentTimeMillis();
        while ((t1 - t0 < (long)timeout || timeout == 0) && argout == null) {
            try {
                argout = this.read_attribute_reply(id);
            }
            catch (AsynReplyNotArrived na) {
                except = na;
                this.sleep(ms_to_sleep);
                t1 = System.currentTimeMillis();
            }
            catch (DevFailed e) {
                throw e;
            }
        }
        if (argout == null && except != null) {
            throw except;
        }
        return argout;
    }

    public DeviceAttribute[] read_attribute_reply(int id) throws DevFailed, AsynReplyNotArrived {
        DeviceAttribute[] data = null;
        Request request = ApiUtil.get_async_request(id);
        this.check_asynch_reply(request, id, "read_attributes");
        Any any = request.return_value();
        AttributeValue[] attl = AttributeValueListHelper.extract(any);
        data = new DeviceAttribute[attl.length];
        for (int i = 0; i < attl.length; ++i) {
            data[i] = new DeviceAttribute(attl[i]);
        }
        ApiUtil.remove_async_request(id);
        return data;
    }

    public void read_attribute_asynch(String attname, CallBack cb) throws DevFailed {
        String[] attnames = new String[]{attname};
        this.read_attribute_asynch(attnames, cb);
    }

    public void read_attribute_asynch(String[] attnames, CallBack cb) throws DevFailed {
        int id = this.read_attribute_asynch(attnames);
        ApiUtil.set_async_reply_model(id, 2);
        ApiUtil.set_async_reply_cb(id, cb);
        if (ApiUtil.get_asynch_cb_sub_model() == 0) {
            AsyncCallObject aco = ApiUtil.get_async_object(id);
            new CallbackThread(aco).start();
        }
    }

    public int write_attribute_asynch(DeviceAttribute attr) throws DevFailed {
        return this.write_attribute_asynch(attr, false);
    }

    public int write_attribute_asynch(DeviceAttribute attr, boolean forget) throws DevFailed {
        DeviceAttribute[] attribs = new DeviceAttribute[]{attr};
        return this.write_attribute_asynch(attribs);
    }

    public int write_attribute_asynch(DeviceAttribute[] attribs) throws DevFailed {
        return this.write_attribute_asynch(attribs, false);
    }

    public int write_attribute_asynch(DeviceAttribute[] attribs, boolean forget) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.access == 0) {
            Except.throw_connection_failed("TangoApi_READ_ONLY_MODE", this.devname + ".write_attribute_asynch()  is not authorized !", "DeviceProxy.write_attribute_asynch()");
        }
        AttributeValue[] attval = new AttributeValue[attribs.length];
        String[] attnames = new String[attribs.length];
        for (int i = 0; i < attribs.length; ++i) {
            attval[i] = attribs[i].getAttributeValueObject_2();
            attnames[i] = attval[i].name;
        }
        Request request = this.idl_version < 2 ? this.device._request("write_attributes") : this.device_2._request("write_attributes");
        Any any = request.add_in_arg();
        AttributeValueListHelper.insert(any, attval);
        request.exceptions().add(DevFailedHelper.type());
        int id = 0;
        if (forget) {
            request.send_oneway();
        } else {
            request.send_deferred();
            id = ApiUtil.put_async_request(new AsyncCallObject(request, this, 2, attnames));
        }
        return id;
    }

    public void write_attribute_reply(int id) throws DevFailed, AsynReplyNotArrived {
        Request request = ApiUtil.get_async_request(id);
        this.check_asynch_reply(request, id, "write_attributes");
    }

    public void write_attribute_reply(int id, int timeout) throws DevFailed, AsynReplyNotArrived {
        long t0;
        int ms_to_sleep = 50;
        AsynReplyNotArrived except = null;
        long t1 = t0 = System.currentTimeMillis();
        boolean done = false;
        while (!(t1 - t0 >= (long)timeout && timeout != 0 || done)) {
            try {
                this.write_attribute_reply(id);
                done = true;
            }
            catch (AsynReplyNotArrived na) {
                except = na;
                this.sleep(ms_to_sleep);
                t1 = System.currentTimeMillis();
            }
            catch (DevFailed e) {
                throw e;
            }
        }
        if (except != null && !done) {
            throw except;
        }
    }

    public void write_attribute_asynch(DeviceAttribute attr, CallBack cb) throws DevFailed {
        DeviceAttribute[] attribs = new DeviceAttribute[]{attr};
        this.write_attribute_asynch(attribs, cb);
    }

    public void write_attribute_asynch(DeviceAttribute[] attribs, CallBack cb) throws DevFailed {
        int id = this.write_attribute_asynch(attribs);
        ApiUtil.set_async_reply_model(id, 2);
        ApiUtil.set_async_reply_cb(id, cb);
        if (ApiUtil.get_asynch_cb_sub_model() == 0) {
            AsyncCallObject aco = ApiUtil.get_async_object(id);
            new CallbackThread(aco).start();
        }
    }

    public int pending_asynch_call(int reply_model) {
        return ApiUtil.pending_asynch_call(this, reply_model);
    }

    public void get_asynch_replies() {
        ApiUtil.get_asynch_replies(this);
    }

    public void get_asynch_replies(int timeout) {
        ApiUtil.get_asynch_replies(this, timeout);
    }

    public void add_logging_target(String target_type, String target_name) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("add_logging_target");
        }
        String[] target = new String[]{this.get_name(), target_type + "::" + target_name};
        DeviceData argin = new DeviceData();
        argin.insert(target);
        this.adm_dev.command_inout("AddLoggingTarget", argin);
    }

    public void add_logging_target(String target) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("add_logging_target");
        }
        String[] str = new String[]{this.get_name(), target};
        DeviceData argin = new DeviceData();
        argin.insert(str);
        this.adm_dev.command_inout("AddLoggingTarget", argin);
    }

    public void remove_logging_target(String target_type, String target_name) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("remove_logging_target");
        }
        String[] target = new String[]{this.get_name(), target_type + "::" + target_name};
        DeviceData argin = new DeviceData();
        argin.insert(target);
        this.adm_dev.command_inout("RemoveLoggingTarget", argin);
    }

    public String[] get_logging_target() throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("get_logging_target");
        }
        DeviceData argin = new DeviceData();
        argin.insert(this.get_name());
        DeviceData argout = this.adm_dev.command_inout("GetLoggingTarget", argin);
        return argout.extractStringArray();
    }

    public int get_logging_level() throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("get_logging_level");
        }
        String[] target = new String[]{this.get_name()};
        DeviceData argin = new DeviceData();
        argin.insert(target);
        DeviceData argout = this.adm_dev.command_inout("GetLoggingLevel", argin);
        DevVarLongStringArray lsa = argout.extractLongStringArray();
        return lsa.lvalue[0];
    }

    public void set_logging_level(int level) throws DevFailed {
        if (this.adm_dev == null) {
            this.import_admin_device("set_logging_level");
        }
        DevVarLongStringArray lsa = new DevVarLongStringArray();
        lsa.lvalue = new int[1];
        lsa.svalue = new String[1];
        lsa.lvalue[0] = level;
        lsa.svalue[0] = this.get_name();
        DeviceData argin = new DeviceData();
        argin.insert(lsa);
        this.adm_dev.command_inout("SetLoggingLevel", argin);
    }

    public String[] dev_inform() throws DevFailed {
        this.checkIfTaco("dev_inform");
        if (this.taco_device == null && this.devname != null) {
            this.build_connection();
        }
        return this.taco_device.dev_inform();
    }

    public void set_rpc_protocol(int mode) throws DevFailed {
        this.checkIfTaco("dev_rpc_protocol");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        this.taco_device.set_rpc_protocol(mode);
    }

    public int get_rpc_protocol() throws DevFailed {
        this.checkIfTaco("get_rpc_protocol");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.taco_device.get_rpc_protocol();
    }

    public static void main(String[] args) {
        String devname = null;
        String cmdname = null;
        try {
            cmdname = args[0];
            devname = args[1];
        }
        catch (Exception e) {
            if (cmdname == null) {
                System.out.println("Usage :");
                System.out.println("fr.esrf.TangoApi.DeviceProxy  cmdname devname");
                System.out.println("\t- cmdname : command name (ping, state, status, unexport...)");
                System.out.println("\t- devname : device name to send command.");
            } else {
                System.out.println("Device name ?");
            }
            System.exit(0);
        }
        try {
            int i;
            String[] devnames = devname.indexOf("*") < 0 ? new String[]{devname} : ApiUtil.get_db_obj().getDevices(devname);
            DeviceProxy[] dev = new DeviceProxy[devnames.length];
            for (i = 0; i < devnames.length; ++i) {
                dev[i] = new DeviceProxy(devnames[i]);
            }
            if (cmdname.equals("ping")) {
                while (true) {
                    for (i = 0; i < dev.length; ++i) {
                        try {
                            long t = dev[i].ping();
                            System.out.println(devnames[i] + " is alive  (" + t / 1000L + " ms)");
                            continue;
                        }
                        catch (DevFailed e) {
                            System.out.println(devnames[i] + "  " + e.errors[0].desc);
                        }
                    }
                    if (dev.length > 1) {
                        System.out.println();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            if (cmdname.equals("status")) {
                for (i = 0; i < dev.length; ++i) {
                    try {
                        System.out.println(devnames[i] + " - " + dev[i].status());
                        continue;
                    }
                    catch (DevFailed e) {
                        System.out.println(devnames[i] + "  " + e.errors[0].desc);
                    }
                }
            } else if (cmdname.equals("state")) {
                for (i = 0; i < dev.length; ++i) {
                    try {
                        System.out.println(devnames[i] + " is " + ApiUtil.stateName(dev[i].state()));
                        continue;
                    }
                    catch (DevFailed e) {
                        System.out.println(devnames[i] + "  " + e.errors[0].desc);
                    }
                }
            } else if (cmdname.equals("unexport")) {
                for (i = 0; i < dev.length; ++i) {
                    try {
                        dev[i].unexport_device();
                        System.out.println(devnames[i] + " unexported !");
                        continue;
                    }
                    catch (DevFailed e) {
                        System.out.println(devnames[i] + "  " + e.errors[0].desc);
                    }
                }
            } else {
                System.out.println(cmdname + " ?   Unknow command !");
            }
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
    }

    private synchronized void sleep(long ms) {
        try {
            this.wait(ms);
        }
        catch (InterruptedException e) {
            System.out.println(e);
        }
    }

    public int subscribe_event(String attr_name, int event, CallBack callback, String[] filters) throws DevFailed {
        int id = 0;
        if (ApiUtil.get_event_consumer() == null) {
            ApiUtil.create_event_consumer();
        }
        try {
            EventConsumer event_consumer = ApiUtil.get_event_consumer();
            id = event_consumer.subscribe_event(this, attr_name.toLowerCase(), event, callback, filters);
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            Except.throw_communication_failed(e.toString(), "Subsrcibe event on " + this.name() + "/" + attr_name + " Failed !", "DeviceProxy.subscribe_event()");
        }
        return id;
    }

    public void unsubscribe_event(int event_id) throws DevFailed {
        if (ApiUtil.get_event_consumer() == null) {
            ApiUtil.create_event_consumer();
        }
        try {
            EventConsumer event_consumer = ApiUtil.get_event_consumer();
            event_consumer.unsubscribe_event(event_id);
        }
        catch (Exception e) {
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            Except.throw_communication_failed(e.toString(), "Unsubsrcibe event on event ID " + event_id + " Failed !", "DeviceProxy.unsubscribe_event()");
        }
    }
}

