/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoDs.Except;

public class DeviceInfo
extends DbDevImportInfo {
    public String last_exported;
    public String last_unexported;

    public DeviceInfo(DevVarLongStringArray info) {
        super(info);
        if (info.svalue.length > 5) {
            this.last_exported = new String(info.svalue[5]);
            this.last_unexported = new String(info.svalue[6]);
        }
    }

    public String toString() {
        String result = super.toString();
        result = result + "\nlast_exported:   " + this.last_exported;
        result = result + "\nlast_unexported: " + this.last_unexported;
        return result;
    }

    public static void main(String[] args) {
        try {
            String devname = args[0];
            Database db = ApiUtil.get_db_obj();
            DeviceInfo info = db.get_device_info(devname);
            System.out.println(info);
        }
        catch (DevFailed e) {
            if (args.length < 2 || !args[1].equals("-no_exception")) {
                Except.print_exception(e);
            }
            System.exit(1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Device name ?");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

