/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class DTMenuBar
extends JMenuBar {
    JMenu file;
    JMenu view;
    JMenu edit;
    JMenu help;
    JMenu refresh;
    JMenuItem exitItem;
    JMenuItem aboutItem;
    JMenuItem errorItem;
    JMenuItem helpItem;
    GridBagConstraints constraints = new GridBagConstraints();
    ErrorHistory errorHistory;

    public DTMenuBar(ErrorHistory errorHistory) {
        this();
        this.setErrorHistory(errorHistory);
        this.setMargin(new Insets(2, 2, 2, 2));
    }

    public void setErrorHistory(ErrorHistory errorHistory) {
        this.errorHistory = errorHistory;
    }

    public ErrorHistory getErrorHistory() {
        return this.errorHistory;
    }

    protected void showErrorHistory() {
        if (this.errorHistory == null) {
            return;
        }
        this.errorHistory.show();
    }

    protected void showHelpWindow() {
        HelpWindow.getInstance().show();
    }

    public DTMenuBar() {
        this.constraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.file = new JMenu("File");
        this.add((Component)this.file, this.constraints);
        ++this.constraints.gridx;
        this.edit = new JMenu("Edit");
        this.add((Component)this.edit, this.constraints);
        ++this.constraints.gridx;
        this.view = new JMenu("View");
        this.add((Component)this.view, this.constraints);
        ++this.constraints.gridx;
        this.refresh = new JMenu("Refresh");
        this.add((Component)this.refresh, this.constraints);
        this.constraints.fill = 2;
        this.constraints.weightx = 0.1;
        this.constraints.gridx = 200;
        this.add((Component)new JLabel(""), this.constraints);
        this.constraints.fill = 0;
        this.constraints.gridx = 201;
        this.constraints.weightx = 0.0;
        this.help = new JMenu("Help");
        this.add((Component)this.help, this.constraints);
        this.constraints.gridx = 3;
        this.exitItem = new JMenuItem("Quit");
        this.aboutItem = new JMenuItem("About...");
        this.helpItem = new JMenuItem("Help");
        this.file.setMnemonic('F');
        this.view.setMnemonic('V');
        this.edit.setMnemonic('E');
        this.help.setMnemonic('H');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DTMenuBar.this.showHelpWindow();
            }
        });
        this.errorItem = new JMenuItem("Error history...");
        this.errorItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DTMenuBar.this.showErrorHistory();
            }
        });
        this.errorItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.add2ViewMenu(this.errorItem, 0);
        this.file.add(new JSeparator());
        this.file.add(this.exitItem);
        this.help.add(this.aboutItem);
        this.help.add(this.helpItem);
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.file == null) {
            return;
        }
        this.file.setFont(f);
        this.view.setFont(f);
        this.edit.setFont(f);
        this.help.setFont(f);
        this.exitItem.setFont(f);
        this.errorItem.setFont(f);
        this.aboutItem.setFont(f);
        this.helpItem.setFont(f);
    }

    public void setQuitHandler(ActionListener listener) {
        this.exitItem.addActionListener(listener);
    }

    public void setAboutHandler(ActionListener listener) {
        this.aboutItem.addActionListener(listener);
    }

    public void add2ViewMenu(JComponent item, int i) {
        item.setFont(this.getFont());
        this.view.add((Component)item, i);
    }

    public void add2ViewMenu(JComponent item) {
        item.setFont(this.getFont());
        this.view.add(item);
    }

    public void add2EditMenu(JComponent item, int i) {
        item.setFont(this.getFont());
        this.edit.add((Component)item, i);
    }

    public void add2EditMenu(JComponent item) {
        item.setFont(this.getFont());
        this.edit.add(item);
    }

    public void add2HelpMenu(JComponent item, int i) {
        item.setFont(this.getFont());
        this.help.add((Component)item, i);
    }

    public void add2HelpMenu(JComponent item) {
        item.setFont(this.getFont());
        this.help.add(item);
    }

    public void add2FileMenu(JComponent item, int i) {
        item.setFont(this.getFont());
        this.file.add((Component)item, i);
    }

    public void add2FileMenu(JComponent item) {
        item.setFont(this.getFont());
        this.file.add(item);
    }

    public void add2RefreshMenu(JComponent item, int i) {
        item.setFont(this.getFont());
        this.refresh.add((Component)item, i);
    }

    public void add2RefreshMenu(JComponent item) {
        item.setFont(this.getFont());
        this.refresh.add(item);
    }

    public void addMenu(JMenu menu) {
        ++this.constraints.gridx;
        menu.setFont(this.getFont());
        this.add((Component)menu, this.constraints);
    }
}

