/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.math;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.math.ExpressionParser;
import fr.esrf.tangoatk.widget.util.chart.math.ParserOptionDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class StaticChartMathExpression
extends JLChart
implements IJLChartActionListener {
    protected static final String EVALUATE_EXPRESSION = "Evaluate an expression";
    public static final int Y1_AXIS = 0;
    public static final int Y2_AXIS = 1;
    public static final int X_AXIS = 2;
    protected HashMap expressionMap = new HashMap();

    public StaticChartMathExpression() {
        this.addUserAction(EVALUATE_EXPRESSION);
        this.addJLChartActionListener(this);
    }

    public void showExpressionDialog() {
        JLDataView jLDataView = new JLDataView();
        Container container = this.getRootPane().getParent();
        ParserOptionDialog parserOptionDialog = container instanceof JDialog ? new ParserOptionDialog((JDialog)container, (JLChart)this, jLDataView) : (container instanceof JFrame ? new ParserOptionDialog((JFrame)container, (JLChart)this, jLDataView) : new ParserOptionDialog((JFrame)null, (JLChart)this, jLDataView));
        ATKGraphicsUtils.centerDialog(parserOptionDialog);
        parserOptionDialog.setVisible(true);
        boolean bl = parserOptionDialog.isValidated;
        int n = parserOptionDialog.selectedAxis;
        if (bl) {
            this.applyExpressionToChart(parserOptionDialog.expressionField.getText().trim(), jLDataView, n, parserOptionDialog.getVariables(), parserOptionDialog.isX());
        }
        parserOptionDialog.dispose();
        parserOptionDialog = null;
    }

    public JLDataView applyExpressionToChart(String string, JLDataView jLDataView, int n, String[] stringArray, boolean bl) {
        Object object;
        Object[] objectArray;
        if (jLDataView != null && this.expressionMap.containsKey(jLDataView)) {
            objectArray = (Object[])this.expressionMap.get(jLDataView);
            object = (Integer)objectArray[0];
            switch ((Integer)object) {
                case 2: {
                    this.getXAxis().removeDataView(jLDataView);
                    break;
                }
                case 0: {
                    this.getY1Axis().removeDataView(jLDataView);
                    break;
                }
                case 1: {
                    this.getY2Axis().removeDataView(jLDataView);
                }
            }
            this.expressionMap.remove(jLDataView);
            jLDataView.reset();
        }
        objectArray = this.applyExpression(string, jLDataView, stringArray, bl);
        object = new Object[stringArray.length + 3];
        object[0] = new Integer(n);
        object[1] = string;
        object[2] = new Boolean(bl);
        for (int i = 0; i < stringArray.length; ++i) {
            object[i + 3] = stringArray[i];
        }
        this.expressionMap.put(objectArray, object);
        switch (n) {
            case 2: {
                this.getXAxis().addDataView((JLDataView)objectArray);
                if (this.getXAxis().isVisible()) break;
                this.getXAxis().setVisible(true);
                this.getXAxis().setAutoScale(true);
                break;
            }
            case 0: {
                this.getY1Axis().addDataView((JLDataView)objectArray);
                if (this.getY1Axis().isVisible()) break;
                this.getY1Axis().setVisible(true);
                this.getY1Axis().setAutoScale(true);
                break;
            }
            case 1: {
                this.getY2Axis().addDataView((JLDataView)objectArray);
                if (this.getY2Axis().isVisible()) break;
                this.getY2Axis().setVisible(true);
                this.getY2Axis().setAutoScale(true);
            }
        }
        this.repaint();
        return objectArray;
    }

    protected JLDataView applyExpression(String string, JLDataView jLDataView, String[] stringArray, boolean bl) {
        Vector vector = new Vector();
        JLDataView jLDataView2 = null;
        if (this.getXAxis().isXY()) {
            vector.addAll(this.getXAxis().getViews());
        }
        vector.addAll(this.getY1Axis().getViews());
        vector.addAll(this.getY2Axis().getViews());
        ExpressionParser expressionParser = new ExpressionParser(stringArray.length, string);
        expressionParser.setX(bl);
        expressionParser.setPrecision(this.getTimePrecision());
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                if (!stringArray[i].equals(((JLDataView)vector.get(j)).getName())) continue;
                expressionParser.add(i, (JLDataView)vector.get(j));
                continue block0;
            }
        }
        vector.clear();
        vector = null;
        jLDataView2 = expressionParser.buildDataView(jLDataView);
        expressionParser.clean();
        expressionParser = null;
        return jLDataView2;
    }

    public void actionPerformed(JLChartActionEvent jLChartActionEvent) {
        if (EVALUATE_EXPRESSION.equals(jLChartActionEvent.getName())) {
            this.showExpressionDialog();
        }
    }

    public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
        return false;
    }

    public String getConfiguration() {
        String string = super.getConfiguration();
        string = string + "expressions:" + this.expressionMap.size() + "\n";
        Set set = this.expressionMap.keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JLDataView jLDataView = (JLDataView)iterator.next();
            Object[] objectArray = (Object[])this.expressionMap.get(jLDataView);
            string = string + "expression_" + n + "_name:'" + jLDataView.getName() + "'\n";
            string = string + "expression_" + n + "_axis:" + (Integer)objectArray[0] + "\n";
            string = string + "expression_" + n + "_expression:'" + (String)objectArray[1] + "'\n";
            string = string + "expression_" + n + "_isX:" + (Boolean)objectArray[2] + "\n";
            string = string + "expression_" + n + "_variables:" + (objectArray.length - 3) + "\n";
            for (int i = 0; i < objectArray.length - 3; ++i) {
                string = string + "expression_" + n + "_variable_" + i + ":'" + (String)objectArray[i + 3] + "'\n";
            }
            string = string + jLDataView.getConfiguration("expression_" + n);
            ++n;
        }
        return string;
    }

    public void applyConfiguration(CfFileReader cfFileReader) {
        super.applyConfiguration(cfFileReader);
        Vector vector = cfFileReader.getParam("expressions");
        int n = 0;
        if (vector != null) {
            n = OFormat.getInt(vector.get(0).toString());
        }
        for (int i = 0; i < n; ++i) {
            JLDataView jLDataView = new JLDataView();
            jLDataView.applyConfiguration("expression_" + i, cfFileReader);
            vector = cfFileReader.getParam("expression_" + i + "_name");
            if (vector != null) {
                jLDataView.setName(vector.get(0).toString());
            }
            int n2 = -1;
            vector = cfFileReader.getParam("expression_" + i + "_axis");
            if (vector != null) {
                n2 = OFormat.getInt(vector.get(0).toString());
            }
            String string = "";
            vector = cfFileReader.getParam("expression_" + i + "_expression");
            if (vector != null) {
                string = vector.get(0).toString();
            }
            boolean bl = false;
            vector = cfFileReader.getParam("expression_" + i + "_isX");
            if (vector != null) {
                bl = OFormat.getBoolean(vector.get(0).toString());
            }
            int n3 = 0;
            vector = cfFileReader.getParam("expression_" + i + "_variables");
            if (vector != null) {
                n3 = OFormat.getInt(vector.get(0).toString());
            }
            String[] stringArray = new String[n3];
            for (int j = 0; j < n3; ++j) {
                String string2 = "";
                vector = cfFileReader.getParam("expression_" + i + "_variable_" + j);
                if (vector != null) {
                    string2 = vector.get(0).toString();
                }
                stringArray[j] = new String(string2);
                string2 = null;
            }
            if (n2 == -1) continue;
            this.applyExpressionToChart(string, jLDataView, n2, stringArray, bl);
        }
    }

    protected void reset(boolean bl) {
        String string;
        int n;
        Vector vector = new Vector();
        if (this.getXAxis().isXY()) {
            vector.addAll(this.getXAxis().getViews());
        }
        vector.addAll(this.getY1Axis().getViews());
        vector.addAll(this.getY2Axis().getViews());
        if (vector.size() != 0 && bl && (n = JOptionPane.showConfirmDialog(this, string = "Reseting chart will remove all the existing dataviews.\nYour component may not work any more.\nAre you sure to reset chart ?", "Risk of breaking component", 2)) != 0) {
            vector.clear();
            vector = null;
            return;
        }
        vector.clear();
        vector = null;
        this.maxDisplayDuration = Double.POSITIVE_INFINITY;
        this.setDisplayDuration(Double.POSITIVE_INFINITY);
        this.getY1Axis().clearDataView();
        this.getY1Axis().setLabels(null, null);
        this.getY1Axis().setScale(0);
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().clearDataView();
        this.getY2Axis().setLabels(null, null);
        this.getY2Axis().setScale(0);
        this.getY2Axis().setAutoScale(true);
        this.getXAxis().clearDataView();
        this.getXAxis().setLabels(null, null);
        this.getXAxis().setScale(0);
        this.getXAxis().setAutoScale(true);
        this.expressionMap.clear();
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        JComponent jComponent;
        String string;
        JFrame jFrame = new JFrame();
        final StaticChartMathExpression staticChartMathExpression = new StaticChartMathExpression();
        staticChartMathExpression.setHeaderFont(new Font("Times", 1, 18));
        staticChartMathExpression.setLabelFont(new Font("Times", 1, 12));
        staticChartMathExpression.setHeader("Test DataView");
        staticChartMathExpression.getXAxis().setAutoScale(true);
        staticChartMathExpression.getXAxis().setGridVisible(true);
        staticChartMathExpression.getXAxis().setSubGridVisible(true);
        staticChartMathExpression.getXAxis().setAnnotation(2);
        staticChartMathExpression.getY1Axis().setAutoScale(true);
        staticChartMathExpression.getY1Axis().setGridVisible(true);
        staticChartMathExpression.getY1Axis().setSubGridVisible(true);
        staticChartMathExpression.getY2Axis().setVisible(false);
        if (stringArray.length > 0) {
            string = stringArray[0];
        } else {
            jComponent = new JFileChooser(".");
            ((JFileChooser)jComponent).addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = null;
                    String string2 = file.getName();
                    int n = string2.lastIndexOf(46);
                    if (n > 0 && n < string2.length() - 1) {
                        string = string2.substring(n + 1).toLowerCase();
                    }
                    return string != null && string.equals("txt");
                }

                public String getDescription() {
                    return "text files ";
                }
            });
            ((JFileChooser)jComponent).setDialogTitle("Load Graph Data (Text file with TAB separated fields)");
            int n = ((JFileChooser)jComponent).showOpenDialog(null);
            if (n == 0) {
                serializable = ((JFileChooser)jComponent).getSelectedFile();
                string = ((File)serializable).getAbsolutePath();
            } else {
                string = "";
                System.exit(0);
            }
        }
        staticChartMathExpression.reset(false);
        staticChartMathExpression.loadDataFile(string);
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout());
        JButton jButton = new JButton("Exit");
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                System.exit(0);
            }
        });
        jComponent.add(jButton);
        serializable = new JButton("Options");
        ((Component)serializable).addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                staticChartMathExpression.showOptionDialog();
            }
        });
        jComponent.add((Component)serializable);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)staticChartMathExpression, "Center");
        jFrame.getContentPane().add((Component)jComponent, "South");
        jFrame.setSize(400, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }
}

