/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;

class TabbedLine {
    JLDataView[] dv;
    DataList[] dl;
    int anno;
    int sIndex;
    int precision = 0;
    String noValueString = "*";

    TabbedLine(int n) {
        this.dv = new JLDataView[n];
        this.dl = new DataList[n];
    }

    void setPrecision(int n) {
        this.precision = n;
    }

    void setNoValueString(String string) {
        this.noValueString = string;
    }

    void add(int n, JLDataView jLDataView) {
        this.dv[n] = jLDataView;
        this.dl[n] = jLDataView.getData();
    }

    double getMinTime() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.dl.length; ++i) {
            if (this.dl[i] == null || !(this.dl[i].x < d)) continue;
            d = this.dl[i].x;
        }
        return d;
    }

    String getFirstLine(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.anno = n;
        if (n == 1) {
            stringBuffer.append("Time (s)\t");
        } else {
            stringBuffer.append("Index\t");
        }
        for (int i = 0; i < this.dv.length; ++i) {
            stringBuffer.append(this.dv[i].getName() + "\t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    String getNextLine() {
        double d = this.getMinTime();
        if (d == Double.MAX_VALUE) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.anno == 1) {
            long l = (long)d;
            long l2 = l / 1000L;
            long l3 = l % 1000L;
            if (l3 == 0L) {
                stringBuffer.append(l2 + "\t");
            } else if (l3 < 10L) {
                stringBuffer.append(l2 + ".00" + l3 + "\t");
            } else if (l3 < 100L) {
                stringBuffer.append(l2 + ".0" + l3 + "\t");
            } else {
                stringBuffer.append(l2 + "." + l3 + "\t");
            }
        } else {
            stringBuffer.append(Double.toString(d) + "\t");
        }
        for (int i = 0; i < this.dl.length; ++i) {
            if (this.dl[i] != null) {
                if (this.dl[i].x >= d - (double)this.precision && this.dl[i].x <= d + (double)this.precision) {
                    stringBuffer.append(Double.toString(this.dl[i].y) + "\t");
                    this.dl[i] = this.dl[i].next;
                    continue;
                }
                stringBuffer.append(this.noValueString + "\t");
                continue;
            }
            stringBuffer.append(this.noValueString + "\t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    String[] getFirstFields(int n, boolean bl) {
        this.anno = n;
        this.sIndex = bl ? 1 : 0;
        String[] stringArray = new String[this.dv.length + this.sIndex];
        if (this.sIndex > 0) {
            stringArray[0] = n == 1 ? "Time (s)" : "Index";
        }
        for (int i = 0; i < this.dv.length; ++i) {
            stringArray[i + this.sIndex] = this.dv[i].getName();
        }
        return stringArray;
    }

    String[] getNextFields() {
        double d = this.getMinTime();
        if (d == Double.MAX_VALUE) {
            return null;
        }
        String[] stringArray = new String[this.dv.length + this.sIndex];
        if (this.sIndex > 0) {
            stringArray[0] = this.anno == 1 ? JLAxis.formatTimeValue(d) : Double.toString(d);
        }
        for (int i = 0; i < this.dl.length; ++i) {
            if (this.dl[i] != null) {
                if (this.dl[i].x >= d - (double)this.precision && this.dl[i].x <= d + (double)this.precision) {
                    stringArray[i + this.sIndex] = this.dv[i].formatValue(this.dl[i].y);
                    this.dl[i] = this.dl[i].next;
                    continue;
                }
                stringArray[i + this.sIndex] = "";
                continue;
            }
            stringArray[i + this.sIndex] = "";
        }
        return stringArray;
    }
}

