/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

class SplashPanel
extends JComponent {
    static ImageIcon imgDefault = new ImageIcon(SplashPanel.class.getResource("/fr/esrf/tangoatk/widget/util/splash.jpg"));
    static Color foregroundDefault = new Color(204, 204, 204);
    private JSmoothLabel title;
    private JSmoothLabel message;
    private JSmoothLabel copyright;
    private JSmoothProgressBar progress = null;
    private BufferedImage ddBuffer;
    private boolean firstUpdate = true;
    private Dimension imgSize;
    private ImageIcon img = imgDefault;
    private Color textForeground = foregroundDefault;

    public SplashPanel() {
        this.initComponents();
    }

    public SplashPanel(ImageIcon imageIcon, Color color, JSmoothProgressBar jSmoothProgressBar) {
        if (imageIcon != null) {
            this.img = imageIcon;
        }
        if (color != null) {
            this.textForeground = color;
        }
        if (jSmoothProgressBar != null) {
            this.progress = jSmoothProgressBar;
        }
        this.initComponents();
    }

    private void initComponents() {
        this.imgSize = new Dimension(this.img.getIconWidth(), this.img.getIconHeight());
        this.setLayout(null);
        this.setDoubleBuffered(false);
        this.title = new JSmoothLabel();
        this.title.setFont(new Font("Dialog", 1, 18));
        this.title.setForeground(this.textForeground);
        this.title.setText("");
        this.title.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
        this.title.setOpaque(false);
        this.title.setDoubleBuffered(false);
        this.message = new JSmoothLabel();
        this.message.setFont(new Font("Dialog", 1, 12));
        this.message.setForeground(this.textForeground);
        this.message.setText("Initializing...");
        this.message.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
        this.message.setOpaque(false);
        this.message.setDoubleBuffered(false);
        this.copyright = new JSmoothLabel();
        this.copyright.setFont(new Font("Dialog", 0, 10));
        this.copyright.setForeground(this.textForeground);
        this.copyright.setText("(c) ESRF 2002");
        this.copyright.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
        this.copyright.setOpaque(false);
        this.copyright.setDoubleBuffered(false);
        if (this.progress == null) {
            this.progress = new JSmoothProgressBar();
            this.progress.setStringPainted(true);
        }
        this.progress.setDoubleBuffered(false);
        this.setPreferredSize(this.imgSize);
        this.setMinimumSize(this.imgSize);
        this.setMaximumSize(this.imgSize);
        this.title.setSize(this.imgSize.width - 10, 23);
        this.message.setSize(this.imgSize.width - 10, 18);
        this.progress.setSize(this.imgSize.width - 10, 21);
        this.copyright.setSize(this.imgSize.width - 10, 15);
        this.ddBuffer = new BufferedImage(this.imgSize.width, this.imgSize.height, 1);
        Graphics graphics = this.ddBuffer.getGraphics();
        this.paintBackground(graphics, 0, 0, this.imgSize.width, this.imgSize.height);
        this.paintComponent(graphics, this.message, 5, this.imgSize.height - 30);
        this.paintComponent(graphics, this.progress, 5, this.imgSize.height - 55);
        this.paintComponent(graphics, this.copyright, 5, this.imgSize.height - 75);
        this.paintComponent(graphics, this.title, 5, this.imgSize.height - 95);
        graphics.dispose();
    }

    private void paintComponent(Graphics graphics, Component component, int n, int n2) {
        graphics.translate(n, n2);
        component.paint(graphics);
        graphics.translate(-n, -n2);
    }

    private void paintBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawImage(this.img.getImage(), n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, null);
    }

    private void repaintComponent(Component component, int n, int n2) {
        Graphics graphics = this.ddBuffer.getGraphics();
        this.paintBackground(graphics, n, n2, component.getSize().width, component.getSize().height);
        this.paintComponent(graphics, component, n, n2);
        graphics.dispose();
        graphics = this.getGraphics();
        if (graphics != null) {
            if (this.firstUpdate) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                graphics.drawImage(this.ddBuffer, 0, 0, null);
                this.firstUpdate = false;
            } else {
                graphics.drawImage(this.ddBuffer, n, n2, n + component.getSize().width, n2 + component.getSize().height, n, n2, n + component.getSize().width, n2 + component.getSize().height, null);
            }
            graphics.dispose();
        }
    }

    void setTitle(String string) {
        this.title.setText(string);
        this.repaintComponent(this.title, 5, this.imgSize.height - 95);
    }

    String getTitle() {
        return this.title.getText();
    }

    void setProgress(int n) {
        if (this.progress.getValue() != n) {
            this.progress.setValue(n);
            this.repaintComponent(this.progress, 5, this.imgSize.height - 55);
        }
    }

    JSmoothProgressBar getProgress() {
        return this.progress;
    }

    void setMessage(String string) {
        this.message.setText(string);
        this.repaintComponent(this.message, 5, this.imgSize.height - 30);
    }

    String getMessage() {
        return this.message.getText();
    }

    void setCopyright(String string) {
        this.copyright.setText(string);
        this.repaintComponent(this.copyright, 5, this.imgSize.height - 75);
    }

    String getCopyright() {
        return this.copyright.getText();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.ddBuffer, 0, 0, null);
    }
}

