/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.AttributeTableModel;
import fr.esrf.tangoatk.widget.util.CommandTableModel;
import fr.esrf.tangoatk.widget.util.DeviceTableModel;
import fr.esrf.tangoatk.widget.util.MyCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;

class DiagPanel
extends JFrame
implements ActionListener,
MouseListener {
    private JButton refreshButton;
    private JButton dismissButton;
    private boolean isUpdating = false;
    private JTable deviceTable;
    private DeviceTableModel deviceModel;
    private JButton startRefresherBtn;
    private JButton stopRefresherBtn;
    private JTextField refreshPeriodText;
    private JLabel refreshPeriodLabel;
    private JLabel refreshStateLabel;
    private JTable attributeTable;
    private AttributeTableModel attributeModel;
    private JTextField attributeEvtText;
    private CommandTableModel commandModel;

    DiagPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.deviceModel = new DeviceTableModel();
        this.deviceTable = new JTable(this.deviceModel);
        this.deviceTable.setDefaultRenderer(JButton.class, new MyCellRenderer());
        this.deviceTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.deviceTable.getColumnModel().getColumn(4).setMaxWidth(25);
        this.deviceTable.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.deviceTable);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(null);
        jPanel3.setPreferredSize(new Dimension(0, 40));
        this.refreshStateLabel = new JLabel();
        this.refreshStateLabel.setFont(ATKConstant.labelFont);
        this.refreshStateLabel.setBounds(10, 10, 180, 25);
        jPanel3.add(this.refreshStateLabel);
        this.startRefresherBtn = new JButton("Start");
        this.startRefresherBtn.setFont(ATKConstant.labelFont);
        this.startRefresherBtn.addActionListener(this);
        this.startRefresherBtn.setBounds(200, 10, 70, 25);
        jPanel3.add(this.startRefresherBtn);
        this.stopRefresherBtn = new JButton("Stop");
        this.stopRefresherBtn.setFont(ATKConstant.labelFont);
        this.stopRefresherBtn.addActionListener(this);
        this.stopRefresherBtn.setBounds(280, 10, 70, 25);
        jPanel3.add(this.stopRefresherBtn);
        this.refreshPeriodLabel = new JLabel();
        this.refreshPeriodLabel.setFont(ATKConstant.labelFont);
        this.refreshPeriodLabel.setBounds(360, 10, 100, 25);
        this.refreshPeriodLabel.setText("Period (ms)");
        jPanel3.add(this.refreshPeriodLabel);
        this.refreshPeriodText = new JTextField();
        this.refreshPeriodText.setFont(ATKConstant.labelFont);
        this.refreshPeriodText.setBounds(470, 10, 80, 25);
        this.refreshPeriodText.addActionListener(this);
        jPanel3.add(this.refreshPeriodText);
        jPanel2.add((Component)jPanel3, "South");
        jTabbedPane.add((Component)jPanel2, "Device");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.attributeModel = new AttributeTableModel();
        this.attributeTable = new JTable(this.attributeModel);
        this.attributeTable.setDefaultRenderer(JButton.class, new MyCellRenderer());
        this.attributeTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.attributeTable.getColumnModel().getColumn(3).setMaxWidth(25);
        this.attributeTable.addMouseListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.attributeTable);
        jPanel4.add((Component)jScrollPane2, "Center");
        this.attributeEvtText = new JTextField();
        this.attributeEvtText.setText(" ");
        jPanel4.add((Component)this.attributeEvtText, "South");
        jTabbedPane.add((Component)jPanel4, "Attribute");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.commandModel = new CommandTableModel();
        JTable jTable = new JTable(this.commandModel);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        JScrollPane jScrollPane3 = new JScrollPane(jTable);
        jPanel5.add((Component)jScrollPane3, "Center");
        jTabbedPane.add((Component)jPanel5, "Command");
        jPanel.add((Component)jTabbedPane, "Center");
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(2);
        JPanel jPanel6 = new JPanel(flowLayout);
        this.refreshButton = new JButton("Update fields");
        this.refreshButton.setFont(ATKConstant.labelFont);
        this.refreshButton.addActionListener(this);
        jPanel6.add(this.refreshButton);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.setFont(ATKConstant.labelFont);
        this.dismissButton.addActionListener(this);
        jPanel6.add(this.dismissButton);
        jPanel.add((Component)jPanel6, "South");
        this.setContentPane(jPanel);
        this.setTitle("ATK Diagnostic");
        this.refreshControls();
    }

    private void refreshControls() {
        this.isUpdating = true;
        if (DeviceFactory.getInstance().isRefreshing()) {
            this.refreshStateLabel.setText("Refresher is Running");
        } else {
            this.refreshStateLabel.setText("Refresher is Stopped");
        }
        this.refreshPeriodText.setText(Long.toString(DeviceFactory.getInstance().getRefreshInterval()));
        this.refreshPeriodText.setCaretPosition(0);
        this.isUpdating = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isUpdating) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.dismissButton) {
            this.setVisible(false);
        } else if (object == this.refreshButton) {
            this.deviceModel.refresh();
            this.deviceModel.fireTableDataChanged();
            this.attributeModel.refresh();
            this.attributeModel.fireTableDataChanged();
        } else if (object == this.refreshPeriodText) {
            String string = this.refreshPeriodText.getText();
            try {
                int n = Integer.parseInt(string);
                DeviceFactory.getInstance().setRefreshInterval(n);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Invalid period:\n" + numberFormatException.getMessage(), "Error", 0);
            }
        } else if (object == this.startRefresherBtn) {
            DeviceFactory.getInstance().startRefresher();
        } else if (object == this.stopRefresherBtn) {
            DeviceFactory.getInstance().stopRefresher();
        }
        this.refreshControls();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.attributeTable) {
            String string;
            int n = this.attributeTable.getSelectedRow();
            int n2 = this.attributeTable.getSelectedColumn();
            if (n != -1) {
                string = this.attributeModel.getAttribute(n).getSubscriptionError();
                this.attributeEvtText.setText(string);
            }
            if (n2 == 3) {
                string = this.attributeModel.getAttribute(n);
                String string2 = string.getPropChanges().getListenerInfo();
                JOptionPane.showMessageDialog(this, string2, "Listeners registered for " + string.getName(), 1);
            }
        } else if (object == this.deviceTable) {
            int n = this.deviceTable.getSelectedRow();
            int n3 = this.deviceTable.getSelectedColumn();
            if (n3 == 4) {
                Device device = this.deviceModel.getDevice(n);
                String string = device.getPropChanges().getListenerInfo();
                JOptionPane.showMessageDialog(this, string, "Listeners registered for " + device.getName(), 1);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

